#!/bin/bash

data_path= ### Your data path ###
repo_path=.
log_path=${repo_path}/results
data_type=clevr_aug   # one of ["clevr_aug", "clevr_mv"]

python train.py --arch aug_PoEMM --datatype ${data_type} --work_mode training \
--input_dir ${data_path} --output_dir ${log_path} \
--batch_size 8 --epochs 1000 --step_per_epoch 300 --optimiser Adam --lr_rate 0.0001 --seed 0 \
--num_slots 7 --pixel_sigma 0.1 --temperature 0.0 --latent_dim 16  --latent_dim_global 256 --view_dim 5 --min_sample_views 1 --max_sample_views 6 --num_vq_show 5 \
--query_nll 1.0 --exp_nll 1.0 --exp_attention 1.0 --kl_latent 1.0 --kl_spatial 1.0 --kl_global 1.0 \
--nodes 1 --gpus 1 --gpu_start 0 --use_bg --nit_innerloop 5 --hdim_refnet 128 \
--two_stage_training \
--flow --num_flows 16 \
--geco --geco_goal -15600 --geco_min 0.01 &
