json_path="/home/bhvora/nncf/examples/tensorflow/classification/configs/pruning/ResNet50"

CTIME="`date +%b-%d-%Y-%H-%M-%p`" 
DATASET=(cifar10 cifar100 imagenet)
MODEL_NAME=(MobileNet DenseNet121 ResNet50 VGG19  DenseNet201 VGG16 ResNet152 EfficientNetB7 EfficientNetB6 MobileNetV2)
MODEL_NAME_LOWER=(mobilenet densenet121 resnet50 vgg19  densenet201 vgg16 resnet152 efficientnetb7 efficientnetb6 mobilenetv2)

ATTACK_NAME=( FastGradientMethod BasicIterativeMethod Deepfool ProjectedGradientDescent  UniversalPerturbation AutoProjectedGradientDescent CarliniWagner ElasticNet Wasserstein AdversarialPatch  ShadowAttack NewtonFool TargetedUniversalPerturbation CarliniWagner)

PRUNING_RATIO=(10 20 30 40 50)
PRUNING_TYPE=(L1 L2 gm )

DATASET_INDEX=0
MODEL_INDEX=2
ATTACK_INDEX_START=0
ATTACK_INDEX_END=0

for (( PR_INDEX=4; PR_INDEX < 5; PR_INDEX++ ))  # Pruning ratio
do
    for (( PT_INDEX = 1; PT_INDEX < 2; PT_INDEX++ ))  # Pruning index
    do  
        PRINT_OUTPUT_FILE="output-${DATASET[$DATASET_INDEX]}-${MODEL_NAME[$MODEL_INDEX]}-${CTIME}.log"
        json_file="${json_path}/${MODEL_NAME_LOWER[$MODEL_INDEX]}-${DATASET[$DATASET_INDEX]}-pruning_${PRUNING_RATIO[PR_INDEX]}%_${PRUNING_TYPE[PT_INDEX]}.json"
        echo $json_file   > $PRINT_OUTPUT_FILE

        python3 main_pruning.py --config=$json_file  --mode=train >> $PRINT_OUTPUT_FILE
    done
done
echo "Done!"