#!/bin/bash

# usage: bash scripting-auto.sh 

art_nncf_venv_path=$1
train_flag=1
attack_flag=1
json_path="configs/pruning/"


export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$art_library_path #$LD_LIBRARY_PATH:/home/shafiz/ART/adversarial-robustness-toolbox/

N_PER_CLASS_TRAINING_SAMPLES=5000
N_BATCH_SIZE=128
N_EPOCHS=10

N_PER_CLASS_TESTING_SAMPLES=1000

N_PER_CLASS_ADV_SAMPLES=$N_PER_CLASS_TESTING_SAMPLES

N_CLASSES=10
N_TRAINING_SAMPLES=$(($N_PER_CLASS_TRAINING_SAMPLES*$N_CLASSES))
N_TESTING_SAMPLES=$(($N_PER_CLASS_TESTING_SAMPLES*$N_CLASSES))
N_ADV_SAMPLES=$(($N_PER_CLASS_ADV_SAMPLES*$N_CLASSES))
TRT_INPUT_1D=32

DATASET=(cifar10 cifar100 imagenet)
MODEL_NAME=(MobileNet DenseNet121 ResNet50 VGG19  DenseNet201 VGG16 ResNet152 EfficientNetB7 EfficientNetB6 MobileNetV2)
MODEL_NAME_LOWER=(mobilenet densenet121 resnet50 vgg19  densenet201 vgg16 resnet152 efficientnetb7 efficientnetb6 mobilenetv2)

ATTACK_NAME=(   FastGradientMethod BasicIterativeMethod Deepfool ProjectedGradientDescent    UniversalPerturbation AutoProjectedGradientDescent CarliniWagner ElasticNet Wasserstein AdversarialPatch  ShadowAttack NewtonFool TargetedUniversalPerturbation CarliniWagner)

PRUNING_RATIO=(10 20 30 40 50)
PRUNING_TYPE=(L1 L2 gm )

DATASET_INDEX=0
MODEL_INDEX_START=1
MODEL_INDEX_END=1
ATTACK_INDEX_START=0
ATTACK_INDEX_END=0

PT_START=2
PT_END=3

CTIME="`date +%b-%d-%Y-%H-%M-%p`" 

for (( MODEL_INDEX=${MODEL_INDEX_START}; MODEL_INDEX<${MODEL_INDEX_END}+1; MODEL_INDEX++ ))
do
    PRINT_OUTPUT_FILE="output/${DATASET[$DATASET_INDEX]}/output-${DATASET[$DATASET_INDEX]}-${MODEL_NAME[$MODEL_INDEX]}-${CTIME}.log"
    echo $PRINT_OUTPUT_FILE >
    echo "Dataset: ${DATASET[$DATASET_INDEX]}, Fed_training: ${N_TRAINING_SAMPLES}, Fed_testing: ${N_TESTING_SAMPLES}, Fed_adv: ${N_ADV_SAMPLES}, Model: ${MODEL_NAME[$MODEL_INDEX]} ***** Model Start ***** " > $PRINT_OUTPUT_FILE

    CLASSIFIER_FILE_PREFIX="classifier-${MODEL_NAME[$MODEL_INDEX]}-${DATASET[$DATASET_INDEX]}-on-${N_TRAINING_SAMPLES}"

    python3 smh-train-classifier-a2a.py $N_TRAINING_SAMPLES $N_BATCH_SIZE $N_EPOCHS $CLASSIFIER_FILE_PREFIX ${MODEL_NAME[$MODEL_INDEX]} ${DATASET[$DATASET_INDEX]} >> $PRINT_OUTPUT_FILE
   

    for (( ATTACK_INDEX=${ATTACK_INDEX_START}; ATTACK_INDEX<${ATTACK_INDEX_END}+1; ATTACK_INDEX++ ))
    do
       
        python3 smh-subset-of-test.py $N_PER_CLASS_TESTING_SAMPLES $N_CLASSES ${DATASET[$DATASET_INDEX]} >> $PRINT_OUTPUT_FILE
        python3 smh-attack-and-adv-examples.py $CLASSIFIER_FILE_PREFIX ${DATASET[$DATASET_INDEX]} ${MODEL_NAME[$MODEL_INDEX]} ${ATTACK_NAME[$ATTACK_INDEX]} $N_TESTING_SAMPLES $N_BATCH_SIZE >> $PRINT_OUTPUT_FILE
       
        for (( PR_INDEX= 0; PR_INDEX < 1; PR_INDEX++ ))  # Pruning ratio
        do
            for (( PT_INDEX=${PT_START}; PT_INDEX<${PT_END}; PT_INDEX++ ))  # Pruning index
            do  
            python3 smh-subset-of-test-adv.py $N_PER_CLASS_TESTING_SAMPLES $N_CLASSES ${DATASET[$DATASET_INDEX]} ${MODEL_NAME[$MODEL_INDEX]} ${ATTACK_NAME[$ATTACK_INDEX]} $N_ADV_SAMPLES >> $PRINT_OUTPUT_FILE
            json_file="${json_path}${MODEL_NAME[$MODEL_INDEX]}/${MODEL_NAME_LOWER[$MODEL_INDEX]}-${DATASET[$DATASET_INDEX]}-pruning_${PRUNING_RATIO[PR_INDEX]}%_${PRUNING_TYPE[PT_INDEX]}.json"
            echo $json_file   >> $PRINT_OUTPUT_FILE
            echo ${ATTACK_NAME[$ATTACK_INDEX]} >> $PRINT_OUTPUT_FILE
            python3 smh-nncf-results.py ${DATASET[$DATASET_INDEX]} ${MODEL_NAME[$MODEL_INDEX]} ${ATTACK_NAME[$ATTACK_INDEX]} $N_ADV_SAMPLES $CLASSIFIER_FILE_PREFIX $json_file $N_BATCH_SIZE >> $PRINT_OUTPUT_FILE
            python3 nncf_pruned_model_attack_results.py ${DATASET[$DATASET_INDEX]} ${MODEL_NAME[$MODEL_INDEX]} ${ATTACK_NAME[$ATTACK_INDEX]} $N_ADV_SAMPLES $CLASSIFIER_FILE_PREFIX $json_file $N_BATCH_SIZE >> $PRINT_OUTPUT_FILE
            python3 smh-nncf-a2a-results.py ${DATASET[$DATASET_INDEX]} ${MODEL_NAME[$MODEL_INDEX]} ${ATTACK_NAME[$ATTACK_INDEX]} $N_ADV_SAMPLES $CLASSIFIER_FILE_PREFIX $json_file $N_BATCH_SIZE >> $PRINT_OUTPUT_FILE
            done
        done
    done
done
echo "Done!"
