"""
Contains the models.
"""

import tensorflow as tf
from tensorflow.keras.layers import Dense

def create_model(input_dim, width, hidden_layers, activation):
    """
    Creates a MLP with certain width, depth and activation function.

    Note that the output dimension defaults to one. 

    Parameters
    ----------
    input_dim : int
        the input dimension.
    width : int
        The width of the MLP. Is set for all but the first and last
        layer.
    hidden_layers : int
        number of hidden layers. Equals one for a shallow architecture.
    activation : function
        activation function to be used in the architecture.

    Returns
    -------
    A MLP model.
    
    """
    inputs = tf.keras.Input(shape=(input_dim,))
    layer = Dense(width, activation = activation)(inputs)
    for i in range(hidden_layers-1):
        layer = Dense(width, activation = activation)(layer)
  
    outputs = Dense(1)(layer)
    return tf.keras.Model(inputs = inputs, outputs = outputs)
