

**Breaking the Curse of Dimensionality for Parametric Elliptic PDEs**

Abstract: *Motivated by recent empirical success, we examine how neural network-based ansatz classes can break the curse of dimensionality for high-dimensional, non-linear elliptic partial differential equations (PDEs) with variational structure. The high-dimensionality of the PDEs can either be induced through a high-dimensional physical domain or a high-dimensional parameter space. The latter include parametric right-hand sides, parametric domains, and material constants. Our main result shows that any scheme, that computes neural network based* $W^{1,p}$*-approximations, leverages the extraordinary approximation capabilities of neural networks and, thus, is able to beat the curse of dimensionality if the ground truth solution is smooth or possesses Barron regularity. Popular examples of* $W^{1,p}$*-convergent schemes include, e.g., the Deep Ritz Method and physics-informed neural networks. We present numerical experiments supporting our theoretical findings.*

## Requirements
- Python 3.9.12 or later
- Tensorflow 2.9.0 or later

## Usage
The code consists of several scripts. Of these, example1.py and example2.py correspond to the examples in Section 3 of the preprint. More precisely, in example1.py we solve the equation $-\Delta u + u = f$ with no parametric dependencies, but with a possibly high-dimensional domain. The domain dimension can be specified in the script. In example2.py we solve a parametric equation of the form $-u''(\tau,x) + u(\tau,x) = f(\tau,x)$ and the user can set the dimension of the parameter space.

