#!/bin/bash
set -e
set -x

virtualenv -p python3 .
source ./bin/activate

pip install -r requirements.txt
TF_CPP_MIN_LOG_LEVEL=2 python train.py --gpu 0 --dataset color_mnist
TF_CPP_MIN_LOG_LEVEL=2 python eval_model.py --gpu 0 --source-dataset color_mnist --model-path ./checkpoints/standard_supervised/color_mnist
TF_CPP_MIN_LOG_LEVEL=2 python eval_pipeline.py --gpu 0 --source-dataset color_mnist --method sr --method-config-file ./configs/sr.json
TF_CPP_MIN_LOG_LEVEL=2 python eval_pipeline.py --gpu 0 --source-dataset color_mnist --method de --method-config-file ./configs/de.json
TF_CPP_MIN_LOG_LEVEL=2 python eval_pipeline.py --gpu 0 --source-dataset color_mnist --method aspest --method-config-file ./configs/aspest.json
