import numpy as np
from roc_tpr import cal_roc_tpr
header = "./numpy_stats_new/projection_regret/"

levels = ['9_8_40_10_1557','8_8_40_10_1557','8_7_40_10_1557','7_7_40_10_1557','10_9_40_10_1557','9_9_40_10_1557','10_10_40_10_1557','7_6_40_10_1557']


for idx,elem in enumerate(levels):
    shortcut = header+elem
    cf10_te_ = np.loadtxt(shortcut+'/cifar10_test.txt')
    cf100_ = np.loadtxt(shortcut+'/cifar100.txt')
    svhn_ = np.loadtxt(shortcut+'/svhn.txt')
    lsun_ = np.loadtxt(shortcut+'/lsun.txt')
    imgn_ = np.loadtxt(shortcut+'/imgn.txt')
    
    cf10_te_ = np.reshape(cf10_te_,[-1,1])
    cf100_=  np.reshape(cf100_,[-1,1])
    svhn_ = np.reshape(svhn_,  [-1,1])
    lsun_ = np.reshape(lsun_, [-1,1])
    imgn_ = np.reshape(imgn_, [-1,1])

    if idx == 0:
        cf10_te = cf10_te_
        cf100 = cf100_
        svhn = svhn_
        lsun = lsun_
        imgn = imgn_
    else:
        cf10_te = np.concatenate([cf10_te,cf10_te_],1)
        cf100 = np.concatenate([cf100,cf100_],1)
        svhn = np.concatenate([svhn,svhn_],1)
        lsun = np.concatenate([lsun,lsun_],1)
        imgn = np.concatenate([imgn,imgn_],1)

cf10_te = np.mean(cf10_te,1)
svhn = np.mean(svhn,1)
cf100 = np.mean(cf100,1)
lsun = np.mean(lsun,1)
imgn = np.mean(imgn,1)

print(cal_roc_tpr(cf10_te,cf100,0.95))
print(cal_roc_tpr(cf10_te,svhn,0.95))
print(cal_roc_tpr(cf10_te,lsun,0.95))
print(cal_roc_tpr(cf10_te,imgn,0.95))
