## 📁 Project Structure

- **`fisher/`**: Code and scripts for computing the Fisher Information Matrix (FIM). Results are saved in `.pt` format.
  - `fisher_full.py`: Full model FIM computation
  - `fisher_lora.py`: LoRA-specific FIM computation
  - `fisher_analysis.py`: Analysis tools for FIM results
  
- **`train/`**: Training scripts and utilities for model fine-tuning
  - `train.py`: Main training script with dynamic-k support
  - `log.py`: Logging utilities
  
- **`ref_dataset/`**: Reference dataset generation for dynamic-k training
  - `ref_dataset.py`: Dataset generation using vLLM
  
- **`safechain/`**: Safety evaluation framework
  - `pipeline.py`: End-to-end safety evaluation pipeline
  
- **`lm-evaluation-harness/`**: Evaluation suite for AIME, GPQA, HumanEval+, and MBPP+

## 🛠️ Installation

Using uv (recommended):
```bash
pip install uv
uv sync
```

Or using pip:
```bash
pip install -r requirements.txt
```

### Additional Setup
For evaluation harness:
```bash
cd lm-evaluation-harness
pip install -e .
```