import subprocess
import argparse
import re
import tempfile
from config import *
from utils import *

pattern = re.compile(r"Results saved to (.+)")

def pipeline(args):
    # resp generate first
    model = args.model
    resp_gen_arg_list = ["python", "resp_gen.py"]
    for key, value in vars(args).items():
        if isinstance(value, bool):
            # 只在 True 的时候加，False 就跳过
            if value:
                resp_gen_arg_list.append(f"--{key}")
                resp_gen_arg_list.append("True")
        elif value is None or (isinstance(value, str) and value.strip() == ""):
            # None 或空字符串 → 跳过
            continue
        else:
            resp_gen_arg_list.append(f"--{key}")
            resp_gen_arg_list.append(str(value))

    print(" ".join(resp_gen_arg_list))
    
    # 即时打印子进程输出，同时收集起来
    proc = subprocess.Popen(
        resp_gen_arg_list,
        stdout=subprocess.PIPE,
        stderr=subprocess.STDOUT,
        text=True,
        bufsize=1  # 行缓冲
    )

    all_output = []
    for line in proc.stdout:
        print(line, end="")       # 直接打印到控制台
        all_output.append(line)   # 收集起来
    proc.wait()

    result_stdout = "".join(all_output)

    # 用正则匹配
    match = pattern.search(result_stdout)
    if match:
        filepath = match.group(1)
        print(f"Found file path: {filepath}")
    else:
        raise ValueError("No file path found in the output.")

    # 执行评估脚本
    subprocess.run(["python", "resp_eval.py", "--file_path", filepath])


if __name__ == '__main__':
    args = get_args()
    print(args)
    pipeline(args)