#include <benchmark/benchmark.h>

#include <string>
#include <iostream>
#include <fstream>

#include "vw.h"
#include "../benchmarks_common.h"

static void benchmark_rcv1_dataset(benchmark::State& state, std::string command_line)
{
  auto vw = VW::initialize(command_line, nullptr, false, nullptr, nullptr);
  std::vector<example*> examples;
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:3.4770757e-02 21:5.2058056e-02 22:1.0131893e-01 66:9.8602206e-02 126:7.3677950e-02 "
          "144:8.3734207e-02 "
          "258:1.3117002e-01 282:1.0712786e-01 286:8.9001723e-02 302:6.8243802e-02 454:1.1229499e-01 459:8.5936494e-02 "
          "533:4.6158761e-02 534:1.0838871e-01 537:2.2317035e-01 540:1.0823997e-01 550:7.0598722e-02 573:6.0984179e-02 "
          "617:6.9755495e-02 620:5.3597409e-02 809:1.2329303e-01 811:1.0078616e-01 866:1.6002567e-01 "
          "1071:6.7204006e-02 "
          "1134:8.8398121e-02 1305:8.9227840e-02 1314:1.5046395e-01 1383:8.7426804e-02 2298:3.2898754e-02 "
          "2477:1.0394224e-01 "
          "3000:2.1763121e-01 3793:1.5177026e-01 5225:1.4700839e-01 7108:2.1639362e-01 7165:1.5993990e-01 "
          "7275:1.5572040e-01 "
          "7851:2.7698877e-01 7853:2.0813602e-01 7854:4.2525813e-01 7876:1.9971584e-01 7922:2.3383786e-01 "
          "7928:2.2501056e-01 "
          "22893:2.4975674e-01")));

  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:2.5941234e-02 45:1.0093741e-01 73:4.4377144e-02 142:1.1601033e-01 159:1.9448641e-01 "
          "197:2.5329438e-01 "
          "257:6.3567974e-02 488:1.6744833e-01 497:1.3232227e-01 547:1.2052315e-01 613:5.2947123e-02 759:2.0554376e-01 "
          "782:1.9669981e-01 905:1.0293012e-01 1211:1.1731350e-01 1383:9.5941707e-02 1398:1.7192762e-01 "
          "1479:1.2192473e-01 "
          "1590:2.0290023e-01 1765:1.7032301e-01 2493:1.7820080e-01 3132:1.4529058e-01 3271:2.2052087e-01 "
          "3405:1.6775523e-01 "
          "5317:1.7017807e-01 6556:2.1031970e-01 8228:2.1553637e-01 12077:4.8640794e-01 28872:2.9970971e-01")));

  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 7:4.4724721e-02 15:2.1997921e-02 17:3.3769939e-02 22:7.8040227e-02 23:3.2728940e-02 24:1.8207725e-02 "
          "26:2.8254675e-02 42:4.1978225e-02 45:1.9938400e-02 50:2.0109808e-02 51:2.3665180e-02 52:2.9594993e-02 "
          "53:6.1693095e-02 55:2.1214541e-02 74:2.7887834e-02 79:4.9039219e-02 81:3.8692791e-02 89:3.6646318e-02 "
          "90:2.8476419e-02 99:3.8045701e-02 107:3.4456529e-02 110:2.7409501e-02 121:3.4106642e-02 122:5.3606208e-02 "
          "146:4.8705038e-02 147:2.7660409e-02 175:7.5247101e-02 178:6.8830401e-02 182:2.8641831e-02 183:4.7949456e-02 "
          "188:3.1163281e-02 189:2.7851848e-02 191:5.7022180e-02 192:7.1189202e-02 209:3.1099102e-02 213:8.5294746e-02 "
          "219:9.3563519e-02 220:3.5511807e-02 233:2.1459159e-02 239:2.9608890e-02 241:9.2885911e-02 264:3.5783652e-02 "
          "271:4.4741906e-02 280:7.4716315e-02 288:2.2889469e-02 291:4.1259747e-02 297:2.9019466e-02 312:3.6049493e-02 "
          "313:8.9054309e-02 315:3.2156143e-02 319:6.2024117e-02 339:2.6347337e-02 379:4.5082387e-02 451:3.1505141e-02 "
          "476:4.0007304e-02 480:4.1698117e-02 516:6.3339397e-02 526:2.1261238e-02 535:3.3876535e-02 545:3.5082880e-02 "
          "553:3.1601660e-02 555:2.6770808e-02 558:3.0439384e-02 572:6.1017144e-02 578:1.0156165e-01 581:4.8116118e-02 "
          "585:1.0146070e-01 617:3.1733036e-02 631:4.2163212e-02 642:3.2645542e-02 655:2.4488568e-02 678:2.6912225e-02 "
          "684:3.7743933e-02 702:2.8839920e-02 703:6.7462221e-02 723:9.5831662e-02 773:3.1474717e-02 789:7.4855991e-02 "
          "802:3.3258229e-02 831:5.7469640e-02 836:3.9973188e-02 845:5.1243026e-02 871:7.3263653e-02 894:9.4162993e-02 "
          "916:7.0301078e-02 963:3.7125837e-02 988:4.5581188e-02 1028:2.5233695e-02 1040:3.4235485e-02 "
          "1049:5.5964489e-02 "
          "1059:3.8257286e-02 1066:4.9865920e-02 1098:5.8958139e-02 1099:1.0642000e-01 1122:2.7161302e-02 "
          "1132:5.5820916e-02 "
          "1133:4.6960417e-02 1162:3.9029490e-02 1188:2.8600320e-02 1194:5.0604455e-02 1196:6.5430172e-02 "
          "1212:4.2503651e-02 "
          "1214:5.0775778e-02 1232:5.6423597e-02 1240:6.1547466e-02 1246:7.7764101e-02 1280:1.3794197e-01 "
          "1296:5.1512964e-02 "
          "1340:7.8965351e-02 1342:3.7148494e-02 1352:5.1221535e-02 1376:4.2615250e-02 1380:3.7119050e-02 "
          "1387:4.7238745e-02 "
          "1426:5.5234205e-02 1454:5.2877679e-02 1455:5.0725996e-02 1479:8.5576959e-02 1492:7.4084811e-02 "
          "1493:4.8998870e-02 "
          "1528:4.4210665e-02 1530:4.8503999e-02 1554:9.3274266e-02 1623:3.6034379e-02 1648:6.2799916e-02 "
          "1690:4.8120685e-02 "
          "1755:4.5155622e-02 1756:4.8210379e-02 1777:9.0586245e-02 1881:5.0639965e-02 1947:7.9649575e-02 "
          "1994:4.8551779e-02 "
          "1997:7.6153621e-02 2009:4.0015411e-02 2039:1.3339286e-01 2111:7.2162248e-02 2262:4.8061442e-02 "
          "2280:6.4266250e-02 "
          "2345:5.6263927e-02 2465:6.3638307e-02 2614:4.7085270e-02 2734:8.9492761e-02 2752:5.2130960e-02 "
          "2756:8.0005348e-02 "
          "2834:5.1661562e-02 2871:5.2857738e-02 3008:1.1090731e-01 3027:4.8987020e-02 3236:6.1085127e-02 "
          "3272:3.7708689e-02 "
          "3284:5.8934376e-02 3291:4.9844332e-02 3338:1.4995308e-01 3371:1.9023912e-01 3374:1.3803375e-01 "
          "3377:6.8909340e-02 "
          "3441:8.7797664e-02 3457:4.5233984e-02 3478:6.2372923e-02 3713:6.7536190e-02 3973:8.4199615e-02 "
          "3993:6.1687645e-02 "
          "4353:7.1359947e-02 4404:7.1069397e-02 4405:8.3499864e-02 4840:1.3851443e-01 4958:7.3976889e-02 "
          "5497:7.9394184e-02 "
          "8075:7.4009515e-02 8467:7.9975940e-02 8641:8.5474081e-02 9527:7.6241784e-02 9537:7.7080742e-02 "
          "9555:7.8563809e-02 "
          "9728:8.4486142e-02 9788:7.1219534e-02 10323:1.6259536e-01 10376:8.6243302e-02 11017:1.3648555e-01 "
          "12299:1.9657618e-01 12866:8.6542256e-02 15564:1.4876729e-01 18171:3.0685624e-01 20279:1.9894341e-01 "
          "26695:1.1104724e-01 26696:1.1756326e-01 26913:9.9067703e-02 32323:1.3729194e-01 37167:8.7625824e-02")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 3:4.1986797e-02 5:2.6179912e-02 17:1.9496726e-02 21:2.3149800e-02 23:3.1993225e-02 24:2.5084825e-02 "
          "49:3.8114011e-02 50:1.9657761e-02 53:6.0306296e-02 54:3.8306452e-02 69:2.3690635e-02 70:1.7837172e-02 "
          "73:1.7982738e-02 91:3.6214627e-02 95:4.0163361e-02 99:3.7190471e-02 102:4.4804830e-02 106:7.8616023e-02 "
          "110:4.5365110e-02 129:9.2167243e-02 140:3.4740668e-02 147:2.7038630e-02 153:5.3785227e-02 183:2.7683120e-02 "
          "187:6.9057137e-02 207:3.9017066e-02 215:9.9909797e-02 217:6.6182606e-02 223:4.4721238e-02 238:4.6286445e-02 "
          "239:2.8943313e-02 253:3.8976792e-02 254:3.7552334e-02 256:6.0604967e-02 257:2.5759345e-02 269:2.3699578e-02 "
          "274:7.2829217e-02 275:4.5884371e-02 276:2.5180764e-02 284:3.8045619e-02 288:2.2374937e-02 302:3.0347472e-02 "
          "312:3.5239138e-02 313:7.0233375e-02 320:5.0995018e-02 321:3.7686653e-02 323:3.7712883e-02 326:4.4142779e-02 "
          "332:4.7283009e-02 334:3.4647163e-02 335:7.0727788e-02 355:5.6434717e-02 367:9.6835844e-02 406:4.9223509e-02 "
          "417:2.0013522e-02 428:4.1733503e-02 444:7.5417697e-02 453:3.0276578e-02 468:4.3970123e-02 489:3.9158344e-02 "
          "506:2.7590115e-02 510:3.3422902e-02 516:3.6568344e-02 532:7.1615264e-02 533:2.0526432e-02 543:8.1320181e-02 "
          "636:1.5416218e-01 638:6.2130053e-02 644:2.8258998e-02 675:1.3132864e-01 676:1.1248107e-01 678:2.6307266e-02 "
          "726:3.3511285e-02 757:3.4779027e-02 777:5.9977800e-02 783:5.1708918e-02 811:2.6470702e-02 839:1.0794318e-01 "
          "842:2.0697769e-02 871:7.1616754e-02 884:9.9041164e-02 955:4.1538641e-02 965:3.4062155e-02 999:8.6894937e-02 "
          "1000:3.2704212e-02 1001:2.5795811e-01 1002:4.3989230e-02 1028:2.4666468e-02 1038:4.1340951e-02 "
          "1063:5.6797281e-02 "
          "1068:6.5421291e-02 1188:2.7957413e-02 1193:6.7524910e-02 1212:4.1548211e-02 1218:3.0026717e-02 "
          "1230:1.1178771e-01 "
          "1294:5.3293657e-02 1313:5.6519736e-02 1324:6.8769053e-02 1375:8.7847814e-02 1437:5.3205792e-02 "
          "1497:1.0660116e-01 "
          "1500:4.9023256e-02 1544:3.6815152e-02 1563:5.5172045e-02 1609:6.3943833e-02 1647:4.1935220e-02 "
          "1666:5.9658233e-02 "
          "1694:4.9814355e-02 1696:1.0818209e-01 1699:1.8198134e-01 1727:4.0036179e-02 1804:6.2561035e-02 "
          "1966:4.3227285e-02 "
          "1991:7.3565029e-02 2027:6.9326729e-02 2065:4.3378502e-02 2090:4.0175326e-02 2096:1.0312126e-01 "
          "2153:3.4037523e-02 "
          "2207:6.6782206e-02 2214:4.5959804e-02 2222:9.9043794e-02 2247:6.5043472e-02 2359:6.1114829e-02 "
          "2474:4.3782581e-02 "
          "2478:7.8985400e-02 2495:4.6261843e-02 2509:5.3805720e-02 2752:5.0959107e-02 2824:5.6097563e-02 "
          "2899:1.0600434e-01 "
          "2942:4.9685217e-02 3294:6.2804215e-02 3533:9.1343574e-02 3661:6.3792802e-02 3779:9.2252716e-02 "
          "3862:2.1168050e-01 "
          "3871:1.1229920e-01 3874:6.9703743e-02 3881:6.6696659e-02 4459:5.6688782e-02 5168:6.9475479e-02 "
          "5775:6.0072321e-02 "
          "6112:7.5319275e-02 6459:9.4217762e-02 6628:1.5544818e-01 6638:1.3720584e-01 6646:1.4070532e-01 "
          "6647:1.5253116e-01 "
          "6729:9.3434729e-02 6824:8.0569461e-02 6882:9.6010573e-02 6911:1.0160501e-01 7056:7.4707553e-02 "
          "8572:2.5678426e-01 "
          "8880:6.9283508e-02 9837:8.1632257e-02 9843:8.1850044e-02 10233:7.8142323e-02 10622:7.4951001e-02 "
          "11138:7.1257427e-02 11593:1.7834796e-01 13401:1.0104093e-01 15240:6.9041334e-02 15796:9.0718590e-02 "
          "16054:1.5468997e-01 19824:9.2912525e-02 33289:1.1517279e-01 43246:1.0781153e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 15:2.8479176e-02 20:2.2463840e-02 23:4.2371877e-02 25:4.6330903e-02 33:5.8889594e-02 39:3.0892659e-02 "
          "45:2.5812857e-02 52:3.8314577e-02 55:4.6502270e-02 63:1.0147369e-01 75:7.6976635e-02 125:4.3622561e-02 "
          "138:4.3973591e-02 144:4.9315326e-02 161:5.8606591e-02 189:3.6057848e-02 191:4.3600846e-02 193:8.2893573e-02 "
          "208:4.7758926e-02 221:1.2687442e-01 230:9.5576935e-02 236:6.3797504e-02 239:3.8332570e-02 252:5.7719201e-02 "
          "259:6.3074701e-02 269:3.1387758e-02 271:2.7601205e-02 276:5.6465514e-02 288:2.9633401e-02 301:7.2265789e-02 "
          "302:6.8051375e-02 312:4.6670768e-02 319:3.8262572e-02 323:4.9947001e-02 364:3.5657953e-02 422:1.6551772e-01 "
          "437:8.1148177e-02 454:3.9061114e-02 460:6.9821924e-02 464:5.8992326e-02 481:4.3425296e-02 506:3.6540389e-02 "
          "526:6.5683812e-02 532:5.6018386e-02 547:3.8202513e-02 555:3.4658298e-02 573:7.5375184e-02 575:4.3338194e-02 "
          "585:1.6396713e-01 625:4.7290489e-02 655:3.1703644e-02 660:2.8935434e-02 678:5.8991589e-02 688:7.7477448e-02 "
          "690:5.0219595e-02 724:3.6186326e-02 773:4.0748123e-02 802:6.0683999e-02 837:1.4202154e-01 927:4.9204905e-02 "
          "945:1.0549542e-01 965:4.5111969e-02 1005:5.3301163e-02 1011:4.7167368e-02 1014:4.4800345e-02 "
          "1028:3.2668307e-02 "
          "1033:4.6181347e-02 1040:1.1565629e-01 1044:7.1853809e-02 1059:2.9252652e-02 1066:6.4557932e-02 "
          "1099:1.1080371e-01 "
          "1102:5.0469600e-02 1119:6.5886393e-02 1122:3.5163846e-02 1171:5.7316359e-02 1188:3.7026841e-02 "
          "1237:5.2241877e-02 "
          "1243:1.2012374e-01 1292:7.4377894e-02 1308:5.9361920e-02 1335:5.9102274e-02 1342:4.8093569e-02 "
          "1351:8.4335715e-02 "
          "1422:4.0325448e-02 1426:8.8632166e-02 1492:5.6647435e-02 1502:7.9012662e-02 1519:1.2547143e-01 "
          "1538:5.8987826e-02 "
          "1540:5.3479932e-02 1577:6.7274019e-02 1586:8.3305068e-02 1592:9.4966508e-02 1594:6.6864945e-02 "
          "1776:5.1703267e-02 "
          "1777:6.9264919e-02 1854:1.2355178e-01 1889:8.1340775e-02 1890:5.9499696e-02 1945:7.7040419e-02 "
          "1994:1.0642549e-01 "
          "2028:5.5188794e-02 2074:5.8859635e-02 2111:9.3423441e-02 2222:1.3117376e-01 2234:1.0513415e-01 "
          "2268:9.5954485e-02 "
          "2438:6.1372146e-02 2548:6.1178055e-02 2574:1.5212426e-01 2614:6.0958017e-02 2688:1.3912547e-01 "
          "2734:1.1586004e-01 "
          "2803:7.1856774e-02 3013:6.0782466e-02 3188:5.3082395e-02 3192:7.3183186e-02 3284:7.6298229e-02 "
          "3432:8.3512142e-02 "
          "3488:9.4829120e-02 3899:7.5703517e-02 3973:1.0900737e-01 4969:9.1419771e-02 5745:7.7066533e-02 "
          "5775:7.9559878e-02 "
          "5974:2.0083311e-01 6197:1.7981011e-01 8213:1.3504241e-01 8766:1.8207975e-01 9987:1.2012266e-01 "
          "10109:1.1744983e-01 11748:1.0037310e-01 15159:1.2140261e-01 17252:1.1719365e-01 19048:2.7880347e-01 "
          "19049:1.0691366e-01 23505:1.3456585e-01 40144:1.6520862e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 18:4.6056196e-02 50:9.5679328e-02 73:3.3542305e-02 157:1.0024465e-01 188:2.7075356e-02 "
          "210:5.2699324e-02 "
          "229:4.2207617e-02 233:6.6247672e-02 234:8.7591767e-02 278:1.8365175e-01 334:6.4625636e-02 353:1.2242922e-01 "
          "354:6.0411990e-02 369:9.2592202e-02 437:1.7613614e-01 547:9.1096997e-02 757:6.4871587e-02 802:3.5815217e-02 "
          "837:7.1646281e-02 910:2.2995535e-01 953:1.3653293e-01 965:6.3534439e-02 1042:3.0493781e-01 "
          "1073:7.6491348e-02 "
          "1145:1.0228382e-01 1173:6.0381923e-02 1237:1.2457500e-01 1422:9.6159309e-02 1666:4.6631940e-02 "
          "1789:1.2541972e-01 "
          "1791:1.3059698e-01 1953:1.0095011e-01 2131:9.8541506e-02 2132:1.2545407e-01 2256:1.0201104e-01 "
          "2313:1.2552865e-01 "
          "2315:1.0146101e-01 2548:8.6161472e-02 2562:1.1722676e-01 3282:1.6630229e-01 3307:1.0607360e-01 "
          "3416:1.2877280e-01 "
          "3540:9.8631248e-02 4065:1.1832068e-01 4099:9.5148496e-02 4241:1.2052083e-01 5129:2.9954630e-01 "
          "6024:3.3074304e-01 "
          "6059:1.5186512e-01 6195:1.5052530e-01 6200:1.2042308e-01 6513:1.5240510e-01 6709:1.6889554e-01 "
          "10199:2.5266066e-01 11347:1.6097301e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 20:4.1563634e-02 21:5.6727868e-02 45:4.7760144e-02 48:8.9214578e-02 148:1.2773652e-01 "
          "152:1.6138925e-01 "
          "156:1.2904224e-01 179:5.7116259e-02 206:2.3923971e-01 284:1.1555570e-01 351:1.3505945e-01 366:1.6035202e-01 "
          "371:1.3003521e-01 393:1.6114947e-01 768:8.8684253e-02 778:1.4543906e-01 965:8.3468251e-02 992:9.0976045e-02 "
          "1127:5.3214960e-02 1162:9.3490653e-02 1200:1.2512271e-01 1397:1.0597364e-01 1468:1.1527381e-01 "
          "1544:9.0214387e-02 "
          "1793:2.0222849e-01 2667:2.1735094e-01 2701:1.1985400e-01 3405:1.6657957e-01 3719:4.2434746e-01 "
          "10225:1.6199465e-01 22844:2.7331567e-01 26060:2.1241799e-01 28578:4.5230788e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 6:5.2982334e-02 9:6.2744521e-02 20:3.3571914e-02 24:2.0806493e-02 35:3.5421308e-02 39:2.7267963e-02 "
          "50:2.2980059e-02 52:3.3819053e-02 55:7.1416140e-02 69:1.6356828e-02 73:2.1021945e-02 90:3.2540824e-02 "
          "98:3.8667805e-02 108:5.5731669e-02 131:7.4235141e-02 147:3.1608347e-02 161:5.1730167e-02 169:5.5573225e-02 "
          "170:3.8090467e-02 175:4.0973283e-02 182:3.2729849e-02 188:2.8730877e-02 189:6.6792771e-02 209:3.5537843e-02 "
          "210:3.3028211e-02 229:4.4788398e-02 251:8.6390018e-02 252:9.2660576e-02 254:4.3898940e-02 269:2.7704971e-02 "
          "276:2.9436490e-02 293:2.4884880e-02 297:5.6147102e-02 298:3.7819773e-02 309:4.2378280e-02 321:4.4055957e-02 "
          "322:5.3446811e-02 334:8.4999621e-02 386:4.4409651e-02 437:4.2304005e-02 475:6.2552527e-02 510:3.9071605e-02 "
          "535:3.8711693e-02 547:3.3720136e-02 555:3.0591775e-02 558:9.7108461e-02 585:4.1530110e-02 600:6.9536529e-02 "
          "655:2.7983794e-02 673:7.1089022e-02 709:5.4233506e-02 724:3.1940516e-02 769:7.7240728e-02 837:4.4902824e-02 "
          "838:5.2558392e-02 841:5.5120695e-02 842:4.0967111e-02 858:6.1720237e-02 871:4.9446672e-02 911:7.5598858e-02 "
          "929:4.1785121e-02 945:4.4370960e-02 955:4.8558962e-02 965:1.0390493e-01 1000:6.4731471e-02 "
          "1002:5.1423717e-02 "
          "1012:3.5827979e-02 1040:6.6239096e-02 1059:2.5820382e-02 1062:8.2865261e-02 1084:5.7188086e-02 "
          "1085:5.8276873e-02 "
          "1086:4.9740933e-02 1122:3.1038005e-02 1127:2.5386428e-02 1132:3.7674323e-02 1142:6.3518740e-02 "
          "1145:3.7861012e-02 "
          "1166:6.0473833e-02 1188:3.2682411e-02 1189:4.2796958e-02 1213:2.5966633e-02 1239:5.2572988e-02 "
          "1243:8.5543849e-02 "
          "1250:6.1925855e-02 1287:1.0774548e-01 1305:4.6384916e-02 1335:5.2167688e-02 1342:4.2450655e-02 "
          "1352:5.8532327e-02 "
          "1373:8.1857003e-02 1376:4.8697677e-02 1420:1.0637193e-01 1435:1.0252235e-01 1454:6.0424853e-02 "
          "1455:4.6766650e-02 "
          "1456:5.3716369e-02 1519:6.5410510e-02 1520:5.8369011e-02 1532:7.2321787e-02 1538:1.0926775e-01 "
          "1548:1.0717531e-01 "
          "1690:9.3104288e-02 1727:4.6802569e-02 1776:4.5636822e-02 1854:6.4409763e-02 1888:5.5238497e-02 "
          "2058:8.2990065e-02 "
          "2066:5.7305049e-02 2107:4.6076745e-02 2131:6.1758850e-02 2223:8.7590136e-02 2607:6.8193659e-02 "
          "2734:6.0399927e-02 "
          "2747:6.3771993e-02 2755:6.3948177e-02 2794:5.6540303e-02 2824:6.5578446e-02 3010:6.2620491e-02 "
          "3013:9.0838596e-02 "
          "3027:1.1747797e-01 3090:7.9230167e-02 3170:7.1368128e-02 3188:4.6854138e-02 3210:7.3022559e-02 "
          "3230:5.3828456e-02 "
          "3240:6.0575113e-02 3429:1.4870682e-01 3439:1.7212602e-01 3570:6.2487315e-02 3690:9.4784535e-02 "
          "3883:1.2023974e-01 "
          "3899:1.7436545e-01 4096:6.3664071e-02 4241:1.5851645e-01 4331:7.7730164e-02 4351:7.0299074e-02 "
          "4666:8.4313765e-02 "
          "5373:7.5695582e-02 5707:7.6307721e-02 5845:8.4146976e-02 5894:8.7468810e-02 5974:2.6482686e-01 "
          "6006:1.0460936e-01 "
          "6607:7.6045342e-02 8478:8.6456358e-02 8532:8.8204101e-02 8766:9.4921440e-02 9253:8.8008501e-02 "
          "9580:1.1787144e-01 "
          "9581:3.3045432e-01 10861:1.0920727e-01 13741:9.2334479e-02 14763:1.0013255e-01 17330:1.2771979e-01 "
          "17331:1.3072690e-01 18683:9.5006585e-02 18868:9.3350902e-02 18869:1.6941223e-01 19048:9.4308019e-02 "
          "19049:9.4369270e-02")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 42:3.6681876e-01 45:1.7422792e-01 56:1.6445871e-01 69:1.4222474e-01 73:7.6599330e-02 81:1.6111104e-01 "
          "82:3.7677154e-01 348:1.2549011e-01 386:1.6181897e-01 394:1.6376621e-01 417:1.4434023e-01 522:2.1393616e-01 "
          "526:1.4989202e-01 784:1.8537326e-01 942:2.0576195e-01 1195:1.6902253e-01 1380:1.5455821e-01 "
          "1664:1.4203092e-01 "
          "1726:1.6600534e-01 1970:2.0831792e-01 2007:3.7718076e-01 2212:1.8370849e-01 2522:2.4476728e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 6:6.8953723e-02 10:2.4920074e-02 24:1.9822951e-02 50:1.7663756e-02 73:1.6158640e-02 121:5.0723456e-02 "
          "157:4.8291773e-02 178:6.0458232e-02 179:2.0943997e-02 188:1.3043258e-02 193:7.4816257e-02 209:4.6250634e-02 "
          "233:1.8848978e-02 236:3.4921709e-02 239:2.6007419e-02 264:3.1431116e-02 265:4.3809656e-02 267:3.5724755e-02 "
          "276:2.2626529e-02 293:1.9127907e-02 302:2.7269145e-02 307:4.2694855e-02 312:3.1664621e-02 326:2.3426855e-02 "
          "368:3.9957818e-02 433:2.1424608e-02 494:3.0670732e-02 506:2.4791485e-02 550:2.8210135e-02 567:4.9445845e-02 "
          "617:2.7873196e-02 625:3.2085080e-02 630:3.6478668e-02 631:3.7034698e-02 670:4.1411690e-02 682:4.8788730e-02 "
          "702:2.5331981e-02 724:2.4551263e-02 783:4.6463773e-02 817:3.9437063e-02 837:9.0064272e-02 842:1.8598272e-02 "
          "848:7.6375939e-02 850:5.0411887e-02 852:7.4332051e-02 855:7.8169920e-02 884:1.1030679e-01 889:9.8633111e-02 "
          "894:3.9411522e-02 905:3.7478998e-02 914:5.6504101e-02 949:4.6126790e-02 950:4.5762073e-02 963:3.2610044e-02 "
          "979:4.8457999e-02 1000:2.9386828e-02 1045:3.4139425e-02 1059:3.3603869e-02 1061:4.0301725e-02 "
          "1066:7.4160680e-02 "
          "1071:2.6853660e-02 1073:8.7932266e-02 1081:7.7701092e-02 1117:9.1598287e-02 1123:9.3790986e-02 "
          "1131:4.6108399e-02 "
          "1132:4.9031150e-02 1162:3.4282148e-02 1170:3.8612958e-02 1177:5.4951586e-02 1178:4.6940666e-02 "
          "1188:2.5121527e-02 "
          "1189:3.2896131e-02 1191:9.6172296e-02 1211:4.2716283e-02 1237:3.5444438e-02 1240:3.1929389e-02 "
          "1247:6.4616486e-02 "
          "1311:7.5592339e-02 1342:3.2629944e-02 1366:5.0296519e-02 1416:3.9530758e-02 1417:3.8943492e-02 "
          "1470:4.3616120e-02 "
          "1494:6.2730476e-02 1511:6.8593867e-02 1556:3.9865732e-02 1577:4.5643266e-02 1821:8.7437980e-02 "
          "1862:5.4120179e-02 "
          "1888:4.2459391e-02 1910:4.3156520e-02 1967:9.7915463e-02 1972:4.1025959e-02 2008:5.0531935e-02 "
          "2018:3.8799949e-02 "
          "2088:4.0381286e-02 2128:3.9645299e-02 2168:5.0549522e-02 2175:7.5826041e-02 2183:1.7829052e-01 "
          "2234:3.3989199e-02 "
          "2270:8.2511209e-02 2281:5.4877985e-02 2316:4.4665784e-02 2322:4.4940550e-02 2477:4.1533679e-02 "
          "2533:4.8195656e-02 "
          "2588:9.1189362e-02 2701:4.3949336e-02 2861:7.2961919e-02 2932:5.8073092e-02 2992:5.0242696e-02 "
          "3077:8.1162862e-02 "
          "3110:1.1454716e-01 3170:5.4857526e-02 3263:6.3250236e-02 3325:4.0466305e-02 3491:1.7403087e-01 "
          "3690:7.2856687e-02 "
          "3858:1.7263067e-01 3973:7.3958009e-02 4037:7.3799074e-02 4492:1.2360445e-01 5166:5.2890390e-02 "
          "5483:5.4483801e-02 "
          "5484:7.0126176e-02 6086:1.6554411e-01 6171:1.6998538e-01 6858:5.3109396e-02 7157:7.4319251e-02 "
          "7502:6.5168351e-02 "
          "7626:6.2204096e-02 7904:1.4150701e-01 7905:5.5091526e-02 7909:1.1336020e-01 8224:1.9635071e-01 "
          "8376:7.8653499e-02 "
          "8568:8.0502190e-02 8665:9.8245032e-02 8954:1.2403890e-01 9111:1.1121018e-01 9636:6.1581194e-02 "
          "11789:8.3692431e-02 12145:8.1212714e-02 15171:8.1602275e-02 16066:8.7211892e-02 17940:8.6479917e-02 "
          "19892:9.3631372e-02 28774:1.0198968e-01 29080:1.0360513e-01 37508:3.2965177e-01 38026:2.7250558e-01 "
          "38027:2.7823427e-01 39870:9.9310391e-02")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 10:7.2575375e-02 13:5.3105585e-02 14:6.1007094e-02 39:6.1041418e-02 52:7.5706534e-02 66:1.1474531e-01 "
          "69:3.6616009e-02 70:1.2180412e-01 224:6.8488613e-02 236:6.0067669e-02 257:6.7409925e-02 286:7.3488168e-02 "
          "312:1.5613814e-01 338:1.2275995e-01 348:7.7095561e-02 417:1.0991191e-01 433:6.2395446e-02 506:1.5152167e-01 "
          "526:5.4388072e-02 533:5.3715851e-02 608:9.9184752e-02 626:1.1936573e-01 976:1.2648109e-01 981:1.3516681e-01 "
          "1014:8.8521890e-02 1033:9.1250636e-02 1038:1.0818560e-01 1134:1.0287061e-01 1189:9.5804259e-02 "
          "1237:1.0322576e-01 "
          "1467:1.2899603e-01 1469:1.2493365e-01 1702:1.2064311e-01 1940:1.4617701e-01 3013:2.0334913e-01 "
          "3094:1.2731636e-01 "
          "3556:1.5597166e-01 6005:1.4457883e-01 7310:3.2087547e-01 14540:4.5219314e-01 44113:4.9592304e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:4.3041363e-02 13:5.6488983e-02 14:1.3618714e-01 15:1.2561819e-01 33:1.2377457e-01 51:3.8032405e-02 "
          "60:9.1334395e-02 65:9.1235265e-02 92:1.1930235e-01 107:9.3758404e-02 133:1.0392829e-01 286:1.2047397e-01 "
          "364:7.4946143e-02 417:5.5710375e-02 464:5.9082136e-02 466:1.4080983e-01 524:1.1203820e-01 526:5.7853177e-02 "
          "559:1.2415101e-01 670:1.2828813e-01 984:1.1284309e-01 1014:9.4161682e-02 1061:1.2484960e-01 "
          "1071:1.9851395e-01 "
          "1145:9.0154551e-02 1321:1.1310215e-01 1408:2.1865422e-01 1546:9.7079456e-02 1682:1.1468476e-01 "
          "1928:2.9595181e-01 "
          "2098:3.5129699e-01 2099:3.5332450e-01 2298:4.0724080e-02 2322:1.3922009e-01 2352:3.3869523e-01 "
          "2433:1.3344310e-01 "
          "2495:1.2877618e-01 2874:1.4713252e-01 3180:1.9468731e-01 3809:1.7077437e-01 4548:1.9092205e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:7.6948032e-02 13:3.6174063e-02 15:3.8331322e-02 17:3.4754235e-02 18:9.2369646e-02 19:8.4811136e-02 "
          "20:3.0235028e-02 21:4.1266091e-02 24:3.9324693e-02 25:6.2358715e-02 26:8.3359905e-02 39:1.1608061e-01 "
          "51:5.8118083e-02 52:5.1569201e-02 56:6.8823032e-02 57:1.5422770e-01 61:5.0647713e-02 64:5.8059540e-02 "
          "73:5.4274600e-02 74:1.1596075e-01 78:2.2976664e-01 85:5.6421570e-02 90:1.0413332e-01 128:7.1366541e-02 "
          "131:6.6856526e-02 183:4.9347039e-02 191:5.8684215e-02 192:7.3264159e-02 207:1.1775935e-01 223:7.9718642e-02 "
          "224:7.8989640e-02 229:4.0336646e-02 231:5.0938148e-02 233:8.9229591e-02 252:4.5883019e-02 253:6.9478773e-02 "
          "284:6.7818902e-02 286:2.9565129e-02 296:5.7838038e-02 319:5.1499210e-02 326:4.6474103e-02 327:5.0113387e-02 "
          "364:4.7993541e-02 374:5.7708595e-02 377:1.0159729e-01 386:6.7718349e-02 417:1.0509670e-01 425:8.7165497e-02 "
          "433:1.0142242e-01 453:5.3970054e-02 494:1.0301866e-01 504:1.3033639e-01 526:7.7748664e-02 533:3.6589757e-02 "
          "550:5.5963159e-02 553:5.5065818e-02 558:5.3040549e-02 576:7.4278675e-02 614:7.8533396e-02 620:1.3083416e-01 "
          "627:6.9430828e-02 629:2.1098308e-01 630:7.2366238e-02 642:5.6884773e-02 680:1.1581571e-01 684:6.5768711e-02 "
          "694:1.4590362e-01 809:9.7733602e-02 842:3.6895178e-02 967:7.6007128e-02 1000:5.8297474e-02 "
          "1012:5.4632526e-02 "
          "1116:1.4595905e-01 1162:1.1514889e-01 1295:7.5850993e-02 1387:1.7274390e-01 1452:1.0727701e-01 "
          "1455:4.2118270e-02 "
          "1629:8.7998495e-02 1668:1.5420632e-01 1874:9.7200349e-02 1922:8.8189125e-02 2010:8.2363419e-02 "
          "2298:2.6078632e-02 "
          "2338:7.9319425e-02 2438:8.2603358e-02 2474:7.8045420e-02 2604:8.2637846e-02 2605:1.5684801e-01 "
          "2949:7.9708070e-02 "
          "3178:1.2648946e-01 3486:1.1706361e-01 5761:1.2493036e-01 6409:1.5009408e-01 8374:1.4057986e-01 "
          "8944:1.4072882e-01 "
          "9468:1.7114536e-01 9542:1.4281800e-01 16939:1.8057093e-01 18916:1.8787301e-01 19549:1.4962879e-01 "
          "46077:2.2488354e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 6:8.6726151e-02 10:3.1343080e-02 17:5.2580785e-02 19:2.5622174e-02 24:3.4998380e-02 32:3.4493487e-02 "
          "42:4.6375811e-02 45:2.2027122e-02 46:5.7714082e-02 51:4.5488548e-02 54:5.3830452e-02 64:3.6810260e-02 "
          "69:2.6774298e-02 70:3.4132022e-02 91:4.0928457e-02 103:3.8919594e-02 106:3.7233032e-02 107:3.8066156e-02 "
          "110:5.1270004e-02 128:4.5247018e-02 138:3.7524387e-02 140:3.1676851e-02 145:7.3194697e-02 152:4.3961454e-02 "
          "161:2.9537480e-02 170:3.6824811e-02 175:3.9611842e-02 179:5.5282053e-02 181:4.4908069e-02 183:3.1286459e-02 "
          "187:4.6095151e-02 213:3.9488055e-02 217:2.8664095e-02 218:2.9477140e-02 223:2.9851111e-02 224:5.0080128e-02 "
          "231:3.2295235e-02 239:3.2710683e-02 247:4.5662746e-02 267:7.6077513e-02 271:2.3553189e-02 274:3.9220650e-02 "
          "286:1.8744553e-02 293:2.4058016e-02 295:3.5114519e-02 305:7.0167907e-02 315:3.5524782e-02 320:8.8822164e-02 "
          "325:7.4259304e-02 326:6.1835594e-02 338:7.4720256e-02 347:6.7153394e-02 354:1.1271958e-01 376:6.0722921e-02 "
          "384:1.2513331e-01 400:3.9448150e-02 469:7.4931473e-02 497:6.0599737e-02 511:3.9570745e-02 516:4.1328218e-02 "
          "526:3.9769553e-02 542:5.4554909e-02 545:3.8758121e-02 573:3.0649109e-02 575:6.2616266e-02 586:3.2930739e-02 "
          "607:5.8357902e-02 613:2.4248239e-02 614:8.4303260e-02 626:1.3451757e-01 637:5.2278031e-02 642:6.1064113e-02 "
          "644:5.4074537e-02 652:5.7144489e-02 673:4.0591221e-02 676:1.2712203e-01 690:4.2854346e-02 692:9.0814456e-02 "
          "721:6.5668158e-02 724:3.0879209e-02 751:5.1081870e-02 762:7.4926659e-02 768:4.0901449e-02 821:8.2716033e-02 "
          "842:2.3391869e-02 865:1.0980399e-01 866:1.2394888e-01 867:1.3751119e-01 908:6.7171104e-02 927:7.1092665e-02 "
          "929:4.0396702e-02 933:9.9634364e-02 954:4.6325278e-02 963:4.1015096e-02 979:1.2790573e-01 "
          "1028:2.7877148e-02 "
          "1061:8.5824378e-02 1075:4.9958751e-02 1083:6.5518975e-02 1116:5.4655213e-02 1159:8.0599025e-02 "
          "1160:4.4534177e-02 "
          "1189:4.1374922e-02 1193:7.6314203e-02 1194:5.5905718e-02 1340:5.1523969e-02 1414:2.4067029e-01 "
          "1594:5.7058476e-02 "
          "1603:4.9185682e-02 1617:4.7782753e-02 1643:5.6122355e-02 1659:5.7659753e-02 1664:3.7683837e-02 "
          "1670:4.0317237e-02 "
          "1694:5.6298375e-02 1727:7.6610573e-02 1744:6.3135087e-02 1865:8.4037557e-02 1881:9.4723031e-02 "
          "1898:6.9048241e-02 "
          "2088:8.5993811e-02 2190:4.9944881e-02 2376:1.0549559e-01 2418:7.8920074e-02 2474:4.9481485e-02 "
          "2550:6.7409225e-02 "
          "2563:6.5813713e-02 2663:6.2287133e-02 2806:5.2126877e-02 3074:5.9419025e-02 3103:9.7503811e-02 "
          "3188:4.5297287e-02 "
          "3616:6.7451552e-02 3617:6.3628629e-02 3635:1.6487806e-01 3840:7.4392207e-02 3841:4.2482756e-02 "
          "4003:1.3662669e-01 "
          "4539:7.7944517e-02 6347:9.2710465e-02 6442:7.0937365e-02 6912:7.7739820e-02 7196:1.2828773e-01 "
          "7319:8.8232942e-02 "
          "7331:8.4076874e-02 9018:1.0105550e-01 11659:2.0078093e-01 19328:1.1897916e-01 26959:1.3848068e-01 "
          "34577:4.8446566e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:5.0952014e-02 32:7.6631241e-02 51:3.4304522e-02 64:4.8299532e-02 101:1.4504756e-01 "
          "179:5.8522206e-02 "
          "188:3.6445778e-02 192:1.0319429e-01 208:9.0540946e-02 284:5.6418311e-02 348:7.3969126e-02 393:1.6511625e-01 "
          "425:2.0787553e-01 469:9.8319195e-02 580:1.1203759e-01 756:2.2900212e-01 915:1.1875520e-01 953:1.0854648e-01 "
          "1021:1.1687630e-01 1022:1.5536287e-01 1071:1.2704551e-01 1091:1.2887962e-01 1205:1.7951781e-01 "
          "1218:7.5390741e-02 "
          "1307:1.2778290e-01 1402:1.7807096e-01 1422:7.6448619e-02 1425:1.1484058e-01 1429:1.8672250e-01 "
          "1461:1.4643911e-01 "
          "1554:9.5934331e-02 2196:1.4846094e-01 2591:3.0864882e-01 3841:9.4380319e-02 4203:1.5448168e-01 "
          "4241:1.6223149e-01 "
          "6068:1.6758694e-01 6269:2.8403872e-01 6507:1.3571587e-01 9026:1.7503001e-01 11340:2.3514977e-01 "
          "17054:3.6490497e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:4.6607524e-02 7:5.0502088e-02 8:5.9874859e-02 13:2.3441575e-02 14:2.6929414e-02 17:3.8132209e-02 "
          "24:1.2142907e-02 35:3.5001211e-02 36:4.8076063e-02 39:6.4297669e-02 51:2.6722157e-02 52:5.6581523e-02 "
          "53:1.0222050e-01 61:3.2820813e-02 70:3.4886409e-02 76:4.3235555e-02 87:3.9704747e-02 91:7.0829526e-02 "
          "95:7.8552559e-02 99:1.1210222e-01 102:3.0567909e-02 106:3.8055953e-02 111:4.2473599e-02 112:6.8559378e-02 "
          "131:7.3354714e-02 135:4.4503096e-02 140:5.3385030e-02 144:7.2827011e-02 175:4.0487338e-02 180:4.1184593e-02 "
          "183:7.6308802e-02 189:5.3248871e-02 207:4.5070276e-02 209:3.5116363e-02 217:6.1484363e-02 218:8.8756278e-02 "
          "224:3.0231865e-02 229:5.4855667e-02 230:3.1946406e-02 234:3.2038122e-02 236:2.6514739e-02 240:2.7883237e-02 "
          "247:4.6671983e-02 262:8.4663130e-02 268:5.8676377e-02 269:4.6352256e-02 274:6.7874037e-02 282:5.5029720e-02 "
          "284:4.3948114e-02 286:4.9993813e-02 288:7.9591990e-02 301:6.3030191e-02 302:5.9354387e-02 306:8.6498134e-02 "
          "320:5.8906514e-02 321:4.3533456e-02 327:5.4984208e-02 337:3.6660958e-02 338:3.2004319e-02 339:7.0994131e-02 "
          "344:4.6945434e-02 347:4.0538486e-02 360:1.1094638e-01 364:3.1100852e-02 380:4.0118597e-02 381:3.9206527e-02 "
          "395:6.8475276e-02 403:1.4556369e-01 411:1.2180469e-01 417:4.8516709e-02 453:3.4973763e-02 454:3.4069091e-02 "
          "463:3.9556872e-02 477:7.3925331e-02 480:4.7084518e-02 496:4.7277056e-02 532:1.0253654e-01 545:3.9614752e-02 "
          "587:8.3291963e-02 601:5.2677236e-02 609:6.5792575e-02 620:4.6615828e-02 626:5.2689761e-02 631:4.7609691e-02 "
          "648:7.5478934e-02 660:5.2963678e-02 668:5.6094419e-02 675:5.4339673e-02 684:8.9441910e-02 690:4.3801513e-02 "
          "697:6.3549682e-02 702:7.7710502e-02 759:1.8168320e-01 773:3.5540499e-02 799:5.8865033e-02 811:3.0577434e-02 "
          "871:4.8860233e-02 948:1.6411592e-01 965:6.6619657e-02 968:5.8587842e-02 976:5.5830579e-02 984:7.9285301e-02 "
          "988:8.7144911e-02 992:4.2885788e-02 1000:3.7778024e-02 1007:1.3170047e-01 1012:1.3964519e-01 "
          "1028:2.8493287e-02 "
          "1033:1.1865935e-01 1045:4.3887693e-02 1046:5.0603177e-02 1061:5.1809594e-02 1071:3.4521531e-02 "
          "1075:5.1062938e-02 "
          "1099:7.7970922e-02 1115:4.6540175e-02 1122:6.4364210e-02 1145:6.3343987e-02 1160:4.5518469e-02 "
          "1179:4.9901389e-02 "
          "1186:5.2660774e-02 1193:1.2893203e-01 1194:5.7141341e-02 1211:5.4913614e-02 1213:6.1229136e-02 "
          "1280:5.2873567e-02 "
          "1360:5.3916153e-02 1406:8.0582261e-02 1415:7.9482011e-02 1452:4.1058347e-02 1488:6.2335163e-02 "
          "1506:5.2385587e-02 "
          "1511:8.8180356e-02 1522:6.7922838e-02 1528:4.9921628e-02 1530:5.4769553e-02 1546:6.8209529e-02 "
          "1605:7.2522745e-02 "
          "1674:3.4493402e-02 1682:4.7591429e-02 1703:1.1435808e-01 1722:1.4537561e-01 1776:7.6353431e-02 "
          "1778:5.3645048e-02 "
          "1806:7.7419043e-02 1831:6.3705266e-02 1850:5.0927609e-02 2166:1.2397415e-01 2182:5.5079211e-02 "
          "2196:6.8302669e-02 "
          "2327:7.0158318e-02 2359:7.0596337e-02 2362:3.3796437e-02 2385:7.9736292e-02 2438:5.3528763e-02 "
          "2496:7.7654257e-02 "
          "2506:4.6206936e-02 2545:6.5792575e-02 2549:1.0106106e-01 2574:7.8364559e-02 2576:6.1300494e-02 "
          "2602:5.2968681e-02 "
          "2858:1.5504116e-01 2914:7.8916632e-02 2915:8.2390152e-02 2962:7.4832916e-02 3164:6.1415128e-02 "
          "3207:7.7633038e-02 "
          "3209:8.2419381e-02 3266:7.0401751e-02 3361:7.0537031e-02 3536:7.8797683e-02 3655:6.2520586e-02 "
          "3669:6.0441695e-02 "
          "3679:8.8719830e-02 3742:6.3229911e-02 3959:1.0485899e-01 3970:8.1901826e-02 4150:8.9074552e-02 "
          "4450:8.5413076e-02 "
          "4510:7.5834684e-02 5271:8.8035360e-02 6122:8.5787587e-02 7288:1.0221625e-01 8205:8.4634513e-02 "
          "12977:1.1876401e-01 14297:9.6603699e-02 17567:1.4796245e-01 18109:1.0227180e-01 25732:9.9909894e-02 "
          "28159:1.4262252e-01 31640:1.2372992e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 4:1.3833031e-01 23:1.1330914e-01 24:1.7740333e-02 69:2.3613300e-02 74:4.6006121e-02 89:6.0454853e-02 "
          "101:9.7493351e-02 102:4.4658571e-02 126:9.3619481e-02 140:5.8629051e-02 145:1.0929819e-01 163:7.4712731e-02 "
          "167:6.1998636e-02 191:5.5558424e-02 252:4.3439079e-02 341:6.1298251e-02 365:4.2825706e-02 533:3.4640819e-02 "
          "703:1.1129136e-01 714:1.4241117e-01 720:1.5995154e-01 842:3.4929972e-02 895:8.6698346e-02 "
          "1059:3.7275225e-02 "
          "1144:1.3744962e-01 1250:8.9398377e-02 1589:1.3940011e-01 1717:1.0305198e-01 2024:7.8340568e-02 "
          "2065:7.3206440e-02 "
          "2074:7.5001955e-02 2262:7.9286203e-02 2298:2.4689566e-02 2834:8.5225262e-02 3039:9.2751868e-02 "
          "3326:8.2036830e-02 "
          "3501:1.0714546e-01 3507:8.3637930e-02 3602:2.1050607e-01 3735:3.2873771e-01 4062:3.6643025e-01 "
          "4731:1.2431975e-01 "
          "6477:1.3839118e-01 9938:2.0393555e-01 10277:3.7197280e-01 19439:4.1409221e-01 25040:2.0360412e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 19:1.5574834e-01 50:5.6592494e-02 90:8.0137588e-02 234:7.9846568e-02 239:8.3324559e-02 "
          "277:6.7762561e-02 "
          "326:7.5056747e-02 417:5.7616692e-02 476:1.1258750e-01 533:5.9093300e-02 546:1.9026326e-01 553:8.8932566e-02 "
          "555:1.2755781e-01 583:1.4078277e-01 655:6.8915084e-02 768:1.0418906e-01 842:1.0088883e-01 "
          "1396:1.8748435e-01 "
          "1544:1.7945109e-01 1850:1.2692364e-01 2298:4.2117592e-02 2495:2.7949882e-01 3144:1.3794634e-01 "
          "3195:1.6527554e-01 "
          "4206:2.6109689e-01 4785:2.0184259e-01 9720:5.3657299e-01 17413:4.5888913e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 15:2.0700416e-02 33:2.5281074e-02 36:4.0064953e-02 51:1.3152628e-02 52:2.7849389e-02 54:1.7571587e-02 "
          "55:3.3800710e-02 74:2.6242925e-02 84:3.1624343e-02 90:5.6236073e-02 95:3.8663518e-02 102:2.5474254e-02 "
          "112:3.3744879e-02 117:3.0028220e-02 121:3.2094926e-02 126:5.3402655e-02 140:3.8027808e-02 161:2.5159581e-02 "
          "179:3.7990641e-02 184:3.6728024e-02 188:4.3030892e-02 189:4.4375796e-02 193:2.8710470e-02 199:1.3789873e-01 "
          "208:3.4714121e-02 209:6.1415430e-02 231:6.5643601e-02 236:2.2096481e-02 240:3.9343562e-02 247:6.5854691e-02 "
          "251:7.1140647e-02 257:2.4797400e-02 259:4.5846570e-02 260:4.6765164e-02 267:3.8272917e-02 268:4.8898894e-02 "
          "274:3.3407561e-02 297:2.7307808e-02 301:5.2527215e-02 312:5.7436943e-02 334:5.6472071e-02 336:2.9971741e-02 "
          "354:5.2790049e-02 397:4.8151467e-02 433:4.8168976e-02 439:3.8291059e-02 457:4.9297448e-02 463:3.2965351e-02 "
          "481:3.1564172e-02 496:3.9399087e-02 506:2.6559802e-02 516:3.5202753e-02 521:5.3557575e-02 525:8.6610608e-02 "
          "526:2.0007186e-02 550:3.0222297e-02 555:2.5191782e-02 556:4.6684448e-02 577:5.3424142e-02 623:3.4095626e-02 "
          "628:3.6183521e-02 644:2.7203707e-02 702:5.6953929e-02 755:4.4877689e-02 756:5.1856834e-02 757:3.3480257e-02 "
          "802:5.4452937e-02 811:2.5482193e-02 815:3.7573531e-02 836:3.7615445e-02 837:8.8237233e-02 864:6.6134639e-02 "
          "871:6.8942331e-02 905:4.0152285e-02 914:6.0534406e-02 927:3.5765149e-02 932:3.3620954e-02 945:6.1865389e-02 "
          "1046:4.2170964e-02 1059:2.1262625e-02 1062:4.0302504e-02 1071:2.8769068e-02 1077:9.5892146e-02 "
          "1094:3.4949627e-02 "
          "1122:2.5559245e-02 1141:5.1271569e-02 1160:6.4227067e-02 1170:4.1367128e-02 1173:3.1163137e-02 "
          "1186:4.3885697e-02 "
          "1188:7.9284415e-02 1196:3.6364768e-02 1202:4.8870970e-02 1213:5.5797771e-02 1218:2.8905414e-02 "
          "1221:4.5057859e-02 "
          "1223:5.7963338e-02 1227:7.0697740e-02 1235:6.5994799e-02 1263:9.2874855e-02 1305:3.8197152e-02 "
          "1311:4.7830548e-02 "
          "1342:3.4957360e-02 1356:4.7737371e-02 1364:6.0627334e-02 1387:4.4452459e-02 1398:3.9611261e-02 "
          "1416:4.2350393e-02 "
          "1417:4.1721236e-02 1421:9.9071980e-02 1422:4.9627859e-02 1423:5.5887341e-02 1426:3.0698052e-02 "
          "1454:4.9758792e-02 "
          "1455:5.9353009e-02 1461:5.6145925e-02 1469:4.5958068e-02 1492:4.1174836e-02 1509:4.5537334e-02 "
          "1532:1.2498433e-01 "
          "1533:1.9209552e-01 1534:1.6738911e-01 1560:4.6135705e-02 1573:4.3252725e-02 1584:4.8326876e-02 "
          "1587:5.3563565e-02 "
          "1590:3.7715349e-02 1645:7.4423216e-02 1696:6.1508052e-02 1780:6.7664050e-02 1881:4.7653064e-02 "
          "1939:6.6962078e-02 "
          "1998:4.4781789e-02 2010:9.3345173e-02 2017:5.7167146e-02 2079:4.7306988e-02 2084:5.3485919e-02 "
          "2126:4.2942889e-02 "
          "2141:5.4069914e-02 2163:6.3037328e-02 2173:5.8369998e-02 2231:9.9078760e-02 2347:4.3487906e-02 "
          "2362:2.8164798e-02 "
          "2367:7.5729519e-02 2506:3.8507286e-02 2604:4.4627674e-02 2605:8.4704071e-02 2663:5.3055242e-02 "
          "2824:5.4002684e-02 "
          "2880:6.1191183e-02 2924:5.0349697e-02 2950:4.9032819e-02 2958:5.4419357e-02 2992:5.3826388e-02 "
          "3008:8.3934948e-02 "
          "3010:8.7310284e-02 3015:5.3944461e-02 3021:5.3086337e-02 3094:4.6834566e-02 3125:6.4632118e-02 "
          "3178:6.8309262e-02 "
          "3190:7.7159502e-02 3272:3.5484515e-02 3284:9.3898967e-02 3291:4.6904359e-02 3294:6.0458884e-02 "
          "3384:1.3233636e-01 "
          "3386:1.7908362e-01 3390:5.7711184e-02 3391:2.2914380e-01 3392:9.9559493e-02 3483:5.7813790e-02 "
          "3488:6.8927631e-02 "
          "3513:5.5964205e-02 3588:5.6635257e-02 3589:6.4268395e-02 3602:7.0919640e-02 3606:1.0351179e-01 "
          "3636:5.3026516e-02 "
          "3843:5.2566960e-02 4012:5.4208007e-02 4096:5.2426230e-02 4178:7.6631151e-02 4206:5.1564824e-02 "
          "4207:1.0796633e-01 "
          "4225:1.4012077e-01 4241:6.2200852e-02 4296:5.9460800e-02 4303:1.1690202e-01 4345:5.8926467e-02 "
          "4351:5.7890039e-02 "
          "4401:5.7095215e-02 4556:7.0813015e-02 4695:4.5922454e-02 5095:7.4864276e-02 5701:7.2696157e-02 "
          "6166:1.1224055e-01 "
          "6198:1.0840566e-01 6244:7.6065265e-02 6760:6.6665113e-02 6858:5.6897562e-02 7165:6.8467967e-02 "
          "7757:1.1378014e-01 "
          "8009:6.8588354e-02 8538:7.5383723e-02 8928:1.3133579e-01 9117:7.2429366e-02 9555:7.3929869e-02 "
          "10158:7.5623363e-02 13518:8.3609208e-02 15331:7.2860174e-02 20774:1.0813317e-01 21462:2.1236785e-01 "
          "29015:2.0266899e-01 32710:1.0803529e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:2.9395949e-02 69:3.9127525e-02 91:1.0127084e-01 106:9.2127107e-02 179:6.5179490e-02 "
          "252:7.1979083e-02 "
          "264:1.6561736e-01 274:9.7045146e-02 275:1.2831138e-01 276:1.1922409e-01 277:1.3813306e-01 305:1.7361912e-01 "
          "315:1.8446869e-01 347:9.8136902e-02 382:1.6746964e-01 387:1.1882319e-01 693:1.3021640e-01 726:9.3711190e-02 "
          "802:1.1268422e-01 905:1.9748497e-01 968:2.4014139e-01 979:4.2101237e-01 1000:9.1454290e-02 "
          "1160:1.1019260e-01 "
          "1222:1.1331024e-01 1335:1.2479147e-01 1375:1.4508973e-01 1694:1.3930121e-01 2028:3.0407351e-01 "
          "2089:1.8845358e-01 "
          "2173:1.6955818e-01 2474:1.2243392e-01 2811:2.5156802e-01 2818:1.7305905e-01 5685:1.9222908e-01 "
          "6560:1.5155666e-01 "
          "6968:2.0063856e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 14:5.0491154e-02 15:7.8854494e-02 26:5.9819169e-02 64:7.0542604e-02 69:3.0304421e-02 70:1.1380713e-01 "
          "84:7.1149886e-02 183:5.9956878e-02 188:3.1438444e-02 208:7.8101404e-02 213:7.5674288e-02 259:6.0920686e-02 "
          "271:4.5136962e-02 286:3.5921767e-02 288:4.8460267e-02 336:6.7431785e-02 380:7.5220145e-02 417:1.4315335e-01 "
          "421:2.3986235e-01 433:1.0837274e-01 476:8.4701166e-02 545:1.2575927e-01 547:6.2473554e-02 573:5.8735471e-02 "
          "613:7.8678764e-02 655:5.1845789e-02 679:1.3156749e-01 696:2.0904973e-01 842:4.4827811e-02 858:6.7536689e-02 "
          "1005:8.7164767e-02 1007:9.4629973e-02 1021:1.0081851e-01 1029:7.2354734e-02 1102:8.2534239e-02 "
          "1115:8.7260239e-02 "
          "1127:4.7033630e-02 1160:8.5344598e-02 1195:8.5940808e-02 1360:1.0108979e-01 1415:1.4902435e-01 "
          "1690:2.1380314e-01 "
          "1727:8.6711481e-02 2200:9.6442714e-02 2298:3.1685658e-02 2362:6.3366443e-02 2490:9.8973975e-02 "
          "2506:8.6635441e-02 "
          "2640:1.0033339e-01 3307:2.9391262e-01 4194:1.3500674e-01 4300:4.3323255e-01 4397:1.7512441e-01 "
          "5706:1.7365138e-01 "
          "6229:3.1077796e-01 15318:1.9857723e-01 21455:2.2676027e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:2.9738942e-02 15:9.8692425e-02 17:6.3490458e-02 25:6.7282662e-02 33:8.5520640e-02 35:5.8277320e-02 "
          "51:2.6278060e-02 61:5.4646939e-02 64:3.6998563e-02 65:6.3037977e-02 70:8.1865713e-02 75:6.6023208e-02 "
          "110:5.1532276e-02 117:1.0157926e-01 223:8.6013354e-02 232:5.8037084e-02 239:5.5667318e-02 253:7.4964933e-02 "
          "255:7.9948254e-02 286:5.4010782e-02 288:4.3034215e-02 293:4.0942136e-02 309:6.9723360e-02 311:6.4554349e-02 "
          "312:6.7776218e-02 338:5.3287465e-02 339:4.9535312e-02 345:8.3342403e-02 346:7.7693880e-02 380:6.6797808e-02 "
          "451:5.9232432e-02 454:5.6725331e-02 474:8.7983862e-02 526:8.3887823e-02 545:6.5958902e-02 546:6.0568940e-02 "
          "549:6.2036149e-02 550:6.0382102e-02 551:1.0459163e-01 552:1.0529398e-01 560:7.8009129e-02 573:5.2158915e-02 "
          "613:4.1265860e-02 614:8.4734522e-02 617:5.9660900e-02 620:7.7615753e-02 682:1.0442935e-01 724:5.2550502e-02 "
          "726:6.4452998e-02 752:1.0412925e-01 773:5.9175234e-02 842:3.9808482e-02 892:1.0280395e-01 "
          "1127:4.1767318e-02 "
          "1155:2.7004293e-01 1193:5.4424204e-02 1305:7.6315321e-02 1668:7.9282247e-02 1682:7.9240136e-02 "
          "1750:1.0233188e-01 "
          "1857:9.9944532e-02 1861:1.0908021e-01 2298:2.8137844e-02 2581:2.3375966e-01 3665:1.1480602e-01 "
          "4095:1.3857204e-01 "
          "4307:2.6519039e-01 4391:1.6621944e-01 13753:3.1575969e-01 13776:3.0212802e-01 22827:2.2031896e-01 "
          "22828:2.1962850e-01 34426:3.6853999e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 9:5.1918406e-02 10:5.6298286e-02 45:3.9565012e-02 50:3.9905146e-02 189:5.5268161e-02 "
          "199:9.8710723e-02 "
          "217:5.1486310e-02 221:6.9658041e-02 276:5.1116817e-02 281:1.1071762e-01 293:4.3212891e-02 301:1.1076637e-01 "
          "354:6.5747753e-02 360:8.1704959e-02 476:7.9388991e-02 478:7.2702803e-02 481:6.6560715e-02 533:4.1668545e-02 "
          "623:7.1898900e-02 625:7.2485141e-02 663:1.1049355e-01 670:9.3555391e-02 963:7.3671117e-02 "
          "1077:2.0221184e-01 "
          "1110:7.9559378e-02 1127:4.4083837e-02 1162:7.7448651e-02 1173:6.5715030e-02 1373:8.3953522e-02 "
          "1422:6.1809383e-02 "
          "1454:6.1972447e-02 1455:4.7964435e-02 1503:8.7904677e-02 1668:8.3679445e-02 1865:8.9152239e-02 "
          "2136:1.3617837e-01 "
          "2168:1.1419916e-01 2298:2.9698439e-02 2347:9.1704801e-02 2367:1.5969405e-01 2495:9.3911298e-02 "
          "3010:1.0874124e-01 "
          "3013:9.3165152e-02 3471:4.0575156e-01 4206:1.0873694e-01 4207:3.2087892e-01 4279:1.2751429e-01 "
          "4472:1.3326290e-01 "
          "5327:1.5314391e-01 6268:2.0862624e-01 7787:3.2642460e-01 8171:1.2131927e-01 11509:1.9116034e-01 "
          "14535:1.8151540e-01 15248:1.7972778e-01 21295:1.8620655e-01 29470:2.0754968e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 3:5.9628952e-02 5:4.6083994e-02 18:3.5066742e-02 19:5.4514714e-02 24:2.5277041e-02 49:7.6288380e-02 "
          "51:1.9403750e-02 64:2.7319781e-02 69:3.3645049e-02 70:2.5332056e-02 110:3.8051490e-02 130:8.2829863e-02 "
          "136:4.6111431e-02 147:3.8399816e-02 166:9.7877294e-02 169:3.9874773e-02 180:5.0634164e-02 217:3.6019802e-02 "
          "229:3.2136470e-02 230:3.9276328e-02 236:3.2598395e-02 242:5.9402239e-02 254:1.2726395e-01 264:4.9676985e-02 "
          "267:5.6463093e-02 277:3.3427928e-02 288:3.1776514e-02 293:3.0231722e-02 311:4.7667008e-02 327:3.9925665e-02 "
          "454:4.1886050e-02 465:1.5049087e-01 510:4.7466654e-02 533:4.9357437e-02 541:2.3898982e-01 547:4.0965348e-02 "
          "573:6.5210216e-02 664:5.2486263e-02 764:5.1675119e-02 773:4.3695062e-02 908:8.4408380e-02 "
          "1033:4.9521223e-02 "
          "1059:5.3111024e-02 1143:7.0629008e-02 1193:4.0186893e-02 1218:4.2643446e-02 1387:1.3762620e-01 "
          "1389:6.3785098e-02 "
          "1573:6.3809685e-02 1629:4.1407488e-02 1642:8.7760955e-02 1748:2.5333095e-01 1749:2.6428944e-01 "
          "1765:4.6707004e-02 "
          "1836:9.6118085e-02 1906:5.5494115e-02 1994:6.7402452e-02 2010:6.5619476e-02 2018:1.0382962e-01 "
          "2066:6.9617793e-02 "
          "2128:6.2659524e-02 2155:1.0694271e-01 2166:7.2628625e-02 2298:2.0777017e-02 2314:1.1907335e-01 "
          "2323:7.8708999e-02 "
          "2332:1.8508783e-01 2337:1.9620001e-01 2349:6.9340944e-02 2474:1.0527870e-01 2509:1.2938014e-01 "
          "2604:6.5838106e-02 "
          "2640:6.5790914e-02 2697:1.2168384e-01 2769:7.7299632e-02 3160:7.6406330e-02 3490:2.7831355e-01 "
          "4550:1.5477930e-01 "
          "5241:9.8046355e-02 5252:1.0370190e-01 6004:1.3559383e-01 6548:9.7147167e-02 11726:1.2324685e-01 "
          "13165:2.5313330e-01 14140:3.5598528e-01 14290:1.1701780e-01 27755:1.2491255e-01 33886:1.4526798e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 33:6.2755585e-02 51:9.1148056e-02 147:6.4611956e-02 233:5.0126459e-02 272:1.4715350e-01 "
          "370:8.6417109e-02 "
          "381:8.1105635e-02 422:2.1189648e-01 453:7.2349414e-02 533:8.3049379e-02 555:6.2533937e-02 560:9.6921824e-02 "
          "567:1.3149492e-01 585:8.4893450e-02 655:9.6852861e-02 994:1.0176907e-01 1011:8.5104041e-02 "
          "1040:7.9970688e-02 "
          "1045:1.5371990e-01 1055:1.7874588e-01 1099:1.6129664e-01 1133:1.0969486e-01 1213:8.9871399e-02 "
          "1280:2.6100886e-01 "
          "1304:1.0108235e-01 1416:2.5086400e-01 1554:9.1304488e-02 2146:1.3001113e-01 2234:9.0389952e-02 "
          "2298:3.4959640e-02 "
          "2777:1.5112884e-01 2780:1.3132241e-01 2796:2.6562428e-01 3387:1.2833355e-01 4337:1.2286689e-01 "
          "5678:1.9151421e-01 "
          "5733:2.6180121e-01 7051:2.1262130e-01 8084:3.2462227e-01 14423:1.7343985e-01 43482:3.3383930e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.1627733e-02 8:1.0221716e-01 10:5.4690916e-02 14:4.5973357e-02 15:1.0119210e-01 21:1.0893970e-01 "
          "52:5.7050470e-02 60:6.4704828e-02 66:8.6469077e-02 73:3.5462610e-02 130:6.7930162e-02 187:8.0431983e-02 "
          "197:8.4822848e-02 207:7.6943070e-02 224:5.1611234e-02 232:5.9507046e-02 233:1.0794454e-01 269:4.6736427e-02 "
          "286:7.8049943e-02 293:4.1979119e-02 323:7.4371174e-02 454:9.8476939e-02 477:7.4538022e-02 493:9.5504105e-02 "
          "526:8.6012535e-02 533:4.0478867e-02 560:7.9984948e-02 586:9.7290337e-02 618:1.3281870e-01 630:8.0058016e-02 "
          "657:9.5844097e-02 684:7.2759233e-02 709:9.1488279e-02 724:1.1307639e-01 757:6.8585500e-02 "
          "1012:1.0233279e-01 "
          "1145:6.3868985e-02 1246:1.4990638e-01 1448:2.5925392e-01 1752:1.2453829e-01 2087:1.0232145e-01 "
          "2104:9.0214588e-02 "
          "2320:1.5078288e-01 2337:1.2981869e-01 2371:8.3327226e-02 2534:8.8775076e-02 2640:9.1355853e-02 "
          "3160:1.0609619e-01 "
          "3352:1.2603877e-01 3368:1.4411251e-01 3811:2.3376593e-01 4150:1.5206629e-01 5272:1.4538135e-01 "
          "6155:1.2583876e-01 "
          "7990:1.3110274e-01 8855:1.8660143e-01 9811:2.4127060e-01 10063:1.8655066e-01 10597:1.2698554e-01 "
          "11560:4.4372913e-01 13218:2.2450250e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:3.0945810e-02 14:6.0191710e-02 15:3.2791279e-02 61:7.3359966e-02 63:5.5673964e-02 69:3.6126621e-02 "
          "73:2.7422462e-02 140:2.5243906e-02 142:1.2137757e-01 174:1.4707513e-01 271:3.1780373e-02 277:7.5326517e-02 "
          "293:3.2461535e-02 296:8.3774686e-02 305:4.5114443e-02 319:4.4056006e-02 320:9.6386433e-02 339:3.9274756e-02 "
          "350:8.8870049e-02 438:5.1075280e-02 500:1.1918874e-01 539:8.5298724e-02 581:1.2144008e-01 647:6.5617993e-02 "
          "755:7.1090207e-02 756:8.2145788e-02 764:5.5486545e-02 857:1.7249721e-01 886:6.6239506e-02 932:9.0174571e-02 "
          "960:8.8375352e-02 1028:3.7614699e-02 1059:3.3681870e-02 1071:7.7161349e-02 1139:9.6052475e-02 "
          "1175:9.0494402e-02 "
          "1239:6.8579793e-02 1623:5.3714778e-02 1644:1.2468517e-01 1685:8.1882931e-02 1765:5.0151993e-02 "
          "1827:1.2126604e-01 "
          "1902:9.3068577e-02 1919:1.2732694e-01 2090:6.1264660e-02 2095:8.6527057e-02 2097:6.3607968e-02 "
          "2136:6.0418397e-02 "
          "2202:8.8464163e-02 2226:9.0295441e-02 2298:2.2309477e-02 2477:7.0485860e-02 2570:1.0119022e-01 "
          "2925:1.5053663e-01 "
          "3111:9.6956834e-02 3261:9.6739851e-02 3736:8.7890595e-02 3751:8.5852265e-02 3845:2.0624125e-01 "
          "4960:1.0495791e-01 "
          "4969:1.0526187e-01 6155:9.7308360e-02 6157:1.4224382e-01 6160:1.1685744e-01 6445:1.1184806e-01 "
          "6475:1.6053885e-01 "
          "8171:9.1135070e-02 10870:1.4029074e-01 11474:2.1215531e-01 12286:1.4517929e-01 14220:3.1391507e-01 "
          "17889:1.4878036e-01 21981:3.5023782e-01 26227:2.0079611e-01 35309:2.6876143e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 6:9.5241554e-02 14:4.8989590e-02 24:4.6358757e-02 39:4.9017154e-02 69:4.9783934e-02 70:1.1542780e-01 "
          "111:7.7267341e-02 136:6.8230204e-02 140:3.4787115e-02 218:5.4809578e-02 223:5.5504937e-02 240:8.5884504e-02 "
          "288:4.7019102e-02 295:6.5291680e-02 302:1.0797662e-01 337:6.6693075e-02 341:7.6328345e-02 451:6.4717241e-02 "
          "469:8.2288787e-02 471:7.8598939e-02 497:1.1267871e-01 553:6.4915515e-02 679:7.5394981e-02 955:8.7290056e-02 "
          "995:1.1742100e-01 1005:8.4572561e-02 1029:7.0202962e-02 1084:1.7405869e-01 1288:1.7310533e-01 "
          "1454:1.7909946e-01 "
          "1654:1.4749189e-01 1666:8.8951565e-02 1837:8.6466342e-02 1850:9.2646755e-02 2521:2.7493519e-01 "
          "3841:7.8992121e-02 "
          "5005:1.7017771e-01 5579:1.1402871e-01 5580:1.9387427e-01 5791:2.5763381e-01 6577:3.1707853e-01 "
          "6968:4.4416669e-01 "
          "7052:1.3584366e-01 32398:3.9894307e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.2013624e-02 7:5.2679230e-02 9:5.2177928e-02 13:2.4452139e-02 14:2.8090339e-02 15:7.6329589e-02 "
          "16:1.0590988e-01 17:6.5585122e-02 18:7.0997104e-02 19:7.6263770e-02 23:3.8549937e-02 33:8.8342123e-02 "
          "39:6.7069538e-02 45:2.3484539e-02 48:4.3868449e-02 50:4.0104616e-02 51:1.6462920e-02 52:3.4858603e-02 "
          "54:3.7239175e-02 55:2.4987649e-02 61:5.7966106e-02 64:3.9245799e-02 65:1.0305351e-01 67:4.2526308e-02 "
          "70:4.5104913e-02 73:2.1668132e-02 74:3.2847822e-02 76:4.5099437e-02 79:3.4114622e-02 81:7.7164315e-02 "
          "82:4.4663277e-02 90:3.3541087e-02 92:5.1641885e-02 95:8.1938952e-02 111:4.4304632e-02 130:4.1506242e-02 "
          "131:4.5192193e-02 138:4.0007178e-02 140:1.9946724e-02 151:6.0452621e-02 169:5.7281472e-02 189:1.0102241e-01 "
          "208:4.3451075e-02 210:7.1444012e-02 217:5.1743671e-02 223:5.3886440e-02 229:4.6165135e-02 230:5.6421783e-02 "
          "233:5.3044051e-02 234:3.3419281e-02 240:2.9085282e-02 250:6.8633877e-02 262:5.2159052e-02 284:4.5842715e-02 "
          "286:4.1940302e-02 288:2.6960472e-02 293:4.3428894e-02 296:3.9096072e-02 301:6.5747418e-02 312:4.2461067e-02 "
          "337:3.8241409e-02 338:5.6524061e-02 339:3.1033339e-02 345:1.0957509e-01 346:1.0214864e-01 360:4.8497483e-02 "
          "363:4.4503402e-02 365:9.4160214e-02 381:1.0671745e-01 389:5.0798457e-02 415:4.2105872e-02 417:5.0608259e-02 "
          "449:7.2954945e-02 451:3.7108481e-02 453:3.6481481e-02 454:3.5537805e-02 464:6.1028581e-02 465:1.1228961e-01 "
          "474:5.5120938e-02 478:1.0297835e-01 479:5.9006579e-02 480:4.9114328e-02 500:5.5623144e-02 506:3.3244450e-02 "
          "524:4.8497483e-02 526:4.2400893e-02 541:1.2297514e-01 542:5.8164518e-02 543:5.7872105e-02 546:9.9017181e-02 "
          "548:5.4089196e-02 551:6.5525524e-02 552:6.5965541e-02 553:3.7222169e-02 556:5.8434125e-02 559:1.1278091e-01 "
          "564:5.2201021e-02 577:6.6870086e-02 580:5.3767432e-02 582:6.3005663e-02 606:7.5156957e-02 608:9.5841527e-02 "
          "620:6.8531893e-02 628:7.6683141e-02 632:1.3093835e-01 642:3.8451705e-02 655:2.8843978e-02 673:4.3276925e-02 "
          "768:4.3607678e-02 784:5.2437697e-02 811:5.4003987e-02 817:5.2883625e-02 921:6.6615589e-02 929:7.2923064e-02 "
          "934:7.1659848e-02 976:9.8604538e-02 995:6.7328498e-02 1007:5.2646607e-02 1014:4.0759355e-02 "
          "1029:4.0253960e-02 "
          "1071:8.5929863e-02 1127:7.7084966e-02 1134:4.7366139e-02 1173:6.6043518e-02 1193:5.7729840e-02 "
          "1240:4.2816110e-02 "
          "1372:7.0188455e-02 1373:8.4373184e-02 1403:6.4591393e-02 1422:1.0807984e-01 1434:8.9639768e-02 "
          "1455:5.9747856e-02 "
          "1506:5.4643925e-02 1511:7.4210338e-02 1547:8.0091611e-02 1575:4.8153628e-02 1602:6.5559559e-02 "
          "1603:5.2440036e-02 "
          "1656:6.4770393e-02 1702:5.5549376e-02 1704:1.3988610e-01 1734:8.0994546e-02 1747:6.1198708e-02 "
          "1782:7.4921742e-02 "
          "1785:6.6769555e-02 1811:6.0848810e-02 1837:8.3945028e-02 1872:6.9466911e-02 1888:5.6936450e-02 "
          "1956:7.9625323e-02 "
          "2087:6.2519781e-02 2136:4.7740199e-02 2299:6.2392604e-02 2314:5.9667949e-02 2326:1.0182066e-01 "
          "2346:1.0716777e-01 "
          "2347:1.1423391e-01 2351:1.4363031e-01 2514:8.0036022e-02 2830:7.4339367e-02 2874:6.3688606e-02 "
          "2881:9.4496951e-02 "
          "2886:7.5438954e-02 2949:5.3879291e-02 3108:8.3652392e-02 3144:5.7736576e-02 3156:7.6338537e-02 "
          "3907:8.5820615e-02 "
          "3950:9.2213839e-02 3951:8.7880947e-02 4222:6.8128645e-02 4346:1.2216473e-01 4347:6.7298673e-02 "
          "4500:8.1812695e-02 "
          "5587:9.0796873e-02 5643:8.1195071e-02 5862:7.4265093e-02 5973:8.0655165e-02 6089:8.2492493e-02 "
          "6115:7.7238463e-02 "
          "7032:9.5414035e-02 8045:8.4447652e-02 9390:8.4141798e-02 11108:8.4447652e-02 13715:2.0089523e-01 "
          "14088:9.4470523e-02 15678:1.2190255e-01 16278:1.0958812e-01 34877:1.9917940e-01 46534:1.5688966e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 19:8.4950879e-02 173:1.9058630e-01 400:1.3079120e-01 476:1.4654084e-01 544:3.4109634e-01 "
                  "620:8.9309230e-02 "
                  "641:5.3667849e-01 929:1.3393615e-01 1012:1.1484140e-01 1152:2.9389077e-01 1668:1.5446040e-01 "
                  "1810:1.7443454e-01 "
                  "2717:2.9153514e-01 3879:3.1377834e-01 13771:3.8768381e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 24:3.5259940e-02 210:1.1746269e-01 272:1.2199502e-01 302:6.0120460e-02 444:8.8242605e-02 "
          "497:6.2738545e-02 "
          "533:4.0664293e-02 545:6.7939311e-02 555:5.1842667e-02 594:8.5156955e-02 651:7.8021646e-02 660:4.3282278e-02 "
          "690:7.5119607e-02 693:9.2249729e-02 871:8.3795317e-02 888:8.1045613e-02 984:8.0308624e-02 "
          "1045:7.5267404e-02 "
          "1073:8.1240952e-02 1085:9.8759510e-02 1218:5.9485022e-02 1245:1.2233380e-01 1447:1.0039085e-01 "
          "1449:7.7783741e-02 "
          "1493:9.4888143e-02 1778:9.2001274e-02 1786:1.0934252e-01 2136:7.8490719e-02 2243:1.8855189e-01 "
          "2509:1.0659289e-01 "
          "3226:1.2683286e-01 3307:1.9075006e-01 4232:1.0996944e-01 4700:2.1821497e-01 4780:1.9473629e-01 "
          "4823:1.2268922e-01 "
          "5154:3.4727961e-01 5200:1.3794123e-01 5424:1.0629105e-01 8040:1.3356847e-01 9271:1.5978555e-01 "
          "13795:2.4659733e-01 16802:2.4933708e-01 16840:1.6365066e-01 16841:4.4720402e-01 24810:2.1912660e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 20:3.6729705e-02 50:4.2568382e-02 74:5.9032887e-02 189:5.8956712e-02 276:5.4528311e-02 "
                  "293:4.6096884e-02 "
                  "312:7.6309465e-02 464:4.5961771e-02 646:9.7183749e-02 802:8.7260127e-02 1102:8.2520775e-02 "
                  "1240:7.6947533e-02 "
                  "1266:2.2145979e-01 1295:9.2144273e-02 1426:6.9054604e-02 1454:6.6108435e-02 1455:5.1165543e-02 "
                  "1461:2.1384285e-01 "
                  "1698:1.3894050e-01 1773:9.4405569e-02 2422:2.1617095e-01 2581:2.3146152e-01 2614:9.9669963e-02 "
                  "3272:7.9821646e-02 "
                  "3426:1.3079403e-01 3427:2.3287509e-01 3433:3.3518818e-01 3453:1.4110875e-01 5230:3.4488061e-01 "
                  "5239:1.5523829e-01 "
                  "5390:2.9576606e-01 8242:1.3338073e-01 11149:1.5178277e-01 11150:2.5405210e-01 11202:1.5036848e-01 "
                  "11228:3.5370305e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 15:4.0280692e-02 20:3.1772655e-02 55:9.2698552e-02 138:6.2195856e-02 140:5.2503690e-02 "
          "161:8.2892641e-02 "
          "181:1.2602797e-01 182:5.2446447e-02 183:5.1856622e-02 188:2.7191067e-02 217:4.7510114e-02 223:4.9477566e-02 "
          "231:5.3528648e-02 236:4.2997278e-02 240:4.5216486e-02 269:7.5166531e-02 286:5.2603859e-02 295:5.8201551e-02 "
          "296:6.0779437e-02 318:7.6095775e-02 323:7.0644595e-02 354:6.0670175e-02 364:5.0434291e-02 400:6.5384448e-02 "
          "433:4.4663534e-02 438:6.2740691e-02 506:5.1682401e-02 550:5.8809210e-02 553:1.2143879e-01 555:4.9020391e-02 "
          "558:5.5737972e-02 559:8.3546244e-02 561:8.0730341e-02 586:5.4581985e-02 624:9.3174390e-02 644:5.2935369e-02 "
          "645:8.4917948e-02 920:9.4532609e-02 954:1.6113804e-01 960:1.8380800e-01 1061:8.4016345e-02 "
          "1084:1.5515737e-01 "
          "1173:1.0267241e-01 1215:9.1186345e-02 1237:7.3890448e-02 1238:9.3727522e-02 1282:8.0825508e-02 "
          "1426:1.2536055e-01 "
          "1454:5.7186425e-02 1455:9.2885062e-02 1509:8.8610560e-02 1546:6.5328695e-02 1580:1.5432303e-01 "
          "1968:1.9629362e-01 "
          "2298:2.7404882e-02 2378:1.0103593e-01 2438:1.4697233e-01 2490:8.5602455e-02 2538:8.9550696e-02 "
          "2577:9.2698611e-02 "
          "2939:1.2816228e-01 3231:1.0025816e-01 3403:9.3670279e-02 4206:2.1057345e-01 4331:1.2455515e-01 "
          "4785:1.3133401e-01 "
          "4965:1.0885483e-01 5205:1.3586406e-01 5391:2.5498012e-01 5862:1.1545382e-01 6093:1.0820258e-01 "
          "6820:2.2542216e-01 "
          "8780:1.5286262e-01 9542:1.5008113e-01 10460:1.5588790e-01 19139:3.7544155e-01 39620:2.1159071e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 45:4.0414255e-02 69:6.0888097e-02 73:3.7288420e-02 121:6.9132656e-02 236:4.7595944e-02 "
          "394:7.9721101e-02 "
          "417:4.1499387e-02 434:1.3306430e-01 464:4.4011056e-02 482:1.6646945e-01 500:9.5721178e-02 534:9.9945098e-02 "
          "579:1.1512957e-01 678:9.2360988e-02 690:7.8626998e-02 702:9.8976709e-02 726:6.9487907e-02 767:7.3544726e-02 "
          "784:9.0239383e-02 865:9.5998116e-02 905:1.4643733e-01 963:7.5252429e-02 992:1.8370458e-01 "
          "1067:1.4068358e-01 "
          "1071:6.1968736e-02 1093:1.2983972e-01 1127:4.5030076e-02 1168:7.8018278e-02 1222:8.4020823e-02 "
          "1504:1.0093144e-01 "
          "1665:1.2943436e-01 1774:1.0357221e-01 1945:1.2061939e-01 2153:7.0579104e-02 2224:1.1946639e-01 "
          "2298:3.0335901e-02 "
          "2329:1.0700605e-01 2986:1.4160600e-01 3188:8.3109185e-02 3484:3.1196496e-01 4259:1.4523777e-01 "
          "4505:1.6704829e-01 "
          "5025:1.3665108e-01 5045:5.6743258e-01 6828:1.6854022e-01 16562:2.2461848e-01 44418:2.3049298e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 13:3.5510998e-02 14:4.0794626e-02 19:6.7170866e-02 20:2.9680824e-02 21:4.0509690e-02 24:3.1145368e-02 "
          "34:9.5946260e-02 51:4.0480658e-02 55:3.6288701e-02 70:3.1213153e-02 76:6.5496355e-02 161:4.5734480e-02 "
          "169:4.9132112e-02 176:7.5689673e-02 229:6.7044027e-02 230:4.8394732e-02 234:4.8533667e-02 252:4.5041990e-02 "
          "268:8.8887230e-02 275:8.0292769e-02 276:4.4063661e-02 284:3.9320730e-02 286:2.9023204e-02 296:9.6133299e-02 "
          "321:6.5947637e-02 322:8.0004856e-02 336:5.4481909e-02 337:5.5536676e-02 364:4.7113825e-02 370:6.3282438e-02 "
          "379:7.7116027e-02 394:6.7277029e-02 417:3.5021536e-02 465:7.7705786e-02 547:5.0475877e-02 548:7.8551874e-02 "
          "567:9.6292496e-02 613:7.8792103e-02 622:7.2400391e-02 623:6.1978206e-02 660:3.8231555e-02 664:6.4671487e-02 "
          "757:6.0859598e-02 812:8.5125886e-02 918:8.9599371e-02 979:9.4368733e-02 1160:6.8954676e-02 "
          "1183:8.3501421e-02 "
          "1413:1.0175154e-01 1422:5.3280853e-02 1455:4.1346248e-02 1524:1.0097626e-01 1629:5.1020663e-02 "
          "1703:1.0231709e-01 "
          "1768:6.5970846e-02 1806:1.1727997e-01 1914:1.0453752e-01 2015:1.1330476e-01 2017:1.0391705e-01 "
          "2165:1.0107109e-01 "
          "2362:5.1197290e-02 2709:1.3458057e-01 3282:9.2146330e-02 3306:1.7594194e-01 3400:8.8038042e-02 "
          "3457:7.7375345e-02 "
          "3669:2.3892394e-01 4073:1.5048082e-01 4276:7.9298832e-02 4377:1.1268108e-01 4378:1.0899535e-01 "
          "4394:1.5377837e-01 "
          "4397:1.4149280e-01 5188:1.6622205e-01 5249:1.1943222e-01 5494:1.2079648e-01 6916:1.2080882e-01 "
          "9501:1.3832329e-01 "
          "13963:1.2996653e-01 15085:1.7255881e-01 15086:1.7965798e-01 15091:1.8159358e-01 15092:1.7803203e-01 "
          "22552:1.7949000e-01 28739:2.8223240e-01 34721:1.8243602e-01 38569:2.1605492e-01 46458:2.1924339e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:4.9571339e-02 9:5.3202420e-02 10:3.4073010e-02 13:4.2213965e-02 15:5.5443440e-02 17:5.0269447e-02 "
          "19:2.7853824e-02 20:3.5283301e-02 21:5.9688363e-02 23:3.9306849e-02 24:3.8046680e-02 39:2.8657997e-02 "
          "45:6.2484689e-02 50:2.4151508e-02 51:3.5227645e-02 52:6.0179595e-02 53:5.9777174e-02 54:5.8518998e-02 "
          "55:4.3138467e-02 56:8.0314256e-02 57:4.4545364e-02 61:3.4907922e-02 64:4.0016372e-02 73:5.2721780e-02 "
          "74:5.6708198e-02 75:4.2174965e-02 77:6.1118480e-02 79:3.4784447e-02 82:7.7106304e-02 106:4.0475968e-02 "
          "118:9.9385507e-02 136:3.9890949e-02 147:3.3219639e-02 152:4.7790427e-02 169:7.2392948e-02 170:8.4012054e-02 "
          "181:4.8819490e-02 183:5.7586405e-02 189:7.0197649e-02 190:7.7616103e-02 191:4.0446918e-02 223:3.2451093e-02 "
          "229:2.7801225e-02 230:3.3977907e-02 259:3.4558192e-02 269:4.9299840e-02 271:4.3352414e-02 286:4.8625931e-02 "
          "293:2.6153430e-02 298:3.9747704e-02 300:9.3147755e-02 310:5.8990639e-02 312:4.3294776e-02 318:1.3023525e-01 "
          "319:6.0097914e-02 327:3.4539647e-02 348:6.1283741e-02 359:4.4580311e-02 364:3.3078585e-02 370:4.4430554e-02 "
          "383:7.1959205e-02 417:4.1632116e-02 441:8.7316729e-02 443:7.6703578e-02 444:5.4725379e-02 454:7.6044425e-02 "
          "501:8.1578225e-02 526:4.3233417e-02 529:5.4197948e-02 530:6.0959689e-02 546:3.8690835e-02 549:1.2669986e-01 "
          "553:3.7953012e-02 558:3.6557138e-02 565:1.0334374e-01 573:6.9922820e-02 580:5.4823134e-02 629:1.2322158e-01 "
          "660:2.6842350e-02 767:7.3779941e-02 769:1.4124213e-01 811:3.2521881e-02 842:4.3055482e-02 898:5.0408684e-02 "
          "911:4.6926010e-02 920:6.2001564e-02 925:5.4264251e-02 984:4.9804963e-02 995:8.5090488e-02 "
          "1014:4.1559651e-02 "
          "1036:4.6050791e-02 1054:1.0306821e-01 1098:1.1988775e-01 1127:2.6680548e-02 1140:7.8529291e-02 "
          "1198:9.0028547e-02 "
          "1260:1.7369935e-01 1284:6.8905577e-02 1288:4.2411551e-02 1304:5.1970556e-02 1449:1.1511271e-01 "
          "1469:5.8654405e-02 "
          "1530:9.8629892e-02 1590:4.8134562e-02 1603:5.3469677e-02 1670:4.3828804e-02 1731:4.6107557e-02 "
          "1771:1.4884703e-01 "
          "1782:7.6392800e-02 1811:6.2043551e-02 1921:5.3716592e-02 1944:8.8915512e-02 1955:1.4737286e-01 "
          "1993:7.6158106e-02 "
          "2014:6.1713733e-02 2234:4.6473153e-02 2344:2.0998187e-01 2493:8.8718928e-02 2496:8.2592368e-02 "
          "2520:1.8489470e-01 "
          "2534:1.1606963e-01 2739:1.0292295e-01 2957:6.4199209e-02 3298:6.5590367e-02 3325:5.5329245e-02 "
          "3825:6.3753046e-02 "
          "4606:8.4417611e-02 5013:1.0154102e-01 5015:8.0033533e-02 5577:1.4689463e-01 5862:7.5723261e-02 "
          "6545:8.1653528e-02 "
          "6566:1.0125647e-01 6624:9.1638193e-02 7686:9.7595640e-02 8314:9.5418602e-02 10194:1.0415505e-01 "
          "10521:1.4890957e-01 10653:9.7411923e-02 10664:2.0873204e-01 10681:1.8252103e-01 10929:1.1533198e-01 "
          "14013:1.7004678e-01 14149:1.1619143e-01 14234:1.0555563e-01 14235:1.0935816e-01 14237:1.1429149e-01 "
          "15808:1.2561381e-01 18347:1.0789288e-01 37766:1.1710033e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("1 |f 19:1.1791160e-01 99:1.9342545e-01 224:1.3611665e-01 238:1.4218083e-01 252:1.3387141e-01 "
                  "296:2.8572229e-01 "
                  "573:1.4104523e-01 644:1.4697337e-01 820:1.7797065e-01 981:2.6863524e-01 1102:1.9819473e-01 "
                  "1122:1.3808885e-01 "
                  "1823:2.8131601e-01 3969:5.4792714e-01 5947:2.6007256e-01 6634:3.9962220e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:2.2569532e-02 13:2.9621040e-02 22:6.5765634e-02 35:4.4227928e-02 39:3.4047458e-02 45:2.8448902e-02 "
          "55:3.0269751e-02 63:5.3290602e-02 69:2.0423545e-02 86:6.8586178e-02 90:4.0631287e-02 121:4.8664715e-02 "
          "125:8.1402041e-02 130:1.0551862e-01 135:5.6234621e-02 161:6.4591579e-02 163:6.4620309e-02 191:4.8053421e-02 "
          "220:5.0669659e-02 236:3.3504326e-02 240:3.5233576e-02 254:5.4813311e-02 259:4.1057251e-02 283:5.6452502e-02 "
          "287:8.3875149e-02 362:8.5199900e-02 369:7.2458014e-02 376:7.8426056e-02 381:4.9541812e-02 388:4.4259883e-02 "
          "417:6.9710255e-02 421:7.7029124e-02 457:7.4748456e-02 474:6.6772871e-02 481:4.7859944e-02 506:4.0271945e-02 "
          "511:5.1107183e-02 617:4.5277957e-02 673:5.2425172e-02 684:5.3854544e-02 702:4.1149944e-02 895:7.4986868e-02 "
          "898:5.9888612e-02 1012:4.4735711e-02 1013:1.6343039e-01 1059:3.2239974e-02 1218:9.1979109e-02 "
          "1342:5.3004947e-02 "
          "1398:6.0061537e-02 1399:1.0104361e-01 1467:7.1950935e-02 1527:8.3373211e-02 1658:1.0620426e-01 "
          "1670:5.2071307e-02 "
          "1674:4.3586254e-02 1717:2.1269377e-01 1889:5.2947205e-02 1906:5.7036329e-02 1986:8.7764293e-02 "
          "2104:1.1305914e-01 "
          "2293:1.4103913e-01 2298:2.1354424e-02 2433:6.9973350e-02 2903:8.3465166e-02 2937:8.5332908e-02 "
          "3046:6.0033880e-02 "
          "3533:7.8746706e-02 3845:7.5653158e-02 3983:9.7022057e-02 4550:1.5908073e-01 5253:9.3513243e-02 "
          "5401:8.0090426e-02 "
          "6061:2.8745261e-01 7201:1.0207684e-01 8625:1.3920194e-01 9804:1.3748865e-01 12425:1.7531814e-01 "
          "15408:2.2224186e-01 15710:1.3853619e-01 15712:1.2770191e-01 16053:2.1900755e-01 17317:4.2601734e-01 "
          "18690:3.1253320e-01 20103:1.5290672e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 15:2.3312449e-02 17:2.1136926e-02 20:1.8388422e-02 24:3.3572737e-02 26:2.9943088e-02 31:5.6113821e-02 "
          "42:7.5322554e-02 45:4.4343378e-02 51:1.4812263e-02 54:1.9788817e-02 55:2.2482257e-02 62:4.7859505e-02 "
          "69:1.5169182e-02 111:3.9862420e-02 147:4.9631748e-02 187:4.4217486e-02 188:1.5736829e-02 213:3.7879527e-02 "
          "218:5.9341207e-02 229:2.4532054e-02 230:2.9982414e-02 276:2.7299147e-02 286:1.7981002e-02 326:2.8264748e-02 "
          "363:4.0041257e-02 378:4.9764730e-02 433:2.5849018e-02 437:3.9232373e-02 439:4.3122727e-02 447:6.4861901e-02 "
          "464:2.3010381e-02 500:5.0046075e-02 561:4.6722680e-02 572:6.4663343e-02 575:3.5475727e-02 584:5.2702796e-02 "
          "585:3.8514666e-02 617:3.3629306e-02 653:1.2741180e-01 660:4.0103771e-02 667:1.6281565e-01 679:6.5857433e-02 "
          "693:5.0483037e-02 802:5.4319736e-02 820:3.7097670e-02 837:7.0506863e-02 850:6.0822479e-02 879:8.4899999e-02 "
          "888:4.4351663e-02 889:5.6705035e-02 946:5.3136952e-02 954:4.4438239e-02 965:3.6927700e-02 992:4.0249269e-02 "
          "1000:3.5455517e-02 1018:1.5019031e-01 1028:2.6741585e-02 1036:6.8802111e-02 1045:4.1189577e-02 "
          "1059:2.3945600e-02 "
          "1081:1.4448093e-01 1091:5.5648603e-02 1122:2.8784379e-02 1125:5.3981084e-02 1127:2.3543157e-02 "
          "1179:7.9296120e-02 "
          "1193:3.0677514e-02 1212:4.5043539e-02 1213:4.0773071e-02 1218:3.2552775e-02 1263:4.9839627e-02 "
          "1305:1.0265116e-01 "
          "1316:7.2023682e-02 1350:5.1238962e-02 1363:5.3808291e-02 1377:6.8995155e-02 1397:7.9382271e-02 "
          "1471:8.5030131e-02 "
          "1509:5.1283360e-02 1512:1.5708025e-01 1554:7.0135646e-02 1566:4.6665289e-02 1573:4.8710469e-02 "
          "1670:3.8674932e-02 "
          "1972:4.9498253e-02 2090:4.3555155e-02 2107:4.2731181e-02 2134:6.2748544e-02 2137:6.4927459e-02 "
          "2139:2.1120659e-01 "
          "2165:1.4942369e-01 2170:1.7031045e-01 2179:6.6696852e-02 2212:4.6756312e-02 2330:5.9650507e-02 "
          "2422:6.3918948e-02 "
          "2548:5.0079059e-02 2558:7.1772955e-02 2576:5.7531878e-02 2949:4.8477072e-02 3062:6.7096904e-02 "
          "3137:4.5897134e-02 "
          "3189:7.2410025e-02 3396:9.5555775e-02 3513:6.3025914e-02 3569:9.3430191e-02 3578:7.4291006e-02 "
          "4038:1.4313830e-01 "
          "4185:9.4768047e-02 4320:7.5559661e-02 4396:1.0317643e-01 4726:6.8795502e-02 5114:1.5545914e-01 "
          "5272:7.9923399e-02 "
          "5342:2.8364262e-01 5393:8.6986728e-02 5651:1.3086396e-01 5656:6.4047053e-02 6669:5.6129802e-02 "
          "6809:7.8536339e-02 "
          "7727:7.9677925e-02 8189:1.3897274e-01 8242:6.6775955e-02 8370:8.8327751e-02 8455:8.7226219e-02 "
          "8472:8.1718117e-02 "
          "8478:8.0178887e-02 9411:9.8288722e-02 9933:1.6187589e-01 9935:1.7572716e-01 10183:1.8179466e-01 "
          "10329:8.5294545e-02 10390:9.2130072e-02 10491:8.2523324e-02 16847:1.7397434e-01 17581:1.7383172e-01 "
          "17668:1.3613629e-01 19206:1.3017537e-01 28552:2.2146516e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 14:7.0019707e-02 16:1.0117023e-01 23:9.6091941e-02 70:5.3574108e-02 85:9.5066614e-02 188:4.3597944e-02 "
          "215:1.0748777e-01 234:8.3302960e-02 236:6.8941504e-02 239:1.4718783e-01 284:6.7489915e-02 286:8.4344611e-02 "
          "323:1.1327099e-01 387:2.1608491e-01 468:1.3206467e-01 726:1.0065144e-01 782:2.3940288e-01 897:9.9176139e-02 "
          "1028:7.4085958e-02 1094:1.0904360e-01 1127:6.5224908e-02 1262:1.7830278e-01 1374:2.2594690e-01 "
          "2089:2.0241046e-01 "
          "2311:1.3807064e-01 2433:1.4398342e-01 2506:1.2014357e-01 2525:3.0000097e-01 3367:4.1591436e-01 "
          "6254:5.3696746e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 17:3.4567621e-02 19:4.0195961e-02 24:3.9113536e-02 64:3.4106769e-02 141:6.7757808e-02 "
          "170:5.7770614e-02 "
          "180:6.3213088e-02 239:5.1316384e-02 284:3.9839853e-02 298:5.7360064e-02 327:4.9844299e-02 364:8.0823794e-02 "
          "384:9.3542114e-02 438:1.0054550e-01 535:5.8712810e-02 549:1.2001424e-01 555:4.6397585e-02 629:6.8145528e-02 "
          "645:8.0374464e-02 678:9.7884901e-02 814:6.3255586e-02 897:5.8544490e-02 942:8.5645333e-02 "
          "1071:5.2986138e-02 "
          "1193:5.0170429e-02 1195:1.1911815e-01 1213:3.9382778e-02 1617:7.4961387e-02 1666:4.4325557e-02 "
          "1765:5.8310311e-02 "
          "1786:9.7858176e-02 1861:1.0055454e-01 1970:8.6709216e-02 2022:9.1767684e-02 2298:2.5938600e-02 "
          "2368:1.1541830e-01 "
          "2372:1.2870164e-01 2381:8.8516533e-02 2493:1.0329431e-01 2534:7.9814903e-02 2733:1.1130546e-01 "
          "3404:1.0284683e-01 "
          "3852:1.0506861e-01 3923:1.4179096e-01 4076:9.9077530e-02 4078:1.1107217e-01 4443:1.2197631e-01 "
          "4559:1.2529337e-01 "
          "4560:1.1132853e-01 4565:9.9695221e-02 4566:1.0973478e-01 4567:1.2731850e-01 4569:1.2414449e-01 "
          "4570:1.2145450e-01 "
          "4571:1.2759164e-01 4572:1.2770182e-01 4573:1.2762308e-01 4574:1.2923534e-01 4575:1.2654817e-01 "
          "7890:1.9347456e-01 "
          "7966:1.6992296e-01 7967:1.8644573e-01 10694:1.1382271e-01 12590:1.1327558e-01 12679:1.4626560e-01 "
          "12680:1.4798453e-01 13777:3.0748692e-01 14064:2.9317814e-01 20679:3.8573670e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 13:7.6524444e-02 24:2.3412153e-02 69:3.1162785e-02 84:7.3165186e-02 140:3.6868900e-02 "
          "142:1.0470017e-01 "
          "161:5.8208492e-02 175:7.8061685e-02 188:3.2328930e-02 189:6.0636535e-02 236:5.1121790e-02 275:1.0219251e-01 "
          "276:5.6081958e-02 277:5.2422687e-02 286:6.2543571e-02 326:9.8313674e-02 357:9.1101423e-02 358:1.0524533e-01 "
          "411:9.8414406e-02 463:7.6267697e-02 534:1.0734890e-01 646:9.9952757e-02 664:8.2310542e-02 757:7.7458970e-02 "
          "1028:5.4936532e-02 1071:1.1269468e-01 1173:7.2098143e-02 1202:1.1306649e-01 1213:4.9471244e-02 "
          "1237:8.7852344e-02 "
          "1266:9.5449135e-02 1307:1.1334878e-01 1422:6.7813128e-02 1768:1.4216390e-01 1915:1.3876088e-01 "
          "2135:1.3306524e-01 "
          "2879:1.3884477e-01 2950:1.1344094e-01 3384:1.2830338e-01 3414:1.5914486e-01 3426:1.3452068e-01 "
          "3512:1.9639419e-01 "
          "3599:2.0612454e-01 3772:1.6826244e-01 4259:1.5599680e-01 4276:1.0092747e-01 5995:1.4563948e-01 "
          "6499:2.8928432e-01 "
          "6909:1.1382619e-01 7757:2.1237916e-01 8737:1.1415749e-01 8738:1.1502828e-01 11176:3.0075887e-01 "
          "13261:1.6885847e-01 14187:2.1581803e-01 14189:2.2812790e-01 14190:2.2750281e-01 14998:1.9226764e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 13:4.9640480e-02 20:4.1490540e-02 24:7.9185165e-02 51:7.9753540e-02 62:2.2662354e-01 "
          "107:8.2391500e-02 "
          "163:1.8335781e-01 171:2.9491165e-01 188:3.5507642e-02 217:1.0504524e-01 218:6.3801184e-02 223:6.4610615e-02 "
          "232:7.3813923e-02 271:5.0979212e-02 337:7.7634186e-02 468:1.0755793e-01 518:1.2785436e-01 522:1.2285697e-01 "
          "550:1.3002762e-01 1029:1.7149833e-01 1125:1.2179970e-01 1321:2.5935227e-01 1666:6.1154883e-02 "
          "2298:3.5786852e-02 "
          "2335:1.1064569e-01 2493:1.7664073e-01 2520:3.4886509e-01 2669:1.8152381e-01 2682:3.3677894e-01 "
          "3144:1.1721148e-01 "
          "4674:1.6338165e-01 5584:2.1123841e-01 35374:4.4362769e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 9:3.7248660e-02 13:2.9555300e-02 17:2.8395260e-02 39:5.7519417e-02 54:2.6584215e-02 55:3.0202571e-02 "
          "82:5.3984504e-02 90:6.8642065e-02 106:4.7981210e-02 140:5.7532616e-02 163:6.4476892e-02 166:5.9282560e-02 "
          "169:6.9236115e-02 193:4.3436334e-02 197:1.0606617e-01 210:4.1148320e-02 217:3.6938652e-02 220:5.0557204e-02 "
          "233:3.0550826e-02 239:4.2153381e-02 252:3.7487809e-02 253:5.6766257e-02 264:5.0944224e-02 271:7.9202615e-02 "
          "278:8.4692985e-02 297:8.6702555e-02 353:5.6459561e-02 357:5.9573766e-02 358:6.8822868e-02 359:5.2846599e-02 "
          "389:6.1400097e-02 413:1.0227356e-01 415:5.0893366e-02 465:1.8055265e-01 495:6.8052046e-02 514:5.0026048e-02 "
          "545:4.9946554e-02 547:4.2010359e-02 584:1.1987603e-01 585:5.1740441e-02 586:4.2436961e-02 637:6.7369297e-02 "
          "689:1.3629048e-01 702:4.1058619e-02 802:2.7964989e-02 811:3.8552240e-02 814:5.1960733e-02 905:6.0746759e-02 "
          "933:6.1181448e-02 963:8.9491390e-02 1045:5.5333909e-02 1090:8.7799616e-02 1091:7.4758098e-02 "
          "1102:5.5500176e-02 "
          "1117:8.7685503e-02 1131:7.4733473e-02 1166:7.5341552e-02 1229:7.8702725e-02 1435:7.5438127e-02 "
          "1449:1.3645744e-01 "
          "1454:1.1602055e-01 1455:3.4411896e-02 1493:6.9758371e-02 1538:6.4867459e-02 1589:7.1052261e-02 "
          "1602:7.9241842e-02 "
          "1666:3.6410827e-02 1674:1.0377880e-01 1747:7.3970877e-02 1810:2.0878312e-01 2010:6.7293398e-02 "
          "2028:6.0689755e-02 "
          "2066:1.2088006e-01 2098:6.5836698e-02 2099:6.6216677e-02 2122:6.6657469e-02 2223:6.4450689e-02 "
          "2323:1.6939335e-01 "
          "2371:6.1539818e-02 2526:1.2256614e-01 2538:1.6614525e-01 2604:1.1431725e-01 2640:6.7469217e-02 "
          "2757:8.4796846e-02 "
          "3002:8.7175414e-02 3013:6.6840976e-02 3394:1.2859802e-01 3395:1.1114874e-01 3403:7.2827727e-02 "
          "3434:7.6285332e-02 "
          "4285:9.1630861e-02 7822:1.1371380e-01 10620:1.2761351e-01 10789:1.3184851e-01 11073:4.3677741e-01 "
          "14259:3.0506501e-01 14290:1.2000287e-01 15690:1.4595971e-01 40965:1.4917921e-01 45429:1.5323952e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 3:6.8201855e-02 5:4.2525712e-02 9:4.1544151e-02 10:4.5048852e-02 17:3.1669784e-02 18:4.0108316e-02 "
          "19:6.2352337e-02 20:2.7551658e-02 24:3.5834610e-02 39:3.7889514e-02 48:5.9138462e-02 51:3.7576761e-02 "
          "54:2.9649891e-02 55:5.7034533e-02 60:5.3297304e-02 62:7.1708634e-02 69:3.8482223e-02 84:5.3362191e-02 "
          "90:7.6557830e-02 101:1.7067148e-01 104:6.5700889e-02 189:4.4224564e-02 191:5.3475969e-02 193:1.0166807e-01 "
          "213:5.6755479e-02 223:4.2904470e-02 229:3.6756754e-02 233:5.7692181e-02 236:8.8973202e-02 252:7.0791982e-02 "
          "254:6.0998667e-02 274:9.5444642e-02 293:3.4578159e-02 298:5.2551515e-02 353:6.2970445e-02 359:5.8940839e-02 "
          "362:9.4814204e-02 365:4.1220501e-02 381:5.5132315e-02 393:1.0682259e-01 417:7.7576645e-02 433:1.2790906e-01 "
          "434:1.2920055e-01 437:9.9527366e-02 445:9.3291104e-02 482:7.7020280e-02 504:7.0146866e-02 516:5.9400313e-02 "
          "533:3.3342402e-02 535:5.3790860e-02 546:5.1154204e-02 549:1.0995333e-01 555:4.2508032e-02 576:6.7686416e-02 "
          "581:7.6401189e-02 606:1.0131808e-01 616:5.5910457e-02 655:6.5836646e-02 660:3.5489000e-02 733:8.3733603e-02 "
          "773:4.9977135e-02 799:8.2776152e-02 802:3.1189896e-02 820:5.5584010e-02 842:3.3620715e-02 858:5.0652307e-02 "
          "861:1.0134329e-01 872:9.4198376e-02 897:5.3636651e-02 910:1.7117321e-01 929:5.8061462e-02 933:6.8236858e-02 "
          "1002:7.1454532e-02 1003:7.3392145e-02 1011:5.7850268e-02 1012:1.0447704e-01 1014:5.4947138e-02 "
          "1028:6.7839883e-02 "
          "1036:6.0885001e-02 1056:6.0698550e-02 1059:6.0746837e-02 1094:5.8973197e-02 1121:9.2806354e-02 "
          "1124:8.0692895e-02 "
          "1168:1.0347998e-01 1189:5.9467442e-02 1213:3.6081284e-02 1380:5.8939490e-02 1401:8.5005760e-02 "
          "1447:8.2314774e-02 "
          "1451:8.7807268e-02 1522:9.5513254e-02 1560:7.7848323e-02 1589:1.3417508e-01 1617:6.8677299e-02 "
          "1670:9.8113216e-02 "
          "1731:6.0960051e-02 1765:9.0451486e-02 1809:9.5794328e-02 1889:5.8921985e-02 1950:1.2749732e-01 "
          "2080:7.4801728e-02 "
          "2107:6.4024784e-02 2128:7.1668133e-02 2248:7.0574254e-02 2298:2.3764143e-02 2360:7.0178375e-02 "
          "2375:1.1865810e-01 "
          "2477:7.5081818e-02 2581:1.4007854e-01 2582:2.3047361e-01 2586:2.9041773e-01 2640:7.5249724e-02 "
          "2688:1.0078031e-01 "
          "2731:8.2036249e-02 2910:9.6039414e-02 3923:7.6723687e-02 4246:1.0638511e-01 4660:1.1090246e-01 "
          "5586:2.3098303e-01 "
          "6005:8.9742698e-02 6576:1.5200076e-01 9825:1.1690991e-01 10110:1.3549109e-01 17286:1.5586308e-01 "
          "17417:1.7657512e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 54:3.9522834e-02 70:6.5392673e-02 79:6.1303228e-02 117:6.7540877e-02 140:3.5843827e-02 "
          "188:3.1430081e-02 "
          "229:4.8996173e-02 247:8.7484092e-02 286:6.0804654e-02 319:6.2555127e-02 338:5.9990354e-02 400:7.5577706e-02 "
          "433:5.1626455e-02 439:1.4582406e-01 533:4.4444893e-02 549:6.9839507e-02 620:8.7378837e-02 929:7.7395014e-02 "
          "1026:1.0507298e-01 1033:1.2783508e-01 1145:7.0126720e-02 1188:6.0534842e-02 1193:6.1270077e-02 "
          "1288:7.4745044e-02 "
          "1546:7.5513259e-02 1557:7.4922509e-02 1603:9.4233595e-02 1629:6.3131027e-02 2298:3.1677227e-02 "
          "2338:9.6347824e-02 "
          "2846:2.9065669e-01 3114:1.3901521e-01 3834:1.3969471e-01 4076:2.0486629e-01 4256:9.9550135e-02 "
          "6093:1.2507106e-01 "
          "16251:8.0098003e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 3:5.2675128e-02 9:5.4326791e-02 15:2.6977433e-02 17:2.4459891e-02 20:2.1279292e-02 23:4.0137552e-02 "
          "24:1.3188031e-02 48:4.5675095e-02 50:2.4661921e-02 62:1.1622863e-01 73:2.2560498e-02 75:4.3066282e-02 "
          "90:5.9128795e-02 140:4.9559031e-02 144:4.6714861e-02 147:3.3921696e-02 170:9.7547479e-02 181:4.9851231e-02 "
          "183:5.8803424e-02 188:1.8210838e-02 189:5.7831932e-02 218:3.2721773e-02 229:2.8388770e-02 253:8.2793005e-02 "
          "258:4.3220721e-02 277:2.9529622e-02 296:6.8921551e-02 305:3.7115712e-02 339:3.2311395e-02 379:5.5287361e-02 "
          "417:2.5108248e-02 434:4.7549017e-02 437:4.5400150e-02 438:4.2019702e-02 481:4.1135423e-02 482:1.0071851e-01 "
          "488:8.5127547e-02 510:4.1931175e-02 516:4.5877334e-02 558:3.7329726e-02 559:5.5953927e-02 575:4.1052915e-02 "
          "594:5.3927861e-02 611:6.4641431e-02 613:5.6488998e-02 626:5.7224698e-02 644:3.5452724e-02 655:3.0031869e-02 "
          "664:4.6365406e-02 678:3.3004150e-02 684:4.6287753e-02 702:3.5368204e-02 757:4.3632519e-02 769:4.8958421e-02 "
          "774:5.3743247e-02 799:6.3931465e-02 802:2.4089254e-02 811:3.3209193e-02 866:1.2582621e-01 867:6.3968413e-02 "
          "953:1.4152899e-01 954:5.1424433e-02 988:5.5899072e-02 1051:7.0164196e-02 1075:5.5457857e-02 "
          "1077:5.9548710e-02 "
          "1093:7.8556523e-02 1094:4.5547452e-02 1127:2.7244408e-02 1131:6.4375982e-02 1178:1.1096545e-01 "
          "1188:3.5074368e-02 "
          "1196:4.7391705e-02 1211:5.9639957e-02 1237:4.9487092e-02 1238:1.3173555e-01 1312:6.7817204e-02 "
          "1350:5.9294309e-02 "
          "1411:6.1209537e-02 1434:5.5123046e-02 1443:5.2646518e-02 1454:6.4847216e-02 1455:8.7324649e-02 "
          "1468:5.9016615e-02 "
          "1513:6.1157364e-02 1536:6.9566980e-02 1557:4.3410696e-02 1577:6.3726574e-02 1629:3.6578618e-02 "
          "1648:7.7015482e-02 "
          "1674:3.7462205e-02 1881:6.2102966e-02 2026:6.2604889e-02 2107:4.9449008e-02 2277:7.9958752e-02 "
          "2298:1.8354038e-02 "
          "2304:1.4407016e-01 2311:5.7672035e-02 2581:6.3897863e-02 2582:2.1006593e-01 2586:1.3603456e-01 "
          "2593:1.0759041e-01 "
          "2640:9.8403171e-02 2669:9.3098298e-02 2682:1.7272414e-01 2861:1.0186854e-01 3046:5.1598869e-02 "
          "3271:5.3420357e-02 "
          "3307:7.1344920e-02 3354:7.4968345e-02 3355:6.2576927e-02 3405:8.5283577e-02 3765:8.0822334e-02 "
          "4038:1.3321519e-01 "
          "4099:6.3996717e-02 4259:8.7872766e-02 4276:5.6852296e-02 5625:9.9668138e-02 5629:1.7794655e-01 "
          "5630:1.5093824e-01 "
          "5903:1.1113475e-01 5904:1.0739675e-01 5905:1.0390513e-01 5906:9.5028035e-02 6319:7.4109852e-02 "
          "6329:1.3957182e-01 "
          "8058:9.0529576e-02 8898:8.3281696e-02 9050:1.1804630e-01 9051:1.9488803e-01 9067:1.2184251e-01 "
          "9068:1.2758169e-01 "
          "9337:1.2393585e-01 10700:1.7724890e-01 11647:1.2141628e-01 15978:1.0364877e-01 16609:1.1705334e-01 "
          "17352:1.2844488e-01 17414:1.2593190e-01 22448:1.3354716e-01 28322:1.3727033e-01 36389:1.5210851e-01 "
          "46155:1.7638119e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 6:4.8821688e-02 7:4.7094759e-02 24:2.7021527e-02 39:2.5126640e-02 45:2.0994969e-02 85:5.7728816e-02 "
          "93:1.0416152e-01 101:6.2229902e-02 108:5.1355124e-02 122:5.6446888e-02 124:1.0210290e-01 128:4.3126818e-02 "
          "131:4.0401414e-02 182:5.1064659e-02 199:8.8687614e-02 230:2.9791011e-02 231:3.0781932e-02 252:2.7727118e-02 "
          "258:3.7110601e-02 267:4.2827137e-02 271:2.2449525e-02 293:2.2930697e-02 297:7.9737261e-02 318:4.3759279e-02 "
          "322:1.1752426e-01 326:2.8084312e-02 345:4.6678059e-02 363:3.9785642e-02 364:2.9002506e-02 426:4.5234930e-02 "
          "459:6.9699623e-02 465:4.7834422e-02 476:4.2127360e-02 477:4.0715691e-02 497:3.4114067e-02 526:3.7906017e-02 "
          "545:6.2548205e-02 558:3.2052416e-02 569:6.6362455e-02 572:6.4250544e-02 581:5.0665870e-02 586:3.1387661e-02 "
          "591:6.0729206e-02 593:4.7062948e-02 651:4.2424247e-02 660:2.3534726e-02 757:3.7464183e-02 802:2.0683752e-02 "
          "817:4.7277484e-02 831:6.0515050e-02 836:4.2091433e-02 838:4.8431039e-02 842:2.2295764e-02 871:4.5563679e-02 "
          "884:6.3011505e-02 1003:4.8670404e-02 1166:5.5724889e-02 1168:4.0530037e-02 1177:2.2384121e-01 "
          "1178:1.7328900e-01 "
          "1180:6.8368636e-02 1194:5.3286068e-02 1212:4.4755988e-02 1214:9.0526603e-02 1216:7.9891615e-02 "
          "1256:1.0839219e-01 "
          "1260:5.8363292e-02 1279:6.5246619e-02 1298:6.1371449e-02 1335:8.1391305e-02 1351:6.8594716e-02 "
          "1352:5.3935848e-02 "
          "1376:4.4873502e-02 1456:4.9498081e-02 1519:6.0273897e-02 1527:6.1528489e-02 1529:5.9858378e-02 "
          "1645:4.9185969e-02 "
          "1648:6.6127785e-02 1656:5.7904154e-02 1773:4.6961643e-02 1783:5.5443790e-02 1879:1.1523613e-01 "
          "1894:8.6815290e-02 "
          "1966:1.1111707e-01 2107:7.1888305e-02 2183:6.4717844e-02 2184:6.4540990e-02 2297:5.7999436e-02 "
          "2524:5.3416122e-02 "
          "2548:1.0442561e-01 2563:6.2729791e-02 2728:6.8231322e-02 2734:9.4235130e-02 2761:7.1217574e-02 "
          "2903:6.1596349e-02 "
          "2984:5.9222504e-02 3025:7.3101617e-02 3204:6.6633731e-02 3993:6.4956576e-02 3997:7.4104518e-02 "
          "4027:1.0893367e-01 "
          "4111:7.8929581e-02 4296:6.6536240e-02 4836:5.6569394e-02 4974:1.1548851e-01 5257:7.7101767e-02 "
          "5597:9.2054129e-02 "
          "5974:1.7862301e-01 6011:1.1732382e-01 6429:6.6712230e-02 6639:1.7986496e-01 6764:9.0444930e-02 "
          "6858:6.3667990e-02 "
          "6916:7.4367955e-02 7097:8.2451954e-02 7241:1.5505870e-01 8251:1.3713257e-01 8464:8.1878409e-02 "
          "8478:7.9667039e-02 "
          "8489:8.3028957e-02 8532:8.1277527e-02 8533:7.8416415e-02 8539:9.1700293e-02 8547:1.0421883e-01 "
          "8734:8.8908844e-02 "
          "8788:7.5774372e-02 8870:9.5251054e-02 8912:8.6641714e-02 8924:7.6402359e-02 9508:8.0223866e-02 "
          "9546:9.4647042e-02 "
          "9689:8.3772622e-02 9850:1.0195707e-01 9984:1.1487805e-01 10316:8.2289495e-02 10996:9.8567791e-02 "
          "11443:9.2394277e-02 11807:8.3128706e-02 13374:1.0035596e-01 14763:9.2269257e-02 16431:9.5063686e-02 "
          "18777:1.0692321e-01 21736:1.1849231e-01 22501:9.3927272e-02 23930:2.7130306e-01 25118:9.9100798e-02 "
          "25122:9.5285393e-02 26555:1.2678458e-01 45186:1.3956489e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 26:5.9874263e-02 69:6.3655801e-02 126:7.1026526e-02 147:5.8614958e-02 158:1.0384791e-01 "
          "181:8.6140387e-02 "
          "182:6.0694683e-02 184:8.2708478e-02 217:5.4982014e-02 224:5.6735270e-02 240:8.8598445e-02 247:8.7587968e-02 "
          "252:5.5799417e-02 305:1.3459252e-01 326:5.6518253e-02 355:1.2234046e-01 464:4.6011608e-02 545:1.2587510e-01 "
          "575:7.0937343e-02 613:4.6511739e-02 620:5.1668622e-02 678:5.7029489e-02 694:1.0479705e-01 726:7.2646521e-02 "
          "768:7.8455083e-02 802:4.1625001e-02 811:9.7159207e-02 1040:1.2283470e-01 1075:9.5828347e-02 "
          "1094:7.8703672e-02 "
          "1115:8.7340608e-02 1160:8.5423201e-02 1163:2.0381756e-01 1189:7.9363279e-02 1193:1.0386243e-01 "
          "1321:1.4913404e-01 "
          "1345:1.1179918e-01 1357:1.2781247e-01 1619:1.2822770e-01 1645:2.3620561e-01 1874:2.0014293e-01 "
          "1922:1.0724887e-01 "
          "2558:1.4351736e-01 2819:2.1067640e-01 2933:1.1996462e-01 3132:2.6784891e-01 3506:2.6400203e-01 "
          "3969:3.2187998e-01 "
          "5277:1.4182754e-01 5729:1.4060757e-01 23742:4.3143690e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 10:3.6200427e-02 23:8.7640256e-02 24:1.3721465e-02 89:7.9170719e-02 110:3.4973625e-02 "
          "113:1.0848862e-01 "
          "161:3.4115009e-02 169:3.6649428e-02 170:4.2531684e-02 233:2.7381184e-02 236:2.9961612e-02 276:6.8978623e-02 "
          "298:4.2229433e-02 319:3.7710987e-02 378:5.9917666e-02 393:5.0698880e-02 438:4.3719333e-02 545:4.4764608e-02 "
          "585:4.6372380e-02 625:4.6608757e-02 655:5.2905113e-02 690:4.9495637e-02 723:9.8653167e-02 724:3.5664670e-02 "
          "836:5.1004473e-02 898:5.3556051e-02 932:4.5588166e-02 953:5.6431163e-02 965:4.4461645e-02 "
          "1028:3.2197367e-02 "
          "1029:4.3607015e-02 1033:4.5515604e-02 1059:2.8830951e-02 1119:6.4936586e-02 1127:2.8346401e-02 "
          "1132:4.2067021e-02 "
          "1166:6.7524880e-02 1171:5.6490097e-02 1213:2.8994255e-02 1214:1.0969601e-01 1245:8.0604650e-02 "
          "1305:5.1793240e-02 "
          "1317:2.1727018e-01 1399:9.0359367e-02 1411:6.3685365e-02 1454:3.9848976e-02 1455:3.0841667e-02 "
          "1459:1.1594378e-01 "
          "1544:4.8055157e-02 1723:7.0103981e-02 1776:5.0957922e-02 1906:1.0704049e-01 2017:7.7515505e-02 "
          "2024:6.0593411e-02 "
          "2107:5.1449139e-02 2126:5.8228195e-02 2136:8.7564215e-02 2227:7.5786047e-02 2235:1.2833685e-01 "
          "2268:1.6012299e-01 "
          "2362:3.8189918e-02 2395:1.2726839e-01 2427:8.8174388e-02 2453:7.3663026e-02 2472:8.6865157e-02 "
          "2615:8.5408926e-02 "
          "2988:5.8656089e-02 2993:9.4368346e-02 3001:9.1456972e-02 3026:6.5700866e-02 3027:1.3117550e-01 "
          "3321:9.4631359e-02 "
          "3337:1.2148705e-01 3899:7.4612185e-02 4003:7.5192645e-02 4012:7.3503077e-02 4603:8.3020084e-02 "
          "5007:1.2731051e-01 "
          "5649:8.9461043e-02 6141:1.6422722e-01 6296:9.0801686e-02 7155:9.7022995e-02 7962:8.7938190e-02 "
          "8066:8.7881669e-02 "
          "8271:1.2632737e-01 8279:1.0498847e-01 8318:8.0862701e-02 8468:2.9195586e-01 8657:1.0076626e-01 "
          "8666:1.0950913e-01 "
          "9788:9.0873785e-02 16737:2.3359637e-01 18642:1.9922072e-01 18939:2.7316278e-01 30657:1.4546421e-01 "
          "32004:3.8112560e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 19:6.7861147e-02 45:1.2243207e-01 51:4.0896658e-02 56:1.1556713e-01 57:2.5897801e-01 60:9.8212868e-02 "
          "64:9.7493149e-02 69:8.7894320e-02 138:9.9384539e-02 255:1.2442380e-01 415:1.0459805e-01 417:5.9905972e-02 "
          "433:7.1369141e-02 464:1.0756845e-01 494:1.0216960e-01 526:1.0533093e-01 533:6.1441246e-02 553:1.5655874e-01 "
          "560:2.5478402e-01 629:1.1504722e-01 652:1.5134901e-01 679:1.0739313e-01 733:1.5429893e-01 "
          "1373:1.2379144e-01 "
          "1380:1.0860993e-01 1503:1.2961751e-01 1617:1.2655415e-01 2298:4.3791045e-02 2493:1.0299602e-01 "
          "2500:1.6541912e-01 "
          "2640:1.3866539e-01 3414:4.4886643e-01 7843:5.5509055e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.4818153e-02 13:1.2181391e-01 19:2.4751273e-01 87:2.5573492e-01 233:1.5607092e-01 "
          "239:1.0261225e-01 "
          "277:1.4128977e-01 417:1.4890411e-01 464:7.5247936e-02 476:1.3864888e-01 494:2.5395590e-01 526:7.3682711e-02 "
          "533:7.2772019e-02 546:2.9133713e-01 555:9.2776619e-02 606:2.2113347e-01 802:1.4286099e-01 "
          "2298:5.1866829e-02 "
          "2601:5.9738106e-01 2604:1.6435535e-01 2605:1.8424225e-01 2671:3.0831844e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 6:6.1550848e-02 13:2.7559496e-02 23:4.3448832e-02 25:4.7508482e-02 54:2.4789041e-02 69:1.9002121e-02 "
          "73:2.4421699e-02 98:4.4921320e-02 146:6.4657673e-02 189:7.7594765e-02 208:1.0277492e-01 253:5.2932955e-02 "
          "269:3.2185532e-02 280:4.7263883e-02 297:3.8524374e-02 344:5.5192217e-02 368:6.0391080e-02 403:1.0107478e-01 "
          "433:3.2380529e-02 464:2.8824627e-02 475:7.2668768e-02 481:4.4529025e-02 501:5.3258561e-02 512:5.5532075e-02 "
          "516:4.9662132e-02 529:5.9909087e-02 678:6.0490962e-02 723:6.0620978e-02 755:6.3311003e-02 860:6.4416662e-02 "
          "888:5.5558413e-02 933:5.7050001e-02 1005:9.2540480e-02 1077:6.4461373e-02 1094:4.9305040e-02 "
          "1173:4.3963261e-02 "
          "1188:3.7967943e-02 1213:5.1075585e-02 1218:6.9043480e-02 1221:1.0762522e-01 1296:6.8385288e-02 "
          "1342:1.0349505e-01 "
          "1398:5.5881415e-02 1422:8.6778432e-02 1527:7.7570662e-02 1590:5.3206768e-02 1591:7.4020326e-02 "
          "1690:1.0816149e-01 "
          "1730:7.1339816e-02 1889:4.9262222e-02 2017:8.0648303e-02 2028:5.6591511e-02 2029:7.2293252e-02 "
          "2126:6.0581494e-02 "
          "2190:6.0016364e-02 2223:6.0098477e-02 2256:7.4272864e-02 2268:9.8393328e-02 2433:6.5103389e-02 "
          "2604:1.0659766e-01 "
          "2794:6.5684229e-02 2958:7.6771878e-02 3013:6.2327355e-02 3014:1.8899082e-01 3192:7.5043261e-02 "
          "3272:5.0059628e-02 "
          "3302:7.7849753e-02 3306:8.0646046e-02 3307:7.7230752e-02 3334:1.0855940e-01 3354:8.1153102e-02 "
          "3392:8.2953885e-02 "
          "3485:9.0900689e-02 3690:6.5034784e-02 3812:2.5842795e-01 3970:9.6289307e-02 4015:1.1348470e-01 "
          "4026:8.8864356e-02 "
          "4107:7.9908781e-02 4150:6.1850533e-02 4206:7.2744854e-02 4421:1.9301024e-01 4859:1.3027187e-01 "
          "5313:1.0459569e-01 "
          "5775:8.1582025e-02 6063:1.5702842e-01 7956:1.5808004e-01 8075:9.8250262e-02 8650:2.4638775e-01 "
          "8933:2.3888263e-01 "
          "9471:1.0044545e-01 13732:2.6127303e-01 15961:1.2457192e-01 15965:1.2028130e-01 20136:1.8492551e-01 "
          "21332:1.2581715e-01 26306:1.8859963e-01 42583:2.7652991e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 18:1.3888066e-01 19:1.5805306e-01 20:2.0893250e-01 180:2.0053490e-01 417:6.6484377e-02 "
                  "425:3.8763109e-01 "
                  "546:1.7712860e-01 1033:1.1583585e-01 1340:1.5144816e-01 1387:5.5822521e-01 1452:1.1807609e-01 "
                  "1778:2.6120701e-01 "
                  "2031:1.7858724e-01 2298:4.8599835e-02 2335:2.5441369e-01 12569:2.9142672e-01 12585:2.6787990e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 64:9.8839223e-02 84:1.3617872e-01 197:1.0530823e-01 342:8.6165667e-02 438:8.2002006e-02 "
                  "462:1.1373973e-01 "
                  "463:1.4195327e-01 468:1.0765198e-01 540:2.8121293e-01 814:8.7348498e-02 929:8.7512255e-02 "
                  "1028:6.0390875e-02 "
                  "1397:1.7927003e-01 1401:1.2812364e-01 1443:2.4516878e-01 1556:1.0862132e-01 3405:3.9715579e-01 "
                  "3622:1.8004780e-01 "
                  "7155:1.8198082e-01 8167:1.8618432e-01 8196:3.8431767e-01 8198:3.8923436e-01 8201:2.1115877e-01 "
                  "41905:2.8560886e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 18:7.5716197e-02 24:6.7648329e-02 35:9.2914887e-02 39:7.1527556e-02 69:4.2906176e-02 73:5.5143408e-02 "
          "140:5.0762586e-02 188:4.4511769e-02 217:7.7774040e-02 218:7.9980068e-02 269:7.2673887e-02 296:9.9495918e-02 "
          "338:8.4959276e-02 388:1.5743224e-01 484:1.4074747e-01 547:8.8452481e-02 684:1.1313866e-01 865:1.4196534e-01 "
          "1288:1.0585509e-01 1380:1.8838896e-01 1658:1.3177589e-01 1666:7.6662712e-02 1682:1.2633711e-01 "
          "1746:1.7998365e-01 "
          "1765:1.0084987e-01 2200:1.3654734e-01 2293:1.7499822e-01 2298:4.4861782e-02 2521:1.3028178e-01 "
          "2523:2.5289389e-01 "
          "2524:1.5205872e-01 2551:4.4479084e-01 2552:3.7810281e-01 2553:1.9953281e-01 2737:2.5187862e-01 "
          "44594:3.4413758e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 14:3.7788037e-02 15:3.4855455e-02 18:4.0023401e-02 24:4.4462826e-02 25:5.6704056e-02 26:7.5800866e-02 "
          "35:8.3158225e-02 51:4.6476822e-02 53:4.6579357e-02 54:5.0095350e-02 60:5.3184468e-02 67:5.7207771e-02 "
          "69:5.9182324e-02 70:6.8994269e-02 74:7.4816719e-02 84:5.3249218e-02 103:9.4511509e-02 136:1.4692821e-01 "
          "151:8.1322834e-02 180:5.7791267e-02 188:2.3528816e-02 232:8.2815424e-02 234:4.4956706e-02 252:7.0642106e-02 "
          "257:4.1753978e-02 269:3.8415246e-02 277:6.4598553e-02 286:2.6884176e-02 288:6.1407238e-02 293:3.4504954e-02 "
          "301:8.8445567e-02 338:7.6038003e-02 340:1.0422952e-01 370:5.8618478e-02 481:5.3147901e-02 488:6.4959936e-02 "
          "497:5.1333122e-02 506:4.4721514e-02 514:5.5676900e-02 533:5.6334075e-02 555:4.2418040e-02 647:1.4637521e-01 "
          "673:5.8217529e-02 842:5.6804307e-02 954:6.6441536e-02 994:6.9032021e-02 1014:5.4830812e-02 "
          "1102:6.1769374e-02 "
          "1119:8.0637872e-02 1122:4.3036774e-02 1134:6.3718468e-02 1250:1.8019807e-01 1307:1.7312421e-01 "
          "1342:5.8861364e-02 "
          "1557:5.6087606e-02 1584:8.1373014e-02 1623:5.7096064e-02 1629:4.7260407e-02 1654:6.8997815e-02 "
          "1674:4.8402019e-02 "
          "1694:8.0745347e-02 1755:1.2114226e-01 1988:7.9720356e-02 2095:1.5572524e-01 2124:1.1163815e-01 "
          "2200:7.2178602e-02 "
          "2298:2.3713833e-02 2490:7.4073017e-02 2493:5.5774655e-02 2627:9.1809630e-02 3291:7.8977779e-02 "
          "3307:9.2179254e-02 "
          "3736:9.3423210e-02 4300:3.6604345e-01 4550:1.7665726e-01 6229:3.0941048e-01 7213:9.6997403e-02 "
          "12199:4.7378793e-01 21455:2.8734306e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:3.9676465e-02 7:1.1218460e-01 10:7.1163908e-02 13:8.8166870e-02 19:5.8174696e-02 20:4.3523502e-02 "
          "21:5.9402779e-02 45:5.0012194e-02 50:5.0442144e-02 51:7.3575445e-02 54:4.6838090e-02 61:7.2907679e-02 "
          "73:4.6144009e-02 80:2.1888907e-01 82:1.6104200e-01 158:1.2292310e-01 232:7.7430665e-02 259:7.2177246e-02 "
          "271:5.3477101e-02 286:1.0155872e-01 293:5.4623302e-02 381:1.4746094e-01 386:9.7480953e-02 400:1.5164897e-01 "
          "417:5.1355034e-02 464:9.2214204e-02 476:1.0035174e-01 511:8.9844674e-02 533:5.2671168e-02 545:8.7999634e-02 "
          "553:1.3421164e-01 601:1.1701645e-01 613:1.3137791e-01 620:1.0355172e-01 627:9.9946082e-02 628:1.6330284e-01 "
          "644:7.2513066e-02 678:1.1429571e-01 1122:6.8129659e-02 1127:5.5724222e-02 1188:7.1739197e-02 "
          "1338:1.2651263e-01 "
          "1408:1.1904471e-01 1452:9.1206416e-02 1566:1.1045192e-01 1620:1.4136057e-01 1711:2.6832262e-01 "
          "1713:1.5371217e-01 "
          "1802:1.2763615e-01 1827:1.2051839e-01 1970:1.2549227e-01 2018:1.1080047e-01 2298:3.7540343e-02 "
          "2322:1.2833610e-01 "
          "2346:2.2822228e-01 2640:1.1887239e-01 2694:1.4104989e-01 2698:1.9994996e-01 2795:1.4268112e-01 "
          "2858:1.4432676e-01 "
          "4414:2.6668468e-01 7374:2.3633917e-01 33886:2.6247320e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:2.0626858e-02 17:3.2237310e-02 18:1.9454313e-02 19:1.7862389e-02 20:3.1889908e-02 23:2.5207102e-02 "
          "24:3.2221302e-02 26:2.1761123e-02 32:2.4046985e-02 33:3.5033520e-02 39:1.8378096e-02 45:3.2226529e-02 "
          "46:1.0536711e-01 47:5.7633463e-02 49:4.2323235e-02 50:5.2627042e-02 51:4.3538488e-02 53:2.2640988e-02 "
          "54:2.4350019e-02 64:1.5156457e-02 67:6.6356115e-02 69:4.1589759e-02 70:4.4932857e-02 72:3.2226000e-02 "
          "73:2.9733973e-02 74:5.6047052e-02 85:2.4938136e-02 87:2.7081441e-02 88:5.0022338e-02 91:5.9879910e-02 "
          "95:6.6409037e-02 102:6.8857156e-02 103:8.6749114e-02 106:6.7732781e-02 124:3.5585407e-02 131:2.9550353e-02 "
          "133:7.0195645e-02 136:6.1045423e-02 140:3.8422916e-02 147:2.1303434e-02 167:2.8944919e-02 175:6.5898053e-02 "
          "179:3.1093542e-02 182:2.2059303e-02 183:2.1811219e-02 184:3.0060152e-02 191:4.3917220e-02 192:3.2382503e-02 "
          "193:3.9785843e-02 215:6.7285113e-02 218:6.9826283e-02 220:2.7350407e-02 229:3.7415437e-02 233:4.6140440e-02 "
          "236:3.0620437e-02 238:6.3451745e-02 239:5.9505913e-02 240:6.7799404e-02 252:2.0280134e-02 257:4.8431031e-02 "
          "259:2.2161834e-02 263:3.2648511e-02 264:2.7559776e-02 265:3.8413662e-02 268:4.0021431e-02 271:3.9182965e-02 "
          "277:7.5868927e-02 284:4.9425703e-02 293:1.6771942e-02 295:6.3878879e-02 302:4.0483881e-02 303:9.8282211e-02 "
          "305:9.7387649e-02 309:7.9738699e-02 319:2.2762470e-02 320:2.3730012e-02 321:5.0274435e-02 323:5.0309427e-02 "
          "326:2.0541392e-02 327:4.6484139e-02 334:7.1232729e-02 337:7.3663555e-02 338:2.1829205e-02 339:6.7016505e-02 "
          "341:6.8290815e-02 344:3.2020099e-02 347:1.0252800e-01 348:4.8712168e-02 364:4.4517819e-02 369:3.9111298e-02 "
          "370:4.8242647e-02 371:4.1809659e-02 380:2.7363716e-02 388:4.0450212e-02 389:3.3216190e-02 394:5.1287882e-02 "
          "395:9.8015636e-02 433:1.8785762e-02 440:3.7211843e-02 451:2.4264561e-02 453:4.0389307e-02 454:3.9344549e-02 "
          "477:5.0422296e-02 484:8.6296208e-02 497:8.8951431e-02 510:2.6333530e-02 526:2.7725173e-02 532:3.3325434e-02 "
          "535:5.4754801e-02 586:2.2957522e-02 588:3.3420771e-02 600:4.6866320e-02 612:5.2563455e-02 613:6.3773930e-02 "
          "615:1.2705654e-01 620:1.8778808e-02 625:4.7633637e-02 627:6.4402603e-02 636:4.6547443e-02 644:7.7591263e-02 "
          "646:3.5359442e-02 647:7.1149103e-02 649:3.7586946e-02 651:3.1029889e-02 656:9.7127736e-02 657:6.4835086e-02 "
          "660:1.7213739e-02 664:2.9118307e-02 670:3.6311053e-02 673:2.8297994e-02 675:3.7063494e-02 676:6.2880367e-02 "
          "678:4.9461197e-02 679:2.8267983e-02 684:6.9368482e-02 703:5.1957905e-02 752:4.2656537e-02 764:2.8668301e-02 "
          "768:4.8278853e-02 774:1.0393646e-01 777:4.7255836e-02 799:6.7980044e-02 807:3.8644243e-02 820:2.6960712e-02 "
          "842:1.6307540e-02 867:6.8019331e-02 871:6.9938622e-02 897:2.6016157e-02 911:3.0093197e-02 929:2.8162388e-02 "
          "963:2.8593497e-02 969:5.7478812e-02 984:3.1939443e-02 992:4.9526479e-02 995:2.6001804e-02 "
          "1000:4.3627799e-02 "
          "1011:2.8059948e-02 1012:2.4147388e-02 1024:3.4396421e-02 1084:1.0760473e-01 1098:4.5408253e-02 "
          "1115:3.1743683e-02 "
          "1122:3.5418998e-02 1130:3.5303943e-02 1133:3.6167871e-02 1193:4.6788286e-02 1222:3.1925201e-02 "
          "1239:5.9993640e-02 "
          "1288:9.4782904e-02 1292:4.4247538e-02 1300:5.7827599e-02 1370:5.1302176e-02 1380:4.8404146e-02 "
          "1394:3.6305919e-02 "
          "1430:4.7680963e-02 1447:3.9926320e-02 1454:5.7397466e-02 1493:3.7737843e-02 1497:3.5196766e-02 "
          "1560:3.7759893e-02 "
          "1654:5.8352847e-02 1657:5.1251095e-02 1658:3.3858139e-02 1664:7.3342666e-02 1696:5.0341431e-02 "
          "1727:5.3408731e-02 "
          "1730:4.1388229e-02 1765:2.5912093e-02 1776:3.0758362e-02 1807:3.8242273e-02 1871:7.9044335e-02 "
          "1874:4.2962216e-02 "
          "1906:3.0787000e-02 1921:5.8325421e-02 1954:5.2997112e-02 1964:4.2923611e-02 2018:3.4020998e-02 "
          "2078:6.2884599e-02 "
          "2097:3.2864407e-02 2121:5.2063338e-02 2194:5.0886810e-02 2202:4.5706887e-02 2206:4.5615319e-02 "
          "2214:6.1310917e-02 "
          "2222:4.6089020e-02 2244:4.3977503e-02 2327:4.7852926e-02 2360:3.4039628e-02 2362:6.4354397e-02 "
          "2364:1.0340417e-01 "
          "2379:3.8688987e-02 2409:4.1381299e-02 2493:2.7110580e-02 2548:3.6394931e-02 2549:1.1670996e-01 "
          "2602:6.1170660e-02 "
          "2752:4.0150110e-02 2762:6.9101833e-02 2793:4.8029341e-02 2824:7.4834801e-02 3361:4.8111238e-02 "
          "3367:8.8024259e-02 "
          "3434:4.1268796e-02 3533:7.1968578e-02 3722:4.7452848e-02 3872:1.5515976e-01 4107:1.1062757e-01 "
          "4150:8.5627317e-02 "
          "4507:5.6169380e-02 5775:4.7330309e-02 6024:5.3539164e-02 6093:7.7056274e-02 6096:6.8419091e-02 "
          "6156:5.8835372e-02 "
          "6638:6.3847341e-02 6729:4.3478899e-02 6756:1.5909155e-01 7124:7.4841395e-02 7546:1.2730533e-01 "
          "8536:5.5361465e-02 "
          "9198:9.5471337e-02 10975:1.1157702e-01 11138:5.6142926e-02 14161:6.5246180e-02 17802:2.0888090e-01 "
          "17813:1.5785755e-01 20422:7.5967424e-02 20936:1.5217708e-01 21290:7.5311877e-02 22524:1.6853943e-01 "
          "25328:2.8366724e-01 32417:9.9164747e-02 37301:1.5487435e-01 37954:7.6718502e-02")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 24:3.0789115e-02 35:4.2288806e-02 42:5.7270121e-02 74:3.8046859e-02 76:5.2237622e-02 93:7.9706125e-02 "
          "163:6.1787102e-02 187:9.6379906e-02 189:3.7997764e-02 230:3.8597960e-02 249:7.6267511e-02 271:2.9086152e-02 "
          "297:6.7032926e-02 345:6.0477231e-02 352:8.3416164e-02 360:1.1788639e-01 439:5.5514183e-02 445:8.0155760e-02 "
          "453:4.2255644e-02 624:6.9420107e-02 646:6.2635198e-02 664:8.7332085e-02 693:6.4989507e-02 802:6.9928691e-02 "
          "848:5.6526646e-02 891:8.3700985e-02 932:4.8743494e-02 937:2.1827382e-01 971:6.4460278e-02 "
          "1029:4.6625219e-02 "
          "1102:5.3184871e-02 1127:3.0308360e-02 1168:1.2530838e-01 1218:4.1906923e-02 1232:7.6977678e-02 "
          "1467:6.8796329e-02 "
          "1497:6.2347032e-02 1563:1.3037422e-01 1721:2.1781097e-01 1769:9.2021987e-02 1898:8.5268609e-02 "
          "2010:6.4486116e-02 "
          "2025:1.6460592e-01 2377:9.0452798e-02 2604:1.0954827e-01 2701:1.1557820e-01 2984:7.6730125e-02 "
          "2988:6.2715895e-02 "
          "3029:1.1025768e-01 3137:5.9085824e-02 3177:1.0778713e-01 3261:8.8538617e-02 3442:1.6862339e-01 "
          "3507:6.9168203e-02 "
          "3737:6.4755090e-02 3825:7.2421692e-02 3834:9.0042897e-02 3848:8.9703210e-02 3908:1.0283307e-01 "
          "4107:8.2120642e-02 "
          "4164:1.1865502e-01 4396:7.8448303e-02 4695:6.6578150e-02 5000:8.0227792e-02 7300:1.1170267e-01 "
          "8387:1.0083031e-01 "
          "8674:3.3094978e-01 9123:1.9373320e-01 11012:1.2159377e-01 12828:2.7226743e-01 12830:1.5475166e-01 "
          "14441:1.0049239e-01 18161:1.6321501e-01 18193:1.3317518e-01 21030:2.4835692e-01 28460:3.1115535e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:2.1197492e-02 20:2.9998001e-02 21:2.4181349e-02 24:2.6202599e-02 43:1.7451607e-01 45:2.0358684e-02 "
          "51:3.4056380e-02 53:8.8426672e-02 54:4.0013377e-02 57:3.7872642e-02 61:2.9678850e-02 64:2.0093985e-02 "
          "69:4.6729211e-02 73:3.1804152e-02 74:2.8475685e-02 93:5.9655029e-02 98:3.4551404e-02 99:3.8847670e-02 "
          "111:3.8407564e-02 128:4.1819792e-02 135:4.0242776e-02 136:8.0932222e-02 140:2.9277496e-02 169:2.9328313e-02 "
          "175:6.1988574e-02 179:4.1222904e-02 184:3.9852865e-02 205:6.2692352e-02 218:4.6128783e-02 223:4.6714004e-02 "
          "224:2.7337743e-02 231:2.9849039e-02 234:2.8971085e-02 236:2.3976460e-02 238:6.8142243e-02 247:4.2204034e-02 "
          "254:3.9225657e-02 262:4.5216542e-02 277:4.1628718e-02 282:4.9761679e-02 288:2.3371959e-02 291:4.2129464e-02 "
          "295:7.7446662e-02 303:1.4816141e-01 326:5.7151873e-02 334:3.6191035e-02 338:2.8940517e-02 339:2.6902717e-02 "
          "342:6.2244061e-02 343:4.9580716e-02 347:6.2066879e-02 348:3.0773269e-02 357:4.2727176e-02 358:4.9360763e-02 "
          "364:2.8123541e-02 370:3.7775028e-02 374:7.0967570e-02 453:5.3546958e-02 516:8.0162413e-02 550:3.2793626e-02 "
          "553:3.2267798e-02 573:4.7962796e-02 576:4.3526262e-02 613:4.7033176e-02 642:3.3333678e-02 646:9.8379813e-02 "
          "656:6.1359156e-02 663:5.6855872e-02 673:3.7516650e-02 677:1.5519008e-01 678:5.7668839e-02 679:3.7476860e-02 "
          "684:6.5253116e-02 686:4.5268402e-02 751:4.7212686e-02 755:4.8695903e-02 759:5.1385351e-02 768:3.7803378e-02 "
          "773:3.2138176e-02 809:5.7270519e-02 811:5.8027115e-02 858:3.2572348e-02 926:6.3016012e-02 954:4.2816382e-02 "
          "981:5.3952847e-02 982:6.7375898e-02 989:6.4064860e-02 1000:3.4161501e-02 1007:7.7273890e-02 "
          "1028:2.5765600e-02 "
          "1033:3.6423378e-02 1048:8.6130410e-02 1122:8.5404731e-02 1187:5.0463051e-02 1220:7.8814290e-02 "
          "1280:8.0952644e-02 "
          "1284:5.8583792e-02 1288:7.5672738e-02 1332:6.9857307e-02 1347:5.4114971e-02 1350:4.9368899e-02 "
          "1356:5.1798891e-02 "
          "1366:5.8468536e-02 1370:1.1515925e-01 1394:4.8133321e-02 1443:4.3833897e-02 1492:4.4678014e-02 "
          "1544:3.8455624e-02 "
          "1567:4.9890734e-02 1603:4.5460124e-02 1654:6.2666424e-02 1731:3.9200824e-02 1777:5.4629464e-02 "
          "1857:5.4280054e-02 "
          "1889:3.7890229e-02 1919:5.1511977e-02 2113:8.7833799e-02 2122:1.1408327e-01 2123:5.2385833e-02 "
          "2190:4.6161819e-02 "
          "2841:4.9678177e-02 2950:9.0083145e-02 2992:5.8405962e-02 3006:1.1705698e-01 3188:4.1866258e-02 "
          "3294:6.5602757e-02 "
          "3354:6.2419225e-02 3808:6.9352977e-02 3881:6.9668643e-02 3898:6.2011838e-02 5272:7.7006444e-02 "
          "7519:8.3567835e-02 "
          "9196:7.8122653e-02 9198:2.0870106e-01 9725:7.7564009e-02 10305:7.7432014e-02 10786:1.3942429e-01 "
          "11443:1.5169606e-01 13631:2.6130822e-01 15968:8.9486316e-02 16983:8.7621823e-02 19340:9.7194873e-02 "
          "19616:1.1553900e-01 20173:9.7879060e-02 21806:1.5483558e-01 24156:1.1844430e-01 25969:1.1526196e-01 "
          "26198:1.1903631e-01 30112:1.0775571e-01 34998:4.3575430e-01 46891:2.2014895e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:3.1656619e-02 10:8.0024064e-02 15:2.6001841e-02 17:2.3575343e-02 20:3.4726046e-02 24:2.1521779e-02 "
          "39:7.3600180e-02 41:6.6438787e-02 51:5.2821495e-02 53:5.8833070e-02 64:3.9384365e-02 69:2.8646600e-02 "
          "70:6.3539214e-02 84:3.9723415e-02 86:5.6817725e-02 87:7.0371680e-02 92:8.7746032e-02 95:4.8565336e-02 "
          "112:4.2387020e-02 117:3.7718516e-02 135:4.6585526e-02 140:4.2008240e-02 147:3.2694977e-02 152:4.7035638e-02 "
          "174:6.8879545e-02 188:1.7552275e-02 196:5.3825524e-02 209:3.6759559e-02 217:3.0668549e-02 221:4.1492797e-02 "
          "223:3.1938571e-02 225:4.2699069e-02 229:2.7362140e-02 236:2.7755441e-02 240:2.9187975e-02 257:3.1148072e-02 "
          "258:4.1657720e-02 259:5.7587981e-02 264:4.2296760e-02 274:4.1963313e-02 280:7.1252547e-02 286:3.3956643e-02 "
          "315:3.8008995e-02 326:3.1525452e-02 348:3.5623509e-02 357:4.9461495e-02 358:5.7140619e-02 364:3.2556150e-02 "
          "365:5.1954228e-02 368:5.3771120e-02 374:3.9146304e-02 378:5.5505730e-02 388:3.6665492e-02 390:5.8006626e-02 "
          "437:4.3758333e-02 440:5.7110060e-02 480:8.3451398e-02 482:5.7334762e-02 494:1.2158807e-01 500:1.3320184e-01 "
          "506:3.3361830e-02 524:4.8668716e-02 550:3.7962299e-02 577:6.7106187e-02 581:5.6873903e-02 585:4.2957827e-02 "
          "587:4.1546237e-02 594:5.1977657e-02 613:2.5943894e-02 620:2.8820364e-02 626:5.5155266e-02 629:4.6475697e-02 "
          "631:4.9837485e-02 637:5.5933785e-02 642:3.8587470e-02 644:3.4170639e-02 726:6.8609163e-02 767:4.2887397e-02 "
          "811:3.2008242e-02 836:7.9999253e-02 927:7.6064110e-02 944:5.8143217e-02 945:4.5896344e-02 988:5.3877581e-02 "
          "1032:5.6268301e-02 1040:4.0466808e-02 1045:9.6413031e-02 1052:9.2478454e-02 1110:4.7390670e-02 "
          "1127:4.4460628e-02 "
          "1162:1.1008783e-01 1193:3.4216560e-02 1196:4.5677867e-02 1215:5.8862265e-02 1230:7.9835445e-02 "
          "1280:5.5347674e-02 "
          "1304:5.1149745e-02 1423:7.0200220e-02 1426:3.8559895e-02 1455:2.8570695e-02 1486:1.7888485e-01 "
          "1502:7.2139539e-02 "
          "1503:1.0988683e-01 1506:5.4836862e-02 1513:5.8945715e-02 1530:5.7332382e-02 1623:4.2593125e-02 "
          "1653:6.1459243e-02 "
          "1654:3.0400028e-02 1670:4.3136582e-02 1674:3.6107447e-02 1866:2.0652953e-01 1928:7.5929418e-02 "
          "1935:5.2731745e-02 "
          "2088:9.2007279e-02 2200:9.1166750e-02 2225:9.2762455e-02 2260:6.9973066e-02 2331:7.6534219e-02 "
          "2424:7.6425441e-02 "
          "2473:1.1307555e-01 2477:5.5891749e-02 2486:9.0610124e-02 2506:4.8369091e-02 2526:6.0101867e-02 "
          "2559:8.4685780e-02 "
          "2747:6.5964341e-02 2834:6.1064664e-02 2846:6.8021186e-02 2887:7.7360801e-02 2988:1.8463162e-01 "
          "2993:8.7419696e-02 "
          "3092:7.9825327e-02 3239:7.8842133e-02 3271:8.7177612e-02 3434:6.3336372e-02 3457:5.3467181e-02 "
          "3566:7.9129651e-02 "
          "3715:9.8483890e-02 3949:8.1433065e-02 3969:1.2739056e-01 4470:7.7320561e-02 5010:1.0028518e-01 "
          "5015:7.8769505e-02 "
          "5468:9.8097086e-02 5678:9.6910112e-02 5696:9.7268172e-02 5930:9.4420217e-02 5959:9.7226828e-02 "
          "7777:1.1096642e-01 "
          "7896:1.1084209e-01 8069:9.9645197e-02 8307:1.6096976e-01 8899:1.2486082e-01 10884:9.2095308e-02 "
          "11108:8.4745817e-02 13953:1.2802964e-01 18530:1.1011625e-01 26200:1.2357365e-01 30529:1.3311438e-01 "
          "36024:1.2871766e-01 38268:1.2432132e-01 41390:3.5186768e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:1.9294567e-02 49:4.1317865e-02 117:5.7254050e-02 140:7.2506659e-02 166:1.2649852e-01 "
          "191:6.0425907e-02 "
          "197:7.8948870e-02 240:4.4305291e-02 276:4.6218608e-02 277:4.3202907e-02 293:3.9072067e-02 297:1.0926868e-01 "
          "318:7.4562304e-02 349:6.5451697e-02 459:7.0143089e-02 464:6.5960854e-02 468:8.0705963e-02 471:6.8651833e-02 "
          "513:3.2491532e-01 514:1.3230985e-01 572:1.0947777e-01 646:8.2373679e-02 647:7.8980573e-02 802:3.5243452e-02 "
          "831:2.1639378e-01 882:8.1250772e-02 992:6.8143710e-02 1028:4.5274630e-02 1057:1.0346802e-01 "
          "1089:1.0017966e-01 "
          "1094:1.3984644e-01 1107:1.5524457e-01 1127:6.7488104e-02 1130:1.3925184e-01 1134:7.2152317e-02 "
          "1171:7.9434082e-02 "
          "1173:1.6588067e-01 1394:8.4578604e-02 1443:7.7023767e-02 1540:7.4117221e-02 1865:8.0609336e-02 "
          "1896:1.1037748e-01 "
          "2323:1.0172505e-01 2525:1.0827968e-01 2543:1.4068958e-01 2949:8.2073733e-02 5024:1.4329709e-01 "
          "6548:1.2555490e-01 "
          "6579:1.5903084e-01 15376:4.6241406e-01 19922:1.5531869e-01 29241:1.8844421e-01 42121:3.9495265e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 20:9.1969095e-02 48:6.7010790e-02 49:1.1567141e-01 50:6.1261389e-02 51:9.3249157e-02 52:9.0156525e-02 "
          "60:1.0225266e-01 69:6.7202754e-02 106:6.0638037e-02 107:6.1994869e-02 130:1.6544470e-01 156:2.8553563e-01 "
          "169:5.1678739e-02 171:8.5039042e-02 179:1.0237471e-01 228:1.3931087e-01 232:1.7103444e-01 244:1.0537499e-01 "
          "257:8.0276348e-02 311:6.1777674e-02 323:6.9414124e-02 337:5.8415264e-02 453:5.5726901e-02 488:7.3763356e-02 "
          "510:6.1518010e-02 514:6.3222274e-02 532:7.7851862e-02 547:1.3854067e-01 576:7.6696612e-02 628:1.6509032e-01 "
          "660:4.0213183e-02 773:1.1884427e-01 888:7.5298764e-02 918:9.4243504e-02 933:7.7320330e-02 "
          "1098:1.0607865e-01 "
          "1127:3.9970778e-02 1470:8.9342088e-02 1567:1.4884678e-01 1575:7.3556565e-02 1664:6.1372224e-02 "
          "1666:4.6015538e-02 "
          "1775:2.2315210e-01 1905:1.0848685e-01 1921:1.3625456e-01 2095:1.7682925e-01 2206:1.0656238e-01 "
          "2298:2.6927551e-02 "
          "2346:9.6685626e-02 2524:2.3816538e-01 7396:1.4772969e-01 16316:5.5153859e-01 37063:2.0547001e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 8:6.3692547e-02 15:2.6423322e-02 17:7.6597482e-02 18:3.0341053e-02 21:4.8163898e-02 49:4.6834331e-02 "
          "50:2.4155371e-02 121:6.9364853e-02 141:4.6960339e-02 152:4.7798071e-02 182:5.8250722e-02 213:9.0102382e-02 "
          "240:2.9661104e-02 288:2.7494226e-02 297:3.4857418e-02 298:3.9754063e-02 319:3.5500474e-02 339:5.3584259e-02 "
          "360:8.3739027e-02 390:9.9805772e-02 411:5.4298032e-02 477:1.5781659e-01 526:2.5538439e-02 593:5.3685870e-02 "
          "594:5.2820198e-02 630:4.9884960e-02 673:4.4133708e-02 760:5.7595734e-02 791:1.1489982e-01 796:9.9045947e-02 "
          "817:1.1317941e-01 866:1.0838424e-01 979:6.6266820e-02 1002:5.4053776e-02 1005:4.9453460e-02 "
          "1021:5.7199996e-02 "
          "1066:5.9897628e-02 1071:3.6722660e-02 1127:2.6684815e-02 1130:5.5060223e-02 1162:4.6881195e-02 "
          "1177:1.2723471e-01 "
          "1178:6.4191848e-02 1180:2.0350952e-01 1337:8.8363722e-02 1388:6.6883922e-02 1497:5.4893073e-02 "
          "1499:7.5865090e-02 "
          "1511:4.4697553e-02 1573:9.3479536e-02 1615:7.7181563e-02 1688:6.2550448e-02 1698:7.8841597e-02 "
          "1776:4.7970913e-02 "
          "2066:1.2641183e-01 2088:9.3498692e-02 2090:4.9367268e-02 2117:7.1579896e-02 2183:2.5727406e-01 "
          "2202:7.1284711e-02 "
          "2218:7.7404819e-02 2369:7.7658772e-02 2576:6.5209076e-02 2577:6.0808416e-02 2701:1.0176013e-01 "
          "3217:1.0828785e-01 "
          "3282:6.4706229e-02 3325:5.5338096e-02 3394:6.4081855e-02 3620:8.2266681e-02 3834:7.9277731e-02 "
          "3855:8.1766233e-02 "
          "3962:7.5613976e-02 4026:8.0405772e-02 4038:6.2173937e-02 4123:8.3180562e-02 4139:9.6340828e-02 "
          "4352:8.1755519e-02 "
          "4395:1.6436347e-01 5010:1.0191077e-01 5120:1.2474316e-01 6831:1.1450683e-01 7066:8.5232772e-02 "
          "9196:9.1901667e-02 "
          "11959:1.1063232e-01 13454:1.1766300e-01 14518:1.0848014e-01 15978:1.0151985e-01 19075:1.0787286e-01 "
          "21063:1.2831092e-01 23272:1.9686770e-01 24376:2.2475766e-01 24377:1.3386171e-01 24701:1.3230270e-01 "
          "28712:3.1488872e-01 34553:2.8893167e-01 34957:1.7519493e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 18:4.2786378e-02 19:1.0251234e-01 24:1.8215524e-02 48:1.3239555e-01 49:3.9007176e-02 51:4.0085796e-02 "
          "56:6.6902488e-02 57:1.0637550e-01 62:1.8254361e-01 64:5.6439359e-02 65:5.6794297e-02 69:5.0882541e-02 "
          "78:8.5595019e-02 82:6.4230233e-02 90:1.3466167e-01 99:6.4444557e-02 104:7.0087790e-02 105:3.1418952e-01 "
          "106:5.7087574e-02 130:5.9690103e-02 148:9.0327598e-02 156:9.1250919e-02 158:1.4054754e-01 167:6.3659318e-02 "
          "170:5.6461673e-02 218:9.4848566e-02 229:3.9211035e-02 233:3.6349077e-02 234:4.8060250e-02 240:7.0820160e-02 "
          "257:1.0651564e-01 286:2.8740099e-02 300:1.3137621e-01 305:5.1264830e-02 322:1.3413866e-01 336:5.3950466e-02 "
          "347:6.0811609e-02 348:8.6434998e-02 365:7.4452475e-02 388:5.2543104e-02 417:3.4679919e-02 434:1.9347405e-01 "
          "438:9.8267391e-02 441:7.2735608e-02 481:5.6816917e-02 496:7.0920110e-02 507:1.0454062e-01 526:3.6013823e-02 "
          "547:4.9983516e-02 548:1.3170254e-01 629:6.6601522e-02 724:8.0163024e-02 768:1.4964972e-01 820:5.9295401e-02 "
          "858:1.4099942e-01 995:9.6825078e-02 1054:8.5856736e-02 1195:2.0255806e-01 1321:1.1920860e-01 "
          "1408:8.0390580e-02 "
          "1455:4.0942941e-02 1629:1.3183661e-01 1810:8.0666609e-02 1841:1.0465272e-01 1871:8.2837723e-02 "
          "2022:8.9688450e-02 "
          "2292:1.0800461e-01 2298:2.5350895e-02 2360:1.2675618e-01 2362:5.0697889e-02 2376:9.5532872e-02 "
          "2524:8.5926697e-02 "
          "2698:1.3502568e-01 3008:1.2189575e-01 3144:8.3030939e-02 3158:1.0748112e-01 4152:1.1640934e-01 "
          "4303:1.2428267e-01 "
          "4905:1.5162693e-01 15319:4.1357726e-01 41390:1.6374409e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:2.1706512e-02 10:3.8932912e-02 13:4.8235025e-02 20:2.3811178e-02 24:3.5214998e-02 25:4.9109746e-02 "
          "49:3.1601414e-02 51:3.2475252e-02 63:5.1252857e-02 64:2.7005320e-02 69:4.1222166e-02 70:2.5040476e-02 "
          "74:3.8269911e-02 75:8.1593543e-02 110:3.7613507e-02 131:5.2651934e-02 138:4.6611045e-02 141:1.1259013e-01 "
          "146:6.6836938e-02 151:7.0431359e-02 175:4.9203981e-02 189:6.4712979e-02 215:5.0239656e-02 217:6.0284849e-02 "
          "218:6.1994802e-02 223:3.7079655e-02 230:3.8824242e-02 236:3.2223176e-02 259:3.9487291e-02 271:2.9256672e-02 "
          "293:2.9883744e-02 297:6.7425914e-02 318:5.7027973e-02 320:8.8732317e-02 350:8.1812821e-02 354:9.5418997e-02 "
          "363:5.1849447e-02 381:9.9993460e-02 438:4.7019359e-02 451:4.3233868e-02 477:5.3061504e-02 572:1.4177161e-01 "
          "628:1.2591575e-01 646:6.3002400e-02 651:9.3610935e-02 653:7.8616522e-02 660:3.0670926e-02 678:3.6931105e-02 "
          "679:5.0367046e-02 681:7.2149619e-02 764:5.1080320e-02 815:1.1498984e-01 837:5.3922884e-02 842:2.9056286e-02 "
          "857:6.6546313e-02 858:4.3775626e-02 882:1.7348987e-01 897:4.6354812e-02 920:1.4867613e-01 923:9.6569635e-02 "
          "932:8.3013743e-02 937:9.2006028e-02 968:1.2055444e-01 994:5.9786640e-02 1029:4.6898562e-02 "
          "1136:5.7357196e-02 "
          "1164:1.3963751e-01 1170:1.0213988e-01 1171:6.0754087e-02 1173:1.1858598e-01 1213:3.1182801e-02 "
          "1237:5.5375244e-02 "
          "1304:5.9383217e-02 1307:1.8643443e-01 1422:4.2744093e-02 1492:6.0045037e-02 1510:6.2141392e-02 "
          "1540:9.5980376e-02 "
          "1546:4.8958868e-02 1556:6.2282681e-02 1566:6.0426906e-02 1573:6.3075215e-02 1588:9.7096950e-02 "
          "1594:7.0875376e-02 "
          "1595:3.9566535e-01 1765:4.6169389e-02 2008:7.8946613e-02 2025:7.8895427e-02 2029:7.4729882e-02 "
          "2080:6.4646468e-02 "
          "2095:7.9655886e-02 2124:9.6686572e-02 2184:8.4111109e-02 2298:2.0537866e-02 2339:6.7046896e-02 "
          "2346:1.2485763e-01 "
          "3187:1.0380191e-01 3263:9.8816559e-02 3291:6.8400368e-02 3536:9.5762268e-02 3843:1.2979347e-01 "
          "4102:7.8684948e-02 "
          "4404:2.3272838e-01 4986:1.0399139e-01 5268:1.7848490e-01 5830:3.4883007e-01 5838:1.2576948e-01 "
          "21961:1.6115521e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:3.2782003e-02 21:4.9080536e-02 24:3.7734956e-02 33:9.4271608e-02 75:7.2779082e-02 85:6.7105964e-02 "
          "140:3.5096835e-02 218:5.5297565e-02 229:8.1228882e-02 271:7.4810937e-02 277:4.9903046e-02 293:4.5131575e-02 "
          "305:6.2723026e-02 323:1.3537751e-01 348:1.0575407e-01 381:1.5101394e-01 393:1.3942534e-01 433:1.0608601e-01 "
          "434:1.3605216e-01 575:6.9376625e-02 613:1.0854876e-01 622:8.7718524e-02 628:1.3492619e-01 802:6.8926662e-02 "
          "1013:2.6798984e-01 1028:5.2296065e-02 1059:4.6828214e-02 1071:6.3360199e-02 1193:5.9993204e-02 "
          "1486:9.4969742e-02 "
          "1510:9.3848310e-02 1540:8.5611716e-02 1617:8.9637935e-02 1757:1.5062536e-01 2107:8.3565451e-02 "
          "2297:1.1415292e-01 "
          "2304:1.1601417e-01 2490:1.6404152e-01 2520:1.0830706e-01 3370:1.0027084e-01 4060:1.2645257e-01 "
          "4301:1.3906521e-01 "
          "5794:2.6835427e-01 7881:5.5270308e-01 7890:2.3135458e-01 7965:2.7350992e-01 7995:1.9781217e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 41:7.6460965e-02 47:1.0179449e-01 75:8.0882333e-02 79:6.6708945e-02 89:8.4404498e-02 95:9.4632253e-02 "
          "117:7.3496625e-02 140:6.6040412e-02 147:6.3707978e-02 188:3.4201581e-02 196:1.7758071e-01 217:1.2541175e-01 "
          "238:6.4412221e-02 264:1.3954511e-01 274:1.7159902e-01 275:1.0811201e-01 276:1.5481928e-01 288:5.2719459e-02 "
          "315:1.2539895e-01 338:6.5280296e-02 385:1.1389117e-01 545:8.0803566e-02 597:1.6270734e-01 644:6.6583388e-02 "
          "675:1.1083849e-01 693:1.0971713e-01 802:4.5241773e-02 839:1.5021373e-01 1068:1.5414457e-01 "
          "1193:6.6672869e-02 "
          "1239:1.0596311e-01 1497:1.0525604e-01 1687:1.2981783e-01 1862:1.4191207e-01 3046:9.6907288e-02 "
          "3240:1.2209174e-01 "
          "4021:2.0941249e-01 6901:2.3940007e-01 12412:4.2440698e-01 21010:5.3902131e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 45:2.3380466e-02 50:2.3581464e-02 85:3.7969586e-02 89:4.2972755e-02 101:8.5896321e-02 "
          "110:3.2141339e-02 "
          "182:5.6866746e-02 183:3.3208694e-02 233:5.2808981e-02 236:2.7535219e-02 244:1.6388537e-01 258:6.9973022e-02 "
          "259:3.3742521e-02 277:2.8235909e-02 297:5.7616517e-02 298:3.8809545e-02 321:4.5208938e-02 353:4.6503972e-02 "
          "363:7.5016879e-02 415:8.7972306e-02 426:1.4839913e-01 459:4.5843069e-02 464:2.5461288e-02 497:3.7990186e-02 "
          "514:8.6473092e-02 533:4.1691247e-02 545:4.1139416e-02 575:3.9254360e-02 578:4.9907815e-02 581:9.5531836e-02 "
          "694:5.7991192e-02 733:6.1837669e-02 741:6.4455017e-02 751:5.4220330e-02 758:6.1396446e-02 800:7.1926422e-02 "
          "802:5.4965638e-02 838:1.5888439e-01 866:5.0418623e-02 968:6.0842726e-02 979:6.4692393e-02 "
          "1057:6.7623079e-02 "
          "1119:1.0104330e-01 1122:3.1850293e-02 1137:5.9143148e-02 1161:9.4842911e-02 1168:7.6420464e-02 "
          "1178:1.6352491e-01 "
          "1188:3.3537738e-02 1213:2.6646201e-02 1214:1.0081245e-01 1218:6.0987290e-02 1232:6.6164285e-02 "
          "1290:9.1505110e-02 "
          "1309:7.5055949e-02 1397:5.1878255e-02 1398:4.9361017e-02 1425:5.4868359e-02 1426:6.4769566e-02 "
          "1456:9.3329944e-02 "
          "1479:5.9268646e-02 1520:5.9896577e-02 1643:5.9570506e-02 1785:6.6473663e-02 1869:9.0012111e-02 "
          "1890:9.1248661e-02 "
          "1974:6.3007481e-02 1982:5.3521547e-02 2128:5.2927259e-02 2136:4.7528632e-02 2141:6.7378461e-02 "
          "2248:5.2119423e-02 "
          "2311:9.3369246e-02 2446:6.0468409e-02 2453:6.7697540e-02 2683:1.5350816e-01 2794:5.8020007e-02 "
          "2953:1.4154516e-01 "
          "3021:6.6152789e-02 3231:6.4204767e-02 3303:8.3674699e-02 3446:1.4173423e-01 3457:5.3042952e-02 "
          "3538:9.2227556e-02 "
          "3636:6.6078246e-02 3684:6.8127528e-02 3690:5.7446346e-02 3741:7.3966950e-02 3975:9.2798546e-02 "
          "4071:1.9737090e-01 "
          "4317:8.4068820e-02 4740:7.3274590e-02 5025:7.9055421e-02 5200:8.3527803e-02 5343:8.3286032e-02 "
          "5597:1.8644831e-01 "
          "6051:1.7262784e-01 6296:8.3448254e-02 6564:8.2796663e-02 6762:6.5484926e-02 7351:1.2491197e-01 "
          "7802:1.0304852e-01 "
          "7918:1.1013559e-01 8269:9.3408287e-02 8284:1.9907956e-01 8561:9.9514432e-02 8615:8.6338528e-02 "
          "8839:1.0385408e-01 "
          "8931:8.5010052e-02 9528:8.2293697e-02 9788:8.3514519e-02 11096:1.0931306e-01 13039:1.0597850e-01 "
          "18670:1.3030945e-01 18948:8.7763079e-02 20277:1.2716289e-01 25194:1.9632274e-01 30706:3.3839357e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 10:4.3145623e-02 26:7.2752446e-02 32:4.7482345e-02 33:4.0856447e-02 45:5.1339019e-02 53:4.4706114e-02 "
          "73:4.7368210e-02 74:4.2410884e-02 84:5.1107738e-02 85:8.3373927e-02 90:4.3305982e-02 141:5.9454944e-02 "
          "189:7.1715206e-02 221:5.3384211e-02 231:4.4456318e-02 260:7.5576633e-02 267:6.1852414e-02 271:3.2422371e-02 "
          "286:4.3688267e-02 322:7.1128093e-02 326:4.0560320e-02 464:3.3020228e-02 558:4.6291195e-02 655:6.3055165e-02 "
          "751:7.0317246e-02 757:9.1611207e-02 802:2.9872181e-02 842:3.2200303e-02 933:6.5353982e-02 "
          "1036:5.8312722e-02 "
          "1046:6.8152003e-02 1142:8.4532015e-02 1213:7.2521575e-02 1266:1.3992213e-01 1386:1.1102156e-01 "
          "1407:9.6986599e-02 "
          "1426:4.9610764e-02 1443:6.5284975e-02 1449:1.7053106e-01 1454:4.7494158e-02 1455:6.2237997e-02 "
          "1492:6.6542171e-02 "
          "1577:7.9024933e-02 1661:8.9481495e-02 1966:1.1386470e-01 2009:1.4521578e-01 2039:6.8861365e-02 "
          "2084:1.4635220e-01 "
          "2232:1.1455743e-01 2422:9.1724619e-02 2762:8.0587253e-02 2820:7.6588288e-02 2860:1.0824523e-01 "
          "2958:8.7946489e-02 "
          "3066:9.3037568e-02 3137:6.5863043e-02 3303:1.0851602e-01 3338:1.4796726e-01 3689:1.1699015e-01 "
          "4217:2.0097664e-01 "
          "4501:7.2062120e-02 5015:1.0134403e-01 5388:1.0007581e-01 6047:9.8626755e-02 6732:1.0660339e-01 "
          "8255:1.1537403e-01 "
          "8285:1.1083832e-01 8638:1.3824497e-01 8641:1.2998612e-01 8647:3.9477676e-01 8648:3.7262881e-01 "
          "8649:1.4078222e-01 "
          "8650:1.3449411e-01 8651:1.0086343e-01 9111:1.1372010e-01 10924:1.0647727e-01 12486:2.0375007e-01 "
          "14641:1.4437276e-01 14767:1.4515346e-01 15072:1.1841264e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 20:6.1912458e-02 70:1.1023878e-01 73:6.5640152e-02 102:1.6354550e-01 217:9.2578605e-02 "
          "223:9.6412398e-02 "
          "277:2.0502310e-01 284:8.2020737e-02 295:1.9202326e-01 388:1.8740001e-01 583:3.0222696e-01 929:2.2090879e-01 "
          "1005:2.4872844e-01 1288:3.7119934e-01 1429:1.6032660e-01 1437:3.2882693e-01 1654:2.3946296e-01 "
          "4531:1.8697311e-01 "
          "4532:2.2044320e-01 6756:4.4700530e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.4273620e-02 13:1.2060388e-01 19:2.4505408e-01 87:2.5319460e-01 233:1.2466624e-01 "
          "239:1.0159296e-01 "
          "277:1.3988627e-01 417:1.4742500e-01 464:7.4500464e-02 476:1.3727161e-01 494:2.5143322e-01 526:7.2950788e-02 "
          "533:7.2049141e-02 546:2.8844315e-01 555:9.1855027e-02 606:2.1893686e-01 802:1.4144188e-01 "
          "2298:5.1351614e-02 "
          "2339:1.6763991e-01 2601:5.9144700e-01 2604:1.6272274e-01 2605:1.8241209e-01 2671:3.0525577e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 17:3.5525315e-02 50:3.5818737e-02 55:3.7786443e-02 125:6.0016096e-02 188:2.6449246e-02 "
          "220:6.3252129e-02 "
          "236:4.1824237e-02 258:6.2773362e-02 287:1.0470332e-01 309:6.6054516e-02 370:6.5894291e-02 496:7.4574627e-02 "
          "516:6.6631801e-02 578:7.5806782e-02 664:1.1401767e-01 691:1.0085808e-01 842:3.7713755e-02 910:8.0464557e-02 "
          "945:6.9160476e-02 1028:4.4945192e-02 1073:7.4722514e-02 1122:4.8378561e-02 1142:9.9005885e-02 "
          "1213:4.0473878e-02 "
          "1214:9.0439662e-02 1454:5.5626277e-02 1455:4.3052729e-02 1456:8.3727047e-02 1546:6.3546412e-02 "
          "1759:1.3254853e-01 "
          "2028:7.5928964e-02 2083:9.0292245e-02 2126:8.1282333e-02 2248:7.9166070e-02 2533:9.7731628e-02 "
          "3008:7.5703427e-02 "
          "3137:7.7140354e-02 3238:1.3031770e-01 3387:9.7856171e-02 3427:1.9595040e-01 3454:2.9910541e-01 "
          "3457:8.0568850e-02 "
          "3512:1.6067585e-01 3520:1.3744037e-01 3532:1.0434286e-01 3539:2.8461808e-01 3570:9.7398221e-02 "
          "3772:1.3766044e-01 "
          "4071:1.1488827e-01 4276:8.2571730e-02 4351:1.0957431e-01 4421:1.0852068e-01 6412:1.3134544e-01 "
          "6826:1.5588900e-01 "
          "6909:9.3124554e-02 7519:1.4577468e-01 8273:1.1595750e-01 8737:9.3395598e-02 8738:9.4108023e-02 "
          "8805:1.3397110e-01 "
          "10912:1.5460221e-01 11176:1.4532679e-01 11233:2.0138259e-01 11236:1.7172134e-01 12163:1.5861778e-01 "
          "13052:1.8489499e-01 15062:1.8395418e-01 15064:1.9098052e-01 15065:1.9171798e-01 15961:1.6713844e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:4.5811582e-02 13:3.5510626e-02 17:8.1412822e-02 18:4.3207396e-02 19:3.9671786e-02 25:6.1215051e-02 "
          "42:7.1805432e-02 45:5.7745513e-02 48:6.3707963e-02 51:5.0174210e-02 64:9.3976207e-02 79:4.9542971e-02 "
          "80:1.6973191e-01 130:6.0277455e-02 133:6.5332361e-02 170:9.6538603e-02 184:6.6762619e-02 187:7.1370870e-02 "
          "217:4.4381708e-02 234:4.8533164e-02 258:6.0284585e-02 311:9.9443242e-02 327:1.0323977e-01 348:5.1552232e-02 "
          "381:1.5498045e-01 459:6.6871963e-02 481:5.7375994e-02 511:6.1268885e-02 514:6.0106184e-02 556:1.7809029e-01 "
          "560:1.2016977e-01 573:4.7455177e-02 574:8.1871383e-02 628:1.1136311e-01 644:4.9449723e-02 773:9.1156952e-02 "
          "803:6.7316994e-02 923:2.5261745e-01 1009:9.2167847e-02 1033:6.1017446e-02 1057:2.3539072e-01 "
          "1179:7.5593449e-02 "
          "1401:9.1573976e-02 1411:8.5375518e-02 1422:9.0211384e-02 1448:2.4612096e-01 1452:6.2197510e-02 "
          "1467:8.6257018e-02 "
          "1520:8.7372020e-02 1778:1.3759285e-01 2026:8.7321766e-02 2126:7.8059733e-02 2298:2.5600348e-02 "
          "2318:9.1732845e-02 "
          "2322:1.4818054e-01 2845:1.4199190e-01 2858:9.8422527e-02 2874:9.2491798e-02 2893:9.6330993e-02 "
          "3000:2.0990610e-01 "
          "3343:1.0437525e-01 3353:1.1744291e-01 3355:8.7282762e-02 3446:1.2210978e-01 4319:1.7593479e-01 "
          "6067:2.0551874e-01 "
          "7553:2.7888784e-01 7990:1.9696939e-01 11814:1.4732128e-01 12214:2.1481329e-01 13769:1.4826271e-01 "
          "13770:1.5828483e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 1:1.9695275e-01 15:5.9699249e-02 21:1.0881859e-01 35:8.4121816e-02 73:4.9924869e-02 110:7.4385516e-02 "
          "210:7.8438461e-02 337:8.8110842e-02 374:8.9878447e-02 381:1.5954332e-01 417:5.5562869e-02 524:1.1174154e-01 "
          "593:1.2129460e-01 614:2.0709239e-01 620:1.1203635e-01 623:9.8330550e-02 625:9.9132314e-02 "
          "1014:9.3912371e-02 "
          "1066:1.3532907e-01 2136:1.0999671e-01 2298:4.0616255e-02 2660:1.6021448e-01 2923:1.7067949e-01 "
          "3471:1.8836792e-01 "
          "4060:1.6558719e-01 4197:1.9397281e-01 4302:6.6785961e-01 6068:1.8530671e-01 6697:1.8958478e-01 "
          "24805:2.5593999e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:2.3847720e-02 24:1.6212892e-02 35:4.6732701e-02 41:5.0049994e-02 48:5.6151323e-02 49:7.2861068e-02 "
          "51:5.8829155e-02 55:7.6323301e-02 69:4.5288470e-02 70:7.1787089e-02 78:1.2899178e-01 108:7.3528945e-02 "
          "123:1.5640830e-01 133:1.2084448e-01 140:5.3581093e-02 141:9.9797495e-02 181:1.0376506e-01 183:7.2290823e-02 "
          "188:2.2387750e-02 193:4.5998365e-02 213:5.3888708e-02 224:6.8343543e-02 236:3.5401788e-02 252:3.9698977e-02 "
          "257:3.9729055e-02 268:7.8343160e-02 284:9.0433702e-02 286:5.3683314e-02 312:5.4349888e-02 327:7.3413476e-02 "
          "381:5.2347530e-02 387:1.1096063e-01 390:2.2783825e-01 476:6.0316872e-02 514:1.1117768e-01 522:1.3115449e-01 "
          "533:3.1658247e-02 535:5.1073834e-02 555:4.0360913e-02 573:4.1826341e-02 653:8.6371541e-02 679:9.3691029e-02 "
          "686:1.1316966e-01 726:8.7510295e-02 811:4.0826190e-02 858:4.8093811e-02 968:1.3244636e-01 "
          "1059:5.7678457e-02 "
          "1066:1.2729111e-01 1099:1.2903515e-01 1102:9.9512644e-02 1132:1.0431192e-01 1179:6.6627026e-02 "
          "1188:4.3119170e-02 "
          "1282:6.6547632e-02 1321:6.2665962e-02 1350:7.2894298e-02 1360:7.1987435e-02 1361:7.4506581e-02 "
          "1437:8.2060151e-02 "
          "1452:5.4820031e-02 1455:3.6441635e-02 1468:1.2284275e-01 1500:7.5609356e-02 1511:1.3387561e-01 "
          "1528:6.6654049e-02 "
          "1690:1.2283609e-01 1731:5.7880901e-02 1768:5.8145188e-02 1784:1.0722645e-01 1994:7.3198915e-02 "
          "2166:7.8874528e-02 "
          "2298:2.2563795e-02 2362:7.6401770e-02 2438:7.1470208e-02 2538:1.2483831e-01 2640:7.1448795e-02 "
          "2730:1.1728761e-01 "
          "2731:7.7892520e-02 2732:1.3395415e-01 3692:1.0372923e-01 3696:1.0527505e-01 4005:1.3723090e-01 "
          "5057:1.3095498e-01 "
          "5707:1.7045881e-01 5981:1.0251673e-01 6507:8.3366945e-02 6576:8.5239530e-02 6825:1.7774710e-01 "
          "7772:9.8812900e-02 "
          "9871:1.9042584e-01 13819:2.6498237e-01 19317:1.3484298e-01 25684:1.4251567e-01 36500:3.4558073e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:5.6138527e-02 15:5.9486382e-02 18:1.1565264e-01 51:6.3994959e-02 64:9.0102598e-02 69:8.1231423e-02 "
          "70:1.0355427e-01 82:1.0254034e-01 140:4.5794755e-02 254:1.7589012e-01 433:6.5958947e-02 437:1.6949970e-01 "
          "443:1.0200477e-01 560:1.1220267e-01 689:1.5289612e-01 1012:8.4784225e-02 1160:2.2876738e-01 "
          "1295:1.1771316e-01 "
          "2075:5.5129921e-01 2298:4.0471431e-02 2349:1.3506883e-01 2506:1.8735969e-01 2526:2.8855836e-01 "
          "2769:1.5057151e-01 "
          "2842:1.3614522e-01 2849:2.3866573e-01 3230:2.1567476e-01 45382:4.0884182e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:7.1322389e-02 20:1.0093312e-01 57:1.2742862e-01 87:2.0453906e-01 133:2.2217266e-01 "
          "152:1.3671161e-01 "
          "215:1.2577802e-01 224:9.1982253e-02 238:1.6267788e-01 302:1.0665893e-01 305:2.4812107e-01 326:9.1630414e-02 "
          "384:3.1395596e-01 387:1.4933977e-01 438:1.1771581e-01 555:9.1973402e-02 811:9.3033671e-02 "
          "1124:1.7459288e-01 "
          "1430:2.1269378e-01 1658:2.5572169e-01 1766:4.8649886e-01 1822:2.4204846e-01 1859:2.0246391e-01 "
          "2950:1.7901534e-01 "
          "5889:2.5545177e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 9:8.0122910e-02 19:7.1023956e-02 24:4.6413746e-02 39:4.3158978e-02 47:7.9937518e-02 49:4.1651003e-02 "
          "51:6.0325474e-02 63:1.1437517e-01 90:5.1504716e-02 104:1.2671208e-01 106:6.0956858e-02 107:6.2320821e-02 "
          "130:6.3735776e-02 152:1.2185993e-01 161:4.8357919e-02 188:2.6857933e-02 229:4.1868679e-02 239:5.3552996e-02 "
          "286:3.0688046e-02 306:8.1829898e-02 347:6.4933300e-02 388:9.4992958e-02 442:1.0544328e-01 481:6.0667854e-02 "
          "546:5.8268443e-02 548:1.7430611e-01 553:9.6775681e-02 613:1.0359083e-01 655:4.4291973e-02 768:6.6962682e-02 "
          "769:1.8841568e-01 1012:5.6707531e-02 1127:4.0180936e-02 1226:1.2095866e-01 1424:1.0373139e-01 "
          "1455:4.3717969e-02 "
          "1574:1.0880555e-01 1629:9.1340780e-02 2153:6.2978670e-02 2298:2.7069129e-02 2490:8.4553689e-02 "
          "2600:3.4490305e-01 "
          "3384:1.0659071e-01 3471:4.3749443e-01 3473:2.2671662e-01 3483:1.1112087e-01 4150:1.7684433e-01 "
          "4507:1.3190773e-01 "
          "4899:1.3658383e-01 5578:1.1196687e-01 9781:2.9919282e-01 10646:1.4297162e-01 14899:3.6853766e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 33:4.4850398e-02 54:5.2780867e-02 64:6.8945691e-02 69:2.3895940e-02 225:1.0210779e-01 "
          "296:5.5412736e-02 "
          "302:5.1828023e-02 323:6.4406820e-02 336:5.3171974e-02 347:1.0147727e-01 364:4.5981046e-02 371:9.0626217e-02 "
          "415:1.0104477e-01 433:4.0719833e-02 459:1.1050291e-01 533:3.5055451e-02 549:1.1560246e-01 550:9.0780593e-02 "
          "616:5.8782998e-02 629:1.1113898e-01 678:4.4928078e-02 681:8.7772734e-02 878:1.4989680e-01 897:1.3456880e-01 "
          "1075:7.5493984e-02 1091:8.7662980e-02 1125:8.5036144e-02 1126:9.2533916e-02 1127:3.7087422e-02 "
          "1132:5.5038992e-02 "
          "1195:6.7766890e-02 1380:6.1967656e-02 1383:1.1241926e-01 1486:1.2952691e-01 1617:1.5153193e-01 "
          "1666:7.2290830e-02 "
          "1726:6.6557199e-02 1908:1.7885029e-01 1909:1.8250057e-01 1944:7.2998635e-02 2363:1.9002834e-01 "
          "2374:2.1925089e-01 "
          "2381:8.5262634e-02 2806:7.8770295e-02 3659:1.7379740e-01 3722:1.0285834e-01 3898:1.0138727e-01 "
          "3923:1.3657866e-01 "
          "7999:1.4312541e-01 11266:1.9227739e-01 11269:3.5715181e-01 11326:1.3130040e-01 11399:1.3736318e-01 "
          "11400:1.2234873e-01 11759:1.4123452e-01 11760:1.2944163e-01 13259:1.3235617e-01 20418:1.3520838e-01 "
          "40551:4.2712587e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 1:5.5881996e-02 4:6.4567454e-02 5:5.3812873e-02 10:3.6988441e-02 14:3.1092601e-02 17:2.6003236e-02 "
          "21:3.0875428e-02 24:1.4020155e-02 33:5.9304085e-02 43:1.5185465e-01 46:1.3668519e-01 48:4.8557054e-02 "
          "50:4.4390954e-02 51:5.3681724e-02 52:3.8584251e-02 53:1.0000994e-01 63:4.8693080e-02 64:7.9007894e-02 "
          "67:7.9698928e-02 69:3.1596754e-02 70:6.2078141e-02 73:2.3983996e-02 84:4.3814309e-02 91:4.8300292e-02 "
          "107:4.4922445e-02 117:4.1602936e-02 136:4.3304186e-02 140:3.7382331e-02 180:4.7551580e-02 223:7.3929377e-02 "
          "271:2.7795475e-02 277:6.5881424e-02 284:7.1515419e-02 288:2.9841974e-02 296:1.1292242e-01 320:4.0169716e-02 "
          "337:4.2328607e-02 338:7.7548064e-02 348:3.9292175e-02 374:7.3106319e-02 377:7.6015435e-02 379:1.6408797e-01 "
          "425:6.5217517e-02 477:5.0411396e-02 484:1.7090176e-01 510:7.5475261e-02 514:7.7566192e-02 550:4.1871823e-02 "
          "553:4.1200429e-02 622:5.5181693e-02 630:5.4144666e-02 660:2.9139094e-02 663:1.2291432e-01 690:5.0573062e-02 "
          "759:1.1108783e-01 764:4.8529159e-02 768:4.8268415e-02 865:6.1746206e-02 960:7.7294081e-02 981:6.8888515e-02 "
          "1005:5.3676322e-02 1028:3.2898244e-02 1211:6.3403055e-02 1295:5.6751970e-02 1322:6.3698299e-02 "
          "1629:3.8886618e-02 "
          "1654:3.3530757e-02 1676:1.0794857e-01 1988:6.5595187e-02 2018:5.7590105e-02 2032:1.4127950e-01 "
          "2298:1.9512121e-02 "
          "3195:7.6568387e-02 3271:5.6791019e-02 3487:9.1085739e-02 4188:1.1075214e-01 4198:1.3043018e-01 "
          "4639:9.8432668e-02 "
          "5254:1.2272792e-01 5580:7.2673932e-02 6434:1.0248729e-01 6994:1.1734892e-01 7546:1.0268693e-01 "
          "9930:3.0383080e-01 "
          "11313:1.1172947e-01 22539:1.4457515e-01 25693:5.9693611e-01 43154:1.6198058e-01 43156:1.5782343e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:2.2583164e-02 20:1.8875476e-02 22:8.4894240e-02 24:1.1698244e-02 39:2.5957879e-02 49:5.2572150e-02 "
          "51:1.5204594e-02 54:2.0312963e-02 69:3.2677427e-02 70:1.9849958e-02 86:5.2290294e-02 90:3.0977407e-02 "
          "140:1.8422117e-02 142:8.8577092e-02 147:3.0089730e-02 161:2.9084774e-02 167:8.5797228e-02 171:5.1415473e-02 "
          "188:3.3900246e-02 191:3.6636066e-02 197:4.7866490e-02 199:5.4113179e-02 205:6.6790529e-02 225:3.9296661e-02 "
          "236:4.3249398e-02 238:3.0422349e-02 240:2.6862178e-02 254:8.7700635e-02 271:2.3192201e-02 305:3.2922935e-02 "
          "320:3.3517115e-02 321:4.1939300e-02 326:2.9013395e-02 357:4.5520235e-02 358:5.2587457e-02 443:4.1034035e-02 "
          "462:5.1698916e-02 463:1.2585601e-01 477:4.2062644e-02 510:3.7194416e-02 526:3.9160024e-02 540:1.2782168e-01 "
          "555:2.9121999e-02 575:3.6415372e-02 606:4.0996090e-02 611:5.7339206e-02 613:4.0426593e-02 620:5.5663295e-02 "
          "673:3.9969098e-02 676:5.2455258e-02 726:3.7292771e-02 811:6.1820325e-02 884:1.3661137e-01 891:1.4006139e-01 "
          "994:8.0244608e-02 1003:5.0280519e-02 1012:3.4106631e-02 1028:2.7449887e-02 1038:4.6005957e-02 "
          "1168:4.1870851e-02 "
          "1188:3.1112190e-02 1195:4.4157963e-02 1311:5.5292677e-02 1383:4.3265078e-02 1399:4.5498665e-02 "
          "1443:4.6699300e-02 "
          "1452:3.9554827e-02 1500:5.4555152e-02 1545:5.8663078e-02 1577:5.6527697e-02 1616:6.0967535e-02 "
          "1629:3.2446515e-02 "
          "1674:8.6712368e-02 1751:5.1588766e-02 1808:6.7055799e-02 1894:5.2970771e-02 1991:1.3861163e-01 "
          "2030:8.6147167e-02 "
          "2074:4.9457423e-02 2103:8.4573619e-02 2126:4.9642485e-02 2218:1.4711404e-01 2834:9.5152877e-02 "
          "3123:1.7206433e-01 "
          "3166:9.9449374e-02 3266:6.7823701e-02 3271:1.3228954e-01 3326:5.4096326e-02 3381:1.2411984e-01 "
          "3403:1.4520887e-01 "
          "3405:7.5649515e-02 3414:7.9519190e-02 3496:8.8938862e-02 3503:1.0427737e-01 3781:1.5484536e-01 "
          "3845:5.7678178e-02 "
          "4210:9.3349628e-02 5202:2.4167243e-01 5835:2.6330248e-01 6265:1.0370156e-01 6607:7.2391756e-02 "
          "6648:9.5830671e-02 "
          "6917:8.6215064e-02 8199:8.4900983e-02 8699:9.0250261e-02 11228:2.0668602e-01 12511:1.1054294e-01 "
          "13329:1.0173886e-01 18199:1.3097887e-01 22982:4.0037256e-01 28661:3.0231792e-01 40245:1.3852310e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 19:1.1240283e-01 20:3.5240572e-02 51:5.9573352e-02 188:3.0158915e-02 218:5.4190431e-02 "
          "230:5.7459924e-02 "
          "232:6.2694892e-02 417:4.1581694e-02 494:7.0917554e-02 526:4.3181058e-02 583:4.0597540e-01 679:7.4543290e-02 "
          "802:3.9894141e-02 811:5.4997645e-02 842:4.3003339e-02 897:6.8605177e-02 1014:7.0281386e-02 "
          "1213:4.6150584e-02 "
          "1452:7.3848985e-02 1666:5.1942758e-02 1808:1.2519339e-01 2153:7.0719078e-02 2298:3.0396067e-02 "
          "2335:2.8940120e-01 "
          "2493:7.1491189e-02 2495:9.6117303e-02 2694:1.1420678e-01 4296:1.2833291e-01 4333:1.6062708e-01 "
          "4345:1.2717968e-01 "
          "4349:2.2267099e-01 5802:3.3220595e-01 5864:1.6601500e-01 15157:5.0331485e-01 15158:3.6618024e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.7742931e-02 19:5.0004061e-02 45:7.2784983e-02 52:6.3807979e-02 56:8.5156612e-02 60:7.2368979e-02 "
          "73:3.9663084e-02 74:6.0127281e-02 117:6.8800077e-02 121:7.3535278e-02 191:1.5238355e-01 197:9.4869941e-02 "
          "286:7.6770887e-02 298:7.1356326e-02 301:1.2034934e-01 319:6.3721374e-02 394:8.4798038e-02 443:8.1328228e-02 "
          "454:6.5051243e-02 477:8.3366901e-02 501:8.6496793e-02 524:8.8773675e-02 526:4.5840077e-02 547:6.3621350e-02 "
          "549:7.1141563e-02 576:9.1907032e-02 578:9.1761917e-02 629:8.4773526e-02 773:6.7860737e-02 785:1.0823027e-01 "
          "811:5.8384307e-02 842:4.5651410e-02 984:8.9411438e-02 995:7.2789580e-02 1011:7.8551166e-02 "
          "1089:1.2038219e-01 "
          "1127:4.7897756e-02 1198:1.6162208e-01 1212:9.1639556e-02 1304:9.3299173e-02 1371:1.0631459e-01 "
          "1449:1.8174060e-01 "
          "1623:7.7691555e-02 1718:2.7500585e-01 1935:1.6285503e-01 1988:1.0847680e-01 2125:1.3335824e-01 "
          "2381:1.1011520e-01 "
          "2520:2.6887438e-01 2534:2.3693590e-01 2780:1.2121079e-01 2887:1.4110918e-01 3339:1.4259072e-01 "
          "5577:1.5575129e-01 "
          "5587:1.6620186e-01 5961:1.8632895e-01 10664:3.0232361e-01 10746:2.1497816e-01 14234:1.8949679e-01 "
          "14235:1.9632322e-01 14237:2.0517968e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:2.5337413e-02 32:7.3564947e-02 45:4.6977684e-02 46:1.2308797e-01 53:1.1727363e-01 54:4.3996170e-02 "
          "56:9.3059972e-02 70:7.2794050e-02 73:4.3344203e-02 136:1.6423722e-01 140:1.0411855e-01 184:9.1960527e-02 "
          "220:8.3670832e-02 238:6.5892249e-02 253:9.3946643e-02 274:8.3646663e-02 305:7.1308307e-02 311:8.0900021e-02 "
          "315:7.5764410e-02 339:6.2078048e-02 344:9.7956434e-02 370:8.7165922e-02 379:1.0622047e-01 464:5.1158622e-02 "
          "510:1.6906416e-01 555:6.3075803e-02 567:1.3263434e-01 678:6.3409001e-02 757:8.3828680e-02 866:1.0130466e-01 "
          "873:2.0698935e-01 927:8.9549653e-02 988:1.0739571e-01 994:1.0265090e-01 1028:5.9454150e-02 "
          "1159:1.7189515e-01 "
          "1160:9.4978929e-02 1178:1.2591439e-01 1241:1.4958297e-01 1259:2.5240293e-01 1342:1.4819625e-01 "
          "1420:1.0450881e-01 "
          "1440:1.8757777e-01 1573:1.0829723e-01 1629:7.0276417e-02 1731:9.0455942e-02 1937:2.3135972e-01 "
          "2266:1.8610232e-01 "
          "2519:1.3397604e-01 2731:1.2172998e-01 3434:1.2625019e-01 3727:1.3155758e-01 3728:1.5253064e-01 "
          "4279:1.5140463e-01 "
          "6050:1.9146764e-01 6080:2.0362209e-01 10548:2.0673855e-01 17649:2.0427847e-01 33165:2.7384955e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 9:3.7009206e-02 10:4.0131334e-02 14:8.0500513e-02 26:6.7669734e-02 35:4.3846082e-02 50:4.8162833e-02 "
          "55:3.0008415e-02 82:5.3637464e-02 84:4.7537193e-02 85:7.7549167e-02 90:4.0280491e-02 124:6.5356731e-02 "
          "153:7.7829875e-02 169:4.0629089e-02 188:4.4081114e-02 189:3.9397027e-02 191:4.7638550e-02 217:3.6701195e-02 "
          "224:3.7871514e-02 230:4.0019322e-02 233:7.9208009e-02 236:3.3215065e-02 241:1.3138908e-01 254:5.4340076e-02 "
          "291:5.8362778e-02 293:3.0803619e-02 296:4.6951640e-02 309:5.2457739e-02 313:6.0024992e-02 315:4.5485537e-02 "
          "339:3.7268862e-02 357:1.2421855e-01 364:3.8960095e-02 386:1.3117999e-01 394:1.5531608e-01 417:1.1266731e-01 "
          "433:3.4502231e-02 434:1.6156656e-01 441:6.0740143e-02 516:1.3808154e-01 524:5.8242075e-02 533:2.9702757e-02 "
          "535:4.7919068e-02 545:4.9625475e-02 575:4.7351576e-02 586:4.2164158e-02 606:5.3307969e-02 613:3.1047178e-02 "
          "642:4.6177804e-02 655:5.8649939e-02 660:3.1615034e-02 664:5.3479154e-02 726:8.2104899e-02 747:8.9717038e-02 "
          "757:5.0326966e-02 815:5.6479909e-02 820:4.9516480e-02 837:9.4109736e-02 842:2.9950691e-02 860:6.8637498e-02 "
          "911:9.3579650e-02 927:5.3761579e-02 954:5.9314378e-02 1000:4.7324602e-02 1012:4.4349480e-02 "
          "1036:9.1834292e-02 "
          "1059:3.1961627e-02 1091:7.4277520e-02 1110:9.6022837e-02 1186:1.1169396e-01 1200:7.3887378e-02 "
          "1218:4.3450139e-02 "
          "1295:6.1574161e-02 1308:6.4859197e-02 1311:7.1898088e-02 1317:9.2304535e-02 1345:1.9473550e-01 "
          "1380:5.2505676e-02 "
          "1426:4.6144802e-02 1520:7.2251782e-02 1526:9.6697204e-02 1623:5.0971389e-02 1643:1.2166692e-01 "
          "1777:1.2813614e-01 "
          "1811:7.3075153e-02 1889:5.2490082e-02 1913:1.0755846e-01 2088:6.5030098e-02 2153:4.9253974e-02 "
          "2360:6.2517725e-02 "
          "2362:4.2336859e-02 2477:6.6885911e-02 2614:6.6603102e-02 2747:7.8939825e-02 2752:1.5475239e-01 "
          "2831:1.1608203e-01 "
          "2872:9.6205324e-02 3068:1.9604450e-01 3282:1.2901625e-01 3811:8.1736766e-02 3921:6.3299030e-02 "
          "4411:1.7298383e-01 "
          "5477:9.7313128e-02 5657:8.0456518e-02 5739:1.0391866e-01 5862:8.9187175e-02 7330:9.3340755e-02 "
          "7703:1.0917459e-01 "
          "8213:1.4754815e-01 9919:1.0781436e-01 10924:9.9038437e-02 13667:1.4801604e-01 21688:1.2020823e-01 "
          "32595:1.6880707e-01 32596:4.3361178e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:2.9465994e-02 14:9.3233332e-02 15:9.7786613e-02 18:7.9669729e-02 19:4.3203831e-02 33:8.4735721e-02 "
          "39:7.5262383e-02 45:3.7141893e-02 51:4.4084262e-02 54:3.4784626e-02 60:6.2527269e-02 65:1.0575296e-01 "
          "70:3.3991762e-02 86:8.9543723e-02 90:1.1132465e-01 102:5.0428703e-02 140:5.3413160e-02 223:1.0563284e-01 "
          "232:9.7363427e-02 240:4.5999728e-02 286:6.6330545e-02 433:4.5437198e-02 454:5.6204695e-02 466:9.6398011e-02 "
          "474:8.7176330e-02 506:5.2577648e-02 527:1.0693540e-01 605:1.1458537e-01 622:1.3349704e-01 627:7.4225634e-02 "
          "646:8.5524030e-02 649:9.0911701e-02 1033:6.6449933e-02 1145:6.1719552e-02 1213:4.2329799e-02 "
          "2203:1.0274456e-01 "
          "2298:2.7879590e-02 2764:1.1556994e-01 3437:1.1193916e-01 5643:1.2841378e-01 6858:1.1263412e-01 "
          "6979:1.5217702e-01 "
          "7995:3.7313917e-01 9262:1.8994366e-01 9925:1.5570769e-01 9932:2.1716699e-01 9944:1.9816263e-01 "
          "9945:1.7020284e-01 "
          "9946:4.0089524e-01 10050:1.8007720e-01 10279:2.6854745e-01 10411:1.8636315e-01 36579:2.1900062e-01 "
          "39772:1.8771996e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 22:2.9239118e-01 62:1.6920285e-01 567:2.1091159e-01 622:2.6849958e-01 623:2.8489134e-01 "
                  "690:1.4533599e-01 "
                  "1045:1.4562194e-01 1192:2.1554929e-01 1213:8.5136972e-02 1459:3.4045029e-01 1575:1.5317327e-01 "
                  "2317:2.7925110e-01 "
                  "2532:2.4290575e-01 3272:1.4128211e-01 3840:2.5229332e-01 10072:3.6247957e-01 18978:3.1740209e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 1:5.7849888e-02 5:3.6146354e-02 13:2.8018670e-02 24:1.4513876e-02 32:8.8435017e-02 50:6.4767085e-02 "
          "51:4.5015443e-02 55:2.8632289e-02 64:2.6560063e-02 69:3.2709435e-02 73:2.4828594e-02 75:4.7395911e-02 "
          "76:5.1677536e-02 79:3.9090499e-02 81:5.2221876e-02 98:4.5669764e-02 124:6.2359601e-02 126:4.5236934e-02 "
          "136:4.4829149e-02 140:5.9641592e-02 141:5.2765232e-02 172:7.3412441e-02 177:7.7114694e-02 179:3.2181542e-02 "
          "188:2.0041646e-02 210:3.9008949e-02 217:3.5018150e-02 218:3.6011424e-02 224:3.6134802e-02 236:6.6508986e-02 "
          "238:9.8492332e-02 252:7.4582070e-02 259:3.8836233e-02 262:5.9766851e-02 271:2.8774295e-02 277:5.5024497e-02 "
          "286:2.2899713e-02 288:3.0892862e-02 291:9.4285242e-02 293:2.9391026e-02 296:4.4798534e-02 320:4.1584294e-02 "
          "327:3.8815398e-02 334:4.7837012e-02 335:1.6534121e-01 339:6.0207956e-02 342:4.8592161e-02 349:4.9234468e-02 "
          "360:5.5571213e-02 367:7.8965567e-02 386:5.2451342e-02 415:4.8247334e-02 423:9.6229039e-02 432:8.7668270e-02 "
          "433:3.2920029e-02 449:8.3595984e-02 451:4.2521037e-02 453:4.1802581e-02 465:6.1310947e-02 496:5.6508161e-02 "
          "526:2.8695315e-02 534:6.6548713e-02 545:4.7349751e-02 551:7.5082928e-02 571:8.6128987e-02 575:4.5180127e-02 "
          "638:5.0664451e-02 644:8.1881404e-02 647:5.9411243e-02 660:5.1074177e-02 664:5.1026706e-02 676:1.1019109e-01 "
          "740:7.9035513e-02 755:6.4365841e-02 791:7.6250255e-02 802:4.4887099e-02 815:9.1243461e-02 817:6.0597103e-02 "
          "818:9.4390117e-02 854:9.2812449e-02 867:7.0399411e-02 905:5.7588432e-02 932:4.8220869e-02 950:7.0315808e-02 "
          "952:7.2355181e-02 954:5.6594338e-02 955:5.7352006e-02 988:1.2910418e-01 989:8.4680401e-02 "
          "1014:4.6704419e-02 "
          "1131:7.0847958e-02 1134:5.4274853e-02 1160:5.4406200e-02 1178:7.2126776e-02 1188:3.8600534e-02 "
          "1189:5.0546624e-02 "
          "1193:3.9069362e-02 1204:1.1213489e-01 1213:3.0668667e-02 1237:5.4462228e-02 1305:5.4784283e-02 "
          "1354:7.3773533e-02 "
          "1361:1.1293077e-01 1369:1.1439385e-01 1421:6.7708559e-02 1426:4.4028696e-02 1470:6.7018442e-02 "
          "1497:6.1678555e-02 "
          "1513:6.7305759e-02 1645:6.3043274e-02 1727:5.5277571e-02 1776:5.3900726e-02 1833:9.6414521e-02 "
          "1837:5.6810800e-02 "
          "1859:7.9537004e-02 2066:6.7681834e-02 2074:6.1361253e-02 2076:6.8821967e-02 2131:1.2350175e-01 "
          "2214:6.3456267e-02 "
          "2256:7.5510338e-02 2364:1.0702242e-01 2433:6.6188097e-02 2477:6.3818663e-02 2538:6.6004887e-02 "
          "2604:6.4007260e-02 "
          "2762:7.1519792e-02 2872:9.1793537e-02 2997:1.1473927e-01 3137:5.8452312e-02 3493:1.2499350e-01 "
          "3737:6.4060792e-02 "
          "3772:6.1607633e-02 3841:5.1900033e-02 3995:1.0092463e-01 4132:8.4288836e-02 4276:6.2567882e-02 "
          "4763:1.2336205e-01 "
          "5121:1.0275881e-01 5358:1.0008355e-01 5393:1.1078198e-01 5656:8.1567153e-02 6002:9.5169514e-02 "
          "6045:9.5020451e-02 "
          "6675:8.8217951e-02 6789:1.2367176e-01 6825:9.3978986e-02 7121:8.9955471e-02 7238:9.4339356e-02 "
          "7467:1.1279986e-01 "
          "7650:1.1254115e-01 9382:1.2908000e-01 10451:1.1105153e-01 10543:1.2120732e-01 10769:1.0747039e-01 "
          "12409:1.2271278e-01 13741:1.0905439e-01 17581:1.0549041e-01 21020:1.3619991e-01 21112:1.2856610e-01 "
          "21131:1.6981247e-01 32388:1.7783988e-01 33289:1.5901797e-01 34592:1.4417179e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("1 |f 20:1.2097207e-01 69:5.8939725e-02 107:1.4188084e-01 223:1.1126158e-01 339:1.0848981e-01 "
                  "623:1.4919472e-01 "
                  "802:8.0882877e-02 943:2.0733470e-01 1295:1.7924264e-01 1666:1.0531070e-01 1682:2.9384211e-01 "
                  "2136:1.6689552e-01 "
                  "2298:6.1626125e-02 2347:1.9029321e-01 3400:2.1192630e-01 4421:2.5087789e-01 9216:3.1270108e-01 "
                  "16358:4.8151895e-01 38839:4.8052466e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:3.2618731e-02 15:2.6792094e-02 20:2.1133101e-02 24:1.3097428e-02 49:5.8860108e-02 50:7.8307994e-02 "
          "53:3.5803821e-02 64:5.0299525e-02 73:2.2405505e-02 138:7.0043184e-02 169:3.4982651e-02 173:6.3371986e-02 "
          "207:4.8613124e-02 217:5.3504527e-02 233:2.6135916e-02 240:3.0075062e-02 288:5.8504995e-02 296:8.4839597e-02 "
          "297:3.5343897e-02 337:3.9542776e-02 349:4.4429544e-02 467:5.9706476e-02 469:4.8789583e-02 472:2.6547438e-01 "
          "506:5.8203235e-02 511:7.3862925e-02 522:1.6329052e-01 560:5.0535001e-02 583:6.0928944e-02 588:5.2850667e-02 "
          "605:7.4917011e-02 645:5.6481887e-02 652:6.2998749e-02 660:4.6089709e-02 673:4.4749651e-02 702:3.5125222e-02 "
          "796:2.9585263e-01 891:7.4722528e-02 963:4.5216952e-02 998:8.0178298e-02 1029:4.1623812e-02 "
          "1454:9.0766735e-02 "
          "1543:2.6838371e-01 1567:1.8325570e-01 1573:5.5981051e-02 1629:3.6327317e-02 1666:5.2739985e-02 "
          "1674:6.2993258e-02 "
          "1906:4.8685696e-02 1921:5.4474991e-02 2219:1.3492395e-01 2563:1.7314021e-01 2818:7.7106826e-02 "
          "3509:9.9484608e-02 "
          "3556:7.4260116e-02 3836:7.6084122e-02 3841:4.6834968e-02 4040:9.7549446e-02 4079:9.6283257e-02 "
          "4123:8.4341452e-02 "
          "5268:9.3559764e-02 5791:6.4012572e-02 6953:9.2716940e-02 7486:1.7482540e-01 7628:1.1184265e-01 "
          "8675:1.1751513e-01 "
          "9636:1.7919677e-01 10151:2.6332083e-01 11296:1.1053274e-01 11669:9.5510043e-02 12206:1.7901723e-01 "
          "13292:2.0485130e-01 24813:2.5784376e-01 25018:1.8570995e-01 32035:2.8762224e-01 43439:1.2744546e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("1 |f 20:8.5649185e-02 35:1.5300527e-01 70:9.0070985e-02 136:1.6395439e-01 238:1.3804416e-01 "
                  "302:1.5324327e-01 "
                  "468:2.2203252e-01 995:1.6664699e-01 1028:1.2455636e-01 1654:2.6642117e-01 2339:2.4116872e-01 "
                  "2521:3.6324486e-01 "
                  "2525:2.9789135e-01 5793:2.7321491e-01 6560:4.6337038e-01 7191:3.9993620e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.6881499e-02 14:6.8972208e-02 15:3.0315053e-02 17:2.7486045e-02 21:3.2636069e-02 26:3.8937405e-02 "
          "33:7.7697486e-02 41:7.7459723e-02 50:2.7713068e-02 51:1.9261574e-02 64:2.7119605e-02 65:1.1026172e-01 "
          "67:4.9755674e-02 70:7.0202820e-02 75:8.1938840e-02 80:9.7023666e-02 112:4.9418226e-02 125:9.7448304e-02 "
          "169:8.3068542e-02 185:1.5948431e-01 209:4.2857271e-02 210:8.3589315e-02 217:1.1431958e-01 231:4.0285397e-02 "
          "233:7.0568912e-02 269:3.3411130e-02 271:2.9380484e-02 286:2.3382142e-02 345:1.7054640e-01 346:1.5898763e-01 "
          "364:3.7956599e-02 451:4.3416828e-02 454:1.4128157e-01 465:1.6335757e-01 474:1.0919336e-01 478:8.5487299e-02 "
          "479:6.9037549e-02 497:4.4646278e-02 505:8.5114613e-02 526:6.1489001e-02 533:2.8937701e-02 551:7.6664701e-02 "
          "552:7.7179521e-02 594:6.0599763e-02 620:8.7680027e-02 622:5.8328371e-02 627:5.4910686e-02 630:1.3657291e-01 "
          "661:7.3736772e-02 670:6.4971738e-02 888:9.7650632e-02 927:5.2376840e-02 933:5.9222423e-02 951:7.2882563e-02 "
          "1002:6.2015027e-02 1003:6.3696668e-02 1007:6.1596397e-02 1134:5.5418264e-02 1135:7.8531742e-02 "
          "1218:4.2330991e-02 "
          "1294:7.5132199e-02 1305:5.5938426e-02 1399:1.3754337e-01 1408:1.1073779e-01 1449:9.3720444e-02 "
          "1477:6.8324536e-02 "
          "1509:6.6687874e-02 1576:8.6475298e-02 1602:7.6704517e-02 1604:7.1853206e-02 1656:1.2830873e-01 "
          "1707:8.6538278e-02 "
          "1734:9.4763413e-02 1746:2.1591997e-01 1802:7.0123695e-02 1929:1.4299203e-01 2201:1.4162618e-01 "
          "2293:8.0453768e-02 "
          "2298:2.0624779e-02 2314:6.9811344e-02 2326:1.1912991e-01 2820:6.9402717e-02 3160:7.5846486e-02 "
          "3209:1.0058758e-01 "
          "3283:8.3187222e-02 3668:1.5541711e-01 4485:1.0417579e-01 4548:1.6371511e-01 5313:6.4128280e-02 "
          "5501:1.4179856e-01 "
          "6994:1.2404062e-01 8454:9.9864200e-02 8528:1.4197265e-01 8672:1.6549565e-01 10426:1.3962416e-01 "
          "13766:1.2922868e-01 13857:1.3814899e-01 14200:1.3085917e-01 15433:1.5271367e-01 15821:1.4571567e-01 "
          "19110:1.6082004e-01 27565:1.3101783e-01 33048:1.5593582e-01 44421:1.4407218e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 15:6.8897694e-02 238:1.8381810e-01 286:5.3141110e-02 292:3.2828090e-01 335:2.2661415e-01 "
                  "433:7.6394275e-02 "
                  "842:6.6316329e-02 975:2.1145256e-01 999:2.7841422e-01 1000:1.0478535e-01 1001:2.3184234e-01 "
                  "1145:1.7569797e-01 "
                  "1151:2.6252651e-01 1152:2.5129834e-01 1154:2.7116492e-01 6476:2.5510469e-01 6632:3.3403799e-01 "
                  "7587:2.9298523e-01 "
                  "32373:3.2148862e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 3:3.9113011e-02 10:2.5835020e-02 13:1.8904261e-02 15:2.0031627e-02 18:2.3001676e-02 24:1.6580220e-02 "
          "35:2.8226433e-02 39:3.6790762e-02 45:1.8156197e-02 50:3.1005392e-02 57:3.3775423e-02 74:2.5395069e-02 "
          "76:3.4866951e-02 90:2.5931042e-02 101:3.1784404e-02 126:6.4052716e-02 127:6.5079093e-02 140:1.5421067e-02 "
          "144:5.8730733e-02 161:2.4346726e-02 172:4.9531542e-02 175:3.2650676e-02 179:2.1712961e-02 182:5.4735318e-02 "
          "188:1.3522144e-02 191:3.0667877e-02 236:2.1382589e-02 242:6.5972291e-02 276:3.9716605e-02 282:4.4378255e-02 "
          "293:1.9830193e-02 297:2.6425550e-02 307:4.4262405e-02 309:3.3770286e-02 312:3.2827195e-02 326:2.4286976e-02 "
          "332:4.4046722e-02 349:5.6243993e-02 360:3.7494022e-02 372:1.1250416e-01 373:7.0163973e-02 430:9.6157946e-02 "
          "475:4.9846679e-02 497:2.9501436e-02 506:2.5701709e-02 516:3.4065425e-02 526:1.9360794e-02 532:3.9402101e-02 "
          "555:2.4377888e-02 586:2.7143674e-02 607:4.8102409e-02 616:3.2064032e-02 649:4.4440672e-02 655:2.2299647e-02 "
          "657:4.5275055e-02 660:4.8567176e-02 664:3.4427833e-02 676:4.3910049e-02 686:4.0371083e-02 739:8.0843642e-02 "
          "756:8.4964566e-02 757:3.2398578e-02 758:4.7677666e-02 760:9.1632873e-02 776:6.4877629e-02 780:1.7262961e-01 "
          "838:4.1882586e-02 842:3.2645758e-02 851:5.0652314e-02 858:4.9183451e-02 866:6.6291437e-02 867:8.0422193e-02 "
          "881:7.8215696e-02 899:8.4526271e-02 908:5.5366825e-02 915:4.4060659e-02 921:5.1501364e-02 925:4.1144531e-02 "
          "927:3.4609649e-02 941:1.6575000e-01 949:8.0966882e-02 963:5.7240784e-02 967:3.9720688e-02 993:5.7096217e-02 "
          "1008:5.3520095e-02 1024:4.0668376e-02 1025:3.9557215e-02 1036:3.4916878e-02 1086:3.9637417e-02 "
          "1110:7.6619133e-02 "
          "1112:5.6757402e-02 1125:4.6384186e-02 1200:4.7565866e-02 1229:5.0340105e-02 1237:3.6745790e-02 "
          "1243:4.0261086e-02 "
          "1250:4.9347300e-02 1254:7.4839398e-02 1266:3.9923280e-02 1267:1.2752004e-01 1271:8.3953507e-02 "
          "1292:5.2315779e-02 "
          "1339:5.9525259e-02 1342:3.3827960e-02 1399:9.9384926e-02 1426:6.2341921e-02 1459:1.1661968e-01 "
          "1461:9.1992013e-02 "
          "1499:9.7379044e-02 1503:4.0339042e-02 1536:5.1655766e-02 1590:3.6496844e-02 1617:3.9385676e-02 "
          "1677:6.6793323e-02 "
          "1690:4.3819398e-02 1782:5.7922956e-02 1800:5.0415084e-02 1843:1.0313184e-01 1888:4.4018298e-02 "
          "1953:5.0417140e-02 "
          "1983:5.8521781e-02 2029:4.9589097e-02 2065:4.0409461e-02 2111:6.5711997e-02 2122:4.2635676e-02 "
          "2153:3.1707827e-02 "
          "2174:5.8076229e-02 2340:9.2127919e-02 2409:4.8926901e-02 2453:5.2570809e-02 2548:4.3031301e-02 "
          "2683:5.6802962e-02 "
          "2734:4.8131324e-02 2762:4.8254568e-02 2771:4.6252441e-02 2920:8.2107961e-02 2988:4.1860864e-02 "
          "3159:6.3750885e-02 "
          "3191:6.7364432e-02 3208:8.4723979e-02 3615:5.3038616e-02 3656:4.9047619e-02 3690:7.5531632e-02 "
          "3713:6.1499439e-02 "
          "3772:7.0378728e-02 3777:7.2201923e-02 3781:6.1764777e-02 3836:5.6885768e-02 3839:1.8151933e-01 "
          "3874:6.4932868e-02 "
          "3885:6.8553247e-02 4038:4.7134314e-02 4107:9.2806339e-02 4152:6.2580898e-02 4501:4.3149829e-02 "
          "4510:6.1156247e-02 "
          "4700:1.0261085e-01 5000:9.0667188e-02 5524:2.6807719e-01 6086:2.5183320e-01 6168:7.2880879e-02 "
          "6220:7.3228434e-02 "
          "6678:6.2071495e-02 7469:6.5752685e-02 7531:5.6062564e-02 7795:6.5188169e-02 7905:5.7114221e-02 "
          "8223:8.5858859e-02 "
          "8274:1.7250787e-01 8421:1.1950840e-01 8671:6.8661399e-02 8846:9.4324574e-02 9509:9.5243573e-02 "
          "9870:9.7906642e-02 "
          "10337:9.0442941e-02 10349:9.7585648e-02 10842:7.6265626e-02 10915:1.5343086e-01 11013:8.5878715e-02 "
          "11254:8.4544860e-02 11447:9.2261069e-02 16122:8.7538578e-02 17905:1.4790887e-01 17989:8.4315941e-02 "
          "18158:1.0853913e-01 18791:9.2193559e-02 20149:9.1666751e-02 20614:9.2431523e-02 21307:9.7018614e-02 "
          "28193:9.7906642e-02 45630:1.0978703e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:4.8030879e-02 50:4.6526819e-02 51:3.2337807e-02 95:9.5060341e-02 106:7.7975176e-02 "
          "107:7.9719946e-02 "
          "179:5.5167068e-02 218:6.1732423e-02 220:1.3911146e-01 229:1.2780477e-01 252:6.0922153e-02 262:1.7347148e-01 "
          "288:5.2957948e-02 302:7.1827680e-02 305:7.0021965e-02 319:1.1577599e-01 417:4.7368854e-02 550:7.4306272e-02 "
          "587:8.1321366e-02 588:1.0039704e-01 647:1.0184545e-01 684:8.7325804e-02 733:2.9114524e-01 968:2.0325254e-01 "
          "1028:5.8381643e-02 1059:5.2277509e-02 1084:2.4299091e-01 1115:1.6145685e-01 1122:1.0639977e-01 "
          "1133:1.0864941e-01 "
          "1183:1.1294098e-01 1186:1.0789989e-01 1335:1.7883337e-01 1449:9.2930526e-02 1530:1.1222070e-01 "
          "1619:2.9380527e-01 "
          "1648:1.4529629e-01 1768:8.9229763e-02 2201:1.4043248e-01 2229:1.2001811e-01 2298:3.4626458e-02 "
          "2349:1.1556190e-01 "
          "2602:1.0853077e-01 2769:1.2882565e-01 2780:1.3007085e-01 5685:1.6270018e-01 10446:1.8534276e-01 "
          "10521:4.4211370e-01 15177:2.1028185e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 1:2.1540928e-01 13:4.9713828e-02 110:6.5637685e-02 166:9.9716909e-02 189:6.6696972e-02 "
          "193:1.2370569e-01 "
          "222:1.0177658e-01 236:1.3418433e-01 247:9.8979823e-02 276:1.0444547e-01 277:5.7662178e-02 389:1.0327873e-01 "
          "454:7.2252184e-02 506:6.7589544e-02 526:5.0914403e-02 555:6.4108200e-02 582:1.2809728e-01 642:7.8176454e-02 "
          "655:9.9291086e-02 660:5.3522494e-02 791:1.3529165e-01 925:1.0820059e-01 932:8.5558809e-02 "
          "1024:1.0694841e-01 "
          "1059:5.4109257e-02 1072:2.0857428e-01 1127:9.0075202e-02 1177:1.4981566e-01 1544:9.0188794e-02 "
          "1580:1.1919905e-01 "
          "1751:1.1356580e-01 2065:1.0626753e-01 2168:1.3781422e-01 2360:1.0583904e-01 2438:1.1352137e-01 "
          "2509:1.3181186e-01 "
          "2611:1.4852233e-01 2612:3.6588663e-01 2968:1.4791709e-01 3434:2.6928684e-01 4886:1.8492621e-01 "
          "6741:1.9514923e-01 "
          "8536:1.7213479e-01 8896:4.6620029e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:4.3433346e-02 9:6.3180707e-02 14:6.5484896e-02 15:6.6051170e-02 17:2.2950253e-02 19:4.5185085e-02 "
          "20:1.9965956e-02 21:7.1108259e-02 24:2.0951137e-02 33:6.4875722e-02 35:6.0390413e-02 39:5.7622701e-02 "
          "45:2.2942577e-02 49:2.6498161e-02 51:5.1420957e-02 53:5.7273138e-02 55:5.1229224e-02 57:7.2262473e-02 "
          "60:3.8623143e-02 61:5.6628395e-02 64:6.3217394e-02 65:3.8581222e-02 66:5.1614501e-02 67:7.0341654e-02 "
          "69:1.6470538e-02 70:5.0104391e-02 73:2.1168087e-02 74:3.2089777e-02 76:7.4597798e-02 89:4.2167928e-02 "
          "102:5.2741278e-02 104:8.0613598e-02 117:3.6718424e-02 126:3.8567599e-02 131:4.4149272e-02 144:4.3831669e-02 "
          "147:3.1828083e-02 163:8.8234901e-02 184:4.4910930e-02 188:1.7086884e-02 209:8.5393295e-02 210:3.3257816e-02 "
          "217:5.0549563e-02 224:5.2161478e-02 229:2.6636645e-02 230:3.2554589e-02 232:6.0141463e-02 245:7.6819614e-02 "
          "259:3.3110563e-02 264:4.1175280e-02 286:5.4505147e-02 295:3.6573891e-02 296:6.4667784e-02 306:5.2059773e-02 "
          "323:4.4393107e-02 326:3.0689565e-02 327:3.3092801e-02 349:4.1975778e-02 365:2.9871402e-02 381:3.9952926e-02 "
          "388:3.5693321e-02 390:5.6468606e-02 393:4.5720480e-02 400:4.1087627e-02 417:4.9440350e-02 433:2.8066590e-02 "
          "434:4.4614341e-02 438:3.9426289e-02 451:6.1380159e-02 464:4.2302314e-02 478:4.2158201e-02 484:5.4029208e-02 "
          "501:4.6163119e-02 524:4.7378287e-02 526:2.4464732e-02 530:5.8406115e-02 533:2.4162354e-02 542:9.6208401e-02 "
          "543:9.5724724e-02 544:6.3287057e-02 545:4.0368922e-02 555:3.0804444e-02 558:5.9303790e-02 560:4.7744039e-02 "
          "573:3.1922895e-02 586:5.8073852e-02 594:5.0599489e-02 613:2.5256002e-02 617:3.6514346e-02 630:4.7787659e-02 "
          "655:2.8178334e-02 660:2.5717936e-02 678:5.2431975e-02 721:6.8397343e-02 769:4.5936756e-02 773:3.6217105e-02 "
          "778:6.9864675e-02 785:5.7762221e-02 787:7.4401699e-02 797:7.1096405e-02 811:3.1159556e-02 858:3.6706384e-02 "
          "882:1.0935473e-01 929:4.2075604e-02 931:7.7467814e-02 939:6.4922288e-02 974:1.0308994e-01 976:5.6893460e-02 "
          "979:6.3480780e-02 996:5.9371065e-02 997:7.1085803e-02 1007:5.1431660e-02 1011:4.1922554e-02 "
          "1012:3.6077049e-02 "
          "1033:6.9497220e-02 1058:8.0624543e-02 1061:8.9391269e-02 1127:2.5562910e-02 1145:3.8124215e-02 "
          "1164:5.5792924e-02 "
          "1196:1.0611072e-01 1200:6.0105294e-02 1212:4.8907798e-02 1213:2.6147150e-02 1243:5.0874807e-02 "
          "1361:5.6865260e-02 "
          "1379:6.6540711e-02 1380:7.2317511e-02 1426:3.7537497e-02 1452:8.7805934e-02 1453:1.6154887e-01 "
          "1455:2.7813155e-02 "
          "1544:7.3374830e-02 1547:7.8243300e-02 1566:5.0668675e-02 1571:8.8579886e-02 1589:5.7427447e-02 "
          "1620:6.4847700e-02 "
          "1656:1.0713501e-01 1659:6.0056109e-02 1682:4.8497457e-02 1690:5.5371169e-02 1702:1.1388632e-01 "
          "1705:7.5125836e-02 "
          "1795:7.5968057e-02 1836:7.9668462e-02 1857:6.1169196e-02 1861:6.6760518e-02 1873:8.1734747e-02 "
          "1883:6.2040519e-02 "
          "1889:4.2699199e-02 1894:5.6031015e-02 1955:6.7282304e-02 1983:7.3949426e-02 2008:1.1208239e-01 "
          "2016:5.2750390e-02 "
          "2074:8.8576473e-02 2202:6.8287708e-02 2298:1.7221244e-02 2328:6.4684331e-02 2340:6.8756513e-02 "
          "2534:5.2990980e-02 "
          "2738:6.3285790e-02 2970:7.4797310e-02 2971:6.8231434e-02 3013:5.4023713e-02 3112:7.2214134e-02 "
          "3170:7.1864262e-02 "
          "3428:1.5954979e-01 3649:6.5435968e-02 3735:8.2133926e-02 3751:6.6271521e-02 4222:6.6556416e-02 "
          "4296:1.2310619e-01 "
          "4297:2.4404040e-01 4345:1.5121578e-01 4349:1.9442989e-01 5849:1.0509431e-01 5870:1.8577178e-01 "
          "5871:1.1213116e-01 "
          "5883:9.6967973e-02 6133:8.6960316e-02 7717:1.1018915e-01 8076:8.6631328e-02 8307:9.2550561e-02 "
          "9429:9.7638398e-02 "
          "9577:1.0613042e-01 9825:1.4344598e-01 11457:1.1385100e-01 14265:1.1070248e-01 17490:9.9048555e-02 "
          "22260:1.1591379e-01 22261:1.1658315e-01 23389:1.3484213e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:4.0370431e-02 17:6.3094154e-02 24:1.6209973e-02 25:5.3944394e-02 41:5.0040986e-02 49:3.4712441e-02 "
          "51:3.5672303e-02 61:7.4182875e-02 64:1.0337587e-01 86:7.2457388e-02 103:5.3103380e-02 110:4.1316397e-02 "
          "123:7.4515976e-02 128:6.1736755e-02 133:5.7572678e-02 140:4.3221101e-02 155:1.0031549e-01 161:4.0302064e-02 "
          "218:4.0219732e-02 221:5.2914120e-02 223:9.7193748e-02 233:7.7189468e-02 239:7.5568043e-02 263:6.3898943e-02 "
          "269:3.6545660e-02 284:3.4650151e-02 295:4.7911592e-02 297:4.3743219e-02 312:5.4340106e-02 337:8.2862526e-02 "
          "374:4.9921732e-02 380:5.3555660e-02 381:1.3657305e-01 407:1.1040561e-01 454:7.7004284e-02 456:1.3299488e-01 "
          "461:2.6594329e-01 476:6.0306013e-02 479:7.5514436e-02 506:4.2545017e-02 533:3.1652547e-02 546:4.8561614e-02 "
          "553:4.7635555e-02 576:6.4255945e-02 579:8.5617766e-02 580:6.8809569e-02 588:1.3727106e-01 607:7.9625748e-02 "
          "628:9.8136246e-02 647:6.6354059e-02 660:3.3690352e-02 667:8.8749148e-02 702:4.3472573e-02 724:4.2132773e-02 "
          "773:4.7444202e-02 847:1.1059231e-01 857:7.3097520e-02 868:9.0156525e-02 946:7.5580835e-02 951:7.9720177e-02 "
          "1012:4.7260731e-02 1059:3.4059696e-02 1130:6.9096096e-02 1145:4.9942505e-02 1193:4.3635022e-02 "
          "1218:4.6302352e-02 "
          "1269:8.8230364e-02 1296:7.7649355e-02 1338:7.6027311e-02 1339:9.8534428e-02 1342:5.5996709e-02 "
          "1388:8.3933875e-02 "
          "1395:8.7297939e-02 1416:6.7839295e-02 1452:5.4810163e-02 1557:5.3357944e-02 1574:9.0679839e-02 "
          "1575:6.1625231e-02 "
          "1578:1.6224891e-01 1629:7.6124489e-02 1642:9.5291048e-02 1663:8.8189177e-02 1863:9.7849682e-02 "
          "1919:7.6044902e-02 "
          "1921:6.7420729e-02 2018:6.6585138e-02 2090:6.1951898e-02 2109:9.4828770e-02 2280:9.6873336e-02 "
          "2327:9.3656681e-02 "
          "2412:1.0501695e-01 2738:8.2904026e-02 2753:1.0808478e-01 3160:8.2962170e-02 4110:1.2134411e-01 "
          "6871:9.0023085e-02 "
          "7977:3.0232638e-01 7986:1.0592239e-01 8335:1.0904638e-01 9796:2.0564905e-01 22668:1.4317057e-01 "
          "35451:4.5523193e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:1.4433180e-02 9:2.3873443e-02 15:3.3985294e-02 24:1.6613854e-02 39:3.6865395e-02 45:1.8193027e-02 "
          "49:4.4097170e-02 50:1.8349431e-02 51:2.1593573e-02 69:2.2113899e-02 70:1.6650014e-02 74:2.5446583e-02 "
          "79:4.4746410e-02 84:3.0664705e-02 92:4.0005989e-02 98:3.0875999e-02 101:3.1848878e-02 121:3.1121008e-02 "
          "140:4.9404629e-02 141:3.5673041e-02 142:4.3881524e-02 151:1.2220389e-01 153:5.0205532e-02 158:4.4715963e-02 "
          "174:5.3171936e-02 179:3.6837816e-02 180:3.3280343e-02 181:3.7091263e-02 184:3.5613514e-02 188:3.9915830e-02 "
          "208:3.3660725e-02 217:2.3674753e-02 220:3.2403167e-02 231:2.6673846e-02 233:1.9580662e-02 236:2.1425964e-02 "
          "239:2.7016982e-02 242:6.6106118e-02 253:3.6382679e-02 257:2.4044923e-02 260:4.5346074e-02 264:5.5283312e-02 "
          "267:3.7111524e-02 269:3.7456214e-02 274:3.2393809e-02 277:3.7200462e-02 280:3.2486122e-02 291:3.7647940e-02 "
          "293:4.7416668e-02 295:2.9002402e-02 296:6.3560642e-02 297:5.5569477e-02 298:6.3375674e-02 302:2.8327685e-02 "
          "312:3.2893784e-02 315:2.9341251e-02 318:1.0586147e-01 320:2.8113933e-02 337:2.9624894e-02 357:8.0129363e-02 "
          "358:9.2569813e-02 360:3.7570082e-02 365:2.3687456e-02 381:5.3642139e-02 393:3.6255471e-02 417:1.8681517e-02 "
          "428:3.8955916e-02 438:3.1264301e-02 454:2.7530463e-02 462:4.3364707e-02 494:5.3945895e-02 506:2.5753845e-02 "
          "510:3.1198431e-02 514:3.2062739e-02 530:4.6314940e-02 533:4.0210016e-02 564:4.0439140e-02 575:3.0544970e-02 "
          "613:2.0027531e-02 623:3.3060994e-02 628:3.5085533e-02 630:3.7894703e-02 661:4.8822735e-02 673:3.3525813e-02 "
          "679:3.3490259e-02 752:5.0536979e-02 764:3.3964530e-02 767:3.3107162e-02 789:4.0340982e-02 791:5.1550578e-02 "
          "805:4.9771879e-02 811:2.4708936e-02 842:1.9320222e-02 857:4.4248242e-02 858:2.9107464e-02 882:4.1320741e-02 "
          "960:5.4096490e-02 964:5.1726248e-02 967:3.9801262e-02 988:7.0419841e-02 992:3.4655038e-02 "
          "1025:3.9637458e-02 "
          "1059:3.4908310e-02 1077:4.4306565e-02 1102:6.0227308e-02 1118:4.5821786e-02 1132:5.0934453e-02 "
          "1162:3.5612918e-02 "
          "1168:3.5120994e-02 1172:5.1468723e-02 1173:6.3414797e-02 1188:2.6096700e-02 1211:4.4374455e-02 "
          "1213:2.0734193e-02 "
          "1223:5.6204442e-02 1241:5.7928935e-02 1243:4.0342756e-02 1287:5.0813120e-02 1342:3.3896580e-02 "
          "1365:5.6039795e-02 "
          "1383:6.1445087e-02 1455:2.2055304e-02 1492:3.9925389e-02 1500:4.5760497e-02 1511:3.3954132e-02 "
          "1541:1.4287210e-01 "
          "1542:1.5492770e-01 1543:6.2888704e-02 1575:3.7303701e-02 1586:5.8713820e-02 1649:6.5071523e-02 "
          "1664:3.1124497e-02 "
          "1685:1.8239805e-01 1693:1.3196081e-01 1700:5.1148955e-02 1727:8.9179538e-02 1777:4.8818253e-02 "
          "1863:5.9231509e-02 "
          "1906:3.6474645e-02 2061:4.8219576e-02 2166:4.7736652e-02 2168:5.2511767e-02 2288:4.3879740e-02 "
          "2314:4.6223626e-02 "
          "2360:4.0328164e-02 2371:6.6781364e-02 2589:5.7774913e-02 2752:4.7567509e-02 2846:1.2530270e-01 "
          "2942:4.6378400e-02 "
          "3092:1.0433442e-01 3117:5.1830597e-02 3170:5.6986999e-02 3209:6.6601247e-02 3291:4.5481049e-02 "
          "3298:4.9833160e-02 "
          "3309:6.0565766e-02 3368:4.0288460e-02 3584:7.5078711e-02 3681:5.9053652e-02 3685:1.5815444e-01 "
          "4102:1.0979836e-01 "
          "4435:8.4645316e-02 4436:2.8834450e-01 4437:2.2934137e-01 4442:2.2093427e-01 4502:6.1412584e-02 "
          "5189:7.4999139e-02 "
          "5999:5.3395502e-02 6524:8.4557086e-02 6869:8.8017218e-02 7574:9.0510391e-02 7765:8.9513831e-02 "
          "7908:7.3671557e-02 "
          "8822:7.8501083e-02 11866:8.5855432e-02 13687:7.8823879e-02 13733:8.7807983e-02 15454:2.5570565e-01 "
          "15600:2.7948990e-01 15605:2.1320854e-01 16206:8.6941220e-02 17258:9.1254577e-02 17774:1.0004707e-01 "
          "22313:1.0811705e-01 27272:9.0951346e-02 29040:9.9794269e-02 30335:1.0411274e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:2.9855097e-02 49:9.8531164e-02 51:5.4689240e-02 52:4.8526730e-02 69:2.3470301e-02 73:3.0164247e-02 "
          "90:4.6692610e-02 91:6.0746424e-02 106:5.5261634e-02 140:6.6262320e-02 175:5.8792286e-02 181:6.6653006e-02 "
          "207:6.5447234e-02 218:9.1814838e-02 223:4.4305313e-02 238:7.7640891e-02 262:7.2610714e-02 264:5.8674239e-02 "
          "279:9.1900989e-02 284:1.1606963e-01 286:2.7820850e-02 300:1.5762909e-01 320:5.0520740e-02 342:5.9034593e-02 "
          "355:1.9866221e-01 359:1.0305386e-01 370:6.0660809e-02 469:6.5684795e-02 471:6.2739469e-02 502:1.1741900e-01 "
          "510:9.4923899e-02 532:7.0949212e-02 545:5.7525188e-02 588:1.2047112e-01 606:6.1793886e-02 613:6.0935479e-02 "
          "617:5.2032467e-02 702:4.7288641e-02 858:8.8561952e-02 867:1.4481185e-01 925:7.4086703e-02 "
          "1171:7.2593145e-02 "
          "1322:8.0112219e-02 1380:1.0305151e-01 1382:1.2226727e-01 1470:8.1420675e-02 1497:7.4933246e-02 "
          "1991:1.2339798e-01 "
          "2006:1.4055741e-01 2122:1.2998584e-01 2123:1.4243343e-01 2153:5.7094548e-02 2206:9.7114138e-02 "
          "2288:7.8851894e-02 "
          "2311:7.7109709e-02 2442:1.3644716e-01 3841:6.3053325e-02 4040:1.3132958e-01 4047:1.5004534e-01 "
          "4274:9.7873800e-02 "
          "5093:9.8693274e-02 7518:1.9876659e-01 11481:1.2299794e-01 17562:6.6415489e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:3.6075033e-02 13:4.7346130e-02 14:9.2091449e-02 17:4.5487799e-02 26:6.4439133e-02 51:3.1876784e-02 "
          "69:5.5272613e-02 70:8.7335631e-02 107:7.8583419e-02 140:6.5393396e-02 188:3.3866502e-02 215:8.3495557e-02 "
          "234:6.4709008e-02 238:6.3781157e-02 239:6.7527629e-02 252:1.0167962e-01 271:4.8622984e-02 274:8.0966748e-02 "
          "302:7.0803672e-02 305:1.6471086e-01 321:8.7926716e-02 342:1.3902660e-01 348:6.8734318e-02 357:9.5434226e-02 "
          "433:5.5628475e-02 437:1.7718621e-01 545:8.0011912e-02 620:5.5607885e-02 647:1.0039350e-01 676:1.0997367e-01 "
          "702:6.5773875e-02 726:7.8185163e-02 988:2.4806704e-01 1005:1.5898091e-01 1188:6.5227434e-02 "
          "1345:1.2032285e-01 "
          "1727:9.3408391e-02 2065:1.7135727e-01 2153:7.9412930e-02 2226:1.3814923e-01 2311:1.0725207e-01 "
          "2506:9.3326479e-02 "
          "2933:1.2911084e-01 2951:1.3538587e-01 3309:1.5138119e-01 3513:1.3563515e-01 3871:4.0379614e-01 "
          "4032:1.5151256e-01 "
          "13209:4.3520710e-01 43979:3.5891464e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.3190622e-02 14:1.6830041e-01 21:7.9635896e-02 33:9.0341188e-02 35:1.7648339e-01 39:8.0241166e-02 "
          "46:1.7567180e-01 51:4.7000539e-02 65:1.9090025e-01 70:6.1360322e-02 103:1.1846460e-01 131:1.2902069e-01 "
          "136:1.1169296e-01 239:9.9565729e-02 295:1.0688259e-01 327:9.6709542e-02 334:1.1918712e-01 338:9.5309153e-02 "
          "478:1.2320204e-01 529:1.5175194e-01 555:1.5242068e-01 557:1.7565317e-01 613:7.3807493e-02 "
          "1033:2.0309688e-01 "
          "1122:9.1335230e-02 1127:7.4704394e-02 1682:1.4172772e-01 2212:1.4836167e-01 2342:3.3919862e-01 "
          "2493:1.1836833e-01 "
          "2795:1.9127959e-01 2870:3.4517047e-01 2875:2.2792691e-01 2950:1.7521738e-01 3368:1.4847514e-01 "
          "27118:4.0229422e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:6.5799162e-02 13:5.6683566e-02 14:3.1028805e-02 15:7.4684158e-02 17:5.4458745e-02 20:3.8223702e-02 "
          "26:3.6761239e-02 27:7.8135923e-02 32:4.0622763e-02 51:3.0789999e-02 53:3.8247604e-02 61:3.7817039e-02 "
          "64:5.3732708e-02 66:1.2247626e-01 73:2.3934787e-02 74:6.1434079e-02 75:7.7359378e-02 84:4.3724410e-02 "
          "103:4.5835365e-02 112:4.6656299e-02 117:4.1517578e-02 128:9.0222947e-02 183:3.6845867e-02 207:5.1931202e-02 "
          "215:4.7632549e-02 218:3.4715045e-02 257:3.4285348e-02 259:3.7438162e-02 263:5.5153392e-02 286:4.6327583e-02 "
          "319:3.8452823e-02 336:4.1439489e-02 349:8.0360271e-02 363:4.9158800e-02 364:3.5835251e-02 450:3.0252454e-01 "
          "454:3.9255336e-02 464:4.7831289e-02 467:1.0799185e-01 474:6.0887016e-02 484:6.1090901e-02 504:5.7477597e-02 "
          "510:4.4485442e-02 514:7.7407040e-02 526:7.7226505e-02 548:1.0116106e-01 550:8.7692432e-02 573:7.5749971e-02 "
          "574:6.2272850e-02 587:4.5730829e-02 609:7.5807996e-02 626:6.0710583e-02 637:6.1567511e-02 658:8.3180182e-02 "
          "668:6.4633526e-02 682:7.2267704e-02 702:3.7522685e-02 724:3.6366254e-02 802:2.5556669e-02 929:4.7574945e-02 "
          "987:7.4172691e-02 1011:4.7401894e-02 1024:5.8106147e-02 1071:6.7347720e-02 1145:4.3107104e-02 "
          "1170:5.7194963e-02 "
          "1212:5.5300120e-02 1305:5.2812096e-02 1313:7.5227022e-02 1361:6.4297631e-02 1388:7.2446227e-02 "
          "1389:5.9778981e-02 "
          "1417:5.7684563e-02 1426:4.2443700e-02 1604:1.1485873e-01 1629:3.8806830e-02 1670:4.7481358e-02 "
          "1690:6.2608257e-02 "
          "1726:5.1871240e-02 1751:1.0446962e-01 1776:5.1960345e-02 1831:7.3402941e-02 1940:7.4347056e-02 "
          "1994:6.3169144e-02 "
          "2185:1.1650452e-01 2229:6.7491829e-02 2299:1.1669061e-01 2329:1.4414385e-01 2371:5.6240059e-02 "
          "2579:9.7067617e-02 "
          "2958:7.5241223e-02 4555:1.0461741e-01 6639:2.2223961e-01 7302:8.3716378e-02 7633:9.9332951e-02 "
          "7638:2.1978004e-01 "
          "12401:1.0589836e-01 15892:2.9378745e-01 21144:1.4541690e-01 30300:1.3861822e-01 33939:1.6032039e-01 "
          "42872:3.7333316e-01 45916:3.1208566e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:3.5089456e-02 54:7.5520828e-02 69:8.1263646e-02 106:6.4950407e-02 107:6.6403732e-02 "
          "133:1.5447146e-01 "
          "138:6.5458655e-02 140:6.8490915e-02 142:1.5692157e-01 158:9.4442792e-02 170:6.4238295e-02 180:1.4751162e-01 "
          "188:6.0057063e-02 215:7.0554532e-02 223:5.2073162e-02 229:4.4611678e-02 238:5.3895678e-02 264:6.8961322e-02 "
          "282:9.3919672e-02 463:1.1430781e-01 481:1.0944921e-01 489:7.7200331e-02 514:1.9949239e-01 611:1.7199175e-01 "
          "673:7.0808530e-02 724:5.3866610e-02 773:1.2729606e-01 802:3.7855178e-02 858:1.0408911e-01 994:8.3961926e-02 "
          "1059:4.3545209e-02 1195:7.8229450e-02 1340:1.5217997e-01 1342:7.1591608e-02 1546:1.4429185e-01 "
          "1554:7.5328395e-02 "
          "1629:9.7324908e-02 2028:8.2153492e-02 2039:1.8313284e-01 2041:1.6186093e-01 2126:8.7945729e-02 "
          "2153:6.7104675e-02 "
          "2362:5.7680648e-02 2824:1.1059585e-01 3271:8.3947688e-02 3406:1.6444556e-01 3983:1.3104372e-01 "
          "7840:1.7006201e-01 "
          "10705:5.3751069e-01 14261:1.4671898e-01 15518:1.9758029e-01 20419:1.9870403e-01 20421:1.9241290e-01 "
          "37218:1.9813593e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 17:4.0016685e-02 20:3.4813181e-02 24:3.5575401e-02 26:3.3481207e-02 49:8.7246455e-02 51:1.6562501e-02 "
          "53:3.4834947e-02 54:3.7464429e-02 55:7.0181467e-02 61:5.8316730e-02 69:6.5017417e-02 91:4.3900426e-02 "
          "106:3.9936658e-02 107:8.5686922e-02 111:7.5468011e-02 123:1.2293375e-01 125:8.3793126e-02 130:1.4886267e-01 "
          "133:7.6630317e-02 182:3.3939980e-02 187:4.9442291e-02 188:1.7596316e-02 189:5.5880405e-02 193:3.6153778e-02 "
          "210:3.4249373e-02 213:4.2355426e-02 217:3.0745501e-02 218:3.1617582e-02 224:3.1725906e-02 231:3.4640308e-02 "
          "233:5.3364903e-02 236:9.6967816e-02 252:6.5482132e-02 257:5.2870598e-02 258:4.1762248e-02 271:5.3018235e-02 "
          "280:8.8537298e-02 288:2.7123550e-02 297:5.8223050e-02 323:4.5716655e-02 343:9.7422421e-02 351:1.1312412e-01 "
          "374:3.9244533e-02 388:6.2235843e-02 456:2.0393121e-01 481:6.7298055e-02 484:5.5640049e-02 503:2.2208700e-01 "
          "510:6.8599917e-02 514:1.2266374e-01 555:3.1722855e-02 561:5.2243501e-02 565:1.0196677e-01 573:3.2874655e-02 "
          "578:5.0433200e-02 616:4.1724805e-02 622:5.0154969e-02 627:4.7216196e-02 655:2.9018451e-02 686:5.2534740e-02 "
          "751:5.4791111e-02 764:4.4108443e-02 773:6.3149132e-02 799:6.1774112e-02 802:3.9410315e-02 890:6.8185538e-02 "
          "910:5.3531952e-02 929:4.3330055e-02 994:5.1626451e-02 1011:4.3172445e-02 1038:5.0114702e-02 "
          "1091:6.2224124e-02 "
          "1185:7.5807326e-02 1239:5.4516789e-02 1350:5.7293434e-02 1373:5.0133582e-02 1383:4.7129039e-02 "
          "1409:7.1785383e-02 "
          "1426:3.8656648e-02 1430:7.3360927e-02 1452:9.0423808e-02 1546:4.2276543e-02 1566:5.2179325e-02 "
          "1694:6.0386408e-02 "
          "1765:3.9867800e-02 1815:9.7637236e-02 1998:5.6391653e-02 2121:8.0103561e-02 2153:4.1261278e-02 "
          "2166:1.0496458e-01 "
          "2168:6.8195030e-02 2298:1.7734684e-02 2696:7.0195362e-02 3215:8.2066827e-02 3361:1.5534545e-01 "
          "3405:2.3005688e-01 "
          "3655:6.5610319e-02 4501:5.6150712e-02 4533:2.4875940e-01 5401:6.6514477e-02 5906:2.1911272e-01 "
          "6057:7.5991526e-02 "
          "6510:7.5905643e-02 6728:1.8321040e-01 6986:9.7460449e-02 7488:1.7487565e-01 7772:7.7664927e-02 "
          "7773:8.8418305e-02 "
          "8361:1.6115098e-01 8563:8.6828746e-02 9842:2.7002820e-01 10453:9.6693739e-02 11800:1.0374169e-01 "
          "30094:1.2790745e-01 35228:2.9172844e-01 44858:1.4881226e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 50:6.9888204e-02 92:8.9993581e-02 125:1.4514393e-01 188:5.1606797e-02 191:6.9127418e-02 "
          "236:4.8197765e-02 "
          "293:4.4698562e-02 326:5.4744449e-02 489:8.2224168e-02 525:1.1157842e-01 660:7.7674806e-02 724:5.7371993e-02 "
          "802:8.4613144e-02 803:8.0777928e-02 883:2.6008549e-01 1014:7.1029179e-02 1123:1.0443715e-01 "
          "1168:1.3376671e-01 "
          "1235:8.5019551e-02 1383:8.1635498e-02 1527:1.1993683e-01 1529:1.1668130e-01 1535:2.6009384e-01 "
          "1554:8.0230415e-02 "
          "1731:7.8801960e-02 1935:9.1569521e-02 2025:1.1800771e-01 2065:9.1085598e-02 2084:1.1666571e-01 "
          "2095:1.1914517e-01 "
          "2097:8.7586269e-02 2475:1.2714623e-01 2791:2.1038178e-01 2878:2.0787698e-01 3006:2.3530935e-01 "
          "3008:8.7239750e-02 "
          "3097:1.7326678e-01 3272:7.7400304e-02 3288:1.9523901e-01 3843:1.1466125e-01 3908:1.5471414e-01 "
          "3975:1.6243498e-01 "
          "5898:1.2959337e-01 8285:1.4959899e-01 11195:1.8754016e-01 24022:4.1366318e-01 47009:2.6367494e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 50:5.4083228e-02 64:8.9609914e-02 179:6.4126730e-02 208:9.9211827e-02 224:7.2004214e-02 "
          "252:1.1990277e-01 "
          "327:7.7345714e-02 348:8.1052966e-02 463:1.5951797e-01 488:1.1025826e-01 514:9.4501913e-02 546:8.6641595e-02 "
          "2878:1.6086632e-01 3006:2.4874543e-01 7692:1.9583936e-01 7693:4.9766293e-01 10850:6.3693678e-01 "
          "35085:3.3086887e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 9:5.2140780e-02 14:1.1341393e-01 19:7.8256488e-02 20:8.2516231e-02 22:9.1854610e-02 51:9.1991201e-02 "
          "52:5.8978725e-02 74:5.5576596e-02 91:1.2500569e-01 133:7.6115355e-02 167:7.4895978e-02 207:7.9543680e-02 "
          "218:1.1159050e-01 223:5.3848073e-02 232:1.2910312e-01 249:1.1140705e-01 255:8.4743798e-02 257:5.2515302e-02 "
          "271:1.0138727e-01 279:1.1169521e-01 284:1.0931631e-01 293:4.3397978e-02 327:5.7313740e-02 345:8.8341549e-02 "
          "346:8.2354210e-02 374:6.6000238e-02 386:7.7448197e-02 426:8.5610323e-02 451:6.2785387e-02 454:6.0127895e-02 "
          "481:6.6845804e-02 496:8.3438382e-02 501:7.9950355e-02 535:1.6110170e-01 545:6.9915332e-02 575:6.6711724e-02 "
          "588:1.8148252e-01 613:1.0437918e-01 617:1.3271530e-01 637:9.4303735e-02 642:6.5058045e-02 644:1.3747755e-01 "
          "645:9.2419013e-02 746:1.3111766e-01 763:3.8713980e-01 784:2.1171567e-01 785:1.0003895e-01 786:1.7644104e-01 "
          "787:2.1817391e-01 954:8.3565630e-02 1024:8.9001916e-02 1029:6.8107352e-02 1077:9.6767724e-02 "
          "1127:4.4272654e-02 "
          "1137:1.0051219e-01 1145:6.6027693e-02 1380:2.3650870e-01 1574:2.0298375e-01 1629:5.9440915e-02 "
          "1807:1.6754232e-01 "
          "1883:1.0744858e-01 2009:7.9745173e-02 2376:1.1239560e-01 2600:1.1506906e-01 2602:9.3483426e-02 "
          "2867:1.4740716e-01 "
          "3046:1.4196885e-01 7919:1.8004318e-01 13750:1.5473911e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:8.3966315e-02 14:2.1434714e-01 39:2.1446773e-01 69:1.5945785e-01 70:1.6400321e-01 90:3.6071742e-01 "
          "169:1.5247037e-01 224:1.4212190e-01 257:1.3988350e-01 286:9.0066932e-02 327:3.2038453e-01 359:1.9704460e-01 "
          "453:1.6441387e-01 533:1.1146669e-01 587:1.8658082e-01 616:1.8691376e-01 811:1.4374645e-01 820:1.8582241e-01 "
          "965:3.8818252e-01 1122:1.4418110e-01 1654:2.3115538e-01 7302:3.4156105e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 24:1.5862413e-02 25:5.2787762e-02 33:9.4564989e-02 45:2.9410239e-02 54:2.7543671e-02 62:6.6614717e-02 "
          "98:4.9913105e-02 112:1.2622423e-01 288:7.0855930e-02 295:7.9382040e-02 298:4.8818450e-02 363:5.5732649e-02 "
          "364:4.0627386e-02 380:5.2407365e-02 395:8.9450009e-02 411:6.6678613e-02 428:6.2974833e-02 533:3.0973880e-02 "
          "593:6.5926872e-02 623:5.3445298e-02 660:3.2967992e-02 678:3.9697018e-02 756:8.1286199e-02 836:9.9832453e-02 "
          "882:1.1309838e-01 953:6.5236062e-02 963:5.4762658e-02 986:1.2391098e-01 1011:5.3740799e-02 "
          "1121:8.6213730e-02 "
          "1132:4.8630700e-02 1156:7.4127086e-02 1188:4.2187050e-02 1209:9.7245663e-02 1213:3.3518203e-02 "
          "1218:9.5087245e-02 "
          "1430:9.1319233e-02 1468:7.0984513e-02 1554:5.7656206e-02 1584:7.5752951e-02 1641:1.0344518e-01 "
          "1655:1.1691648e-01 "
          "1670:9.1143616e-02 1778:7.0077114e-02 1825:7.7875875e-02 1827:1.4873329e-01 1888:7.1302854e-02 "
          "1940:8.4289253e-02 "
          "1985:8.6047791e-02 2144:1.7051274e-01 2146:1.3900460e-01 2182:7.1950577e-02 2317:1.0994042e-01 "
          "2378:8.1389576e-02 "
          "2380:8.8894755e-02 2438:6.9925211e-02 2582:1.7218889e-01 2682:9.8994277e-02 2848:1.6929021e-01 "
          "2984:8.2960263e-02 "
          "3114:9.6880428e-02 3272:9.4176903e-02 3384:8.6929262e-02 3776:1.3618723e-01 4075:8.4502488e-02 "
          "4254:1.5954304e-01 "
          "4413:1.2173450e-01 4788:1.6521727e-01 4805:1.5046164e-01 4832:1.7714061e-01 4957:9.4435260e-02 "
          "5012:1.5989286e-01 "
          "5088:1.0631809e-01 5404:1.3624269e-01 5416:1.1252620e-01 5714:1.4843389e-01 5722:1.0971965e-01 "
          "6250:1.2510063e-01 "
          "6486:1.2474418e-01 6643:1.1480732e-01 6938:1.2428887e-01 8955:1.5551388e-01 9224:1.2911779e-01 "
          "12109:1.2459122e-01 24172:1.8175951e-01 24248:1.6225596e-01 27524:1.7760278e-01 32880:1.7668918e-01 "
          "38731:1.8205141e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 10:7.3688202e-02 16:4.2647079e-02 17:2.4684658e-02 21:2.9309791e-02 22:5.7044707e-02 23:4.0506385e-02 "
          "24:2.2534465e-02 60:4.1541986e-02 64:7.1749315e-02 69:1.7715257e-02 73:2.2767810e-02 85:4.0074170e-02 "
          "101:4.3198735e-02 102:3.3503916e-02 112:1.2390248e-01 121:7.1470246e-02 125:4.1702006e-02 126:4.1482247e-02 "
          "161:5.6026340e-02 169:3.5548333e-02 184:8.1787407e-02 231:6.1257210e-02 257:3.2613717e-02 272:7.7966459e-02 "
          "278:7.3625579e-02 288:2.8328741e-02 293:2.6951559e-02 302:3.8422707e-02 312:4.4616010e-02 395:7.5052246e-02 "
          "474:5.7918381e-02 526:2.6313590e-02 531:8.7962382e-02 546:3.9871570e-02 559:5.6468099e-02 581:5.9550051e-02 "
          "594:5.4423414e-02 630:5.1399086e-02 638:9.7500011e-02 690:4.8008591e-02 803:4.8706066e-02 845:6.3420013e-02 "
          "871:5.3553198e-02 879:5.8559619e-02 930:9.5274083e-02 986:6.1404239e-02 995:4.1783422e-02 "
          "1026:6.1439559e-02 "
          "1032:5.8915954e-02 1127:2.7494762e-02 1134:4.9770016e-02 1186:1.2112933e-01 1189:4.6351232e-02 "
          "1209:8.1593119e-02 "
          "1213:4.7616638e-02 1218:3.8016602e-02 1315:6.7712806e-02 1321:5.1442698e-02 1399:5.1764321e-02 "
          "1425:1.7059653e-01 "
          "1554:4.8375934e-02 1591:6.9007516e-02 1608:8.9887559e-02 1613:8.7341413e-02 1647:5.3093873e-02 "
          "1670:7.6473251e-02 "
          "1778:5.8797590e-02 1833:1.4969465e-01 1917:9.0091631e-02 1958:6.8622552e-02 1994:6.0089242e-02 "
          "2144:6.8172291e-02 "
          "2320:9.6806072e-02 2409:6.6497400e-02 2584:9.2262588e-02 2891:7.0147336e-02 2958:7.1572721e-02 "
          "3137:5.3600747e-02 "
          "3339:8.1851393e-02 3403:1.0719457e-01 3404:2.0503433e-01 3484:1.1552336e-01 3741:7.8066811e-02 "
          "3782:1.8040204e-01 "
          "3997:2.4315840e-01 4015:1.0579927e-01 4092:8.2039781e-02 4337:6.5098673e-02 4486:1.2127002e-01 "
          "4697:8.3556734e-02 "
          "4735:9.0028562e-02 4746:8.6249232e-02 4836:1.5866172e-01 5236:1.1663843e-01 5249:8.6412244e-02 "
          "7796:1.1097532e-01 "
          "11678:1.1396743e-01 13627:1.0032533e-01 15538:2.1301998e-01 15646:1.2230206e-01 16123:1.0503034e-01 "
          "23349:2.4871998e-01 23775:2.8443152e-01 23780:2.1064730e-01 23873:2.2710598e-01 24128:1.2336331e-01 "
          "24165:1.3724400e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 17:5.7871699e-02 19:1.4122494e-01 32:9.0594172e-02 39:6.9237307e-02 158:1.4219311e-01 "
          "188:4.3086540e-02 "
          "239:8.5911795e-02 305:8.7815166e-02 433:7.0773132e-02 724:8.1101589e-02 772:3.5598662e-01 899:1.5907176e-01 "
          "1021:2.3394598e-01 1240:1.0547417e-01 1726:1.1567979e-01 2381:2.5090879e-01 3659:1.4393735e-01 "
          "5317:2.0469376e-01 "
          "5806:1.8561636e-01 6258:4.2265531e-01 8000:5.1769900e-01 13157:2.7750269e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 1:5.0917495e-02 2:8.4022067e-02 9:3.1080451e-02 16:4.0934045e-02 20:4.3257099e-02 23:3.8879339e-02 "
          "24:1.2774618e-02 41:3.9435875e-02 45:2.3685209e-02 51:3.4844503e-02 54:4.6551399e-02 69:4.7470175e-02 "
          "70:2.1676384e-02 79:3.4406126e-02 82:7.6267675e-02 84:3.9921887e-02 110:3.2560278e-02 125:4.0026933e-02 "
          "137:7.9769954e-02 140:3.4061320e-02 145:7.8704417e-02 157:6.5310791e-02 188:1.7639972e-02 192:4.9946651e-02 "
          "204:7.1613833e-02 218:3.1696025e-02 220:7.1425684e-02 223:3.2098148e-02 239:3.5172973e-02 240:2.9333809e-02 "
          "257:3.1303700e-02 259:3.4182329e-02 271:2.5326151e-02 277:2.8603941e-02 280:8.8756956e-02 297:3.4472786e-02 "
          "302:3.6879357e-02 306:9.0998031e-02 320:3.6601078e-02 339:3.1298511e-02 344:4.9387679e-02 357:1.0431913e-01 "
          "358:1.3703561e-01 362:7.0933409e-02 368:5.4039780e-02 369:6.0325116e-02 406:5.9818208e-02 443:4.4809643e-02 "
          "451:3.7425563e-02 464:2.5793156e-02 465:1.5065396e-01 466:6.1472557e-02 496:4.9736552e-02 514:4.1741963e-02 "
          "541:1.5372695e-01 545:4.1675635e-02 594:5.2237354e-02 642:3.8780268e-02 652:6.1446030e-02 689:1.8751045e-01 "
          "702:5.8006369e-02 725:7.5285248e-02 759:5.9781507e-02 845:1.2774794e-01 850:6.8178080e-02 872:1.1932062e-01 "
          "894:5.3300958e-02 897:4.0127221e-02 971:5.6127418e-02 1028:2.9975595e-02 1059:5.6329854e-02 "
          "1089:6.6327311e-02 "
          "1094:4.4119652e-02 1186:9.3800947e-02 1188:3.3974871e-02 1193:3.4387518e-02 1224:8.1934161e-02 "
          "1230:8.0234326e-02 "
          "1282:5.2434854e-02 1305:4.8219256e-02 1322:5.8039401e-02 1342:9.2610531e-02 1394:5.5998109e-02 "
          "1417:8.9174643e-02 "
          "1443:8.6344033e-02 1449:8.0787584e-02 1530:1.5035278e-01 1573:5.4601301e-02 1619:7.1881793e-02 "
          "1664:4.0520482e-02 "
          "1674:3.6287855e-02 1809:1.2134221e-01 1881:1.2624453e-01 1889:4.4081338e-02 1953:1.1135899e-01 "
          "2028:5.0639808e-02 "
          "2029:6.4690210e-02 2125:7.3476762e-02 2157:2.0394801e-01 2196:7.1855977e-02 2292:1.2824583e-01 "
          "2298:1.7778683e-02 "
          "2323:6.7350492e-02 2349:5.9334345e-02 2446:6.1256565e-02 2526:6.0402159e-02 2538:1.5159594e-01 "
          "2539:1.3699244e-01 "
          "2736:7.4476399e-02 2769:6.6144511e-02 2809:9.5819652e-02 2865:1.1017533e-01 3395:9.2743024e-02 "
          "3506:7.0519976e-02 "
          "3507:6.0226746e-02 3678:8.0832243e-02 3997:8.3600082e-02 4240:8.5631669e-02 4453:1.0718775e-01 "
          "4585:8.6432479e-02 "
          "4721:1.2115701e-01 5121:1.5313636e-01 5313:5.5278957e-02 5332:1.0605104e-01 5844:1.1127193e-01 "
          "5893:1.0305139e-01 "
          "5901:8.3901562e-02 5939:1.3286862e-01 6578:9.0147890e-02 6825:8.2717091e-02 6890:1.0765095e-01 "
          "10630:1.2103367e-01 10771:1.0254871e-01 11546:1.5691282e-01 12152:9.0077728e-02 13515:9.8785929e-02 "
          "14268:1.2005077e-01 14290:1.0013095e-01 19516:1.3625880e-01 22395:1.3700928e-01 29206:1.3820721e-01 "
          "31988:1.4759038e-01 37763:1.5893826e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 19:5.3078134e-02 24:4.1669935e-02 56:1.8969722e-01 64:7.6255038e-02 78:2.7596816e-01 87:1.9203125e-01 "
          "199:1.1384408e-01 210:1.1199631e-01 255:1.6477551e-01 286:6.5746017e-02 293:8.4382847e-02 337:7.4303500e-02 "
          "439:1.9543362e-01 468:1.0294345e-01 494:2.0852740e-01 549:1.8020125e-01 555:1.0373452e-01 613:1.1986816e-01 "
          "992:1.4716806e-01 1603:1.0189159e-01 1668:2.0253362e-01 2367:1.0877778e-01 2520:1.1960126e-01 "
          "2600:3.1533527e-01 "
          "3370:1.1072703e-01 4202:4.6694767e-01 4203:1.4404821e-01 13706:4.1404381e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 18:5.6056540e-02 50:4.4628195e-02 53:6.5238774e-02 67:8.0124870e-02 69:3.1765617e-02 70:4.0494990e-02 "
          "82:8.4151186e-02 136:1.2480562e-01 151:1.1390028e-01 188:3.2954320e-02 230:6.2785842e-02 239:6.5708801e-02 "
          "257:5.8480371e-02 277:5.3436786e-02 286:3.7653819e-02 288:1.4964308e-01 295:7.0537597e-02 320:6.8376727e-02 "
          "338:1.6413274e-01 374:7.3497020e-02 381:1.6170757e-01 417:1.0842336e-01 441:9.5294490e-02 510:7.5878628e-02 "
          "613:4.8709549e-02 628:8.5332565e-02 768:8.2162306e-02 1013:9.7411908e-02 1222:9.1990732e-02 "
          "1288:1.6446801e-01 "
          "1562:2.5408825e-01 1654:1.4893608e-01 1666:5.6757294e-02 1765:7.4664280e-02 1799:1.1733646e-01 "
          "1998:1.7881344e-01 "
          "2200:2.4123746e-01 2298:3.3213455e-02 2346:1.1925569e-01 2362:6.6421799e-02 2376:1.2516232e-01 "
          "2493:1.3226469e-01 "
          "3361:1.3862990e-01 5890:2.2006290e-01 6089:1.5542614e-01 6956:1.3252905e-01 6968:1.6288808e-01 "
          "7761:1.4227273e-01 "
          "10657:3.4909892e-01 18084:4.6899009e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 20:4.9444132e-02 24:5.9771866e-02 48:1.3154505e-01 49:1.0113294e-01 51:7.5209044e-02 54:3.1426456e-02 "
          "60:5.6490775e-02 62:7.6005280e-02 107:1.2169860e-01 130:1.2446170e-01 148:2.9639822e-01 156:2.6709017e-01 "
          "171:1.3468234e-01 228:1.3031146e-01 232:8.7963790e-02 239:4.9831502e-02 244:1.6688983e-01 257:4.4349685e-02 "
          "259:8.1995733e-02 293:1.0796765e-01 323:6.4930007e-02 336:5.3603899e-02 348:5.0721966e-02 359:1.7440808e-01 "
          "379:7.5873256e-02 488:1.1682425e-01 547:1.7306893e-01 802:3.3058733e-02 842:3.5635207e-02 "
          "1029:1.3725325e-01 "
          "1663:1.6671342e-01 1664:9.7199544e-02 1743:1.9968998e-01 1758:2.8546399e-01 1786:9.5026560e-02 "
          "2493:1.2432595e-01 "
          "2520:2.4554352e-01 2840:2.0697108e-01 3046:1.4860563e-01 3048:2.2954246e-01 3719:2.4054185e-01 "
          "3817:2.2641847e-01 "
          "5494:1.1884978e-01 7761:1.0789519e-01 15455:2.4754892e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:3.6978137e-02 17:4.6626545e-02 20:4.0563542e-02 24:2.5139617e-02 33:6.2805220e-02 45:4.6610951e-02 "
          "51:8.5262835e-02 52:6.9185629e-02 53:6.8722993e-02 64:9.6546508e-02 65:7.8382976e-02 69:3.3462130e-02 "
          "70:1.4494644e-01 79:6.7709014e-02 87:8.2201250e-02 102:6.3285135e-02 152:9.3025558e-02 188:5.8776449e-02 "
          "223:6.3167065e-02 232:1.2218553e-01 284:5.3738002e-02 288:1.1229634e-01 291:1.6331233e-01 320:7.2028540e-02 "
          "374:1.3108733e-01 393:9.2887342e-02 464:5.0759252e-02 511:1.4177483e-01 622:9.8946594e-02 660:5.2249473e-02 "
          "679:8.5802808e-02 858:7.4573986e-02 1014:8.0897152e-02 1028:5.8990020e-02 1033:8.3390869e-02 "
          "1124:1.1880191e-01 "
          "1127:5.1934518e-02 1170:1.0276746e-01 1280:1.0946482e-01 1467:1.1788510e-01 1557:1.4011033e-01 "
          "1616:1.3101970e-01 "
          "1658:1.0277080e-01 1670:1.4444938e-01 1750:2.1543945e-01 2153:8.1400961e-02 2298:3.4987289e-02 "
          "2495:1.1063550e-01 "
          "2950:1.2181117e-01 3142:1.8677534e-01 3394:1.2471738e-01 4195:2.4093345e-01 4196:2.2380726e-01 "
          "4197:2.8290850e-01 "
          "8004:2.1816064e-01 9206:4.5614010e-01 23487:2.2793944e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 15:6.4738058e-02 17:3.4667209e-02 20:3.0159321e-02 47:7.6819658e-02 64:3.4205031e-02 65:5.8278371e-02 "
          "70:3.1716350e-02 140:2.9434940e-02 174:1.0128640e-01 233:3.7298899e-02 240:4.2920507e-02 326:7.8490466e-02 "
          "380:6.1754327e-02 394:1.1574629e-01 444:7.9201937e-02 465:7.8958511e-02 583:8.6952478e-02 588:1.2770371e-01 "
          "629:1.6308379e-01 839:1.1335945e-01 1218:5.3390633e-02 1288:6.1380610e-02 1315:9.5096074e-02 "
          "1449:1.1820640e-01 "
          "1454:5.4282643e-02 1459:9.3281724e-02 1544:6.5461181e-02 1645:8.1189461e-02 1778:8.2575515e-02 "
          "1996:9.7980328e-02 "
          "2184:3.1384379e-01 2200:1.8894120e-01 2298:2.6013331e-02 2349:8.6816557e-02 2353:8.4596701e-02 "
          "2476:1.2713952e-01 "
          "2769:9.6781030e-02 2770:1.5556271e-01 3198:1.0221510e-01 3679:2.3122619e-01 4003:1.0242812e-01 "
          "4232:9.8702803e-02 "
          "4684:1.3103031e-01 5000:1.0221253e-01 5572:1.5069701e-01 5935:1.6411133e-01 6900:1.3929147e-01 "
          "7310:1.2876862e-01 "
          "10229:1.3242257e-01 10557:1.3388468e-01 10585:3.9394876e-01 10586:1.8626647e-01 10589:1.8657076e-01 "
          "11565:1.3864174e-01 11796:1.8616593e-01 14612:1.6532886e-01 17749:1.6665757e-01 19469:1.8508823e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:2.8469902e-02 23:5.8907494e-02 42:7.5554907e-02 49:9.8906875e-02 51:2.5156705e-02 110:4.9333256e-02 "
          "142:1.4655490e-01 151:9.2376612e-02 179:7.2663747e-02 180:6.5646522e-02 183:5.0971515e-02 242:7.7014215e-02 "
          "252:4.7393460e-02 263:7.6297626e-02 271:6.4970404e-02 277:4.3338865e-02 288:6.9753997e-02 291:7.4261747e-02 "
          "293:3.9195027e-02 319:5.3194534e-02 357:2.1026230e-01 358:2.4290648e-01 360:7.4108168e-02 464:3.9080143e-02 "
          "514:6.3244760e-02 628:6.9207318e-02 673:6.6130720e-02 801:1.0042958e-01 1218:5.5286661e-02 "
          "1575:7.3582724e-02 "
          "1688:9.3726687e-02 2009:1.8793724e-01 2244:1.0277279e-01 2298:2.6937125e-02 2346:9.6720010e-02 "
          "2794:8.9054026e-02 "
          "2892:2.1875204e-01 2968:1.1117442e-01 3046:1.2821963e-01 4070:1.6577339e-01 4110:1.4488921e-01 "
          "13686:2.0645064e-01 23627:2.9994503e-01 32721:3.3521676e-01 40173:5.6160587e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:6.4027585e-02 19:1.2111145e-01 39:7.3595539e-02 188:4.5798678e-02 238:8.6253159e-02 "
          "252:8.1212297e-02 "
          "255:1.3115136e-01 305:9.3342803e-02 546:9.9360503e-02 547:9.1009796e-02 549:1.7230716e-01 606:1.1623173e-01 "
          "608:2.0247270e-01 613:6.7694709e-02 644:8.9160532e-02 1617:1.3339688e-01 1823:1.7065871e-01 "
          "2372:3.8778132e-01 "
          "2373:3.3106750e-01 2381:2.6670259e-01 3731:4.5910743e-01 6634:4.1046706e-01 7387:2.4818450e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 20:5.2213650e-02 24:3.2359872e-02 51:7.1212411e-02 67:1.0864551e-01 69:7.2928362e-02 218:1.3594350e-01 "
          "271:6.4154640e-02 667:1.7716940e-01 701:1.7276812e-01 932:1.0751238e-01 1150:1.7239195e-01 "
          "1250:3.4222117e-01 "
          "2094:3.2695574e-01 2097:1.2840460e-01 2298:4.5035861e-02 2330:2.8677970e-01 2474:1.3477865e-01 "
          "2493:1.0592382e-01 "
          "3736:3.0040437e-01 4256:1.4153151e-01 6780:6.2007076e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 49:3.9988112e-02 51:2.4270695e-02 140:2.9406741e-02 238:4.8562396e-02 252:4.5724280e-02 "
          "280:6.1823029e-02 "
          "321:6.6946603e-02 357:7.2662756e-02 358:8.3943978e-02 387:7.5481713e-02 465:7.8882866e-02 468:7.8108564e-02 "
          "620:4.2339340e-02 688:1.7595084e-01 689:9.8181032e-02 692:1.4274293e-01 726:5.9529472e-02 801:9.6892491e-02 "
          "842:3.6767535e-02 908:1.0558011e-01 955:7.3789276e-02 1028:4.3817535e-02 1033:6.1942380e-02 "
          "1188:4.9663574e-02 "
          "1189:6.5033451e-02 1247:1.2774247e-01 1380:6.4456083e-02 1636:1.4933172e-01 1645:1.7022197e-01 "
          "1954:1.1948910e-01 "
          "2028:7.4023940e-02 2525:1.0479485e-01 2538:8.4922098e-02 3860:1.3038887e-01 4285:2.3454750e-01 "
          "5121:1.3220982e-01 "
          "6466:1.4181073e-01 6578:1.3177581e-01 7469:1.2538511e-01 7822:2.9107320e-01 8727:1.6229621e-01 "
          "8739:1.4538153e-01 "
          "14302:4.9044997e-01 20115:1.8064937e-01 24891:4.3587640e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:4.6818007e-02 8:5.6217354e-02 9:6.6192977e-02 10:5.0927982e-02 11:9.3016952e-02 13:2.2009626e-02 "
          "16:3.6532994e-02 21:2.5107803e-02 24:2.3926586e-02 25:3.7941329e-02 30:6.9069296e-02 31:5.6137249e-02 "
          "33:2.8482994e-02 45:2.1138679e-02 50:2.1320406e-02 51:2.5089812e-02 53:5.2769944e-02 54:3.3519372e-02 "
          "55:6.2791258e-02 66:4.7556229e-02 81:6.9456406e-02 91:3.9277650e-02 110:2.9059539e-02 111:3.9879065e-02 "
          "124:4.8985604e-02 128:4.3422021e-02 131:4.0677965e-02 146:5.1637053e-02 147:2.9325549e-02 165:5.3055484e-02 "
          "170:5.9835006e-02 182:3.0366054e-02 190:2.1906663e-01 193:3.2346733e-02 197:1.4915322e-01 209:3.2971248e-02 "
          "224:2.8385125e-02 225:3.8298655e-02 229:2.4542296e-02 250:6.1778069e-02 252:2.7916912e-02 259:7.9606630e-02 "
          "263:4.4942781e-02 271:2.2603193e-02 283:7.1021572e-02 300:4.8565619e-02 302:3.2914251e-02 312:3.8219653e-02 "
          "315:3.4091923e-02 326:2.8276550e-02 327:5.1625453e-02 360:4.3653090e-02 370:3.9222293e-02 376:5.8273721e-02 "
          "378:1.0448048e-01 395:6.4292409e-02 417:2.1706261e-02 421:5.7235740e-02 422:9.6173845e-02 441:4.5525420e-02 "
          "453:5.5598486e-02 464:2.3019988e-02 478:3.8843445e-02 498:7.3118217e-02 504:7.9301439e-02 506:2.9923677e-02 "
          "525:5.7632379e-02 527:6.0860474e-02 545:7.8057572e-02 546:1.0920249e-01 547:5.2969810e-02 558:3.2271817e-02 "
          "573:2.9412907e-02 585:1.1865318e-01 592:5.8903303e-02 606:6.7649566e-02 617:3.3643346e-02 618:1.9061311e-01 "
          "630:4.4030275e-02 637:5.0169449e-02 647:4.6669565e-02 655:2.5962766e-02 678:4.8309427e-02 802:3.5260357e-02 "
          "848:4.3927528e-02 945:4.1166428e-02 948:7.3425077e-02 951:5.6070514e-02 963:3.9360791e-02 984:4.3966699e-02 "
          "987:6.0441017e-02 1028:2.6752749e-02 1036:4.0652603e-02 1040:9.4713308e-02 1099:4.3237824e-02 "
          "1127:2.3552986e-02 "
          "1133:8.4297411e-02 1169:5.8522630e-02 1193:3.0690324e-02 1213:5.0558273e-02 1247:7.7993028e-02 "
          "1259:6.7078903e-02 "
          "1262:6.4385876e-02 1273:5.5157077e-02 1280:4.9643740e-02 1315:5.8005184e-02 1347:5.6188263e-02 "
          "1434:4.7654271e-02 "
          "1455:2.5626300e-02 1545:1.5961391e-01 1556:4.8118513e-02 1596:8.0679923e-02 1623:3.8203631e-02 "
          "1650:6.0234591e-02 "
          "1676:8.7783448e-02 1697:7.5732850e-02 1737:9.4696321e-02 1820:7.1270034e-02 1827:5.0939571e-02 "
          "1854:5.9758004e-02 "
          "1882:8.7179236e-02 1890:4.8725523e-02 1893:7.3311776e-02 1937:6.1486434e-02 1960:9.2976660e-02 "
          "1984:9.0454280e-02 "
          "2016:4.8602805e-02 2018:4.6832096e-02 2129:1.5937248e-01 2234:6.9462128e-02 2299:5.6160234e-02 "
          "2433:5.1993016e-02 "
          "2477:5.0131746e-02 2519:6.0285576e-02 2525:6.3982390e-02 2602:4.9733043e-02 2640:5.0243855e-02 "
          "2731:5.4775178e-02 "
          "2753:7.6020516e-02 2803:5.8844991e-02 2910:6.4125024e-02 2965:9.3353666e-02 3192:5.9931215e-02 "
          "3247:6.5985441e-02 "
          "3294:6.8116181e-02 3309:7.0372030e-02 3367:7.1565583e-02 3457:4.7957044e-02 3615:6.1751164e-02 "
          "3720:8.2366705e-02 "
          "3818:7.7950045e-02 4012:6.1073605e-02 4402:1.5400408e-01 4404:7.5347729e-02 4714:7.7850275e-02 "
          "5250:7.7959582e-02 "
          "5253:6.9484107e-02 5313:4.9335603e-02 5325:8.7216243e-02 5510:7.7869222e-02 5647:7.5838998e-02 "
          "5733:7.0179485e-02 "
          "6219:8.4520586e-02 6611:2.6079112e-01 7311:7.2549909e-02 7398:9.2181757e-02 8536:7.6208621e-02 "
          "8557:7.8907147e-02 "
          "10265:1.0698969e-01 11614:6.8983786e-02 11917:1.2334778e-01 19917:9.0490118e-02 21880:1.1073822e-01 "
          "25049:2.6711825e-01 26284:1.1677517e-01 32191:1.1669831e-01 45730:1.1756807e-01 46060:1.4139245e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 24:6.9329806e-02 51:9.0110235e-02 62:1.7195952e-01 63:1.4221314e-01 107:2.7533919e-01 "
          "130:1.3417943e-01 "
          "286:1.0938722e-01 359:1.4134195e-01 370:1.4086714e-01 427:4.7556114e-01 496:1.5942375e-01 546:1.2266935e-01 "
          "550:1.2229095e-01 613:8.3575122e-02 1029:1.3013111e-01 1425:1.7816542e-01 1575:1.5566878e-01 "
          "1651:2.4535567e-01 "
          "2009:1.5236722e-01 2098:1.7608486e-01 2099:1.7710117e-01 2335:1.7619270e-01 3144:1.8664810e-01 "
          "4699:3.1969145e-01 "
          "13616:3.4107882e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 7:1.6083248e-01 9:5.5568893e-02 18:5.3648338e-02 20:3.6852725e-02 23:6.9512561e-02 42:8.9157000e-02 "
          "50:4.2710960e-02 73:3.9071590e-02 90:6.0480691e-02 123:1.0499278e-01 126:7.1187235e-02 161:9.6146189e-02 "
          "183:6.0147878e-02 189:5.9154175e-02 190:1.3726093e-01 230:6.0088549e-02 257:5.5968042e-02 269:5.1492728e-02 "
          "275:1.6879702e-01 276:9.2633680e-02 280:7.5616159e-02 283:8.4030971e-02 286:9.4034232e-02 341:7.8918472e-02 "
          "344:8.8300481e-02 526:4.5156468e-02 533:4.4598345e-02 575:7.1097843e-02 613:4.6616979e-02 620:5.1785525e-02 "
          "724:1.0051359e-01 757:7.5565353e-02 802:7.0636719e-02 898:8.9145705e-02 955:9.0252154e-02 963:7.8851081e-02 "
          "1059:4.7990009e-02 1063:1.2340502e-01 1173:7.0335589e-02 1188:6.0743846e-02 1266:2.2220153e-01 "
          "1321:8.8280253e-02 "
          "1419:2.6059356e-01 1422:6.6155322e-02 1455:5.1336911e-02 1456:9.9837758e-02 1473:4.0969402e-01 "
          "1511:1.8859638e-01 "
          "1589:1.0599832e-01 1723:1.1669025e-01 1765:7.1456686e-02 2126:9.6922636e-02 2153:7.3954269e-02 "
          "2212:9.3705557e-02 "
          "2949:9.7154185e-02 3013:9.9715784e-02 3196:1.3113439e-01 3291:1.0586372e-01 3580:1.4704342e-01 "
          "3652:1.3397823e-01 "
          "4419:2.0025432e-01 4639:1.6035363e-01 7108:1.2348503e-01 16847:1.6614150e-01 28139:2.6008931e-01 "
          "46900:2.6008931e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("1 |f 16:2.0615885e-01 46:1.8459667e-01 365:1.5531306e-01 438:2.0499265e-01 469:2.3966596e-01 "
                  "555:1.6016430e-01 "
                  "616:2.1066277e-01 1239:2.7524772e-01 2200:2.7253583e-01 2345:3.3661565e-01 2350:2.9912609e-01 "
                  "2521:2.6003033e-01 "
                  "3841:2.3006442e-01 4154:5.0639737e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:1.9983938e-02 9:6.9369137e-02 10:6.0687970e-02 13:5.5041600e-02 14:7.1899019e-02 15:2.7791716e-02 "
          "17:4.2664241e-02 20:2.1921584e-02 21:2.9919537e-02 22:5.8231439e-02 24:1.3586096e-02 26:3.5696369e-02 "
          "33:7.1230173e-02 35:6.6305541e-02 39:5.1043201e-02 51:4.2137895e-02 52:3.7389696e-02 53:8.8626191e-02 "
          "54:2.3591051e-02 55:2.6802011e-02 61:3.6721580e-02 65:1.0108385e-01 70:2.3053328e-02 77:6.4293921e-02 "
          "85:4.0907856e-02 90:8.5850552e-02 92:5.5391617e-02 95:5.1908404e-02 98:4.2750388e-02 99:4.8066143e-02 "
          "102:5.7907186e-02 106:4.2578921e-02 110:5.8631308e-02 152:5.0273407e-02 161:3.3778448e-02 173:6.5736420e-02 "
          "183:7.5085290e-02 188:3.9371040e-02 191:1.0153291e-01 215:4.6252765e-02 224:5.7270594e-02 225:4.5638323e-02 "
          "233:5.6895595e-02 234:3.5845865e-02 254:4.8533827e-02 286:5.1152319e-02 293:2.7512247e-02 327:3.6334176e-02 "
          "344:5.2524917e-02 348:3.8075704e-02 349:4.6087224e-02 362:7.5439289e-02 363:4.7734804e-02 417:4.3795135e-02 "
          "433:3.0815661e-02 451:6.7392230e-02 478:4.6287518e-02 481:4.2377047e-02 489:5.0609488e-02 501:5.0684709e-02 "
          "504:5.5812631e-02 511:4.5252278e-02 524:8.8075653e-02 526:4.5479633e-02 532:5.4666154e-02 533:4.4917520e-02 "
          "542:1.0563183e-01 543:1.0510078e-01 546:4.0701039e-02 548:5.8016628e-02 558:3.8456485e-02 564:5.5991352e-02 "
          "571:8.0623314e-02 580:5.7671499e-02 605:1.3157816e-01 606:4.7612000e-02 620:6.4646192e-02 630:5.2468367e-02 "
          "702:3.6435753e-02 755:6.0251348e-02 764:4.7026716e-02 768:4.6774045e-02 836:5.0501291e-02 911:8.3580650e-02 "
          "927:8.1300095e-02 981:6.6755749e-02 1012:6.7066789e-02 1028:3.1879727e-02 1049:1.1971291e-01 "
          "1122:3.4315024e-02 "
          "1127:2.8066751e-02 1130:5.7911646e-02 1134:8.6021036e-02 1145:4.1858409e-02 1170:5.5538181e-02 "
          "1193:6.1921619e-02 "
          "1293:6.4111784e-02 1385:1.0442358e-01 1434:5.6786876e-02 1454:6.6804558e-02 1455:5.1704314e-02 "
          "1566:5.5631578e-02 "
          "1573:5.8069725e-02 1629:3.7682705e-02 1653:6.5689877e-02 1654:3.2492660e-02 1750:6.8764858e-02 "
          "1850:5.6980379e-02 "
          "1861:7.3299579e-02 1955:2.0623422e-01 1979:9.6217841e-02 2201:7.6684192e-02 2248:5.6152675e-02 "
          "2298:3.2014083e-02 "
          "2360:5.5837695e-02 2362:6.4023241e-02 2477:5.9739139e-02 2627:7.3203668e-02 2812:1.7654823e-01 "
          "2876:2.1889210e-01 "
          "2877:2.2006370e-01 2924:6.7597888e-02 2957:6.7534715e-02 3051:1.1884689e-01 3052:2.2089420e-01 "
          "3054:2.0440713e-01 "
          "3134:7.2849274e-02 3674:7.4525982e-02 4103:9.5867537e-02 4256:5.9421148e-02 4470:8.2643040e-02 "
          "4554:9.7539298e-02 "
          "5148:1.1299586e-01 10076:1.1250795e-01 10077:1.1192647e-01 10103:1.7574643e-01 10734:1.3732937e-01 "
          "10903:1.2539929e-01 10905:1.1759551e-01 10912:2.3013321e-01 12062:1.0248313e-01 13549:1.1752033e-01 "
          "19657:1.4151923e-01 27014:1.4162548e-01 34769:1.5926248e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 7:4.8715625e-02 11:5.6441750e-02 14:4.3982569e-02 20:1.8899871e-02 24:1.1713364e-02 26:3.0775914e-02 "
          "36:4.6375424e-02 39:4.4007313e-02 42:7.7417552e-02 55:6.0297769e-02 57:4.0400509e-02 64:2.1435190e-02 "
          "74:3.0376339e-02 81:1.0057145e-01 117:3.4757841e-02 138:3.6997024e-02 140:3.1231668e-02 161:6.1116554e-02 "
          "169:3.1285878e-02 172:1.0031424e-01 179:4.3974388e-02 182:3.1197617e-02 188:3.3944063e-02 191:3.6683414e-02 "
          "192:1.2785511e-01 193:3.3232540e-02 209:3.3874158e-02 213:6.5919459e-02 229:4.2691655e-02 230:7.3536843e-02 "
          "234:3.0904805e-02 247:4.5021009e-02 252:6.0191154e-02 269:5.5420104e-02 286:3.1291254e-02 287:6.4029299e-02 "
          "297:3.1608950e-02 298:3.6049262e-02 329:2.2209166e-01 334:8.1020415e-02 337:3.5364114e-02 341:4.0473234e-02 "
          "344:4.5284785e-02 349:8.3387256e-02 353:4.3196432e-02 360:4.4848517e-02 367:6.3728832e-02 369:5.5313595e-02 "
          "383:6.5263547e-02 385:9.1194823e-02 415:3.8937815e-02 516:6.8991341e-02 526:3.9210636e-02 550:3.4982488e-02 "
          "586:3.2467935e-02 594:8.1097901e-02 624:5.5424515e-02 636:1.8378220e-01 644:5.3314582e-02 647:4.7947597e-02 "
          "656:6.5454669e-02 660:2.4344726e-02 677:1.5139177e-01 679:3.9978314e-02 698:9.8888576e-02 701:1.6318694e-01 "
          "768:4.0326625e-02 778:6.6134244e-02 802:3.6225948e-02 820:6.4558841e-02 837:4.2800721e-02 845:5.5815578e-02 "
          "858:5.8830839e-02 871:4.7131851e-02 898:4.5718260e-02 916:7.6574229e-02 927:4.1398373e-02 929:3.9828971e-02 "
          "950:5.6748085e-02 988:8.4062248e-02 992:4.1368749e-02 1002:8.2991883e-02 1025:4.7316406e-02 "
          "1033:6.5786406e-02 "
          "1063:6.3288108e-02 1094:8.4898107e-02 1122:2.9584978e-02 1128:1.8577971e-01 1130:8.4537141e-02 "
          "1132:6.0801964e-02 "
          "1133:5.1150817e-02 1183:9.0026736e-02 1189:4.0793445e-02 1191:5.6828119e-02 1218:5.6649636e-02 "
          "1235:4.5116793e-02 "
          "1262:1.1200009e-01 1295:4.7414344e-02 1309:6.9717675e-02 1332:7.4520044e-02 1345:5.7465792e-02 "
          "1355:6.3940085e-02 "
          "1366:6.2371109e-02 1368:6.3449875e-02 1369:9.2321083e-02 1426:3.5533179e-02 1539:7.7777542e-02 "
          "1573:5.0065283e-02 "
          "1575:4.4530533e-02 1603:4.8494432e-02 1623:3.9249822e-02 1629:3.2488450e-02 1668:4.5932326e-02 "
          "1677:7.9894900e-02 "
          "1694:5.5507164e-02 1766:6.4636476e-02 1771:7.9731472e-02 1788:6.2872313e-02 1789:7.4924394e-02 "
          "1839:1.4415966e-01 "
          "1861:6.3195832e-02 1896:6.7008063e-02 1897:1.2630878e-01 2088:1.3979888e-01 2090:4.4766583e-02 "
          "2097:7.8695543e-02 "
          "2173:1.1439515e-01 2379:5.4716337e-02 2385:7.6915696e-02 2442:9.0640515e-02 2478:8.8011891e-02 "
          "2577:5.5141501e-02 "
          "2588:6.6787474e-02 2933:6.1662905e-02 2938:6.4490505e-02 2992:1.0549045e-01 2997:9.2599854e-02 "
          "3013:5.1139113e-02 "
          "3026:5.6085709e-02 3226:7.1338922e-02 3565:6.6003427e-02 3574:6.4943179e-02 3615:6.3442200e-02 "
          "3644:9.0326816e-02 "
          "3736:6.4222366e-02 3836:6.8043977e-02 3845:5.7752725e-02 3963:9.3040556e-02 4459:6.3167207e-02 "
          "4966:9.8092563e-02 "
          "5093:6.5560982e-02 5253:7.1386911e-02 5812:1.3828517e-01 5902:8.7960884e-02 6005:6.1561648e-02 "
          "6074:1.1669607e-01 "
          "6653:1.0330607e-01 6994:9.8041035e-02 7157:9.2160933e-02 8924:7.9031914e-02 10462:8.3123550e-02 "
          "11619:1.0373321e-01 12143:1.0348041e-01 13630:1.1361745e-01 13741:8.8011891e-02 14619:1.0691887e-01 "
          "19466:1.0552382e-01 23258:1.3579927e-01 26903:1.4091165e-01 32035:1.2257048e-01 44984:1.3114814e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 188:4.7758471e-02 257:8.4751651e-02 309:1.1927230e-01 347:1.1546365e-01 371:1.7459229e-01 "
          "441:2.3383018e-01 "
          "447:3.3328635e-01 459:1.2573329e-01 549:1.0612217e-01 678:8.6554378e-02 767:1.1669350e-01 814:1.1738279e-01 "
          "874:2.1435185e-01 897:1.0864045e-01 996:1.6594432e-01 1000:1.0760117e-01 1195:1.3055357e-01 "
          "1617:1.3910513e-01 "
          "1726:1.2822309e-01 1944:1.4063258e-01 2368:2.1418063e-01 2381:1.6425930e-01 2382:2.8090066e-01 "
          "2762:1.7042892e-01 "
          "3659:1.5954466e-01 3727:1.7957838e-01 3728:2.0820697e-01 3923:1.5540299e-01 7180:2.9499236e-01 "
          "7271:2.9447657e-01 "
          "11400:2.3570603e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 49:2.6593460e-02 92:2.9903814e-02 125:2.2981675e-02 147:3.9591964e-02 166:2.8400956e-02 "
          "187:5.9722267e-02 "
          "252:1.7959576e-02 259:1.9625962e-02 262:3.0203288e-02 286:1.9593796e-02 308:9.3310796e-02 345:3.0234594e-02 "
          "399:3.8020805e-02 411:3.0831495e-02 462:3.2414403e-02 463:6.2348142e-02 467:3.3435874e-02 483:4.2059101e-02 "
          "514:2.3966366e-02 550:2.1905156e-02 601:3.1818345e-02 755:3.2527398e-02 842:1.4441547e-02 "
          "1089:3.8082175e-02 "
          "1215:3.3964936e-02 1340:3.1809594e-02 1390:4.1778281e-02 1659:3.5597671e-02 1668:2.8761668e-02 "
          "1688:8.4754921e-02 "
          "1717:4.2606100e-02 1858:4.8437323e-02 1943:5.7270952e-02 2031:1.0471829e-01 2094:3.5312399e-02 "
          "2104:6.6986039e-02 "
          "2117:6.8817087e-02 2176:8.0722705e-02 2177:8.9910753e-02 2298:1.0207724e-02 2345:3.8374819e-02 "
          "2350:3.4100935e-02 "
          "2353:3.3196047e-02 2433:3.3448275e-02 2465:4.3404516e-02 2722:4.2227600e-02 2813:6.2607728e-02 "
          "2953:4.8624344e-02 "
          "3112:1.0214347e-01 3269:4.5760740e-02 3335:5.3647660e-02 3511:6.5826543e-02 3512:3.6338739e-02 "
          "3518:4.0297989e-02 "
          "3617:3.9282706e-02 3686:1.4204527e-01 4349:4.4165228e-02 4587:9.5542975e-02 4616:6.3987166e-02 "
          "4700:4.5392096e-02 "
          "4882:7.6458178e-02 5252:5.0948624e-02 5324:9.7931027e-02 5834:5.2358467e-02 6342:1.1121751e-01 "
          "6467:4.4490814e-02 "
          "6513:1.1964232e-01 6760:4.8318949e-02 7812:1.2431086e-01 7845:7.8304097e-02 8035:4.7963277e-02 "
          "8076:1.0776348e-01 "
          "8496:5.4083977e-02 8880:1.6846560e-01 9111:5.1002447e-02 9763:6.4579807e-02 9845:6.2377118e-02 "
          "10162:9.2579208e-02 10229:8.7981157e-02 10791:6.3087530e-02 10921:7.6810189e-02 11838:7.1770445e-02 "
          "12369:1.1044537e-01 12464:1.1964360e-01 12465:5.9311107e-02 12467:7.6287217e-02 12863:1.0114585e-01 "
          "14492:1.0048021e-01 14554:1.0631961e-01 15231:5.4112561e-02 15232:8.5184939e-02 15398:6.4367905e-02 "
          "15995:6.6351980e-02 16350:6.2534265e-02 18534:7.8812949e-02 19033:5.6898870e-02 20421:1.4290971e-01 "
          "20422:3.0835548e-01 20423:6.9179900e-02 20424:8.1802994e-02 20429:1.4276752e-01 20432:1.5615670e-01 "
          "20448:7.4783526e-02 20449:1.2382197e-01 20450:3.0463278e-01 20451:2.5153989e-01 20457:1.0679454e-01 "
          "20458:7.5686820e-02 20469:1.1411776e-01 20471:6.7378841e-02 20473:1.3667542e-01 20499:8.7418839e-02 "
          "20506:9.5354743e-02 20510:6.8119936e-02 20513:1.2678204e-01 20515:8.1495240e-02 20523:7.3291533e-02 "
          "20524:6.8538547e-02 21712:1.2151792e-01 22219:9.6353017e-02 26658:1.3408868e-01 26679:8.9372955e-02 "
          "31114:7.2896078e-02 31115:8.2014181e-02 31116:8.9618862e-02 33235:8.0097318e-02 34504:1.4252687e-01 "
          "39235:7.3413640e-02 40798:8.4596194e-02 42988:7.9273321e-02")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 16:4.4935737e-02 24:1.4023458e-02 73:2.3989646e-02 98:4.4126600e-02 112:4.6763241e-02 "
          "175:4.6757545e-02 "
          "182:3.7350371e-02 189:3.6320195e-02 208:4.8106406e-02 213:4.6611428e-02 267:5.3038135e-02 313:5.5337157e-02 "
          "342:4.6950255e-02 363:4.9271476e-02 379:5.8789674e-02 399:7.2694100e-02 480:1.1411501e-01 529:5.8849212e-02 "
          "554:7.7502169e-02 622:1.1583226e-01 657:6.4836346e-02 660:6.1166070e-02 684:4.9219962e-02 721:7.7514239e-02 "
          "784:1.2183672e-01 836:5.2127022e-02 894:5.8511630e-02 905:1.3277948e-01 963:4.8413936e-02 "
          "1003:6.0274579e-02 "
          "1036:5.0002869e-02 1045:5.0684508e-02 1051:7.4608915e-02 1056:4.9849745e-02 1142:7.2485775e-02 "
          "1156:1.1095772e-01 "
          "1162:5.0896395e-02 1253:6.8997547e-02 1310:8.6943768e-02 1430:8.0732450e-02 1493:1.0818697e-01 "
          "1515:9.0381123e-02 "
          "1554:5.0972030e-02 1557:9.6873306e-02 1655:6.1047360e-02 1670:1.2418364e-01 1694:1.1251677e-01 "
          "1825:6.8847604e-02 "
          "1889:8.1932589e-02 2136:1.1092228e-01 2144:1.5074493e-01 2179:8.2071662e-02 2204:7.1470626e-02 "
          "2248:5.7960335e-02 "
          "2269:7.3056310e-02 2347:6.0265008e-02 2448:7.0166618e-02 2449:1.2069513e-01 3053:1.4036365e-01 "
          "3272:4.9174007e-02 "
          "3907:9.5015399e-02 4324:2.5314730e-01 4337:1.1613669e-01 4679:9.4948605e-02 4836:7.0056871e-02 "
          "4982:2.7980295e-01 "
          "5012:6.7356996e-02 5230:8.9034773e-02 5398:1.2370962e-01 5405:1.2755367e-01 5416:1.6843574e-01 "
          "5490:9.6487761e-02 "
          "5503:9.5867150e-02 5667:1.0213576e-01 6205:9.3221895e-02 6994:1.1737657e-01 11762:1.4697248e-01 "
          "12987:1.1208437e-01 16190:1.2385871e-01 16558:1.3019893e-01 16615:1.0173512e-01 16802:1.6790171e-01 "
          "21852:1.7284045e-01 23484:1.6147393e-01 25679:3.9550489e-01 38701:1.3974796e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:3.4704458e-02 19:5.0884608e-02 51:5.1921565e-02 233:7.9715975e-02 239:6.4962104e-02 "
          "286:3.7225928e-02 "
          "381:1.8178526e-01 417:9.4268717e-02 476:8.7776296e-02 546:1.4833443e-01 625:8.0143064e-02 655:5.3728081e-02 "
          "1014:7.5923026e-02 1127:8.2526051e-02 1493:1.0750385e-01 1603:2.5489196e-01 1836:3.1879002e-01 "
          "2298:3.2836024e-02 "
          "2369:1.4184782e-01 2493:7.7229939e-02 2581:2.7279055e-01 2582:2.0663187e-01 2586:1.4373863e-01 "
          "2671:3.3048755e-01 "
          "2694:1.2337440e-01 5577:1.5849400e-01 5579:2.0620932e-01 5586:3.1916001e-01 5770:1.4951378e-01 "
          "9573:3.5881174e-01 "
          "9574:3.1604800e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 19:4.7141802e-02 110:5.5713292e-02 197:8.9439541e-02 199:1.0111161e-01 234:5.7671737e-02 "
          "252:5.3522632e-02 "
          "336:6.4739928e-02 359:7.5450905e-02 381:7.0575565e-02 500:9.5988996e-02 546:6.5483138e-02 606:7.6602049e-02 "
          "608:7.8811117e-02 623:1.5455788e-01 625:7.4248157e-02 1012:6.3728951e-02 1100:1.8316162e-01 "
          "1373:8.5995480e-02 "
          "1449:8.1643313e-02 1616:1.1391912e-01 1725:1.1566798e-01 1746:1.2204692e-01 1868:9.7022101e-02 "
          "2007:1.0874698e-01 "
          "2136:8.2385376e-02 2304:1.9265278e-01 2770:1.8191975e-01 2842:1.0233498e-01 3385:1.4155610e-01 "
          "3410:1.3455942e-01 "
          "3411:1.2548108e-01 3414:1.4858328e-01 3415:1.7561471e-01 3599:1.1366122e-01 3669:1.0880093e-01 "
          "4077:1.0436727e-01 "
          "4078:1.3026538e-01 4099:1.0607094e-01 4100:1.3863809e-01 4102:1.1654849e-01 4173:1.1902151e-01 "
          "4197:1.4528182e-01 "
          "4202:1.3467494e-01 4295:3.5818946e-01 4300:1.5939757e-01 4307:1.3661711e-01 5741:2.2440434e-01 "
          "9217:3.5951647e-01 "
          "11063:1.4297469e-01 12577:1.6604775e-01 13074:2.0468581e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("1 |f 64:5.5706531e-02 69:4.0518682e-02 239:8.3814964e-02 417:5.7955794e-02 438:9.6991450e-02 "
                  "549:1.5814693e-01 "
                  "555:7.5781099e-02 623:1.0256536e-01 897:9.5620625e-02 942:2.3684485e-01 1071:8.6542174e-02 "
                  "1173:9.3743935e-02 "
                  "1193:8.1943281e-02 1195:1.1490761e-01 1213:6.4323828e-02 1617:1.2243430e-01 1666:7.2396860e-02 "
                  "1786:1.5983160e-01 "
                  "1970:1.4162202e-01 2022:1.4988400e-01 2298:4.2365473e-02 2368:1.8851252e-01 2381:1.4457391e-01 "
                  "2520:1.4793402e-01 "
                  "3306:1.7196353e-01 3669:1.5152155e-01 3923:1.3677898e-01 4030:2.2109078e-01 4355:2.5863808e-01 "
                  "4565:1.6283205e-01 "
                  "4566:1.7922965e-01 8725:1.9494782e-01 10688:2.4301118e-01 21476:5.6346345e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 6:6.2754907e-02 24:1.4555287e-02 45:2.6986720e-02 48:8.5352257e-02 54:2.5273964e-02 75:8.0477215e-02 "
          "86:6.5061063e-02 87:1.1357024e-01 101:7.9989687e-02 102:3.6640704e-02 135:5.3344339e-02 140:5.4697018e-02 "
          "181:9.3156129e-02 182:3.8766854e-02 192:5.6908771e-02 217:3.5118066e-02 220:4.8065402e-02 238:6.4089596e-02 "
          "239:6.7854181e-02 240:3.3422682e-02 259:3.8947042e-02 275:6.3532874e-02 276:5.9033334e-02 286:2.2965049e-02 "
          "297:3.9277986e-02 321:8.8351913e-02 326:7.5758412e-02 332:6.5469466e-02 355:7.8141198e-02 365:3.5136905e-02 "
          "421:1.2371839e-01 428:5.7785455e-02 463:4.7415469e-02 468:6.0882345e-02 482:6.5653116e-02 494:4.7261640e-02 "
          "521:7.7034146e-02 547:3.9939802e-02 624:6.8871737e-02 644:8.2115024e-02 647:5.9580754e-02 660:3.0251298e-02 "
          "679:4.9677946e-02 693:1.0916758e-01 733:7.1375646e-02 811:6.2057443e-02 866:5.8195300e-02 867:7.0600271e-02 "
          "869:1.7880274e-01 870:1.8608500e-01 888:5.6645244e-02 929:4.9492370e-02 955:1.6056985e-01 979:7.4670687e-02 "
          "1029:4.6256911e-02 1059:3.0582940e-02 1075:6.1207395e-02 1159:9.8746590e-02 1179:1.4273641e-01 "
          "1192:7.7868290e-02 "
          "1212:9.7404882e-02 1213:3.0756170e-02 1240:4.9201149e-02 1308:6.2061455e-02 1486:6.2023588e-02 "
          "1491:1.0286001e-01 "
          "1499:8.5486189e-02 1500:6.7879066e-02 1513:6.7497797e-02 1520:6.9135152e-02 1538:6.1670348e-02 "
          "1546:4.8289027e-02 "
          "1647:5.8064759e-02 1653:7.0375994e-02 1717:8.4550329e-02 1960:7.0105396e-02 1996:7.6298386e-02 "
          "2123:6.9440722e-02 "
          "2153:4.7129370e-02 2212:1.0110869e-01 2526:6.8821691e-02 2811:1.2456290e-01 3137:5.8619089e-02 "
          "3271:5.8958665e-02 "
          "3424:1.0629191e-01 3484:7.4617952e-02 3616:8.2638845e-02 3617:7.7955164e-02 3690:6.6306993e-02 "
          "4958:1.0012808e-01 "
          "5288:1.0113242e-01 5424:1.2578398e-01 5827:1.2598442e-01 5960:1.2689516e-01 6123:1.0266279e-01 "
          "6894:1.0444117e-01 "
          "7580:1.1412975e-01 8092:1.0845778e-01 11133:3.3757788e-01 12121:1.7489992e-01 17971:2.1923038e-01 "
          "26167:1.4458314e-01 28774:1.5715960e-01 38869:1.4450687e-01 41126:3.4245893e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 41:6.5770514e-02 64:3.8988218e-02 120:1.0874638e-01 476:7.9262182e-02 1448:1.0210901e-01 "
                  "1603:1.4934568e-01 "
                  "1931:1.1732806e-01 2097:1.4313841e-01 2298:2.9651001e-02 2318:1.0624741e-01 2541:1.4503135e-01 "
                  "3953:2.2228055e-01 "
                  "4317:2.4048807e-01 5791:1.0412786e-01 6894:1.5287578e-01 8777:1.9350675e-01 9949:1.7480159e-01 "
                  "9950:1.6042686e-01 "
                  "9952:1.5631177e-01 9954:1.7755750e-01 10850:6.1053681e-01 13829:2.0958987e-01 15995:1.9273667e-01 "
                  "25636:1.9262849e-01 33990:2.1807390e-01 33991:2.1497139e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:1.9774411e-02 91:6.8124056e-02 161:4.9164150e-02 166:7.6570109e-02 183:5.2075267e-02 "
          "189:8.6714417e-02 "
          "191:6.1928660e-02 210:5.3147692e-02 229:7.2071724e-02 233:3.9459836e-02 252:4.8419729e-02 264:1.1140943e-01 "
          "265:9.1714345e-02 275:8.6314000e-02 276:8.0201052e-02 277:4.4277336e-02 288:4.2089939e-02 364:5.0646935e-02 "
          "386:7.1462259e-02 387:7.9931371e-02 417:9.8239690e-02 526:3.9095894e-02 533:3.8612679e-02 644:5.3158563e-02 "
          "678:4.9487121e-02 684:1.1751261e-01 865:8.7088540e-02 886:8.1711449e-02 971:8.6882174e-02 "
          "1036:7.0508808e-02 "
          "1059:4.1549139e-02 1183:8.9763276e-02 1266:8.0618404e-02 1399:7.6909773e-02 1455:4.4446845e-02 "
          "1456:1.4635269e-01 "
          "1546:6.5604143e-02 1647:7.8885175e-02 1729:1.1296030e-01 1804:1.1768481e-01 1811:9.4995469e-02 "
          "1890:8.4510669e-02 "
          "1935:8.2033694e-02 2126:8.3914377e-02 2298:2.7520429e-02 2619:1.4788656e-01 3816:1.8322898e-01 "
          "4689:1.3101651e-01 "
          "5241:3.6256132e-01 6347:1.5431349e-01 7310:3.5548088e-01 7931:1.4512981e-01 8252:2.0377167e-01 "
          "8253:2.1248284e-01 "
          "8254:1.4707601e-01 8297:2.4446608e-01 8298:1.6438119e-01 8299:2.3180476e-01 8335:1.3302477e-01 "
          "18732:3.0728489e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:4.6660215e-02 15:5.2353233e-02 18:6.0115542e-02 23:4.6004370e-02 24:2.5593098e-02 26:3.9715264e-02 "
          "51:4.6882015e-02 54:4.4440143e-02 64:2.7661379e-02 69:5.6169566e-02 73:2.5858115e-02 131:5.3931043e-02 "
          "135:5.5398207e-02 140:4.0303402e-02 147:3.8879953e-02 158:6.8883479e-02 176:6.2196508e-02 179:7.9978935e-02 "
          "183:3.9806690e-02 195:1.3797440e-01 224:3.7633136e-02 229:3.2538295e-02 236:3.3005994e-02 238:9.3804613e-02 "
          "271:2.9967424e-02 277:3.3845901e-02 280:5.0043810e-02 319:4.1542780e-02 321:9.1753647e-02 327:6.8445273e-02 "
          "334:4.9820576e-02 357:5.8818229e-02 358:6.7950025e-02 417:4.8725836e-02 425:7.0313640e-02 471:9.1062576e-02 "
          "489:9.5336698e-02 506:3.9672956e-02 533:2.9515795e-02 547:7.0227630e-02 549:1.1067711e-01 573:6.6025585e-02 "
          "620:3.4272373e-02 638:5.2765258e-02 655:3.4421559e-02 676:1.8922324e-01 679:8.7350555e-02 726:1.0112634e-01 "
          "820:1.2839688e-01 884:8.4112801e-02 894:6.3068897e-02 939:7.9306558e-02 1000:4.7026724e-02 "
          "1007:1.0637523e-01 "
          "1013:6.1698955e-02 1155:1.1924140e-01 1188:6.8066396e-02 1189:5.2642543e-02 1193:4.0689379e-02 "
          "1195:5.7057992e-02 "
          "1213:3.1940345e-02 1467:7.0880763e-02 1486:6.4411625e-02 1557:4.9755942e-02 1654:3.6150865e-02 "
          "1666:6.0867034e-02 "
          "1757:1.0215911e-01 1760:2.2709574e-01 1837:5.9166465e-02 1889:5.2159689e-02 1922:7.1139373e-02 "
          "2065:6.2375728e-02 "
          "2153:4.8943948e-02 2196:8.5024312e-02 2214:1.5770420e-01 2525:8.4828161e-02 3457:6.3581675e-02 "
          "3649:7.9934038e-02 "
          "3850:9.9384211e-02 3854:8.0482282e-02 3892:9.0174913e-02 3893:1.0720570e-01 3918:2.6785809e-01 "
          "4032:9.3380548e-02 "
          "5424:7.7150360e-02 5643:9.6895821e-02 6005:7.9443201e-02 7185:1.2371162e-01 8787:3.2106280e-01 "
          "12963:1.2044412e-01 15759:3.6455157e-01 20102:1.4721939e-01 27133:3.6548179e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 64:1.7770378e-01 167:1.4206883e-01 309:8.2798578e-02 347:8.0154620e-02 364:6.1494086e-02 "
          "371:1.2120160e-01 "
          "459:1.4778429e-01 549:7.3669784e-02 616:7.8615151e-02 678:6.0085870e-02 739:1.9821386e-01 811:1.0236625e-01 "
          "874:1.4880261e-01 878:1.1840012e-01 897:7.5417973e-02 992:8.4795825e-02 1075:1.0096407e-01 "
          "1191:1.1648376e-01 "
          "1240:8.1159286e-02 1398:9.3981847e-02 1495:2.6073274e-01 1617:9.6566491e-02 1670:8.1479065e-02 "
          "1726:8.9012198e-02 "
          "1731:1.4512868e-01 1944:9.7626843e-02 2362:6.6823922e-02 2374:2.3656930e-01 2381:1.1402846e-01 "
          "3659:1.1075557e-01 "
          "3727:1.2466294e-01 3728:1.4453684e-01 3923:1.8265745e-01 11266:5.9906405e-01 11400:1.6362663e-01 "
          "11434:1.9284385e-01 11472:2.0159966e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 10:7.0927240e-02 33:3.2004036e-02 45:4.0215332e-02 46:3.6755830e-02 76:7.7229060e-02 98:6.8250798e-02 "
          "112:4.2718612e-02 146:5.8020376e-02 240:2.9416310e-02 252:5.3110600e-02 260:5.9201360e-02 269:2.8881595e-02 "
          "272:7.5045198e-02 282:5.8055356e-02 311:6.9254607e-02 365:3.0925049e-02 380:4.2324390e-02 480:8.4104225e-02 "
          "482:9.7835608e-02 567:6.7059658e-02 784:5.3034503e-02 879:5.6365497e-02 905:5.0829928e-02 933:5.1193658e-02 "
          "955:5.0621249e-02 1036:4.5678038e-02 1143:6.0606502e-02 1149:8.8214703e-02 1156:5.9865322e-02 "
          "1168:4.5852050e-02 "
          "1173:6.6795178e-02 1189:4.4614535e-02 1215:5.9322737e-02 1253:6.3029833e-02 1335:5.4383237e-02 "
          "1422:3.7105653e-02 "
          "1468:5.7327367e-02 1530:5.7780884e-02 1554:7.8838646e-02 1623:4.2926326e-02 1670:4.3474033e-02 "
          "1765:4.0079113e-02 "
          "1773:5.3128190e-02 1780:8.5657857e-02 1798:1.3471301e-01 1827:5.7236671e-02 1889:4.4205315e-02 "
          "1935:5.3144258e-02 "
          "1977:1.3343529e-01 2144:1.1110093e-01 2184:1.2362664e-01 2197:7.2483592e-02 2204:6.5289013e-02 "
          "2224:7.0211478e-02 "
          "2267:1.6705896e-01 2288:5.7286993e-02 2300:1.0586048e-01 2308:6.6930018e-02 2367:5.6621287e-02 "
          "2404:7.3001079e-02 "
          "2474:5.3355835e-02 2481:9.1271445e-02 2589:7.5427771e-02 2653:8.2092732e-02 2818:7.5417906e-02 "
          "2886:7.6297544e-02 "
          "2903:6.9684580e-02 2912:9.3026578e-02 2949:5.4492503e-02 2958:1.1664265e-01 2984:6.6999033e-02 "
          "3325:5.4881386e-02 "
          "3437:7.1583837e-02 3484:6.5673508e-02 3769:8.2058802e-02 3795:7.9859555e-02 3823:6.8591535e-02 "
          "3933:1.4775467e-01 "
          "4075:6.8244532e-02 4337:6.2659539e-02 4590:1.8622316e-01 4675:9.5193632e-02 4731:8.9773051e-02 "
          "4739:1.0969728e-01 "
          "4997:1.6663924e-01 5010:1.0106970e-01 5012:1.0418134e-01 5028:1.9578026e-01 5029:1.2303083e-01 "
          "5076:1.2836717e-01 "
          "5093:7.1702026e-02 5261:9.9492952e-02 5263:8.6710997e-02 5290:1.1255535e-01 7201:1.4429569e-01 "
          "7337:1.0845268e-01 "
          "7567:1.0299381e-01 7786:8.4711127e-02 8063:1.1942018e-01 10364:2.3133691e-01 10504:1.0890530e-01 "
          "10608:1.2132790e-01 11977:1.0711236e-01 12000:1.1469761e-01 14267:1.6960521e-01 15389:1.0008810e-01 "
          "15451:1.0667179e-01 15597:1.2334229e-01 18411:1.2277594e-01 19940:1.2262496e-01 20263:1.2292839e-01 "
          "23754:1.3121080e-01 27958:1.4655745e-01 32035:1.3405156e-01 32762:1.5338148e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 15:6.2449891e-02 21:6.7231253e-02 24:3.0528890e-02 45:5.6603115e-02 51:3.9679404e-02 64:5.5867173e-02 "
          "80:1.1804737e-01 125:9.5656708e-02 176:1.2561713e-01 448:1.8683130e-01 464:6.1640698e-02 497:1.5572320e-01 "
          "511:1.0168497e-01 614:1.2794763e-01 702:8.1873640e-02 1429:1.2756036e-01 3125:3.3013815e-01 "
          "3352:1.8561506e-01 "
          "3477:1.7290212e-01 6873:1.8773741e-01 7486:2.6440963e-01 8225:4.4987288e-01 11830:4.0889326e-01 "
          "11831:4.2797947e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 39:1.0062896e-01 50:8.4805004e-02 107:6.9239333e-02 157:1.1047889e-01 163:9.1007069e-02 "
          "240:4.9620695e-02 "
          "254:1.8421125e-01 255:1.4467944e-01 257:8.9657106e-02 271:4.2841390e-02 318:1.7525031e-01 336:6.4002343e-02 "
          "337:6.5241426e-02 382:2.9377505e-01 535:1.1525904e-01 613:7.4677326e-02 990:1.1130646e-01 992:7.6319061e-02 "
          "994:8.7547302e-02 1009:1.0827483e-01 1127:4.4641595e-02 1183:9.8092869e-02 1187:9.9310562e-02 "
          "1189:7.5257719e-02 "
          "1240:7.3046058e-02 1380:1.5653461e-01 1623:7.2409973e-02 1664:1.4384714e-01 1727:8.2301512e-02 "
          "2080:9.4663695e-02 "
          "2131:1.0860187e-01 2318:1.0776382e-01 2538:9.8273173e-02 2681:1.2844808e-01 3046:8.4547840e-02 "
          "5589:1.5673013e-01 "
          "8421:2.6372126e-01 46901:6.7741430e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:1.9743230e-02 39:7.4175663e-02 50:6.2511489e-02 51:5.3852335e-02 69:5.5149980e-02 73:3.3774346e-02 "
          "85:1.2475629e-01 102:4.9700558e-02 137:1.2328483e-01 140:5.2641924e-02 220:1.1038873e-01 229:7.1958080e-02 "
          "236:4.3110486e-02 238:5.1344067e-02 252:4.8343383e-02 269:4.4511449e-02 271:3.9141681e-02 274:6.5178528e-02 "
          "279:1.0289983e-01 293:6.7693077e-02 298:6.0762126e-02 305:5.5564329e-02 315:5.9036575e-02 334:6.5072700e-02 "
          "338:5.2036025e-02 388:5.6949809e-02 400:6.5556593e-02 417:3.7588470e-02 438:6.2905878e-02 440:8.8704854e-02 "
          "631:7.7408902e-02 646:8.4289141e-02 660:4.1033771e-02 676:8.8529207e-02 726:1.0656556e-01 802:3.6062982e-02 "
          "842:3.8873591e-02 1000:6.1423533e-02 1059:7.0237875e-02 1143:9.3404926e-02 1188:5.2508321e-02 "
          "1189:6.8758585e-02 "
          "1218:5.6394789e-02 1223:1.9147316e-01 1444:3.0534506e-01 1511:6.8318009e-02 1664:1.4944071e-01 "
          "1674:5.6083046e-02 "
          "1768:1.4859484e-01 1857:9.7597368e-02 1865:8.2483768e-02 1937:1.8027839e-01 2226:1.1121064e-01 "
          "2291:1.1151499e-01 "
          "2298:2.7477035e-02 2793:1.1449140e-01 2851:1.1060414e-01 2908:2.2692639e-01 2938:1.0870071e-01 "
          "3459:1.0892428e-01 "
          "3872:1.3248518e-01 3874:1.3091435e-01 4065:1.1913920e-01 4585:1.3358179e-01 4895:1.3680226e-01 "
          "6177:1.5027332e-01 "
          "6243:1.2657709e-01 9104:1.3347296e-01 9551:2.5887942e-01 9760:1.8417296e-01 9765:1.9490364e-01 "
          "10999:3.7175620e-01 12629:1.4525203e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 13:4.2149704e-02 21:2.8398529e-02 22:5.5271149e-02 23:3.9247014e-02 31:6.3494816e-02 40:1.0104750e-01 "
          "42:1.2012206e-01 50:4.0829808e-02 55:4.3072797e-02 79:5.8805536e-02 90:3.4147590e-02 110:3.2868195e-02 "
          "120:6.5820746e-02 122:6.4282060e-02 147:3.3169068e-02 161:3.2061268e-02 172:6.5226182e-02 188:1.7806791e-02 "
          "228:5.4837894e-02 234:3.4023583e-02 240:5.0136145e-02 276:3.0889971e-02 293:2.6113616e-02 298:3.9687198e-02 "
          "315:3.8560145e-02 354:3.9731469e-02 359:9.3414366e-02 365:3.1129951e-02 370:1.2385060e-01 380:4.2604823e-02 "
          "543:5.8918573e-02 558:3.6501486e-02 561:5.2868403e-02 572:7.3168911e-02 573:6.9816381e-02 617:3.8052775e-02 "
          "651:4.8312992e-02 660:2.6801489e-02 691:1.8956625e-01 694:1.2445321e-01 704:8.4104590e-02 720:1.1626857e-01 "
          "773:3.7743010e-02 802:5.6208644e-02 803:7.9902597e-02 809:6.7258380e-02 866:5.1558800e-02 "
          "1122:3.2570567e-02 "
          "1123:6.1013855e-02 1145:3.9730471e-02 1168:4.6155855e-02 1181:1.0255010e-01 1194:1.0274440e-01 "
          "1232:6.7660540e-02 "
          "1334:8.3938710e-02 1377:7.8070506e-02 1394:5.6527678e-02 1416:5.3967800e-02 1455:2.8984983e-02 "
          "1462:1.4437114e-01 "
          "1474:8.0023959e-02 1482:1.6641031e-01 1497:5.4800745e-02 1540:8.3871506e-02 1556:5.4425113e-02 "
          "1623:4.3210745e-02 "
          "1733:7.9882957e-02 1783:1.0690484e-01 1865:9.1218024e-02 1939:8.5330881e-02 2071:7.2881758e-02 "
          "2134:7.1002245e-02 "
          "2135:7.3292397e-02 2214:5.6380220e-02 2305:6.7127049e-02 2331:7.7643998e-02 2335:5.5487905e-02 "
          "2538:5.8644645e-02 "
          "2722:7.4242875e-02 3026:1.0454445e-01 3196:7.4038893e-02 3282:6.4597391e-02 3291:5.9770994e-02 "
          "3338:1.6443987e-01 "
          "3432:7.7353239e-02 3444:1.6625471e-01 3446:8.5603580e-02 3532:1.1894052e-01 3588:7.2171241e-02 "
          "3597:6.5750234e-02 "
          "3631:8.8323660e-02 4227:9.3021996e-02 4232:6.8095885e-02 4337:6.3074708e-02 4385:8.2261287e-02 "
          "4677:7.9071485e-02 "
          "4944:9.5113397e-02 5197:8.7698899e-02 5259:9.9007480e-02 5597:1.4774826e-01 5745:7.1382985e-02 "
          "6296:8.5335381e-02 "
          "6319:1.7292418e-01 6354:9.4210044e-02 6971:1.5305863e-01 7075:9.0580098e-02 7756:7.9129167e-02 "
          "7956:8.4335580e-02 "
          "8066:8.2591146e-02 8531:1.3011539e-01 8873:9.9497408e-02 9501:9.6968852e-02 9884:9.9923305e-02 "
          "9886:9.1794536e-02 "
          "9888:8.7052643e-02 10318:1.1857352e-01 12164:1.2265076e-01 15462:1.0822061e-01 18528:1.0736036e-01 "
          "18540:1.3098568e-01 18855:1.0000303e-01 19103:1.1330112e-01 19257:1.7254175e-01 20136:9.8657623e-02 "
          "24174:1.4113031e-01 25922:1.2145054e-01 31029:1.4924273e-01 31440:1.2203924e-01 45358:1.3182078e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 32:2.5237672e-02 33:3.6768209e-02 73:1.4869946e-02 101:2.8213643e-02 103:2.8476102e-02 "
          "125:2.7236110e-02 "
          "126:4.5871731e-02 133:3.0872714e-02 140:2.3176840e-02 142:3.8872879e-02 166:9.3966782e-02 169:2.3217069e-02 "
          "179:4.0447935e-02 188:2.0322885e-02 198:5.8160599e-02 225:1.0409479e-01 238:4.7440030e-02 242:5.8560755e-02 "
          "257:3.6064763e-02 277:1.9463396e-02 353:3.2055821e-02 381:2.8065734e-02 387:3.5136167e-02 447:1.0382340e-01 "
          "510:2.7637437e-02 526:1.7185740e-02 550:2.5960302e-02 642:2.6387822e-02 721:4.8047084e-02 808:1.0720868e-01 "
          "814:2.9501539e-02 858:6.7284703e-02 869:7.5764328e-02 897:4.6230283e-02 941:4.1271027e-02 966:1.0141711e-01 "
          "1021:6.5172538e-02 1125:4.1173238e-02 1185:5.1710658e-02 1240:4.9749631e-02 1282:7.4876413e-02 "
          "1340:6.3828737e-02 "
          "1357:4.8753191e-02 1383:5.4431736e-02 1397:6.0547601e-02 1403:4.4326410e-02 1413:4.8082046e-02 "
          "1486:7.7733643e-02 "
          "1495:9.4395764e-02 1653:7.1160525e-02 1659:7.1429841e-02 1666:2.0672832e-02 1726:3.2226007e-02 "
          "1732:7.9582915e-02 "
          "1898:5.0520178e-02 1910:3.9714672e-02 1981:1.1957908e-01 2079:4.0635683e-02 2126:3.6887016e-02 "
          "2345:4.5478877e-02 "
          "2363:5.4341935e-02 2585:6.8648413e-02 2767:6.0101844e-02 2951:8.1243448e-02 2988:6.2914103e-02 "
          "3013:3.7950039e-02 "
          "3034:1.4156190e-01 3074:7.3609255e-02 3075:6.7068219e-02 3112:5.0728265e-02 3369:5.8296971e-02 "
          "3384:8.0655158e-02 "
          "3390:1.3839495e-01 3486:5.4303702e-02 3572:1.2869374e-01 3614:5.8254573e-02 3665:4.9358979e-02 "
          "4150:3.7659708e-02 "
          "4695:6.6788554e-02 5277:5.4099146e-02 5315:6.5313116e-02 5450:7.3769473e-02 6409:6.9625936e-02 "
          "6545:5.4956406e-02 "
          "6646:1.1634938e-01 6751:1.9942153e-01 6753:1.1264584e-01 6818:9.4818808e-02 6857:2.1449672e-01 "
          "6912:5.6879498e-02 "
          "7007:1.2253035e-01 7009:7.7970915e-02 7061:1.4940131e-01 7062:1.3122486e-01 7132:8.3376773e-02 "
          "7144:5.8971476e-02 "
          "7160:1.2511712e-01 7162:8.4976211e-02 7169:1.4755931e-01 7175:6.4034335e-02 7201:5.7827137e-02 "
          "7206:9.0749592e-02 "
          "7321:1.8798064e-01 7413:7.8159556e-02 7541:6.6347778e-02 7771:8.7349735e-02 8193:8.0557935e-02 "
          "10013:7.2125815e-02 10275:7.3981509e-02 11159:9.5342338e-02 11256:1.2635794e-01 11859:7.9391256e-02 "
          "12055:6.8417445e-02 13228:1.2630662e-01 13234:7.5531125e-02 13242:1.7011069e-01 13370:1.2862749e-01 "
          "13584:9.0888634e-02 14936:6.8502404e-02 17854:7.9296708e-02 18053:7.1032740e-02 20762:1.3378911e-01 "
          "21018:8.7706871e-02 22302:7.3237188e-02 24480:9.0818882e-02 24675:8.7101780e-02 24678:9.8122410e-02 "
          "27656:8.7501325e-02 29325:1.6352734e-01 29771:8.9824073e-02 31064:8.5427165e-02 32546:8.6955734e-02 "
          "33156:1.4176357e-01 34076:8.1926256e-02 34601:9.1763385e-02 34635:1.6414487e-01 37017:1.6974966e-01 "
          "40551:9.8545119e-02 43185:8.2294136e-02")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 4:9.2658103e-02 24:3.4065697e-02 32:5.8415916e-02 56:7.3896386e-02 75:6.5702215e-02 87:1.5698797e-01 "
          "126:6.2709346e-02 138:6.3548855e-02 140:3.1684101e-02 142:8.9976393e-02 179:4.4611417e-02 181:7.6053381e-02 "
          "189:8.8228785e-02 194:2.5486296e-01 231:5.4693099e-02 238:5.2323237e-02 253:7.4600466e-02 271:3.9888144e-02 "
          "293:4.0743086e-02 297:9.1927558e-02 438:1.0854013e-01 467:9.1718718e-02 471:7.1587905e-02 526:3.9778657e-02 "
          "533:6.6518679e-02 547:5.5208724e-02 679:6.8669736e-02 815:7.4704394e-02 842:3.9614942e-02 921:1.0581463e-01 "
          "1025:8.1274197e-02 1099:7.6302335e-02 1112:1.1661367e-01 1127:4.1564252e-02 1131:9.8212436e-02 "
          "1173:1.3002819e-01 "
          "1213:4.2514201e-02 1304:8.0962256e-02 1410:1.1735421e-01 1540:7.7287033e-02 1670:1.4329039e-01 "
          "1726:7.4591331e-02 "
          "1765:6.2946714e-02 2009:1.7865404e-01 2323:1.0607558e-01 2538:1.9202043e-01 4279:2.0356078e-01 "
          "5295:1.2182522e-01 "
          "6130:1.2681465e-01 6867:2.5291836e-01 6869:1.8047395e-01 9837:1.5624182e-01 9838:2.3017746e-01 "
          "10443:3.9884469e-01 10622:3.7433451e-01 22859:1.9077112e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:2.8033763e-02 13:3.6792487e-02 25:6.3424788e-02 54:3.3093873e-02 55:6.3659385e-02 107:6.1066858e-02 "
          "169:8.6189918e-02 170:5.9075464e-02 182:5.0761543e-02 183:5.0190669e-02 193:5.4072559e-02 217:4.5983795e-02 "
          "228:8.1047587e-02 240:4.3763854e-02 293:3.8594585e-02 389:7.6435097e-02 443:6.6852644e-02 456:9.2353411e-02 "
          "526:3.7681017e-02 581:8.5275568e-02 585:1.0905576e-01 586:5.2828472e-02 589:1.2011190e-01 645:8.2189858e-02 "
          "660:3.9611224e-02 664:1.1344983e-01 746:1.1660524e-01 857:8.5943960e-02 860:8.5997552e-02 871:7.6688088e-02 "
          "899:9.7162001e-02 945:1.1651568e-01 960:1.0507236e-01 984:7.3497124e-02 1028:4.4721350e-02 "
          "1040:6.0675103e-02 "
          "1085:9.0383068e-02 1099:7.2278693e-02 1206:1.2985559e-01 1213:8.4515959e-02 1222:7.3464356e-02 "
          "1226:1.1852483e-01 "
          "1234:9.6859910e-02 1434:1.3487859e-01 1453:8.9126743e-02 1454:5.5349246e-02 1455:7.2531573e-02 "
          "1538:8.0751508e-02 "
          "1544:1.1301322e-01 1566:1.3213457e-01 1727:7.2587289e-02 1759:1.3188840e-01 1773:7.9040997e-02 "
          "1890:8.1452236e-02 "
          "1958:9.8267376e-02 2233:1.6468456e-01 2234:6.8580374e-02 2515:8.8958278e-02 3015:1.7201971e-01 "
          "3230:8.3483905e-02 "
          "3512:9.4425134e-02 3772:1.3697486e-01 3823:1.0204645e-01 4276:8.2160503e-02 4840:1.4498876e-01 "
          "4969:1.2514929e-01 "
          "5390:1.9978628e-01 6130:1.2012735e-01 6499:1.3908614e-01 6749:1.3308734e-01 6909:9.2660770e-02 "
          "8440:1.3638055e-01 "
          "8737:9.2930466e-02 8738:9.3639337e-02 9247:1.2230179e-01 11200:2.4046142e-01 12157:1.5539138e-01 "
          "14403:1.6568016e-01 15048:1.7923634e-01 22583:2.1769908e-01 29197:2.5489852e-01 43552:2.2665370e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:6.2578380e-02 10:1.0264272e-01 19:3.5162400e-02 20:2.6306810e-02 21:3.5904687e-02 25:9.1864914e-02 "
          "32:8.0148295e-02 41:5.0330881e-02 45:6.3438445e-02 49:7.3269978e-02 53:4.4569150e-02 54:2.8310241e-02 "
          "64:5.0516285e-02 73:2.7890718e-02 75:5.3241272e-02 102:4.1042522e-02 112:5.4367635e-02 128:6.2094405e-02 "
          "140:2.5674963e-02 142:1.2345017e-01 144:5.7751875e-02 147:4.1936152e-02 179:3.6150511e-02 183:7.2696529e-02 "
          "209:7.9831183e-02 224:6.8727091e-02 233:3.2534391e-02 238:4.2399723e-02 242:1.3614275e-01 253:6.0451902e-02 "
          "257:3.9952017e-02 271:3.2323044e-02 277:3.6506392e-02 286:2.5723945e-02 293:3.3015840e-02 295:8.1591323e-02 "
          "312:5.4654907e-02 327:7.3825479e-02 338:7.2756462e-02 363:5.7283748e-02 371:8.2302988e-02 443:5.7189267e-02 "
          "451:8.0873474e-02 454:1.0915732e-01 460:8.1766613e-02 462:1.7193955e-01 463:8.9925930e-02 478:9.4049156e-02 "
          "481:5.0854217e-02 497:4.9117763e-02 504:6.6977471e-02 511:5.4304615e-02 512:6.3420221e-02 516:5.6716468e-02 "
          "526:8.4113464e-02 533:3.1835914e-02 534:7.4756198e-02 537:9.0908602e-02 540:7.4653611e-02 545:5.3189419e-02 "
          "581:7.2949208e-02 614:6.8330124e-02 760:7.2696671e-02 811:6.9512688e-02 820:5.3072598e-02 842:6.7368932e-02 "
          "856:1.1655242e-01 925:6.8502672e-02 1029:5.1813968e-02 1127:5.7027344e-02 1136:6.3368760e-02 "
          "1212:6.4440101e-02 "
          "1218:4.6570592e-02 1282:6.6921107e-02 1296:7.8099184e-02 1371:7.4759446e-02 1405:2.0247264e-01 "
          "1544:5.7099260e-02 "
          "1598:1.2033819e-01 1643:7.7019095e-02 1690:7.2956130e-02 1726:6.0444500e-02 1756:1.2375571e-01 "
          "1872:8.9416206e-02 "
          "1906:6.0604706e-02 2577:7.6751687e-02 2660:8.9504428e-02 2806:7.1535930e-02 2874:8.1978500e-02 "
          "2949:6.9352180e-02 "
          "3128:1.6631119e-01 3156:9.8261200e-02 3368:6.6941582e-02 3381:1.7298621e-01 3506:9.0002626e-02 "
          "3611:1.1424561e-01 "
          "3840:1.7285609e-01 3956:1.2004261e-01 4953:1.2486731e-01 5083:1.0699926e-01 6697:1.0591225e-01 "
          "6751:1.2146479e-01 "
          "7358:1.2859841e-01 7359:1.3852337e-01 7519:1.2408227e-01 11482:1.3416697e-01 12929:2.9392001e-01 "
          "14119:1.6144532e-01 16028:2.4748370e-01 16059:2.2951299e-01 26806:1.3505866e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 14:5.6446832e-02 15:5.2066214e-02 20:4.1068852e-02 33:1.3344572e-01 51:5.6012399e-02 53:1.1780763e-01 "
          "64:7.8863449e-02 65:1.3436715e-01 70:4.3189108e-02 90:6.7399971e-02 210:6.8409465e-02 234:6.7155212e-02 "
          "271:5.0461087e-02 280:8.4267005e-02 286:6.7994952e-02 293:5.1542643e-02 326:6.3126720e-02 464:5.1391568e-02 "
          "601:1.1041693e-01 774:1.0372401e-01 1012:7.4208468e-02 1014:8.1904903e-02 1071:7.2360694e-02 "
          "1107:1.2095449e-01 "
          "1127:5.2581474e-02 1305:9.6074454e-02 1347:1.2543894e-01 1361:1.9804515e-01 1365:1.4536378e-01 "
          "1394:1.1157343e-01 "
          "1642:1.4962533e-01 1656:2.2037071e-01 1668:9.9809557e-02 1702:2.3425777e-01 1956:1.6000509e-01 "
          "2298:3.5423134e-02 "
          "2376:1.3348933e-01 2689:2.7634206e-01 2693:1.6405082e-01 3203:1.6825619e-01 3530:1.7058820e-01 "
          "4949:3.6378768e-01 "
          "15719:4.6822739e-01 25122:2.1417844e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 13:6.2646717e-02 69:4.3194566e-02 163:1.3666806e-01 166:1.2565793e-01 238:8.4392965e-02 "
                  "284:6.9367662e-02 "
                  "433:1.2462515e-01 549:2.0896430e-01 625:1.1023036e-01 684:1.1389912e-01 739:1.5823035e-01 "
                  "1075:2.8638455e-01 "
                  "1080:1.5451045e-01 2848:1.6503064e-01 3659:1.4969802e-01 4274:1.8012621e-01 11326:4.0185165e-01 "
                  "11465:2.9448813e-01 11772:2.2051105e-01 16872:4.3127707e-01 40090:4.0943465e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 13:6.3963227e-02 17:6.1452683e-02 21:7.2966985e-02 25:6.5123171e-02 32:1.1923736e-01 41:1.0228449e-01 "
          "46:5.6147464e-02 50:3.6594722e-02 51:7.8324497e-02 64:8.5455738e-02 79:5.2705914e-02 80:1.5879945e-01 "
          "101:6.3517004e-02 167:6.8389885e-02 182:5.2120831e-02 217:4.7215145e-02 225:6.5736488e-02 233:3.9050199e-02 "
          "286:8.0568470e-02 332:8.8021658e-02 443:6.8642817e-02 447:1.1137659e-01 459:1.2045257e-01 462:1.8149494e-01 "
          "477:7.0363499e-02 478:6.6671580e-02 480:7.5879946e-02 528:9.3326136e-02 540:1.8804578e-01 545:6.3841902e-02 "
          "560:7.5505361e-02 586:5.4243106e-02 616:6.4075805e-02 620:4.4369806e-02 627:1.2276807e-01 630:7.5574346e-02 "
          "668:1.5306054e-01 670:8.5794285e-02 694:1.5237175e-01 773:5.7275958e-02 820:6.3701682e-02 878:9.6502803e-02 "
          "963:6.7559563e-02 976:8.9974821e-02 992:6.9113404e-02 1202:9.4507024e-02 1239:8.3720148e-02 "
          "1388:1.0132731e-01 "
          "1394:8.5782163e-02 1397:8.0506891e-02 1437:9.9047460e-02 1544:1.4382793e-01 1648:1.1427984e-01 "
          "1653:9.4618335e-02 "
          "1668:1.6104251e-01 1726:7.2549984e-02 1755:8.2171723e-02 1778:1.4637712e-01 1802:9.2597365e-02 "
          "1983:1.1694818e-01 "
          "2007:9.7357653e-02 2016:1.4124693e-01 2640:8.6239442e-02 2792:1.4224488e-01 3271:7.9268083e-02 "
          "4269:1.2424967e-01 "
          "4587:2.0566268e-01 6548:1.2734155e-01 6760:1.2891746e-01 6954:1.5914796e-01 7082:1.6970989e-01 "
          "7792:1.3062592e-01 "
          "17848:2.8013837e-01 27680:3.8594082e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:2.5616324e-02 13:7.0554838e-02 17:7.7077754e-02 20:2.8100086e-02 21:3.8352229e-02 32:1.2065993e-01 "
          "33:4.3507840e-02 50:3.2566972e-02 51:6.9703810e-02 64:8.3161652e-02 80:1.1401722e-01 101:9.5706984e-02 "
          "110:4.4388514e-02 176:7.1658596e-02 209:5.0363660e-02 222:6.8828009e-02 225:5.8501285e-02 233:7.2931372e-02 "
          "271:3.4526434e-02 286:7.1700804e-02 302:5.0276596e-02 312:5.8380608e-02 327:7.8857996e-02 336:5.1580317e-02 "
          "364:4.4604644e-02 376:8.9013241e-02 443:6.1087731e-02 447:9.9118069e-02 451:5.1021222e-02 459:1.0719511e-01 "
          "462:1.3031246e-01 463:5.6732211e-02 466:8.3803810e-02 480:6.7528315e-02 494:5.6548156e-02 509:1.3794871e-01 "
          "526:3.4431662e-02 540:1.9028927e-01 545:9.6196525e-02 547:8.0911510e-02 560:6.7194961e-02 573:4.4928282e-02 "
          "620:3.9486300e-02 627:1.0925577e-01 649:7.9034276e-02 657:8.0518156e-02 679:1.0063938e-01 694:8.0088221e-02 "
          "741:8.9015022e-02 773:5.0971951e-02 811:7.4251212e-02 946:8.1200711e-02 1202:8.4105223e-02 "
          "1388:9.0174846e-02 "
          "1405:1.0305608e-01 1426:5.2830271e-02 1437:8.8145927e-02 1590:1.0989675e-01 1653:1.7671216e-01 "
          "1668:1.1562771e-01 "
          "1726:6.4564869e-02 1762:1.1310451e-01 1778:1.3026631e-01 2016:7.4240901e-02 2068:1.1660907e-01 "
          "2124:1.1410192e-01 "
          "2225:1.2709230e-01 2260:9.5868930e-02 2470:8.3038196e-02 2640:7.6747611e-02 2792:1.2658888e-01 "
          "2851:9.7562648e-02 "
          "2874:8.7566793e-02 3271:1.8407901e-01 4201:1.1058408e-01 4587:1.0809851e-01 5271:1.2625974e-01 "
          "6548:1.1332587e-01 "
          "6760:1.1472832e-01 6772:1.4511348e-01 6954:1.4163154e-01 7082:1.5103099e-01 7792:1.9682622e-01 "
          "17278:1.6185188e-01 17848:2.4930531e-01 27680:3.9054534e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 3:5.8669753e-02 15:3.0047564e-02 17:2.7243517e-02 24:1.4688877e-02 25:4.8882410e-02 36:5.8156043e-02 "
          "55:6.9148898e-02 79:6.6984013e-02 89:8.4752537e-02 103:4.8120316e-02 121:4.6587199e-02 176:6.0440283e-02 "
          "179:3.2569572e-02 182:3.9122663e-02 188:2.0283299e-02 189:6.4413421e-02 230:3.8644522e-02 233:4.9628943e-02 "
          "236:3.2074012e-02 267:5.5554818e-02 269:3.3116326e-02 312:4.9240991e-02 313:5.7962928e-02 336:4.3505300e-02 "
          "365:3.5459399e-02 477:5.2815877e-02 493:6.7671947e-02 526:2.9041309e-02 529:6.1641634e-02 545:4.7920670e-02 "
          "558:8.7256081e-02 586:4.0715676e-02 655:3.3449609e-02 660:3.0528948e-02 664:5.1641960e-02 724:3.8179155e-02 "
          "733:7.2030738e-02 800:8.3782487e-02 802:4.5428328e-02 820:8.0958545e-02 848:5.6594837e-02 871:5.9104629e-02 "
          "897:7.8122206e-02 908:8.3050571e-02 932:4.8802294e-02 1025:5.9336063e-02 1028:3.4467399e-02 "
          "1033:4.8724618e-02 "
          "1040:4.6763189e-02 1059:3.0863635e-02 1085:6.9659553e-02 1086:1.0066838e-01 1127:3.0344922e-02 "
          "1132:4.5032896e-02 "
          "1134:5.4929271e-02 1162:1.2721682e-01 1166:7.2285622e-02 1188:3.9065961e-02 1366:7.8215070e-02 "
          "1503:6.0508810e-02 "
          "1511:5.0828300e-02 1592:1.0019644e-01 1744:7.8060433e-02 1865:6.1367568e-02 1881:6.9170520e-02 "
          "2009:9.2544280e-02 "
          "2090:5.6138515e-02 2098:1.8608221e-01 2099:1.8715620e-01 2246:9.4625220e-02 2453:7.8856535e-02 "
          "2576:7.4153200e-02 "
          "2607:8.1513286e-02 2663:7.7012017e-02 2871:1.5151946e-01 2879:8.7111764e-02 2984:7.6822683e-02 "
          "3068:2.8841230e-01 "
          "3146:7.7929944e-02 3170:8.5307799e-02 3239:9.1109477e-02 3262:8.0413118e-02 3589:9.3288399e-02 "
          "3765:9.0020210e-02 "
          "3863:9.3288399e-02 5719:1.1149309e-01 5947:6.9873765e-02 6051:8.4265843e-02 6125:2.1701829e-01 "
          "6243:9.4172813e-02 "
          "7254:1.3665134e-01 7351:2.0506811e-01 8264:1.1857761e-01 8374:1.8658353e-01 8396:1.8101695e-01 "
          "8497:9.4768122e-02 "
          "10988:1.0687632e-01 12206:1.1857761e-01 14431:1.1644929e-01 18623:1.6222636e-01 22052:1.4015107e-01 "
          "29725:1.3053772e-01 36790:3.9194429e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:3.1473912e-02 9:5.2059948e-02 24:2.1397565e-02 95:8.1753679e-02 110:9.2341997e-02 121:6.7864448e-02 "
          "161:5.3199720e-02 182:9.6493684e-02 183:5.6349788e-02 297:5.7742130e-02 298:6.5853536e-02 319:5.8807369e-02 "
          "326:5.3069159e-02 353:7.8909732e-02 386:2.0178296e-01 423:1.4186886e-01 433:4.8533447e-02 437:7.3661692e-02 "
          "457:1.0423904e-01 464:4.3203697e-02 476:7.9605423e-02 617:6.3141517e-02 645:9.2275739e-02 655:4.8726674e-02 "
          "673:7.3108524e-02 684:1.2715846e-01 757:7.0793718e-02 778:1.2081173e-01 831:1.1435150e-01 837:2.0402378e-01 "
          "848:8.2442768e-02 1060:1.3768728e-01 1073:8.3474241e-02 1102:7.7568866e-02 1235:1.9667311e-01 "
          "1295:8.6614870e-02 "
          "1308:9.1235854e-02 1387:9.3994342e-02 1429:8.9406498e-02 1503:8.8144325e-02 1512:1.4053564e-01 "
          "1645:9.2943639e-02 "
          "1768:1.2993087e-01 2009:1.6709477e-01 2084:1.1309551e-01 2223:9.0078399e-02 2298:2.9779404e-02 "
          "2409:1.0690954e-01 "
          "2453:1.1487180e-01 2548:2.2437645e-01 2550:1.2141022e-01 3128:1.2891401e-01 3298:1.0866936e-01 "
          "3478:2.1013297e-01 "
          "3627:1.6386107e-01 5129:1.5576573e-01 5657:2.3751301e-01 7031:1.4291728e-01 8240:1.2509257e-01 "
          "10897:1.8293658e-01 16275:2.3864718e-01 22422:3.6469769e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 18:4.4368517e-02 39:4.1914042e-02 51:4.1568071e-02 55:3.7263501e-02 64:3.4566604e-02 78:1.5028395e-01 "
          "188:5.4738536e-02 189:1.0266827e-01 213:6.2783897e-02 217:4.5574382e-02 225:6.3452095e-02 229:4.0660962e-02 "
          "230:4.9694732e-02 236:4.1245416e-02 239:5.2008241e-02 271:3.7448313e-02 284:4.0376980e-02 291:7.2473057e-02 "
          "327:5.0516311e-02 417:3.5962299e-02 433:4.2843781e-02 464:3.8138844e-02 573:4.8730448e-02 678:4.7271527e-02 "
          "767:1.3374868e-01 773:5.5285577e-02 799:9.1568425e-02 836:7.0213206e-02 858:5.6032464e-02 898:7.3725730e-02 "
          "988:8.0063701e-02 992:6.6711657e-02 1040:6.0134888e-02 1059:3.9688937e-02 1075:7.9431750e-02 "
          "1121:1.0266401e-01 "
          "1127:3.9021902e-02 1136:7.3416770e-02 1143:8.9363992e-02 1171:7.7764764e-02 1289:2.4790300e-01 "
          "1364:1.1316732e-01 "
          "1417:7.7877097e-02 1455:1.1078867e-01 1914:1.0734566e-01 1974:9.4379857e-02 1984:8.8510923e-02 "
          "2234:6.7969777e-02 "
          "2298:2.6288310e-02 2448:9.4511881e-02 2477:8.3056815e-02 2506:1.5084390e-01 2588:1.0770215e-01 "
          "2933:9.9438220e-02 "
          "3240:9.3111016e-02 3282:9.4621606e-02 3941:1.1672842e-01 4277:1.7590864e-01 6765:1.3338171e-01 "
          "12706:1.2325671e-01 15196:1.8970683e-01 16296:1.4885935e-01 19299:2.0812753e-01 21309:5.4047841e-01 "
          "38114:3.8150764e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:5.0110620e-02 9:4.8953984e-02 24:4.8014529e-02 48:6.9686428e-02 51:4.4278972e-02 52:5.5374004e-02 "
          "55:9.4720796e-02 64:3.6820896e-02 69:2.6782036e-02 70:3.4141894e-02 84:6.2879898e-02 99:7.1185783e-02 "
          "117:5.9706256e-02 130:6.5933987e-02 133:7.1463257e-02 140:5.3649072e-02 144:7.1272798e-02 163:1.4347500e-01 "
          "167:7.0318408e-02 217:4.8546560e-02 218:8.4527940e-02 225:1.1444014e-01 236:7.4388891e-02 257:4.9305618e-02 "
          "269:4.5363046e-02 283:7.4027948e-02 300:8.5709520e-02 302:5.8087688e-02 319:5.5298846e-02 387:8.1332177e-02 "
          "464:4.0626109e-02 481:6.2760256e-02 558:5.6953911e-02 575:1.3144526e-01 638:7.0237428e-02 684:7.0621155e-02 "
          "733:9.8668367e-02 769:7.4695788e-02 774:8.1995994e-02 820:6.5498002e-02 932:6.6849828e-02 954:7.8458183e-02 "
          "964:1.0606791e-01 1000:6.2598690e-02 1193:5.4162860e-02 1282:2.1551017e-01 1417:1.4045660e-01 "
          "1443:1.3599817e-01 "
          "1455:7.6573901e-02 1499:1.1817453e-01 1629:5.5807944e-02 1674:9.6773572e-02 2083:9.4849661e-02 "
          "2203:1.0319836e-01 "
          "2298:2.8002728e-02 3327:1.1348975e-01 3506:1.8806483e-01 4076:1.0696186e-01 4077:2.2925474e-01 "
          "4078:1.1991101e-01 "
          "4256:8.8002503e-02 5223:1.9332863e-01 7511:5.2624375e-01 9196:1.4315459e-01 11943:2.9932427e-01 "
          "12708:1.8259221e-01 20614:1.8992110e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:2.4555020e-02 14:8.8345043e-02 15:3.4148734e-02 17:5.2423164e-02 18:6.6391513e-02 39:6.2718712e-02 "
          "45:9.5313683e-02 51:3.6736924e-02 60:1.0935052e-01 65:8.8127553e-02 67:9.4897248e-02 69:2.2220245e-02 "
          "70:9.6250467e-02 73:4.8352327e-02 140:5.5170257e-02 190:1.0032484e-01 218:4.1420069e-02 231:4.5379940e-02 "
          "232:4.7920391e-02 234:7.4574955e-02 262:6.8743378e-02 269:3.7636347e-02 286:6.2852792e-02 369:7.8832299e-02 "
          "433:9.0355530e-02 476:6.2105812e-02 533:3.2597199e-02 550:4.9856640e-02 620:6.4086221e-02 627:6.1854761e-02 "
          "660:3.4695819e-02 773:4.8860148e-02 814:5.6657568e-02 1000:5.1936243e-02 1071:4.7459297e-02 "
          "1127:5.8391023e-02 "
          "1171:6.8726741e-02 1305:6.3012473e-02 1411:1.3118610e-01 1452:5.6445941e-02 1544:5.8464661e-02 "
          "1583:1.3284311e-01 "
          "1682:1.1077831e-01 1810:7.3927514e-02 1921:1.1756006e-01 2036:1.8682660e-01 2359:9.7053997e-02 "
          "3158:9.8501869e-02 "
          "3477:9.4546013e-02 3520:2.0281479e-01 3599:8.6805575e-02 3793:1.0717977e-01 4378:9.8915227e-02 "
          "4524:3.2215282e-01 "
          "7653:1.9852798e-01 9260:1.3856341e-01 9319:1.6406249e-01 9950:1.2570232e-01 13138:4.0538982e-01 "
          "13140:2.6357689e-01 13141:1.6012470e-01 13142:1.5947199e-01 13143:1.6207166e-01 13144:1.6114460e-01 "
          "13145:1.6236560e-01 14999:1.4300665e-01 37504:2.1142346e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 23:5.0356243e-02 57:5.7067335e-02 73:4.7923204e-02 82:5.8341853e-02 90:4.3813381e-02 "
          "161:1.1484323e-01 "
          "179:7.6990664e-02 188:4.7947343e-02 276:6.7105621e-02 277:3.7047621e-02 312:5.5465195e-02 319:4.5472600e-02 "
          "332:7.4421838e-02 334:9.2333153e-02 489:6.1633896e-02 506:4.3425895e-02 558:9.8285504e-02 564:6.8188109e-02 "
          "573:4.2684656e-02 620:3.7514433e-02 757:5.4740999e-02 795:1.1086615e-01 802:5.1170599e-02 842:3.2577582e-02 "
          "918:8.0591381e-02 941:7.8557380e-02 954:6.4516671e-02 955:1.1069864e-01 992:5.8435008e-02 "
          "1046:6.8950512e-02 "
          "1059:3.4764890e-02 1069:1.1610706e-01 1077:7.4709319e-02 1091:8.0792189e-02 1102:5.9979863e-02 "
          "1123:7.8284390e-02 "
          "1126:8.5281357e-02 1130:7.0526704e-02 1132:8.5885204e-02 1221:7.3670655e-02 1266:6.7454830e-02 "
          "1293:7.8077435e-02 "
          "1295:6.6974655e-02 1342:5.7156101e-02 1398:6.4765334e-02 1426:5.0192032e-02 1440:7.2344705e-02 "
          "1455:3.7189450e-02 "
          "1503:6.8157300e-02 1528:6.8021849e-02 1727:6.3015573e-02 1848:1.1009494e-01 1919:7.7619389e-02 "
          "2008:8.8514045e-02 "
          "2010:1.2313409e-01 2018:6.7963764e-02 2028:1.5651304e-01 2446:1.3433272e-01 2588:9.4339974e-02 "
          "2604:2.1495508e-01 "
          "2605:1.9519000e-01 2611:9.5424756e-02 2612:9.8512605e-02 3010:1.4275436e-01 3282:8.2882278e-02 "
          "3284:1.5352701e-01 "
          "4080:9.5759518e-02 4183:3.5964954e-01 4501:7.2906435e-02 5599:1.3777307e-01 5656:9.2985295e-02 "
          "5707:2.4517189e-01 "
          "5710:1.0526723e-01 6122:1.1689184e-01 7148:1.0874660e-01 8361:9.9703707e-02 8478:1.1640593e-01 "
          "8497:1.0674709e-01 "
          "9628:2.9072931e-01 11128:2.4012716e-01 11820:1.4897515e-01 18855:1.2830982e-01 19075:1.3817447e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 13:8.9665808e-02 17:1.2141340e-01 64:1.0535277e-01 125:1.8038677e-01 183:7.2243035e-02 "
          "222:1.0841835e-01 "
          "259:7.3404342e-02 286:7.3284030e-02 511:9.1372140e-02 527:1.4643835e-01 533:5.3566638e-02 545:8.9495726e-02 "
          "546:8.2182400e-02 578:1.0857073e-01 627:1.0164528e-01 773:1.3594513e-01 811:6.9079056e-02 866:1.0968195e-01 "
          "1452:1.9466104e-01 1535:2.8427854e-01 2094:1.3207419e-01 2298:3.8178574e-02 2360:1.1274592e-01 "
          "2841:2.9616743e-01 "
          "6952:4.1697928e-01 6953:3.2880306e-01 8494:1.9394566e-01 10849:2.5320274e-01 19597:2.7614805e-01 "
          "37682:3.2096243e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:2.4361879e-02 20:3.4476139e-02 23:3.8407639e-02 24:2.6483713e-02 26:3.3157058e-02 42:8.3407380e-02 "
          "49:2.7023993e-02 55:5.2245822e-02 69:1.6797381e-02 72:4.9102213e-02 74:3.2726571e-02 75:4.1210141e-02 "
          "84:3.9437540e-02 87:9.8466940e-02 179:2.7981445e-02 188:4.5471951e-02 193:3.5803754e-02 195:6.8033420e-02 "
          "208:7.3297501e-02 209:3.6495015e-02 210:3.3917788e-02 224:5.3196575e-02 231:5.8083311e-02 233:4.2637635e-02 "
          "236:6.5756001e-02 238:3.2818500e-02 240:4.9063884e-02 247:4.8504300e-02 258:8.6794250e-02 269:6.7892872e-02 "
          "271:2.5018884e-02 291:4.8418600e-02 293:2.5555126e-02 296:3.8951758e-02 298:3.8838409e-02 305:3.5516039e-02 "
          "306:5.3092852e-02 319:3.4682792e-02 320:8.6281292e-02 321:4.5242559e-02 342:4.2250272e-02 349:4.2808749e-02 "
          "354:6.5832496e-02 389:8.5691780e-02 422:1.0645232e-01 433:2.8623547e-02 444:9.0538405e-02 459:4.5877159e-02 "
          "494:4.0976483e-02 575:3.9283548e-02 577:6.6623248e-02 623:4.2519379e-02 644:3.3924725e-02 670:5.5326540e-02 "
          "679:7.2926305e-02 684:4.4292770e-02 769:4.6848331e-02 783:1.0510413e-01 789:1.4484234e-01 801:6.5480009e-02 "
          "802:2.3051016e-02 815:4.6856545e-02 836:7.9423524e-02 851:6.5275520e-02 927:4.4601381e-02 932:4.1927435e-02 "
          "953:5.1899739e-02 1063:6.8184733e-02 1094:4.3584373e-02 1122:3.1873979e-02 1125:5.9775200e-02 "
          "1162:4.5801383e-02 "
          "1188:3.3562675e-02 1196:4.5349140e-02 1213:2.6666015e-02 1226:7.8480363e-02 1234:6.4135090e-02 "
          "1237:4.7354218e-02 "
          "1347:6.2193315e-02 1397:5.1916834e-02 1421:5.8871739e-02 1454:3.6649100e-02 1476:8.4735341e-02 "
          "1511:4.3668035e-02 "
          "1528:5.1881526e-02 1556:5.3261124e-02 1589:9.9162623e-02 1619:1.6945003e-01 1721:7.8512236e-02 "
          "1827:9.5465869e-02 "
          "1840:7.0520833e-02 1894:9.6751340e-02 1937:6.8057723e-02 2025:1.9875330e-01 2028:1.0498398e-01 "
          "2061:6.2014662e-02 "
          "2097:5.0074942e-02 2291:7.1279019e-02 2338:5.3418670e-02 2533:1.0902175e-01 2556:6.5859266e-02 "
          "2558:7.9476781e-02 "
          "2582:2.2179939e-01 2586:1.3017152e-01 2688:7.4482083e-02 2908:6.9116421e-02 3008:4.9876831e-02 "
          "3013:5.5095766e-02 "
          "3302:6.8817161e-02 3386:1.7305978e-01 3603:7.7880703e-02 3829:1.0181555e-01 3844:1.3291118e-01 "
          "3845:1.0534944e-01 "
          "3849:2.4820413e-01 3850:2.1651246e-01 4099:6.1238479e-02 4549:1.2710826e-01 4960:8.2627408e-02 "
          "5991:7.2205223e-02 "
          "5999:6.8671361e-02 6881:1.0264567e-01 7795:8.4007852e-02 8862:1.2496292e-01 9063:1.0671701e-01 "
          "10487:2.6917657e-01 11953:1.1550321e-01 12678:8.5650057e-02 14000:1.2432995e-01 14441:1.4635567e-01 "
          "15118:1.1143283e-01 15194:1.1539851e-01 16203:1.1571475e-01 18905:1.0909086e-01 24254:1.4092743e-01 "
          "26274:1.1920506e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 17:1.6157839e-02 18:2.0463156e-02 23:2.6514268e-02 24:1.4750388e-02 25:2.8991636e-02 45:2.7348451e-02 "
          "50:1.6291296e-02 51:2.7020093e-02 54:1.5127296e-02 55:3.6067296e-02 63:3.0256810e-02 70:1.4782491e-02 "
          "82:3.0718964e-02 89:2.9687805e-02 98:2.7412841e-02 131:5.2627660e-02 138:4.6589557e-02 147:2.2408165e-02 "
          "169:2.3268877e-02 175:4.9181297e-02 182:2.3203233e-02 184:3.1618983e-02 188:2.5245901e-02 225:4.9549401e-02 "
          "230:2.2919653e-02 241:7.5248457e-02 251:6.1244640e-02 252:3.6117882e-02 259:2.3311080e-02 267:3.2948971e-02 "
          "271:1.7271496e-02 276:6.6721179e-02 293:3.7023056e-02 297:3.9804474e-02 298:2.6811644e-02 311:2.7816024e-02 "
          "334:4.8616536e-02 342:2.9166985e-02 353:3.2127354e-02 354:2.6841555e-02 357:5.7396740e-02 368:3.6853127e-02 "
          "370:2.9970441e-02 380:2.8782716e-02 389:3.4938682e-02 390:3.9756019e-02 397:4.1453369e-02 422:9.1086634e-02 "
          "428:3.4586489e-02 433:1.9759934e-02 474:3.7911639e-02 480:5.7195108e-02 506:2.2865206e-02 516:3.0305881e-02 "
          "575:4.5916360e-02 585:8.2195036e-02 587:2.8474556e-02 655:4.1633543e-02 690:5.3207133e-02 693:3.8591079e-02 "
          "696:4.7244642e-02 723:6.2635310e-02 727:1.3699055e-01 747:5.1382266e-02 802:1.5913002e-02 817:7.6332480e-02 "
          "825:5.6618009e-02 842:3.5997916e-02 910:3.6597382e-02 953:6.0662728e-02 954:3.3970214e-02 955:3.4424998e-02 "
          "967:3.5337016e-02 972:5.1658113e-02 1033:2.8898049e-02 1038:3.4261163e-02 1040:7.2372101e-02 "
          "1059:4.3680862e-02 "
          "1066:4.0397227e-02 1077:3.9336991e-02 1091:4.2539828e-02 1099:5.5939518e-02 1106:5.0755002e-02 "
          "1110:3.2480158e-02 "
          "1122:2.2003831e-02 1132:2.6708530e-02 1133:6.4413123e-02 1136:3.3860467e-02 1162:3.1618454e-02 "
          "1174:1.1928816e-01 "
          "1188:2.3169605e-02 1189:3.0340130e-02 1191:4.2265922e-02 1196:5.3006094e-02 1213:4.8036031e-02 "
          "1215:4.0342446e-02 "
          "1221:3.8790096e-02 1234:4.4274915e-02 1238:4.1466706e-02 1240:2.9448500e-02 1280:3.7933651e-02 "
          "1287:4.5113746e-02 "
          "1311:4.1177090e-02 1426:5.5461716e-02 1452:2.9456932e-02 1479:4.0945847e-02 1492:3.5447221e-02 "
          "1510:3.6684789e-02 "
          "1538:6.2496979e-02 1554:5.3614251e-02 1580:4.0324446e-02 1589:6.8455771e-02 1594:4.1840844e-02 "
          "1642:5.1212799e-02 "
          "1658:3.5613921e-02 1774:4.1394886e-02 1800:4.4851154e-02 1832:5.4094791e-02 1839:5.1090319e-02 "
          "1998:6.5274939e-02 "
          "2024:3.8471013e-02 2065:3.5949774e-02 2146:4.5089345e-02 2186:4.5397431e-02 2229:4.2024162e-02 "
          "2234:3.1348266e-02 "
          "2362:4.1053642e-02 2446:7.0730723e-02 2472:5.5151056e-02 2509:4.4591293e-02 2519:4.6065263e-02 "
          "2557:1.1446991e-01 "
          "2564:6.4825624e-02 2577:4.1011501e-02 2760:5.3945333e-02 2852:5.6861222e-02 2871:4.2820949e-02 "
          "3199:5.4248597e-02 "
          "3214:8.8089675e-02 3244:1.3200054e-01 3298:4.4243701e-02 3358:4.9237031e-02 3380:1.2193784e-01 "
          "3392:1.2079871e-01 "
          "3570:4.4299252e-02 3597:4.4419158e-02 3745:4.9400087e-02 3822:6.7421511e-02 3910:1.0704347e-01 "
          "3970:5.8759704e-02 "
          "4353:5.7809904e-02 4404:5.7574522e-02 4823:1.2247636e-01 5095:6.4450294e-02 5506:7.5883336e-02 "
          "5728:5.7828464e-02 "
          "5766:6.6474907e-02 6063:5.6595922e-02 6198:5.5119794e-02 6200:5.3504985e-02 6300:1.7682716e-01 "
          "6876:6.4484932e-02 "
          "7056:6.1913613e-02 7759:1.9671187e-01 8318:5.1340070e-02 8371:6.9518536e-02 8414:5.9019651e-02 "
          "8545:6.8906106e-02 "
          "8728:6.4577833e-02 8934:1.3189568e-01 8942:7.7439994e-02 9086:2.2448486e-01 9087:2.2275636e-01 "
          "9091:1.1490481e-01 "
          "9287:8.9408137e-02 9288:2.1482499e-01 9555:6.3645869e-02 10225:5.4786440e-02 11891:7.8832917e-02 "
          "12332:6.5091543e-02 12483:6.6728741e-02 16652:8.4502995e-02 17451:8.2018852e-02 17452:8.2139313e-02 "
          "17797:8.6957686e-02 18528:7.2529890e-02 18580:7.7000916e-02 18867:2.1321160e-01 18882:1.8085392e-01 "
          "18934:1.8959132e-01 18935:7.9664022e-02 21372:9.8621920e-02 36288:2.5964507e-01 36981:1.1169640e-01 "
          "45022:8.6446628e-02")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 14:6.4467840e-02 111:1.0167994e-01 140:9.6070483e-02 170:9.0105437e-02 188:4.0141065e-02 "
          "196:2.0841956e-01 "
          "277:6.5090381e-02 349:9.8610863e-02 693:1.2877072e-01 702:7.7960022e-02 724:7.5557336e-02 733:1.4255030e-01 "
          "809:1.5161760e-01 811:1.2394014e-01 812:1.3452463e-01 813:3.6554593e-01 837:1.7984694e-01 "
          "1073:1.1340365e-01 "
          "1080:1.3840842e-01 1185:3.6291966e-01 1363:1.3725269e-01 1653:2.9496798e-01 1837:1.1378536e-01 "
          "2026:1.3799623e-01 "
          "2191:2.3809795e-01 2558:1.8307644e-01 7274:2.6464102e-01 7319:2.1589431e-01 20718:2.4722189e-01 "
          "23329:2.6174015e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 13:7.1981162e-02 64:1.1553010e-01 104:2.4291268e-01 133:2.2422476e-01 257:9.1369763e-02 "
                  "426:1.4895077e-01 "
                  "587:1.2187174e-01 655:8.4909670e-02 724:1.6409191e-01 746:2.2812758e-01 911:1.3547872e-01 "
                  "1351:2.2587050e-01 "
                  "1546:2.0944844e-01 2298:5.1892716e-02 2493:3.1848466e-01 2720:2.9111224e-01 3144:1.6996248e-01 "
                  "4733:4.5726046e-01 "
                  "9922:3.2260084e-01 13616:3.1058770e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 20:3.5426963e-02 24:3.7175037e-02 45:1.0622653e-01 50:1.0713975e-01 85:6.6110238e-02 "
          "125:6.8795666e-02 "
          "130:1.2181818e-01 142:2.3430778e-01 188:3.0318428e-02 233:4.3813545e-02 257:9.1095962e-02 325:1.3723950e-01 "
          "337:6.6288449e-02 354:1.4196715e-01 364:5.6234952e-02 488:8.3705150e-02 497:1.1199509e-01 514:7.1743347e-02 "
          "522:1.0490222e-01 655:4.9998745e-02 936:1.8560193e-01 1188:5.8393784e-02 1425:9.5533311e-02 "
          "1906:8.1615396e-02 "
          "1931:2.5374830e-01 3425:1.4394051e-01 3869:1.4341305e-01 3936:1.4939938e-01 4674:1.3950446e-01 "
          "5231:1.6672216e-01 "
          "5373:3.7757310e-01 5806:1.3061146e-01 6912:1.4367189e-01 7004:1.3606028e-01 7531:1.2569965e-01 "
          "10193:1.5232466e-01 10597:1.3449588e-01 11081:1.5037350e-01 11418:1.7424211e-01 11648:4.8068807e-01 "
          "11649:1.7627829e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 166:2.2369288e-02 175:5.9315063e-02 179:1.2809139e-02 187:2.2414200e-02 228:2.4566401e-02 "
          "252:1.4145401e-02 "
          "415:1.9203765e-02 462:2.5530377e-02 463:4.9106922e-02 660:1.2006590e-02 741:4.9994711e-02 755:2.5619375e-02 "
          "897:1.8146280e-02 923:3.7803620e-02 989:3.3705126e-02 1067:6.3129060e-02 1100:2.8590225e-02 "
          "1325:3.5646044e-02 "
          "1350:2.5973443e-02 1383:2.1365510e-02 1429:2.4137994e-02 1449:3.6533657e-02 1456:2.5252182e-02 "
          "1831:3.0307429e-02 "
          "1894:2.6158454e-02 1932:6.6655390e-02 2016:2.4626872e-02 2031:2.9543621e-02 2032:5.8213379e-02 "
          "2094:1.0121276e-01 "
          "2104:4.2566307e-02 2117:6.7182004e-02 2123:2.7560681e-02 2298:8.0398535e-03 2813:1.1767147e-01 "
          "2842:5.6758922e-02 "
          "2869:3.1999189e-02 2953:6.4843677e-02 3034:1.6319405e-01 3269:6.1024886e-02 3358:3.2649729e-02 "
          "3368:2.3719279e-02 "
          "3425:3.7872396e-02 3507:1.0099120e-01 3677:4.5226544e-02 3686:1.1187834e-01 4025:3.9907329e-02 "
          "4101:4.1764829e-02 "
          "4299:4.2646732e-02 5310:6.0401548e-02 5324:7.7132873e-02 6081:5.4134257e-02 6302:6.4187646e-02 "
          "6473:5.3635053e-02 "
          "7693:8.0200784e-02 7755:4.1110165e-02 8026:3.7084721e-02 8051:4.5762550e-02 8068:5.7919882e-02 "
          "8746:9.8159000e-02 "
          "9474:5.6316331e-02 9811:3.9710395e-02 10823:5.0604101e-02 10972:4.9658701e-02 11092:5.5230349e-02 "
          "11093:5.0077733e-02 11120:9.9291071e-02 11121:7.1418628e-02 11220:5.4020237e-02 11267:4.4763863e-02 "
          "11565:1.0225162e-01 11790:5.1390368e-02 12427:4.7200680e-02 12465:1.6279697e-01 12737:1.4343330e-01 "
          "12903:5.5365864e-02 13799:5.0465941e-02 14181:6.3293517e-02 14492:4.6741758e-02 14518:4.8515435e-02 "
          "14523:1.1336754e-01 14529:9.9352613e-02 14532:4.7143437e-02 14684:5.4230697e-02 14720:2.3659725e-01 "
          "14838:1.5381865e-01 14852:5.6886509e-02 15231:4.2620376e-02 15456:6.0357597e-02 16048:1.6729310e-01 "
          "17902:5.4548465e-02 18011:4.9272750e-02 18531:6.3579172e-02 19609:5.8463931e-02 20217:7.0203803e-02 "
          "20354:9.3937181e-02 20477:5.2172810e-02 21572:9.0367042e-02 21573:5.3185523e-02 21574:5.3564008e-02 "
          "21576:6.2075004e-02 21577:6.2193818e-02 21578:1.6462313e-01 21579:6.0130280e-02 21580:5.9448391e-02 "
          "21581:5.9781116e-02 21582:1.2114492e-01 21583:1.5251434e-01 21585:1.0658691e-01 21587:7.4396230e-02 "
          "21588:5.0627396e-02 21589:1.9557379e-01 21590:1.8860839e-01 21594:1.1301569e-01 21599:9.5003620e-02 "
          "21602:1.1368744e-01 21605:6.1138425e-02 21606:5.7599962e-02 21638:1.2919849e-01 21647:5.3372230e-02 "
          "21650:5.5320404e-02 21657:6.1242390e-02 21846:5.3286750e-02 22557:9.3627281e-02 25917:5.9530113e-02 "
          "27112:1.3358177e-01 28817:6.2193818e-02 28859:5.4115124e-02 30084:5.8220740e-02 30088:5.6528155e-02 "
          "30089:9.6174456e-02 30093:6.4187646e-02 30096:9.0781853e-02 30098:6.0985304e-02 30099:6.0041357e-02 "
          "30100:5.9997313e-02 30258:6.6743135e-02 35094:9.3627281e-02 35892:6.7590028e-02 36105:9.4540790e-02 "
          "36686:6.9329962e-02 37838:5.7662800e-02 37839:6.1035972e-02 37845:6.8406597e-02 37846:7.5485937e-02 "
          "37847:6.1509181e-02 37850:6.4941280e-02 37851:1.2819797e-01 37852:6.2499888e-02 37853:6.4030543e-02 "
          "37854:5.7475943e-02 37855:6.9496304e-02 37858:1.0530329e-01 37860:1.0442354e-01 37866:9.8518610e-02 "
          "37867:1.0251138e-01 37869:5.6802183e-02 37904:5.7631310e-02 40965:5.6290295e-02 40966:6.6301174e-02 "
          "40967:5.7323910e-02 41078:6.1900452e-02 43118:5.8752507e-02 43475:5.7919882e-02 44021:5.9091888e-02 "
          "44022:9.6127242e-02 44026:5.6971852e-02 44070:6.2754661e-02 46252:6.3726455e-02 46254:1.0165885e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("1 |f 16:1.5060583e-01 46:1.3485394e-01 140:7.4015707e-02 365:1.1346130e-01 438:1.4975387e-01 "
                  "469:2.9644275e-01 "
                  "555:1.1700530e-01 616:1.5389608e-01 1239:2.0107751e-01 1666:1.1178005e-01 1765:1.4704677e-01 "
                  "1823:4.0947297e-01 "
                  "2345:4.1635984e-01 2521:1.8996072e-01 2523:2.1778291e-01 3841:1.6806963e-01 22697:5.1552552e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:9.5310286e-02 19:1.3974650e-01 53:1.7713191e-01 86:2.8963685e-01 99:2.2924401e-01 169:1.7306933e-01 "
          "349:2.1980585e-01 668:2.9933012e-01 669:4.3729487e-01 820:2.1092729e-01 1000:2.0159046e-01 "
          "1186:2.8100756e-01 "
          "1556:2.7347463e-01 3533:3.3254439e-01 5947:3.0823284e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:7.2837725e-02 15:4.8267905e-02 17:4.3763533e-02 24:3.9951447e-02 49:8.5553020e-02 50:4.4125002e-02 "
          "51:3.0668456e-02 69:5.3177439e-02 70:6.7790896e-02 73:4.0365145e-02 79:6.3551471e-02 80:9.1239542e-02 "
          "110:6.0142010e-02 200:1.0882857e-01 217:5.6930840e-02 218:5.8545657e-02 220:7.7920116e-02 231:6.4142779e-02 "
          "233:4.7085751e-02 288:5.0224140e-02 293:4.7782529e-02 295:6.9742270e-02 302:6.8119779e-02 326:5.8521528e-02 "
          "337:7.1239181e-02 338:1.0529758e-01 339:5.7811409e-02 417:4.4923566e-02 505:2.2945575e-01 547:6.4747490e-02 "
          "684:8.2817852e-02 702:6.3280642e-02 726:7.5221464e-02 842:4.6459470e-02 930:1.6891181e-01 984:9.0994075e-02 "
          "1033:1.3252333e-01 1075:9.9224955e-02 1140:1.4347365e-01 1193:6.3517109e-02 1288:7.7486254e-02 "
          "1449:8.8133238e-02 "
          "1477:1.0878696e-01 1654:1.1842968e-01 1657:1.4601213e-01 1776:8.7629229e-02 1921:9.8140649e-02 "
          "1999:1.6166395e-01 "
          "2107:8.8473946e-02 2153:7.6402694e-02 2228:1.5383309e-01 2298:3.2838963e-02 2349:1.0959633e-01 "
          "2506:8.9788824e-02 "
          "2769:1.2217538e-01 2970:1.4263000e-01 4072:1.9588663e-01 4077:1.1266355e-01 4459:1.2724708e-01 "
          "4488:1.7338629e-01 "
          "10660:5.7738906e-01 15026:2.1171205e-01 15150:2.1310103e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:4.3958109e-02 13:2.7490620e-02 14:3.1580910e-02 15:4.9321443e-02 17:2.6411617e-02 21:3.1360324e-02 "
          "35:4.1046944e-02 51:3.1337854e-02 59:1.8135990e-01 60:7.5257510e-02 63:4.9457803e-02 64:7.2751857e-02 "
          "67:1.2475913e-01 70:7.4409992e-02 73:2.4360664e-02 79:3.8353786e-02 131:5.0807878e-02 140:2.2425352e-02 "
          "144:5.0442375e-02 222:5.6280140e-02 223:6.0582493e-02 232:6.9212019e-02 255:9.5342144e-02 257:3.4895398e-02 "
          "269:5.4358643e-02 286:5.8629204e-02 311:4.5468096e-02 405:7.8745760e-02 451:8.7553404e-02 503:7.7624463e-02 "
          "550:4.2529419e-02 574:6.3380890e-02 627:5.2764229e-02 637:1.0609768e-01 644:3.8281597e-02 802:4.4041138e-02 "
          "814:1.1533163e-01 866:5.6936078e-02 1127:2.9418318e-02 1145:1.1448679e-01 1213:3.0090671e-02 "
          "1305:5.3751796e-02 "
          "1682:5.5811856e-02 1721:8.8595383e-02 1844:1.7780794e-01 2007:1.4867954e-01 2080:6.2382322e-02 "
          "2249:1.2157840e-01 "
          "2298:1.9818557e-02 2524:1.6029903e-01 4389:1.2127040e-01 6177:1.8351804e-01 9104:2.2973095e-01 "
          "9551:4.5116875e-01 "
          "9552:2.4014360e-01 9553:2.2305939e-01 9554:2.4415736e-01 10394:2.8145981e-01 10817:3.1014943e-01 "
          "12788:1.2550271e-01 16464:1.4664307e-01 20721:1.1273442e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:3.0117968e-02 13:3.9527871e-02 16:6.5610908e-02 18:4.8095360e-02 20:3.3038210e-02 26:5.3798307e-02 "
          "49:4.3847229e-02 50:3.8290076e-02 55:9.6390881e-02 77:9.6897937e-02 81:7.3673002e-02 95:7.8231610e-02 "
          "106:6.4171068e-02 130:6.7096516e-02 136:6.3243568e-02 161:5.0907794e-02 169:5.4689758e-02 183:5.3922154e-02 "
          "188:2.8274132e-02 209:5.9214238e-02 217:1.6786459e-01 218:5.0803799e-02 230:9.1208093e-02 239:5.6376804e-02 "
          "240:7.9607598e-02 252:8.4889278e-02 282:9.2792727e-02 297:5.5254512e-02 309:7.0611991e-02 337:6.1818782e-02 "
          "347:6.8357185e-02 393:7.5654924e-02 468:8.5646555e-02 553:6.0171138e-02 586:5.6756072e-02 590:3.1021634e-01 "
          "603:1.1235283e-01 613:4.1791797e-02 655:4.6627454e-02 660:4.2556170e-02 673:6.9958895e-02 684:1.2168027e-01 "
          "773:5.9929427e-02 882:8.6224712e-02 898:7.9918504e-02 932:6.8028502e-02 984:1.6570927e-01 993:2.0213698e-01 "
          "1040:6.5186068e-02 1045:7.4004717e-02 1102:7.4227080e-02 1124:9.6761830e-02 1173:1.0676201e-01 "
          "1247:1.4007045e-01 "
          "1282:1.4230041e-01 1312:1.0529293e-01 1338:9.6034355e-02 1372:1.1346246e-01 1449:1.9956678e-01 "
          "1455:4.6023183e-02 "
          "1623:6.8611257e-02 1696:1.2445514e-01 1910:9.3551248e-02 2016:8.7287508e-02 2066:2.0038271e-01 "
          "2122:8.9149073e-02 "
          "2190:8.6079910e-02 2269:2.2385880e-01 2495:9.0110451e-02 2526:9.6815266e-02 2538:9.3117639e-02 "
          "2942:9.6778616e-02 "
          "3008:8.0926634e-02 3206:1.0776239e-01 3230:2.6422054e-01 3533:1.0508373e-01 5702:1.4143851e-01 "
          "6005:1.0761378e-01 "
          "6047:1.2348396e-01 6120:1.1422234e-01 7136:1.4062630e-01 7761:1.2206708e-01 8040:1.3132772e-01 "
          "12002:1.5303040e-01 20705:1.9861072e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 9:5.4797787e-02 22:9.6535370e-02 23:1.1606181e-01 40:1.0423626e-01 45:4.1759279e-02 54:6.6217221e-02 "
          "55:4.4432048e-02 95:8.6053118e-02 98:7.0871070e-02 115:1.1303246e-01 147:5.7932366e-02 182:5.9987873e-02 "
          "188:3.1100949e-02 189:5.8333322e-02 221:7.3521264e-02 240:5.1718295e-02 276:5.3951744e-02 280:7.4566863e-02 "
          "344:8.7075174e-02 371:1.1369681e-01 433:5.1085830e-02 464:4.5475785e-02 497:6.7853339e-02 526:4.4529848e-02 "
          "678:5.6365360e-02 802:4.1140262e-02 953:9.2627972e-02 1166:1.1083756e-01 1171:9.2724711e-02 "
          "1224:1.4445771e-01 "
          "1235:8.6752146e-02 1245:1.3230714e-01 1399:8.7599501e-02 1538:9.5428757e-02 1674:6.3978940e-02 "
          "3008:8.9017592e-02 "
          "3010:2.4086194e-01 3188:8.5875131e-02 3597:1.1483791e-01 3678:1.4251493e-01 4609:2.3836443e-01 "
          "4639:2.6773477e-01 "
          "5241:1.4791887e-01 5602:1.4596452e-01 6063:1.4631878e-01 6319:1.2656675e-01 6564:1.4788111e-01 "
          "8254:1.6751817e-01 "
          "8433:2.9844129e-01 8435:2.0696881e-01 8440:1.6116884e-01 8441:2.1204530e-01 8442:3.5928679e-01 "
          "10924:1.4664155e-01 13810:1.5943980e-01 18948:1.5675148e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:2.1553624e-02 14:3.2496616e-02 22:6.2805362e-02 24:1.4653249e-02 51:1.9045310e-02 55:7.5431637e-02 "
          "64:2.6815113e-02 70:2.4864106e-02 79:3.9465878e-02 172:1.5554368e-01 179:3.2490574e-02 188:5.6488741e-02 "
          "217:3.5354421e-02 218:6.1558150e-02 224:7.6561138e-02 229:5.3406645e-02 238:6.4520940e-02 259:3.9209168e-02 "
          "268:7.0806734e-02 277:8.5616775e-02 282:6.6406190e-02 284:3.1322524e-02 296:4.5228720e-02 298:4.5097105e-02 "
          "302:4.2302825e-02 305:4.1239347e-02 327:3.9188132e-02 382:2.3305613e-01 417:2.7897827e-02 428:5.8174372e-02 "
          "533:2.8612796e-02 555:3.6478285e-02 561:6.0075089e-02 575:4.5613982e-02 645:6.3191272e-02 653:7.8062795e-02 "
          "660:3.0454898e-02 702:3.9297689e-02 726:7.9092011e-02 802:4.5318138e-02 815:5.4407343e-02 926:8.4093899e-02 "
          "965:4.7480900e-02 986:2.2971520e-01 990:2.3242559e-01 992:5.1751707e-02 1012:4.2722046e-02 "
          "1032:6.4865574e-02 "
          "1040:4.6649761e-02 1051:7.7959590e-02 1188:3.8971204e-02 1213:3.0963169e-02 1235:5.6440458e-02 "
          "1276:2.0680168e-01 "
          "1297:8.1517816e-02 1355:7.9988129e-02 1406:9.7241290e-02 1434:6.1247334e-02 1449:9.2668176e-02 "
          "1609:8.9134432e-02 "
          "1650:7.7416107e-02 1761:1.1088559e-01 1796:1.4765410e-01 1823:2.5619426e-01 1837:9.7112730e-02 "
          "1972:6.3643865e-02 "
          "2088:1.0606514e-01 2234:5.2727692e-02 2298:2.0393210e-02 2349:6.8060033e-02 2769:7.5871706e-02 "
          "2992:7.7941857e-02 "
          "3046:9.7070858e-02 3164:7.4111670e-02 3195:8.0025911e-02 3484:2.2129725e-01 5589:1.0627819e-01 "
          "5739:1.0010530e-01 "
          "5863:1.6943109e-01 6005:1.3039389e-01 6159:8.9071676e-02 6507:7.5347237e-02 6582:3.3553860e-01 "
          "6862:1.1062043e-01 "
          "9706:1.5760425e-01 10471:2.3614560e-01 11977:1.2251969e-01 13338:1.5657935e-01 14288:1.6183287e-01 "
          "40853:1.5494815e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 74:1.4902481e-01 166:1.3142130e-01 189:8.7902881e-02 225:1.1401055e-01 233:6.7726992e-02 "
          "236:7.4109651e-02 "
          "239:9.3448266e-02 271:6.7287028e-02 349:1.1513197e-01 545:1.1072466e-01 547:9.3131207e-02 573:8.7558731e-02 "
          "771:1.9760321e-01 858:1.7046431e-01 1160:1.2722576e-01 1240:1.1472671e-01 1272:3.7008139e-01 "
          "1383:1.2552403e-01 "
          "1397:1.3962771e-01 1503:1.3981059e-01 1670:1.1517876e-01 1726:1.2582760e-01 2079:2.6864064e-01 "
          "2762:1.6724491e-01 "
          "2846:3.0751446e-01 3106:2.9097906e-01 3659:1.5656400e-01 6911:3.2804856e-01 40562:3.8050953e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 14:1.1274514e-01 16:9.6213408e-02 32:8.7178119e-02 46:8.6150430e-02 49:6.4298630e-02 51:3.9025906e-02 "
          "140:4.7284380e-02 170:9.3070269e-02 238:7.8085594e-02 326:7.4469209e-02 426:1.1994631e-01 437:1.0336564e-01 "
          "443:1.7832702e-01 482:1.3543579e-01 547:8.2391806e-02 555:7.4747957e-02 573:7.7461921e-02 724:7.8043476e-02 "
          "842:5.9120122e-02 869:3.2438478e-01 2090:1.1475488e-01 2200:3.3189762e-01 2493:9.8284639e-02 "
          "2506:1.1425714e-01 "
          "2512:1.8409124e-01 2515:1.4014906e-01 2553:3.1469002e-01 2878:1.6701224e-01 3841:1.0737003e-01 "
          "6750:1.9770351e-01 "
          "10097:2.7905267e-01 14559:2.4764159e-01 16847:4.5837066e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:5.2399036e-02 13:4.8794594e-02 35:4.3030191e-02 36:5.9104305e-02 45:2.7678477e-02 49:3.1968020e-02 "
          "50:2.7916426e-02 70:2.5330968e-02 126:4.6528880e-02 133:5.3020887e-02 146:6.7612313e-02 151:7.1248427e-02 "
          "169:3.9873060e-02 179:6.9465406e-02 188:3.4902580e-02 212:1.6067602e-01 271:2.9596075e-02 286:2.3553720e-02 "
          "288:5.3800009e-02 293:5.1184554e-02 296:4.6077963e-02 323:5.3556912e-02 415:1.0414418e-01 426:1.0097076e-01 "
          "506:6.6339776e-02 617:4.4051785e-02 620:3.3847678e-02 644:4.0131237e-02 646:6.3733287e-02 764:5.1672898e-02 "
          "817:6.2327735e-02 932:4.9598038e-02 933:5.9656996e-02 987:7.9140007e-02 1005:5.7153493e-02 "
          "1014:4.8038278e-02 "
          "1028:3.5029404e-02 1033:4.9519096e-02 1059:3.1366881e-02 1188:3.9702952e-02 1189:5.1990215e-02 "
          "1383:5.5211518e-02 "
          "1500:6.9619022e-02 1511:5.1657081e-02 1688:7.2289720e-02 1702:6.5469541e-02 1717:1.8198669e-01 "
          "1933:1.9337599e-01 "
          "2298:2.0776125e-02 2495:6.5697484e-02 2509:7.6410711e-02 2795:7.8964666e-02 3342:1.1957579e-01 "
          "3459:8.2360573e-02 "
          "3582:9.3303792e-02 4033:2.2265546e-01 4035:2.2276157e-01 4038:1.5079491e-01 4080:1.4628747e-01 "
          "4081:3.5616681e-01 "
          "4083:1.5597261e-01 4084:1.5573537e-01 4085:1.6107123e-01 4170:2.0180480e-01 4194:1.4988287e-01 "
          "5458:2.0474730e-01 "
          "7241:9.7407155e-02 13279:2.4732950e-01 16197:2.6617524e-01 16198:2.9285574e-01 16997:1.5459327e-01 "
          "24393:1.4337030e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 13:3.5121266e-02 14:4.0346909e-02 24:1.8193074e-02 47:7.4771158e-02 48:1.0668425e-01 49:6.5963492e-02 "
          "54:3.1590655e-02 63:6.3185945e-02 69:7.4571513e-02 70:8.6183265e-02 73:3.1122522e-02 84:9.6263997e-02 "
          "87:1.0072111e-01 90:4.8175968e-02 101:5.9050631e-02 107:5.8293030e-02 111:6.3635938e-02 140:7.9983957e-02 "
          "142:8.1360213e-02 165:8.4661856e-02 170:5.6392085e-02 171:7.9961181e-02 180:6.1704691e-02 184:6.6030599e-02 "
          "188:2.5122106e-02 196:7.7039048e-02 230:8.1040129e-02 231:8.3735719e-02 234:4.8001017e-02 247:6.9926150e-02 "
          "252:4.4547658e-02 283:6.6934973e-02 311:9.8352887e-02 338:8.1187032e-02 342:6.0910039e-02 357:7.0792928e-02 "
          "358:8.1783853e-02 360:6.9658242e-02 388:5.2478343e-02 393:6.7220844e-02 433:9.8470666e-02 437:1.0604203e-01 "
          "606:6.3756987e-02 616:5.9570137e-02 617:5.3685464e-02 646:7.7671103e-02 673:6.2159818e-02 686:7.5003386e-02 "
          "802:7.9300053e-02 811:4.5812547e-02 814:1.0454537e-01 858:5.3967807e-02 898:1.2022889e-01 910:7.6427095e-02 "
          "932:6.0444627e-02 1012:5.3042527e-02 1122:9.6433483e-02 1443:7.2626606e-02 1557:5.9885662e-02 "
          "1560:8.2943968e-02 "
          "1839:1.0669301e-01 2009:1.6154605e-01 2088:7.7776805e-02 2126:7.7203840e-02 2622:1.1629759e-01 "
          "2854:2.8569898e-01 "
          "2870:2.6763520e-01 2904:1.2956272e-01 3033:9.6777074e-02 3684:9.8288991e-02 3701:1.2892863e-01 "
          "3749:1.5339580e-01 "
          "4472:3.1718406e-01 5313:7.8725956e-02 6835:1.0321023e-01 7861:1.2666813e-01 10969:4.0498388e-01 "
          "14663:1.7727321e-01 20301:1.6033885e-01 23169:2.0116536e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:6.7640401e-02 14:1.0198212e-01 24:4.5985386e-02 33:6.7851931e-02 39:1.2647533e-01 51:5.9768721e-02 "
          "65:1.4337812e-01 69:6.1208922e-02 89:9.2553847e-02 91:9.3566857e-02 106:1.4411852e-01 170:8.4185481e-02 "
          "208:1.9552626e-01 232:7.7963538e-02 234:1.2132888e-01 271:5.3845122e-02 276:6.5058932e-02 311:8.6718440e-02 "
          "337:8.1998564e-02 393:1.0035130e-01 406:1.2717758e-01 453:7.8224860e-02 497:1.3853751e-01 506:7.1283914e-02 "
          "533:5.3033646e-02 547:7.4526422e-02 642:1.3959913e-01 686:1.1196955e-01 802:4.9609918e-02 995:8.5266136e-02 "
          "1007:1.1288670e-01 1059:5.7066809e-02 1342:9.3822137e-02 1422:7.8667901e-02 1590:1.0122431e-01 "
          "1663:1.4776042e-01 "
          "1702:3.3252901e-01 2128:1.1399366e-01 2298:3.7798692e-02 2360:1.1162408e-01 2362:7.5591564e-02 "
          "2524:1.2811843e-01 "
          "2557:1.4954908e-01 5313:1.9899023e-01 5579:1.4019732e-01 6177:3.5001245e-01 9104:3.8532963e-01 "
          "9551:3.5612664e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 6:1.3602209e-01 9:3.2166064e-02 17:2.4520716e-02 24:2.7745385e-02 45:2.4512514e-02 50:2.4723247e-02 "
          "79:3.5607900e-02 99:9.8160177e-02 119:6.6302091e-02 140:5.4328080e-02 169:3.5312239e-02 182:9.8305173e-02 "
          "183:3.4816612e-02 189:3.4241408e-02 192:8.7520882e-02 193:3.7509426e-02 207:4.9071133e-02 217:3.1898361e-02 "
          "229:2.8459363e-02 230:8.3000727e-02 239:3.6401536e-02 269:2.9806575e-02 307:5.9758265e-02 323:8.0307469e-02 "
          "338:3.4845319e-02 339:8.4524237e-02 341:7.7346295e-02 353:8.2550451e-02 360:5.0620332e-02 370:4.5482360e-02 "
          "453:3.8078360e-02 488:5.0402727e-02 500:5.8057901e-02 506:3.4699637e-02 533:2.5815761e-02 555:3.2912362e-02 "
          "556:6.0991928e-02 558:3.7422553e-02 564:5.4485984e-02 631:5.1835973e-02 656:7.3878415e-02 660:2.7477790e-02 "
          "673:4.5171261e-02 678:3.3086222e-02 768:4.5516491e-02 803:4.8382584e-02 815:1.0301830e-01 817:5.5198468e-02 "
          "858:3.9218165e-02 925:5.5548850e-02 945:1.0018101e-01 983:6.6673033e-02 1002:5.5324540e-02 "
          "1066:6.1305776e-02 "
          "1075:1.8360974e-01 1085:6.2697552e-02 1110:4.9291037e-02 1116:6.0822140e-02 1123:1.0591222e-01 "
          "1213:2.7936373e-02 "
          "1243:9.2032909e-02 1280:1.5021783e-01 1312:1.1511004e-01 1353:1.0874441e-01 1357:7.4151672e-02 "
          "1358:1.5558441e-01 "
          "1371:6.0622476e-02 1506:5.7035822e-02 1511:7.7458702e-02 1523:9.2446022e-02 1643:1.0574520e-01 "
          "1674:6.3586749e-02 "
          "1727:5.0352853e-02 1731:4.7199059e-02 1785:6.9692224e-02 1834:9.4285749e-02 1910:6.0404439e-02 "
          "1914:7.5133219e-02 "
          "2022:6.5095864e-02 2061:6.4969011e-02 2074:5.5894535e-02 2107:8.3932638e-02 2166:1.0890041e-01 "
          "2170:1.5940247e-01 "
          "2222:7.3570549e-02 2234:4.7573309e-02 2353:5.9836701e-02 2609:7.8149281e-02 2701:6.1514113e-02 "
          "2710:1.0853941e-01 "
          "2794:6.0829252e-02 3014:1.9901413e-01 3188:5.0408330e-02 3325:1.8108778e-01 3463:8.3710425e-02 "
          "3536:8.5792504e-02 "
          "3540:6.6504173e-02 3690:1.0197456e-01 3858:1.7143957e-01 4108:1.0328130e-01 4132:7.6779485e-02 "
          "5121:9.3603954e-02 "
          "5720:9.4356239e-02 6144:1.0139626e-01 6149:3.5853177e-01 7302:7.9105765e-02 7690:9.0198882e-02 "
          "10771:1.0613065e-01 13134:1.0919771e-01 13451:1.8877305e-01 15615:1.0167150e-01 17465:1.2535700e-01 "
          "20206:2.9124358e-01 40403:1.5622568e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:3.8776815e-02 49:8.3037637e-02 69:1.5894213e-01 70:6.5797754e-02 135:1.4211494e-01 "
          "277:8.6826056e-02 "
          "284:8.2888633e-02 339:9.5005319e-02 367:2.1097282e-01 373:2.7783743e-01 608:3.6482778e-01 613:7.9145074e-02 "
          "724:1.0078824e-01 965:1.2564847e-01 1629:1.0755225e-01 1654:9.2739061e-02 1666:9.2221342e-02 "
          "1674:1.1015026e-01 "
          "2523:1.7967635e-01 6577:1.9937071e-01 6721:2.9358754e-01 19328:6.5752047e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:6.4167894e-02 18:6.0520239e-02 21:5.6740988e-02 45:4.7771189e-02 64:4.7150079e-02 73:4.4076335e-02 "
          "75:8.4138386e-02 79:6.9394425e-02 80:1.6868511e-01 87:8.4247395e-02 112:8.5918404e-02 192:1.0073843e-01 "
          "209:7.4511550e-02 210:6.9249652e-02 224:1.0861098e-01 263:1.0156595e-01 286:9.7007960e-02 302:7.4382737e-02 "
          "364:6.5991253e-02 381:8.3190255e-02 464:5.2022748e-02 478:1.4862801e-01 514:1.7668264e-01 575:8.0204874e-02 "
          "611:1.2628964e-01 620:5.8418814e-02 627:9.5467582e-02 660:5.3550061e-02 724:6.6969097e-02 865:1.1347343e-01 "
          "911:9.3616642e-02 1011:8.7291427e-02 1033:8.5466623e-02 1071:1.2402202e-01 1127:9.0121597e-02 "
          "1371:1.1814405e-01 "
          "1390:1.4676078e-01 1426:7.8160822e-02 1868:1.1436385e-01 2166:1.2534674e-01 2298:3.5858192e-02 "
          "2322:2.0755525e-01 "
          "2327:1.4886521e-01 2350:1.1979143e-01 3160:2.2326942e-01 3257:3.0594131e-01 3266:1.4938174e-01 "
          "3834:1.5813251e-01 "
          "3836:1.4967345e-01 4253:1.4439610e-01 7108:1.3930242e-01 7692:1.7447011e-01 7851:3.7420416e-01 "
          "7877:2.0790541e-01 "
          "13132:2.8663671e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 8:5.2967023e-02 13:2.0737091e-02 22:4.6041191e-02 24:1.8187728e-02 54:1.8652469e-02 93:5.8359347e-02 "
          "98:3.3800963e-02 110:2.7379397e-02 122:5.3547330e-02 126:3.3480618e-02 131:3.8326081e-02 165:1.1928599e-01 "
          "179:2.3818104e-02 182:7.4656993e-02 188:1.4833161e-02 221:3.5064932e-02 225:3.6084335e-02 229:2.3123330e-02 "
          "239:2.9576370e-02 252:2.6302833e-02 269:2.4217943e-02 276:2.5731526e-02 282:4.8680875e-02 288:5.4561023e-02 "
          "298:3.3059668e-02 313:4.2388245e-02 341:6.2844127e-02 345:4.4280306e-02 353:3.9614115e-02 376:9.2961393e-02 "
          "400:3.5668258e-02 428:4.2646315e-02 477:3.8624212e-02 482:4.8452735e-02 527:9.7087927e-02 530:5.0702475e-02 "
          "533:2.0975392e-02 558:3.0405952e-02 642:3.2609686e-02 645:4.6324093e-02 655:2.4461672e-02 723:7.7231459e-02 "
          "724:2.7920388e-02 757:3.5539728e-02 773:3.1440146e-02 802:1.9621272e-02 836:1.1147294e-01 850:5.7329819e-02 "
          "859:7.2786041e-02 871:4.3223169e-02 872:5.9259314e-02 894:7.5886674e-02 911:3.9030135e-02 950:5.2041918e-02 "
          "952:5.3551290e-02 1029:3.4138121e-02 1040:5.7902046e-02 1056:3.8184889e-02 1059:2.2570552e-02 "
          "1062:4.2781632e-02 "
          "1079:1.4910714e-01 1081:5.2189127e-02 1127:2.2191219e-02 1132:3.2932524e-02 1145:3.3095714e-02 "
          "1165:8.0184832e-02 "
          "1240:3.6311001e-02 1260:5.5365294e-02 1263:4.6977643e-02 1321:4.1519769e-02 1335:4.5601711e-02 "
          "1354:1.1458641e-01 "
          "1363:1.2102907e-01 1364:1.3505977e-01 1376:7.2074644e-02 1454:3.1196106e-02 1477:4.9524803e-02 "
          "1492:4.3707624e-02 "
          "1509:4.8338473e-02 1532:1.0703932e-01 1538:4.5513406e-02 1777:5.3442933e-02 1906:3.9929982e-02 "
          "2024:4.7436062e-02 "
          "2029:5.4396924e-02 2090:4.1054051e-02 2177:7.7772021e-02 2178:7.3425233e-02 2204:5.4746479e-02 "
          "2223:4.5220986e-02 "
          "2248:7.5171672e-02 2268:7.4035875e-02 2281:6.2408790e-02 2338:4.5470543e-02 2362:2.9897299e-02 "
          "2438:8.0175750e-02 "
          "2495:4.7273699e-02 2614:7.9634726e-02 2734:5.2797817e-02 2967:5.7513054e-02 3009:6.6400237e-02 "
          "3013:4.6898101e-02 "
          "3027:4.8933215e-02 3092:6.7459166e-02 3128:6.4717166e-02 3160:5.4977059e-02 3188:4.0956937e-02 "
          "3392:6.2418494e-02 "
          "3423:8.6617440e-02 3532:1.2280480e-01 3643:1.5630542e-01 3690:4.8935305e-02 3737:4.7412477e-02 "
          "3899:5.8410782e-02 "
          "4031:6.2327541e-02 4340:6.8484023e-02 4353:7.1281575e-02 4554:7.7120289e-02 5268:7.6733820e-02 "
          "5401:5.6069687e-02 "
          "5507:7.5235702e-02 5648:7.1640879e-02 5845:7.3555991e-02 5974:2.3149499e-01 6669:8.9578688e-02 "
          "6762:5.5782918e-02 "
          "6813:9.5655434e-02 7516:1.3148998e-01 7759:2.3481439e-01 7934:1.8377750e-01 8237:7.1814358e-02 "
          "8318:1.7672966e-01 "
          "8342:6.0716040e-02 8361:1.0959920e-01 8388:1.3796613e-01 8395:8.8680476e-02 8458:9.0654351e-02 "
          "8903:8.0072775e-02 "
          "9227:1.8114832e-01 9378:1.6685012e-01 10183:8.1651725e-02 10422:8.7490283e-02 10985:9.0277113e-02 "
          "14413:8.4770739e-02 15419:7.4725702e-02 15781:1.0897700e-01 17453:3.0631030e-01 18543:9.4031692e-02 "
          "18988:8.3123624e-02 18989:8.3350755e-02 18991:1.0945505e-01 28386:1.1877659e-01 36450:1.3125199e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 6:7.5162902e-02 10:2.7164089e-02 13:3.3654317e-02 15:2.1062145e-02 17:3.2333389e-02 23:3.1336673e-02 "
          "25:3.4264620e-02 40:4.7651555e-02 45:4.0063001e-02 50:1.9254351e-02 54:3.7520338e-02 55:2.0312089e-02 "
          "57:3.5512984e-02 73:2.9822594e-02 89:5.9408151e-02 90:2.7265051e-02 102:2.5919402e-02 103:3.3730425e-02 "
          "110:2.6243521e-02 112:3.4334555e-02 124:9.2839777e-02 166:3.9869212e-02 172:5.2079666e-02 179:2.2829974e-02 "
          "182:2.7423427e-02 188:2.4072800e-02 189:6.9586009e-02 210:2.7673418e-02 213:3.4223091e-02 225:3.4587320e-02 "
          "230:4.5864429e-02 231:2.7989293e-02 232:2.9556183e-02 236:2.2482606e-02 253:6.4639151e-02 255:4.0714748e-02 "
          "267:3.8941715e-02 271:4.8711020e-02 276:5.1760204e-02 290:8.3272777e-02 293:2.0850347e-02 295:5.1527008e-02 "
          "297:2.7784998e-02 312:3.4515973e-02 313:4.0629704e-02 316:6.0846146e-02 378:4.4961039e-02 389:4.1293312e-02 "
          "464:2.0789234e-02 475:5.2411016e-02 480:3.9924309e-02 506:2.7023921e-02 526:3.4467056e-02 533:3.4041055e-02 "
          "558:2.9144512e-02 559:4.3685023e-02 573:4.4974472e-02 579:5.4383047e-02 583:4.7898244e-02 585:5.8916308e-02 "
          "586:2.8540066e-02 587:9.3952462e-02 645:7.5179569e-02 646:4.3957740e-02 678:2.5767397e-02 686:4.2447951e-02 "
          "723:1.2880041e-01 756:5.2763004e-02 789:4.2330436e-02 802:4.9076356e-02 815:3.8230106e-02 829:7.0888035e-02 "
          "837:3.7622824e-02 852:4.7854993e-02 927:3.6390126e-02 932:5.7919964e-02 941:1.7036395e-01 944:1.3148479e-01 "
          "945:3.7177190e-02 953:4.2344835e-02 963:3.5546530e-02 965:3.3363145e-02 994:4.1714054e-02 "
          "1028:2.4160272e-02 "
          "1056:3.6600728e-02 1059:5.6453042e-02 1110:3.8387634e-02 1134:3.8503230e-02 1166:5.0669339e-02 "
          "1170:4.2089995e-02 "
          "1188:7.1456023e-02 1196:3.7000220e-02 1201:7.5464062e-02 1213:2.1756720e-02 1235:3.9658703e-02 "
          "1247:7.0435107e-02 "
          "1263:1.2570931e-01 1266:4.1977115e-02 1273:4.9812075e-02 1338:4.8291340e-02 1342:6.0222235e-02 "
          "1377:6.2335186e-02 "
          "1423:5.6863945e-02 1426:7.4534677e-02 1440:4.5020081e-02 1454:2.9901888e-02 1455:3.9184473e-02 "
          "1461:5.7127047e-02 "
          "1488:5.2855767e-02 1503:4.2414267e-02 1515:6.6359721e-02 1532:6.0596410e-02 1560:4.6941902e-02 "
          "1561:9.3150236e-02 "
          "1566:4.2160779e-02 1590:8.0532998e-02 1647:4.1074641e-02 1674:2.9247941e-02 1690:4.6073664e-02 "
          "1698:6.2844977e-02 "
          "1747:4.9747519e-02 1889:3.5529476e-02 1906:6.4802542e-02 2015:6.3420743e-02 2017:5.8166113e-02 "
          "2065:7.1938954e-02 "
          "2141:5.5014756e-02 2167:1.0584860e-01 2235:5.6877192e-02 2371:4.1387279e-02 2377:1.0748149e-01 "
          "2380:5.7701729e-02 "
          "2422:5.7748981e-02 2438:4.5388568e-02 2477:4.5273721e-02 2519:5.4443594e-02 2577:4.8470654e-02 "
          "2632:1.0950754e-01 "
          "2734:1.0620534e-01 2747:5.3432774e-02 2759:6.3761964e-02 2818:6.0616206e-02 2919:8.7232865e-02 "
          "2924:5.1229529e-02 "
          "3010:5.2467965e-02 3015:5.4887112e-02 3094:1.0000512e-01 3202:8.1101902e-02 3204:6.0588498e-02 "
          "3272:7.5769536e-02 "
          "3296:7.2323434e-02 3317:8.4190853e-02 3354:5.8530189e-02 3369:1.1691815e-01 3417:9.5852435e-02 "
          "3426:1.8218037e-01 "
          "3427:1.4012337e-01 3433:7.2243400e-02 3453:1.8802482e-01 3457:4.3309759e-02 3512:5.1012255e-02 "
          "3565:1.3844933e-01 "
          "3912:5.9520077e-02 4414:6.0122732e-02 4492:7.9576574e-02 4807:8.6210519e-02 5012:4.9454924e-02 "
          "5239:7.0216723e-02 "
          "5390:1.0793258e-01 5490:7.0843346e-02 5994:7.3380105e-02 6022:9.0486169e-02 6196:6.6785671e-02 "
          "6299:1.0725134e-01 "
          "7185:8.4268317e-02 7330:6.3180469e-02 7345:7.6343909e-02 8242:6.0330201e-02 9555:7.5221755e-02 "
          "9788:6.8189904e-02 "
          "9840:8.3538808e-02 10342:7.5071089e-02 10467:7.5790152e-02 10931:9.4324708e-02 11148:6.4417072e-02 "
          "11149:6.8653740e-02 11150:2.4194863e-01 11202:1.1515777e-01 11253:7.9532035e-02 11257:1.3639961e-01 "
          "13196:8.7734230e-02 14196:7.4527591e-02 14220:1.2228498e-01 14989:7.8882217e-02 14990:2.2610106e-01 "
          "15716:8.2757011e-02 22586:1.0445593e-01 32502:9.8319061e-02 40495:1.0317352e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 14:4.6685375e-02 17:3.9043721e-02 24:3.5642762e-02 39:4.6711642e-02 41:6.4986050e-02 53:9.7434938e-02 "
          "70:6.0479779e-02 101:6.8327434e-02 125:6.5960057e-02 135:7.7151470e-02 138:6.6490836e-02 140:5.6129370e-02 "
          "157:1.8222515e-01 167:7.3569357e-02 183:5.5437617e-02 188:6.1004069e-02 210:5.6579288e-02 229:7.6725185e-02 "
          "234:5.5541933e-02 247:8.0911487e-02 257:8.7341174e-02 284:4.4998646e-02 286:5.6236453e-02 293:4.2629275e-02 "
          "295:6.2220700e-02 320:6.0314614e-02 326:5.2210093e-02 338:5.5483330e-02 342:7.0478953e-02 394:7.6991834e-02 "
          "407:1.4337897e-01 433:4.7747806e-02 453:6.0631219e-02 464:7.1966082e-02 496:1.3877112e-01 516:7.3230974e-02 "
          "533:4.1105788e-02 549:6.4592525e-02 613:1.2657496e-01 616:6.8928547e-02 655:4.7937904e-02 684:7.3886104e-02 "
          "690:1.5935852e-01 740:2.9913169e-01 760:9.3864232e-02 767:7.1026899e-02 782:1.5962097e-01 812:1.6494313e-01 "
          "814:7.1446441e-02 815:7.8162819e-02 844:1.2304020e-01 992:1.2588154e-01 1036:7.5061359e-02 "
          "1073:1.7234431e-01 "
          "1115:8.0682985e-02 1119:9.9624366e-02 1122:5.3169947e-02 1213:4.4482388e-02 1535:2.1814872e-01 "
          "1617:8.4668003e-02 "
          "1654:5.0346255e-02 1682:8.2505457e-02 1702:9.2321545e-02 1729:1.2025382e-01 2104:9.1611803e-02 "
          "2298:2.9297344e-02 "
          "2548:9.2505068e-02 2623:1.2080402e-01 2880:1.2729374e-01 2891:1.1095203e-01 3589:1.3369514e-01 "
          "4470:1.2805253e-01 "
          "5874:1.1226498e-01 6074:2.0972548e-01 7761:1.2549773e-01 22172:2.2821054e-01 24843:4.1516986e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 10:7.0070818e-02 13:3.0282617e-02 24:1.5686616e-02 26:4.1215312e-02 42:6.1233964e-02 55:6.4943276e-02 "
          "74:4.0680200e-02 90:8.7173775e-02 98:4.9359940e-02 125:1.0314921e-01 131:5.5968020e-02 133:5.5713881e-02 "
          "147:4.0348452e-02 152:5.8046080e-02 161:3.9000869e-02 166:1.0284418e-01 179:3.4781855e-02 188:2.1661038e-02 "
          "189:4.0627711e-02 210:4.2160925e-02 219:8.0608368e-02 228:6.6707455e-02 229:3.3767268e-02 231:4.2642169e-02 "
          "240:3.6020506e-02 259:4.1974254e-02 276:6.3621782e-02 286:7.2911397e-02 288:3.3389047e-02 296:4.8418313e-02 "
          "306:6.5996163e-02 309:5.4096408e-02 378:1.7874366e-01 428:6.2276911e-02 438:4.9980700e-02 481:1.0268275e-01 "
          "526:3.1013934e-02 532:6.3117981e-02 533:3.0630611e-02 548:6.6986464e-02 574:6.9817968e-02 576:6.2181368e-02 "
          "617:7.8374468e-02 678:6.6468000e-02 702:4.2069014e-02 760:6.9944382e-02 764:5.4297425e-02 802:4.8514038e-02 "
          "860:7.0781596e-02 949:7.6603115e-02 955:6.1986126e-02 1025:6.3366458e-02 1028:3.6808588e-02 "
          "1056:5.5761840e-02 "
          "1059:3.2960042e-02 1126:8.0853909e-02 1127:3.2406095e-02 1173:4.8307218e-02 1218:4.4807430e-02 "
          "1237:5.8862850e-02 "
          "1266:1.0828160e-01 1309:9.3366392e-02 1356:1.2529221e-01 1419:6.8588868e-02 1422:4.5436170e-02 "
          "1451:8.0665760e-02 "
          "1455:5.9698220e-02 1456:6.8569623e-02 1535:1.6255687e-01 1561:8.3817869e-02 1594:7.5339198e-02 "
          "1783:7.6806203e-02 "
          "1833:1.0420495e-01 1838:9.7478606e-02 1875:1.0487134e-01 2006:1.2504297e-01 2009:5.8370791e-02 "
          "2028:6.2183250e-02 "
          "2083:7.3946290e-02 2084:8.2910649e-02 2207:9.9655889e-02 2214:6.8583615e-02 2248:6.4834334e-02 "
          "2253:9.5959149e-02 "
          "2288:7.0148386e-02 2791:8.8304028e-02 2880:9.4854891e-02 2896:1.1264571e-01 3057:1.7787817e-01 "
          "3096:1.1765064e-01 "
          "3134:8.4112354e-02 3137:6.3175336e-02 3188:5.9809897e-02 3484:8.0417737e-02 3652:9.2017658e-02 "
          "3762:1.0593174e-01 "
          "3816:1.4535163e-01 5731:1.2507614e-01 5862:9.1973200e-02 6018:9.0290904e-02 6193:2.3413058e-01 "
          "6405:1.3231085e-01 "
          "6406:3.1385079e-01 6846:1.2977491e-01 8451:1.4598264e-01 8651:9.6747451e-02 9725:1.1080751e-01 "
          "9825:1.0740144e-01 "
          "11164:1.0144614e-01 13341:1.3000965e-01 14219:1.4506726e-01 20869:1.3627610e-01 21071:2.9298630e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 5:7.7685639e-02 15:6.3808762e-02 19:1.6053554e-01 224:7.7660814e-02 327:8.3421938e-02 "
                  "359:1.0767267e-01 "
                  "381:1.0071529e-01 500:1.3698167e-01 533:6.0909640e-02 546:9.3448102e-02 608:1.1246787e-01 "
                  "1340:1.3528216e-01 "
                  "1725:1.6506469e-01 1778:1.3780554e-01 2493:1.7287858e-01 3377:1.9988342e-01 3411:1.7906854e-01 "
                  "3415:2.5061205e-01 "
                  "4102:1.6632122e-01 4525:3.1949246e-01 6093:1.7140402e-01 7880:3.7428093e-01 12385:2.5560999e-01 "
                  "12574:3.0325091e-01 12575:2.9858702e-01 12576:2.3341639e-01 12577:2.3695944e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 23:6.7910634e-02 24:4.6827294e-02 35:6.4317226e-02 51:4.9103871e-02 61:6.0310587e-02 73:3.8171180e-02 "
          "98:7.0212141e-02 107:7.1495287e-02 119:1.1190140e-01 131:7.9611816e-02 133:1.3418244e-01 180:7.5679630e-02 "
          "188:3.0811785e-02 223:5.6065913e-02 230:5.8703799e-02 252:5.4636855e-02 311:7.1244806e-02 334:7.3544040e-02 "
          "337:6.7367129e-02 370:7.6762885e-02 415:7.4174866e-02 453:6.4266786e-02 454:6.2604383e-02 497:1.1381753e-01 "
          "501:8.3243266e-02 506:5.8564343e-02 553:6.5571606e-02 655:5.0812352e-02 777:1.2731229e-01 802:4.0757757e-02 "
          "851:1.9541831e-01 852:1.0370798e-01 866:8.9214206e-02 949:1.0896424e-01 1002:1.5809599e-01 "
          "1003:9.5906034e-02 "
          "1046:9.2986949e-02 1132:6.8408199e-02 1213:4.7149636e-02 1218:6.3736416e-02 1376:8.8424154e-02 "
          "1452:7.5447641e-02 "
          "1470:1.0303334e-01 1557:1.2435932e-01 1679:1.3655433e-01 1757:1.5080504e-01 1966:9.1756694e-02 "
          "2010:9.8077208e-02 "
          "2362:6.2103361e-02 2444:1.1164161e-01 2604:1.6661243e-01 2761:1.4033569e-01 3026:2.5495380e-01 "
          "3144:2.1345061e-01 "
          "3189:1.4177455e-01 3247:1.2914169e-01 3272:7.8243330e-02 3278:1.3476554e-01 3355:1.0587688e-01 "
          "4074:2.8453517e-01 "
          "4533:3.7232360e-01 5401:1.1646925e-01 8909:2.7678004e-01 11526:1.6955662e-01 12493:1.7072928e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 32:1.4378616e-01 46:1.4209117e-01 70:1.4227942e-01 73:8.4718294e-02 135:1.8149976e-01 "
          "140:7.7987917e-02 "
          "238:1.2878951e-01 240:1.1371795e-01 288:1.0541034e-01 295:3.0718428e-01 339:1.2133448e-01 347:1.6533063e-01 "
          "553:1.4553164e-01 724:1.2872005e-01 977:4.9486303e-01 1160:1.8564081e-01 1284:2.6421994e-01 "
          "1380:1.7094025e-01 "
          "1654:1.1844017e-01 2379:3.9168647e-01 3841:1.7708945e-01 3921:2.0607966e-01 4531:2.4131638e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 8:6.0927220e-02 9:5.0900683e-02 15:2.5276106e-02 24:1.2356331e-02 39:2.7418142e-02 50:3.9122909e-02 "
          "52:5.7576001e-02 55:5.1155742e-02 56:4.5382682e-02 73:4.4359889e-02 75:4.0350318e-02 86:5.5231892e-02 "
          "90:3.2720044e-02 95:4.7209837e-02 112:4.1203965e-02 115:6.2011044e-02 117:3.6665760e-02 121:6.6353254e-02 "
          "138:3.9027855e-02 140:1.9458456e-02 161:9.4603337e-02 180:4.1908454e-02 182:3.2910109e-02 189:3.2002401e-02 "
          "209:6.0502190e-02 213:4.1070197e-02 217:5.0477058e-02 221:6.8292581e-02 229:4.5035072e-02 231:3.3589188e-02 "
          "252:5.1227488e-02 254:1.2323026e-01 259:3.3063073e-02 262:5.0882269e-02 265:5.7309054e-02 269:2.7857557e-02 "
          "271:5.1409457e-02 276:2.9598612e-02 302:3.5671793e-02 315:3.6948130e-02 319:3.3959158e-02 334:4.0725850e-02 "
          "350:1.1598504e-01 355:6.6335924e-02 400:4.1028693e-02 417:8.3864719e-02 433:2.8026335e-02 454:3.4667887e-02 "
          "460:6.1969008e-02 477:4.4428885e-02 494:4.0121537e-02 516:7.2778396e-02 521:6.5396123e-02 524:8.0103353e-02 "
          "546:3.7016924e-02 550:3.6902737e-02 555:3.0760260e-02 578:4.8902858e-02 585:4.1758839e-02 586:3.4250155e-02 "
          "594:8.5549504e-02 613:2.5219778e-02 644:3.3216905e-02 655:2.8137917e-02 664:4.3441381e-02 702:3.3137716e-02 "
          "743:7.9298951e-02 767:4.1690372e-02 789:8.6011216e-02 802:2.2570072e-02 842:4.1192740e-02 858:3.6653735e-02 "
          "871:1.0434090e-01 898:4.8227813e-02 911:4.4895813e-02 950:5.9863083e-02 954:4.8181362e-02 "
          "1012:6.0996138e-02 "
          "1013:8.5395284e-02 1052:8.9897305e-02 1059:4.3958481e-02 1085:5.8597837e-02 1088:8.9098096e-02 "
          "1099:4.6860270e-02 "
          "1124:5.8392126e-02 1136:4.8025705e-02 1162:4.4845764e-02 1187:5.6786180e-02 1189:4.3032665e-02 "
          "1193:3.3261545e-02 "
          "1218:9.8534495e-02 1229:6.3519642e-02 1235:4.7593333e-02 1242:9.8548524e-02 1342:4.2684454e-02 "
          "1372:1.6339037e-01 "
          "1373:4.8612334e-02 1397:5.0833620e-02 1408:5.4532200e-02 1492:5.0276261e-02 1523:1.4628977e-01 "
          "1560:5.6333698e-02 "
          "1623:4.1404314e-02 1666:2.9386565e-02 1670:4.1932601e-02 1674:7.3660575e-02 1697:8.2077712e-02 "
          "1727:4.7060337e-02 "
          "1799:6.0751934e-02 1811:5.9359312e-02 1850:5.1822715e-02 1858:8.1600420e-02 2090:7.9957008e-02 "
          "2109:7.2284855e-02 "
          "2149:7.7081785e-02 2190:5.1945992e-02 2248:5.1069930e-02 2316:5.8428988e-02 2596:1.2658514e-01 "
          "2760:7.6512903e-02 "
          "2771:5.8361787e-02 3170:7.1761191e-02 3228:2.5503290e-01 3429:8.8312365e-02 3434:6.1568603e-02 "
          "3642:9.1734685e-02 "
          "3644:9.5285013e-02 3690:5.6289591e-02 3754:1.0490363e-01 5503:8.4470339e-02 5648:8.2407489e-02 "
          "5666:1.1847161e-01 "
          "5882:1.3553809e-01 5993:1.5584879e-01 6063:8.0272339e-02 6209:1.8979874e-01 6296:8.1767917e-02 "
          "6729:6.4865842e-02 "
          "6809:8.5151620e-02 7404:1.7907660e-01 7786:8.1707582e-02 8414:8.3710022e-02 8805:1.4632952e-01 "
          "9541:7.8936510e-02 "
          "10358:1.7636500e-01 11443:1.0082047e-01 16295:1.0727436e-01 17581:8.9808837e-02 17896:3.2630825e-01 "
          "18525:1.3381621e-01 23447:9.7757243e-02 26958:1.0210705e-01 27080:1.8615700e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 8:4.7581278e-02 9:3.9751027e-02 24:9.6497098e-03 51:1.2542047e-02 69:2.1747228e-02 81:3.4720287e-02 "
          "95:3.6868650e-02 106:3.0242259e-02 110:4.1643687e-02 111:3.3752866e-02 121:3.0604990e-02 124:4.1460466e-02 "
          "126:3.0076271e-02 141:3.5081543e-02 144:3.4181364e-02 161:2.3991603e-02 180:7.8099884e-02 183:4.3026593e-02 "
          "188:2.2561030e-02 189:5.9639130e-02 192:3.7728775e-02 210:2.5935529e-02 213:5.4305807e-02 217:6.4998306e-02 "
          "220:3.1865891e-02 225:3.2415237e-02 228:4.1035462e-02 236:2.1070700e-02 239:2.6569013e-02 240:5.2876029e-02 "
          "242:3.8395964e-02 247:3.7089232e-02 261:7.0545286e-02 263:3.8038701e-02 269:2.1755435e-02 295:2.8521512e-02 "
          "296:2.9784797e-02 297:2.6040103e-02 298:5.0283290e-02 302:2.7857983e-02 319:4.4903103e-02 320:4.6811756e-02 "
          "326:2.3932723e-02 337:4.9327616e-02 344:3.7306540e-02 349:3.2734077e-02 351:5.0594456e-02 354:2.9731253e-02 "
          "364:4.1846447e-02 388:2.7834814e-02 415:6.7318805e-02 476:3.5899844e-02 488:7.7204384e-02 506:2.5326820e-02 "
          "510:5.1947668e-02 511:3.2141048e-02 526:3.2302529e-02 533:1.8842591e-02 534:7.4914381e-02 547:2.6478868e-02 "
          "553:2.8357189e-02 554:5.3330176e-02 555:4.0673304e-02 561:3.9561681e-02 571:5.7263806e-02 584:4.4625249e-02 "
          "611:4.7298271e-02 613:4.6999149e-02 629:3.5282288e-02 644:2.5940834e-02 651:6.1212085e-02 655:5.2437346e-02 "
          "660:2.0055685e-02 673:5.5822928e-02 758:7.9547837e-02 764:7.0096523e-02 765:4.8580248e-02 789:3.9672092e-02 "
          "802:1.7626159e-02 815:3.5829261e-02 818:6.2756307e-02 820:5.3184900e-02 853:7.2380386e-02 858:4.8466053e-02 "
          "866:9.2067309e-02 884:9.0916544e-02 888:3.7554063e-02 898:3.7663642e-02 926:5.5378962e-02 929:5.5555418e-02 "
          "941:4.5816179e-02 945:3.4842469e-02 948:6.2145561e-02 954:3.7627369e-02 967:1.0927314e-01 969:6.6968419e-02 "
          "1002:1.5233967e-01 1009:4.8350334e-02 1012:2.8134059e-02 1059:2.0275554e-02 1094:1.0262907e-01 "
          "1096:1.1554346e-01 "
          "1126:8.4213302e-02 1132:7.0595913e-02 1179:3.9655574e-02 1189:3.3606477e-02 1213:2.0390399e-02 "
          "1222:6.2978260e-02 "
          "1296:4.6224244e-02 1314:6.1421290e-02 1332:6.1391145e-02 1342:3.3334542e-02 1352:7.7821679e-02 "
          "1368:5.2271314e-02 "
          "1398:3.7772395e-02 1486:4.1119743e-02 1528:3.9671656e-02 1530:4.3524202e-02 1557:3.1763699e-02 "
          "1577:4.6628870e-02 "
          "1629:5.6168631e-02 1653:4.6657130e-02 1664:3.0608421e-02 1668:3.7839994e-02 1670:3.2747380e-02 "
          "1674:4.6411153e-02 "
          "1685:4.9291257e-02 1838:5.9964512e-02 1889:3.3298228e-02 2097:9.1371775e-02 2175:7.7463396e-02 "
          "2231:5.5800967e-02 "
          "2247:5.9707772e-02 2379:4.5076445e-02 2548:8.8988803e-02 2602:4.2093083e-02 2647:8.4548011e-02 "
          "2738:8.3560742e-02 "
          "2831:7.3639162e-02 2858:8.7419696e-02 2938:5.3128608e-02 2959:2.2756046e-01 2984:5.0467890e-02 "
          "3046:7.9233110e-02 "
          "3063:1.3796210e-01 3230:7.1567640e-02 3355:7.7525258e-02 3405:1.0565606e-01 3569:7.9110526e-02 "
          "3653:5.9904020e-02 "
          "3735:6.4050712e-02 3891:5.6145210e-02 3946:7.1917526e-02 4257:1.3527769e-01 5218:6.8634562e-02 "
          "5483:1.5539017e-01 "
          "5710:6.1393879e-02 6172:6.5735728e-02 6487:1.5883690e-01 6507:4.9618963e-02 6845:8.1302747e-02 "
          "7136:6.6273741e-02 "
          "8270:8.3051763e-02 8507:1.3142994e-01 9842:1.2401330e-01 11647:8.8840552e-02 12629:7.0993446e-02 "
          "12972:1.2174878e-01 13325:8.0867514e-02 14076:8.9954801e-02 15578:7.6549485e-02 15619:2.4627675e-01 "
          "15694:1.9752599e-01 18118:3.0472583e-01 18275:9.9646263e-02 18793:7.8891620e-02 20185:9.6214384e-02 "
          "21139:9.2444547e-02 22268:9.1391817e-02 22275:8.3137773e-02 29393:1.7291266e-01 33391:1.2545249e-01 "
          "43983:1.2221190e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:3.5893559e-02 14:3.1962421e-02 15:6.1871167e-02 17:2.6730681e-02 18:3.3853170e-02 21:8.2821406e-02 "
          "39:3.1980406e-02 46:7.0014626e-02 60:4.4985253e-02 65:9.4304137e-02 70:6.3814789e-02 73:6.4335570e-02 "
          "103:4.7214493e-02 140:2.2696260e-02 179:5.4107025e-02 223:6.1314359e-02 232:4.1371558e-02 271:2.8573059e-02 "
          "286:2.2739561e-02 338:7.9717480e-02 339:3.5311095e-02 342:4.8252329e-02 388:4.1572824e-02 417:5.7584304e-02 "
          "426:5.7573613e-02 451:7.1490869e-02 453:4.1510232e-02 463:7.9493098e-02 474:1.0619254e-01 533:2.8142445e-02 "
          "542:1.1205611e-01 543:1.1149277e-01 547:3.9547641e-02 560:5.5608571e-02 611:7.0642561e-02 620:5.5328153e-02 "
          "655:3.2819945e-02 764:8.4465653e-02 773:4.2182885e-02 842:2.8377354e-02 933:5.7594892e-02 980:8.2214892e-02 "
          "1009:1.5154894e-01 1170:5.8915887e-02 1399:9.4909161e-02 1546:4.7814887e-02 2032:1.4523183e-01 "
          "2055:1.1127604e-01 "
          "2298:2.0057976e-02 2810:1.3324007e-01 2818:8.4848128e-02 2947:9.0209723e-02 4470:1.4843686e-01 "
          "4472:1.5239035e-01 "
          "4488:1.0590401e-01 5257:9.8132730e-02 5545:1.8705845e-01 7148:1.9879293e-01 8503:4.0609068e-01 "
          "8512:1.0681489e-01 "
          "8603:4.2897844e-01 8745:1.6462547e-01 9214:8.6768322e-02 18626:1.5790586e-01 28169:3.9131895e-01 "
          "44945:1.6488293e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 9:4.0455632e-02 55:8.5597135e-02 73:2.8445156e-02 90:4.4031553e-02 98:5.2322075e-02 179:3.6869146e-02 "
          "217:4.0118936e-02 229:3.5793670e-02 233:3.3181142e-02 265:7.7121124e-02 275:7.2580062e-02 276:8.3589874e-02 "
          "278:9.1984741e-02 297:4.4871237e-02 349:5.6406021e-02 411:6.9896743e-02 417:3.1657461e-02 471:5.9163887e-02 "
          "495:7.3911078e-02 587:5.4348540e-02 622:6.5445803e-02 623:5.6024741e-02 767:5.6102972e-02 802:3.0372674e-02 "
          "814:1.3466901e-01 836:6.1808385e-02 839:1.0084469e-01 858:8.3514720e-02 866:6.6482410e-02 899:8.4769778e-02 "
          "942:7.6409690e-02 1028:3.9017506e-02 1071:4.7272328e-02 1100:1.3933346e-01 1193:4.4760253e-02 "
          "1215:1.3037306e-01 "
          "1222:6.4094573e-02 1235:6.4046614e-02 1238:7.9146266e-02 1243:6.8364322e-02 1282:6.8251431e-02 "
          "1304:6.6911332e-02 "
          "1373:6.5417893e-02 1455:3.7374638e-02 1459:8.2983524e-02 1488:8.5359141e-02 1666:3.9545666e-02 "
          "1674:4.7233809e-02 "
          "2083:7.8383870e-02 2137:9.4732881e-02 2254:1.0144539e-01 2265:1.3621454e-01 2495:7.3177144e-02 "
          "3240:8.1965230e-02 "
          "3979:1.4174108e-01 4378:9.8525546e-02 4639:1.1674171e-01 4733:1.2043531e-01 4944:1.2264381e-01 "
          "6104:1.1311021e-01 "
          "6188:1.1905863e-01 6277:1.2293752e-01 7720:1.2454427e-01 7769:1.6415018e-01 9874:1.4174108e-01 "
          "10016:1.5802848e-01 10118:1.4729320e-01 10431:1.4377169e-01 10454:1.5453503e-01 12894:1.3862425e-01 "
          "13228:1.4270210e-01 13274:1.6719006e-01 16847:1.2095542e-01 16892:1.9083780e-01 17634:2.6429141e-01 "
          "18554:1.9053182e-01 19333:1.5463884e-01 19442:2.0494147e-01 24727:1.4585796e-01 25656:1.5191534e-01 "
          "25737:2.0003448e-01 28592:1.8545201e-01 41921:1.8475433e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:4.4330198e-02 20:1.0205229e-01 26:7.9184949e-02 69:6.7920826e-02 81:1.0843822e-01 85:9.0745546e-02 "
          "107:9.6565917e-02 188:4.1616283e-02 210:8.1001706e-02 233:6.0140222e-02 257:7.3851794e-02 277:1.4161964e-01 "
          "284:6.4422287e-02 296:9.3023717e-02 339:7.3839560e-02 417:9.7150378e-02 453:8.6802654e-02 533:5.8849081e-02 "
          "535:9.4940454e-02 549:9.2473865e-02 679:1.0286228e-01 1195:1.1376317e-01 1503:2.1020257e-01 "
          "1714:3.6448792e-01 "
          "2341:2.0580284e-01 2493:9.8650686e-02 2520:1.4646065e-01 2522:5.2672458e-01 3371:1.6143516e-01 "
          "3583:1.9653179e-01 "
          "4525:3.0868408e-01 4554:2.1637060e-01 4755:2.1652095e-01 11338:2.2030811e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 7:1.2076401e-01 24:3.3017382e-02 51:1.7983440e-02 73:4.0075790e-02 74:3.5881653e-02 75:9.4821818e-02 "
          "87:4.5241646e-02 101:1.4831707e-01 121:7.4300431e-02 124:5.9448179e-02 136:4.2736180e-02 181:5.2301552e-02 "
          "182:3.6851775e-02 183:3.6437333e-02 218:5.8125973e-02 231:3.7612189e-02 233:2.7610250e-02 236:3.0212266e-02 "
          "244:7.5354815e-02 276:3.3143658e-02 283:5.0905608e-02 293:2.8018828e-02 297:1.0999338e-01 309:4.7715314e-02 "
          "318:5.3469103e-02 326:3.4315985e-02 346:5.3169955e-02 365:5.6553058e-02 386:5.0002512e-02 387:5.5928390e-02 "
          "433:3.1383067e-02 438:7.4642539e-02 465:5.8448482e-02 480:5.3650539e-02 506:3.6314916e-02 526:4.6317048e-02 "
          "532:5.5672720e-02 553:4.0660016e-02 580:5.8733404e-02 603:7.5921252e-02 638:8.1777394e-02 651:1.2370034e-01 "
          "664:8.2362108e-02 678:5.8627579e-02 694:6.3629255e-02 725:8.1541859e-02 802:6.5949120e-02 807:6.4558201e-02 "
          "815:5.1373862e-02 842:4.6126425e-02 858:6.9493152e-02 861:8.2118899e-02 866:1.4435531e-01 867:6.7112625e-02 "
          "869:1.4947902e-01 870:1.7689241e-01 882:1.5204006e-01 884:1.8372852e-01 967:5.6122858e-02 990:7.1268350e-02 "
          "1000:4.3046240e-02 1059:2.9072147e-02 1094:4.7786228e-02 1110:5.1585548e-02 1113:8.2799681e-02 "
          "1119:6.5479837e-02 "
          "1127:5.9985779e-02 1134:5.1740885e-02 1172:7.2574884e-02 1173:8.9419775e-02 1178:6.8759345e-02 "
          "1179:9.6272729e-02 "
          "1193:6.3061781e-02 1213:4.9502235e-02 1304:5.5677366e-02 1332:8.8025823e-02 1342:4.7796801e-02 "
          "1426:4.1973099e-02 "
          "1436:9.0053909e-02 1492:9.5320612e-02 1504:6.4067803e-02 1540:5.3149931e-02 1560:6.3080825e-02 "
          "1594:6.6452347e-02 "
          "1778:6.1125945e-02 1881:6.5155491e-02 1910:6.3216276e-02 2090:5.2879937e-02 2186:1.7205416e-01 "
          "2335:5.9536222e-02 "
          "2339:6.2862784e-02 2515:6.4581774e-02 2545:7.4967466e-02 2731:6.6474319e-02 2752:6.7073867e-02 "
          "3478:8.0251612e-02 "
          "3488:9.4243966e-02 4268:1.7262340e-01 4459:7.4615434e-02 4502:8.6596496e-02 4660:8.9864731e-02 "
          "5661:2.3034665e-01 "
          "6266:1.1291286e-01 7792:9.2358410e-02 12206:1.1169474e-01 13491:3.8575628e-01 14115:3.2277462e-01 "
          "18129:1.6157924e-01 21148:1.3408947e-01 23801:1.2671553e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 9:3.9047420e-02 15:3.2830209e-02 17:5.0399043e-02 21:3.5343792e-02 24:1.6049184e-02 26:4.2167932e-02 "
          "55:3.1661075e-02 63:5.5740055e-02 110:4.0906575e-02 125:8.5143618e-02 146:7.2688527e-02 161:3.9902303e-02 "
          "231:4.3627765e-02 233:5.4224979e-02 250:8.6963847e-02 254:5.7332754e-02 276:6.5092281e-02 298:4.9393263e-02 "
          "315:4.7990572e-02 342:5.3732343e-02 354:4.9448363e-02 370:5.5212498e-02 417:5.1734962e-02 459:5.8344889e-02 "
          "471:9.6686266e-02 516:5.5830456e-02 530:7.5752750e-02 547:4.4039067e-02 573:4.1404005e-02 584:7.4219726e-02 "
          "646:6.8518274e-02 651:6.0128618e-02 664:9.5534846e-02 693:7.1093716e-02 802:2.9315438e-02 812:7.4270420e-02 "
          "820:5.2243508e-02 845:7.6476283e-02 848:1.2976973e-01 860:7.2417587e-02 972:9.5166214e-02 "
          "1012:4.6791945e-02 "
          "1028:3.7659355e-02 1040:1.0722614e-01 1073:1.4940500e-01 1132:4.9203299e-02 1213:8.0926068e-02 "
          "1245:9.4278485e-02 "
          "1246:1.1605694e-01 1250:8.0876209e-02 1272:1.4118958e-01 1335:6.8131879e-02 1345:1.3331391e-01 "
          "1399:1.0568800e-01 "
          "1452:5.4266494e-02 1497:6.8203047e-02 1538:6.7999952e-02 1590:1.0127620e-01 1645:6.9712117e-02 "
          "1654:3.8383406e-02 "
          "1674:4.5589659e-02 1768:9.7454295e-02 1827:7.1706690e-02 1889:5.5380877e-02 1890:6.8590023e-02 "
          "1984:7.5203635e-02 "
          "2077:9.4358116e-02 2134:8.8366844e-02 2214:7.0168801e-02 2298:2.2335960e-02 2688:9.4723590e-02 "
          "2842:2.0976666e-01 "
          "2869:2.3197569e-01 2949:6.8268776e-02 3137:6.4635523e-02 3209:1.0893305e-01 3267:1.0756392e-01 "
          "3566:1.6916227e-01 "
          "3736:8.7994933e-02 3772:1.1534501e-01 3800:1.3765170e-01 3905:1.0364754e-01 3962:9.3948156e-02 "
          "4060:9.1060810e-02 "
          "4256:7.0193887e-02 4276:6.9186449e-02 4301:1.0014340e-01 5201:1.3352646e-01 5224:1.0396527e-01 "
          "6319:9.0188041e-02 "
          "6459:1.4384629e-01 6909:7.8028604e-02 7756:9.8481320e-02 7802:1.3115078e-01 8366:1.1621507e-01 "
          "8737:7.8255713e-02 "
          "8738:7.8852646e-02 8973:1.0293191e-01 9023:1.4799172e-01 9850:1.4450552e-01 10078:1.2316786e-01 "
          "10740:2.4058978e-01 10843:1.5387842e-01 11134:1.2795007e-01 12763:1.3844594e-01 14469:1.5356319e-01 "
          "14676:1.8276082e-01 15419:1.1164500e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 20:1.2073731e-01 24:3.5655953e-02 69:1.1325333e-01 107:1.1424642e-01 130:1.9782786e-01 "
          "232:1.0235250e-01 "
          "286:1.4679986e-01 293:7.2204351e-02 365:8.6074553e-02 417:6.7884162e-02 427:2.4457857e-01 441:2.4106389e-01 "
          "481:1.8830538e-01 546:1.0681760e-01 548:2.5780097e-01 897:1.1200133e-01 942:2.7741858e-01 943:1.6695169e-01 "
          "1127:7.3659621e-02 1195:2.2788467e-01 1380:2.0838316e-01 1666:8.4799118e-02 3454:4.8966736e-01 "
          "3520:2.5584859e-01 "
          "4378:2.1127167e-01 9216:2.5179565e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:3.9171346e-02 43:2.0216760e-01 46:1.9029258e-01 69:5.2139089e-02 70:1.1253875e-01 73:6.7009635e-02 "
          "120:1.9993812e-01 136:1.2098891e-01 140:6.1686106e-02 223:9.8423898e-02 257:9.5987849e-02 302:1.1308473e-01 "
          "326:9.7150803e-02 379:1.6421561e-01 547:1.0748643e-01 622:1.5417385e-01 995:1.2297589e-01 "
          "1115:1.5013219e-01 "
          "1437:1.9826239e-01 1654:1.9660351e-01 1666:9.3159638e-02 1771:2.6663470e-01 2097:1.5543267e-01 "
          "2339:1.7796865e-01 "
          "2521:2.6805383e-01 3953:2.4137236e-01 5580:2.0304596e-01 6452:3.8592029e-01 7015:3.4150165e-01 "
          "9866:2.2703636e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:1.8516038e-02 14:5.8586579e-02 15:2.5750304e-02 20:2.0311356e-02 24:1.2588143e-02 26:3.3074327e-02 "
          "33:3.1448416e-02 36:4.9838841e-02 51:1.6361225e-02 64:3.9003368e-02 69:1.6755469e-02 74:3.2644913e-02 "
          "75:4.1107319e-02 87:4.1160576e-02 110:3.2084987e-02 130:4.1249849e-02 140:3.3564117e-02 144:4.4589933e-02 "
          "170:3.9018791e-02 180:7.2288379e-02 187:4.8841443e-02 189:3.2602787e-02 192:8.3332576e-02 209:3.6403954e-02 "
          "217:3.0371867e-02 230:5.6073252e-02 231:5.7938382e-02 238:3.2736611e-02 258:1.0765166e-01 263:4.9621865e-02 "
          "274:4.1557368e-02 277:4.7723729e-02 300:5.3621884e-02 315:3.7641302e-02 339:3.0841639e-02 343:5.6840003e-02 "
          "359:7.3570244e-02 397:5.9898067e-02 459:4.5762688e-02 464:2.5416646e-02 471:4.4789765e-02 514:6.9643617e-02 "
          "545:4.1067284e-02 586:7.3226281e-02 644:3.3840079e-02 645:1.1392449e-01 660:2.6162842e-02 678:5.3339019e-02 "
          "724:3.2718953e-02 741:6.4342000e-02 802:2.2993501e-02 817:5.2556951e-02 847:8.5882425e-02 890:1.4135604e-01 "
          "897:3.9541472e-02 954:4.9085278e-02 1059:2.6449664e-02 1075:5.2935231e-02 1130:5.3657804e-02 "
          "1162:4.5687102e-02 "
          "1229:6.4711317e-02 1342:4.3485243e-02 1354:6.3985102e-02 1425:5.4772157e-02 1443:5.0251774e-02 "
          "1449:1.2269042e-01 "
          "1486:5.3641118e-02 1540:8.1872955e-02 1620:6.5969527e-02 1629:5.9115831e-02 1653:1.0305288e-01 "
          "1765:3.9383307e-02 "
          "1861:6.7915432e-02 1982:9.0460964e-02 2018:5.1707879e-02 2094:6.0605444e-02 2104:9.2753686e-02 "
          "2132:8.0541968e-02 "
          "2298:1.7519163e-02 2349:5.8468226e-02 2360:5.1736195e-02 2388:7.5747959e-02 2438:5.5491470e-02 "
          "2538:5.7247214e-02 "
          "2574:8.1237905e-02 2640:1.5487242e-01 2659:8.3443388e-02 2769:6.5178983e-02 3144:5.7379927e-02 "
          "3230:1.9215894e-01 "
          "3287:8.2141235e-02 3534:8.7638319e-02 4268:1.9466157e-01 4380:8.2137160e-02 11614:7.6165825e-02 "
          "18285:1.0734633e-01 20845:2.8818318e-01 21696:1.2524238e-01 31932:6.6825104e-01 36527:1.2724198e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 3:4.7358435e-02 15:2.4254501e-02 20:1.9131495e-02 21:2.6111502e-02 45:2.1983711e-02 50:2.2172702e-02 "
          "55:2.3390761e-02 57:4.0895630e-02 73:2.0283384e-02 74:3.0748611e-02 82:4.1808978e-02 89:6.8412550e-02 "
          "90:3.1397574e-02 98:3.7309296e-02 126:7.7555694e-02 128:4.5157842e-02 161:4.9912736e-02 166:4.5912124e-02 "
          "179:2.6290277e-02 182:3.1579953e-02 188:3.4360055e-02 189:6.4446144e-02 193:3.3639815e-02 199:5.4847147e-02 "
          "208:4.0674243e-02 210:3.1867836e-02 221:6.5532342e-02 225:3.9829664e-02 237:1.1368909e-01 262:4.8825718e-02 "
          "269:4.5260560e-02 276:2.8402301e-02 286:1.8707611e-02 288:2.5237504e-02 297:3.1996328e-02 309:4.0889412e-02 "
          "334:6.6167846e-02 389:4.7552075e-02 415:3.9415006e-02 426:1.4585848e-01 433:5.6439180e-02 439:4.4865306e-02 "
          "495:5.2703764e-02 516:4.1246764e-02 526:2.3442248e-02 533:4.8588138e-02 550:3.5411209e-02 555:2.9516997e-02 "
          "575:3.6909293e-02 586:3.2865837e-02 587:3.8754307e-02 594:4.8484724e-02 600:6.7093514e-02 625:4.0275294e-02 "
          "678:5.0240625e-02 744:6.5437056e-02 746:7.2542876e-02 757:3.9228532e-02 760:5.2868284e-02 773:3.4703441e-02 "
          "802:2.1657838e-02 813:7.1046472e-02 820:1.1885653e-01 838:5.0711863e-02 897:3.7244558e-02 898:4.6278551e-02 "
          "915:5.3349100e-02 927:4.1905720e-02 933:4.7382742e-02 945:4.2812083e-02 963:4.0934265e-02 990:6.1073072e-02 "
          "1022:6.9794588e-02 1024:4.9241688e-02 1028:2.7822208e-02 1059:4.2181775e-02 1132:3.6350716e-02 "
          "1133:5.1777687e-02 "
          "1137:9.4155788e-02 1138:7.2905622e-02 1166:1.5225866e-01 1188:5.3392015e-02 1209:7.2689667e-02 "
          "1213:5.9787054e-02 "
          "1218:5.7343896e-02 1266:1.3495232e-01 1345:5.8170050e-02 1347:5.8434419e-02 1394:5.1975317e-02 "
          "1434:4.9559277e-02 "
          "1440:8.7779030e-02 1443:4.7332712e-02 1455:2.6650727e-02 1473:7.2197050e-02 1534:2.1446846e-01 "
          "1544:9.9091224e-02 "
          "1557:3.9029095e-02 1559:1.1038345e-01 1573:5.0678849e-02 1616:6.1794475e-02 1623:3.9730843e-02 "
          "1670:8.4443495e-02 "
          "1769:7.4370086e-02 1788:6.3642830e-02 1790:9.1352969e-02 1982:5.0324157e-02 1998:5.2470442e-02 "
          "2079:5.5429198e-02 "
          "2131:5.9589084e-02 2168:6.3453071e-02 2260:6.5270834e-02 2311:5.1850986e-02 2371:8.0695875e-02 "
          "2433:5.4071467e-02 "
          "2445:8.2646713e-02 2526:5.6062989e-02 2607:1.1140538e-01 2747:6.1531495e-02 2771:5.6002930e-02 "
          "2860:7.8479633e-02 "
          "2879:7.0316926e-02 3010:1.7799324e-01 3066:1.1420924e-01 3188:7.6543823e-02 3338:1.0727878e-01 "
          "3434:5.9080135e-02 "
          "3565:6.6812322e-02 3588:6.6359051e-02 3684:6.4057574e-02 3762:8.0069751e-02 3812:7.6882236e-02 "
          "4002:8.0065124e-02 "
          "4060:6.7274459e-02 4241:2.1469857e-01 4254:5.6826130e-02 5239:8.0859363e-02 5253:7.2261773e-02 "
          "5740:6.9525748e-02 "
          "6005:1.0551034e-01 6749:8.2796775e-02 7605:2.1471533e-01 8538:2.1077296e-01 10200:1.0008208e-01 "
          "10417:2.9210812e-01 13732:2.1699969e-01 13934:2.2996841e-01 13939:1.0878794e-01 15164:1.0832625e-01 "
          "32336:1.3652714e-01 42502:1.1495851e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 18:8.0745719e-02 22:8.7020926e-02 24:2.0303031e-02 51:2.6388519e-02 74:5.2651979e-02 "
          "101:6.5899082e-02 "
          "112:1.1463179e-01 182:5.4075517e-02 196:8.5973725e-02 252:4.9714115e-02 262:8.3606079e-02 269:4.5773529e-02 "
          "271:4.0251508e-02 315:6.0710505e-02 363:7.1334779e-02 411:1.7910612e-01 480:7.8725666e-02 567:1.0628074e-01 "
          "660:4.2197246e-02 682:1.0486832e-01 684:7.1260199e-02 807:9.4731338e-02 815:7.5384922e-02 930:1.4533933e-01 "
          "963:7.0093244e-02 986:9.3671329e-02 1132:6.2244669e-02 1273:9.8223090e-02 1449:7.5833805e-02 "
          "1747:9.8095797e-02 "
          "1760:2.2929570e-01 1825:9.9676915e-02 2009:1.9713973e-01 2021:1.2721319e-01 2082:1.3478462e-01 "
          "2084:1.0731042e-01 "
          "2098:8.7308727e-02 2099:8.7812640e-02 2220:3.5174122e-01 2224:1.1127596e-01 2757:1.1245256e-01 "
          "2912:3.0940869e-01 "
          "2949:8.6363457e-02 2977:2.5625414e-01 3484:1.7622931e-01 3742:1.0572089e-01 4539:1.3320422e-01 "
          "4595:1.3868551e-01 "
          "4603:1.2284106e-01 4697:2.1581642e-01 5153:1.5856999e-01 7118:1.6339099e-01 24186:3.3701989e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:3.9159972e-02 20:2.5371054e-02 23:4.7855541e-02 24:3.7521940e-02 39:3.4890711e-02 48:5.4457892e-02 "
          "49:5.7011027e-02 51:4.2889167e-02 62:6.6033185e-02 64:4.8719376e-02 73:2.6898621e-02 90:4.1637599e-02 "
          "110:6.7857243e-02 140:2.4761682e-02 148:7.7972256e-02 167:5.4951765e-02 188:3.6762580e-02 209:4.5472428e-02 "
          "217:3.7937708e-02 218:6.6056095e-02 222:6.2143553e-02 236:3.4334127e-02 257:9.1946036e-02 284:3.3611208e-02 "
          "286:2.4808923e-02 297:4.2431634e-02 311:5.0205078e-02 337:4.7472537e-02 342:1.1047814e-01 357:6.1185021e-02 "
          "387:6.3558698e-02 426:6.2812969e-02 437:5.4130074e-02 516:5.4699015e-02 545:5.1297426e-02 575:4.8946917e-02 "
          "584:7.2715618e-02 585:5.3139832e-02 586:4.3584727e-02 601:6.8212137e-02 613:9.4543688e-02 615:9.2439875e-02 "
          "625:5.3410705e-02 664:5.5280939e-02 673:5.3723581e-02 681:7.6876163e-02 768:5.4134175e-02 803:5.7542909e-02 "
          "814:5.3366080e-02 837:5.7455387e-02 866:6.2867828e-02 942:7.2255373e-02 945:9.6128166e-02 "
          "1013:1.0866900e-01 "
          "1040:1.3062423e-01 1066:7.2912864e-02 1073:6.1340798e-02 1084:7.3174991e-02 1094:5.4305702e-02 "
          "1173:8.1985824e-02 "
          "1188:7.0805326e-02 1213:3.3225596e-02 1224:1.0085057e-01 1234:7.9911686e-02 1380:5.4274667e-02 "
          "1422:4.5544270e-02 "
          "1455:3.5342615e-02 1538:1.5897942e-01 1546:8.8325009e-02 1587:8.3228551e-02 1641:1.0254212e-01 "
          "1643:7.4279465e-02 "
          "1664:4.9875583e-02 1668:6.1659232e-02 1674:4.4665754e-02 1731:5.6135308e-02 1857:7.7728666e-02 "
          "2016:6.7030750e-02 "
          "2080:1.1662649e-01 2229:7.5849317e-02 2298:2.1883307e-02 2311:6.8761699e-02 2526:7.4347407e-02 "
          "2581:1.9879921e-01 "
          "2669:1.1100002e-01 2682:2.5606436e-01 2834:7.5538412e-02 2950:7.6188557e-02 3013:6.8648785e-02 "
          "3164:7.9526886e-02 "
          "3230:6.8876177e-02 3240:7.7508859e-02 3424:1.1482613e-01 3570:7.9955623e-02 3660:1.0287525e-01 "
          "4276:6.7784339e-02 "
          "4402:1.0120752e-01 4421:1.5083607e-01 5205:1.0848998e-01 5388:9.6220344e-02 6151:1.0439683e-01 "
          "6263:1.4830780e-01 "
          "6321:1.1211188e-01 9047:1.5158699e-01 9048:1.5423070e-01 9050:1.4074524e-01 9051:1.3723719e-01 "
          "9592:1.2441593e-01 "
          "11010:1.6001624e-01 13055:1.2206364e-01 18099:1.8915881e-01 25284:1.5773876e-01 33854:1.7134602e-01 "
          "36164:1.7960684e-01 36175:1.9212481e-01 36317:2.0546171e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 3:5.9084825e-02 5:2.1758886e-02 9:3.5990648e-02 10:3.9026849e-02 24:2.5046382e-02 47:6.0796466e-02 "
          "48:5.1233005e-02 49:3.1677663e-02 50:4.6837308e-02 51:4.0349357e-02 90:3.9171904e-02 112:4.9328711e-02 "
          "141:5.3779248e-02 161:8.7764584e-02 171:6.5016478e-02 175:4.9322702e-02 188:4.8744347e-02 189:6.4869128e-02 "
          "193:7.1060278e-02 208:5.0745565e-02 221:8.1758760e-02 222:1.6321613e-01 225:4.9691860e-02 229:5.3915251e-02 "
          "233:4.9980056e-02 234:3.9029650e-02 236:5.4690223e-02 269:3.3350613e-02 271:4.9655374e-02 281:7.6751180e-02 "
          "297:3.9918914e-02 300:6.3013077e-02 312:4.9589358e-02 319:6.8835489e-02 339:3.6243159e-02 351:7.7560209e-02 "
          "393:5.4657303e-02 417:4.7684964e-02 458:1.6547404e-01 464:2.9868048e-02 477:5.3189535e-02 481:4.6140924e-02 "
          "516:5.1459849e-02 548:6.3169591e-02 561:1.0268465e-01 562:1.0309701e-01 578:5.8545705e-02 593:1.0409700e-01 "
          "606:1.0879382e-01 616:4.8436508e-02 620:3.3540253e-02 623:4.9841437e-02 628:5.2893545e-02 678:7.7691071e-02 "
          "817:6.1761633e-02 910:6.2142912e-02 992:5.2244555e-02 1024:6.1434388e-02 1040:4.7094025e-02 "
          "1059:5.2626375e-02 "
          "1106:8.6182766e-02 1162:5.3688616e-02 1171:6.0900681e-02 1173:9.5601618e-02 1188:6.6612378e-02 "
          "1212:5.8467634e-02 "
          "1213:3.1258043e-02 1243:6.0819127e-02 1295:5.9879534e-02 1296:1.1997771e-01 1373:5.8197889e-02 "
          "1416:6.1908364e-02 "
          "1419:1.3573970e-01 1422:8.9919724e-02 1426:4.4874817e-02 1455:3.3249695e-02 1528:6.0815793e-02 "
          "1540:5.6824338e-02 "
          "1549:8.7487832e-02 1569:1.0293916e-01 1575:5.6237571e-02 1576:8.6318664e-02 1694:7.0099950e-02 "
          "1723:1.9721478e-01 "
          "1853:9.8646112e-02 1872:8.1128895e-02 1910:6.7586601e-02 2023:1.3265592e-01 2069:1.0506098e-01 "
          "2228:9.6441127e-02 "
          "2280:1.4968111e-01 2298:2.0587422e-02 2313:1.9874728e-01 2347:6.3571200e-02 2359:8.6002246e-02 "
          "2419:1.3584435e-01 "
          "2438:6.5210097e-02 2937:8.2267947e-02 2942:6.9918230e-02 2949:6.2924452e-02 3010:1.5819575e-01 "
          "3090:9.5375471e-02 "
          "3209:1.0040537e-01 3353:9.4445854e-02 3393:1.1561656e-01 3479:9.2122458e-02 3674:8.1145287e-02 "
          "3850:9.7261183e-02 "
          "4075:7.8804411e-02 4346:1.4267352e-01 4401:1.4131436e-01 4421:8.3810702e-02 4986:1.0424231e-01 "
          "5477:9.4634905e-02 "
          "5583:1.2110616e-01 6115:2.1525595e-01 6675:8.9913279e-02 7502:1.0205891e-01 10123:1.2226074e-01 "
          "10771:1.1874972e-01 13775:1.3189581e-01 22643:1.0125681e-01 39128:1.4717700e-01 40689:2.8476065e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:3.7628341e-02 13:4.9384743e-02 19:5.5171680e-02 33:6.3909553e-02 39:5.6764551e-02 51:5.6295998e-02 "
          "69:3.4050509e-02 218:6.3472494e-02 236:1.1722644e-01 271:1.0643444e-01 305:7.1995698e-02 323:9.1776468e-02 "
          "357:9.9543408e-02 381:1.7333913e-01 393:9.4520621e-02 464:5.1651772e-02 549:1.3290125e-01 613:5.2213214e-02 "
          "996:1.2274128e-01 1071:7.2727069e-02 1193:6.8862312e-02 1195:9.6564397e-02 1213:5.4055534e-02 "
          "1520:1.2150855e-01 "
          "1617:1.0288958e-01 1731:9.1327906e-02 2107:9.5919371e-02 2298:3.5602488e-02 2381:1.2149495e-01 "
          "2502:1.9364254e-01 "
          "2534:1.0955136e-01 4102:1.3640073e-01 4192:1.6333564e-01 4476:3.6165452e-01 7304:1.6357312e-01 "
          "7987:1.6194734e-01 "
          "10657:1.7831282e-01 10688:2.0421824e-01 12784:1.9788939e-01 12798:2.2486965e-01 12801:2.3880054e-01 "
          "12805:4.1293827e-01 13680:1.8357480e-01 16271:2.5984645e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 18:8.7572038e-02 20:8.4782861e-02 26:5.7854366e-02 32:6.3931584e-02 39:4.8860211e-02 47:1.5322497e-01 "
          "70:1.1006905e-01 73:8.9887559e-02 74:5.7103224e-02 99:7.7902503e-02 136:1.4273028e-01 145:1.3566193e-01 "
          "188:5.1481538e-02 218:5.4634091e-02 238:5.7263628e-02 240:5.0562363e-02 257:5.3957842e-02 277:1.2865651e-01 "
          "284:7.9693779e-02 295:1.5530632e-01 297:5.9420358e-02 326:5.4611575e-02 336:6.5216936e-02 338:9.8262414e-02 "
          "343:2.0865628e-01 434:7.9390481e-02 441:8.7924972e-02 553:1.3579631e-01 757:7.2851278e-02 774:1.5193069e-01 "
          "929:7.4872836e-02 995:1.6496140e-01 1086:8.9128494e-02 1115:8.4394112e-02 1160:1.3975473e-01 "
          "1189:1.2984052e-01 "
          "1191:1.8087693e-01 1288:2.0186995e-01 1315:1.8967925e-01 1380:7.6005094e-02 1429:1.5577805e-01 "
          "1619:1.2390185e-01 "
          "1629:6.1073691e-02 1654:1.5513752e-01 1666:5.2368015e-02 1674:6.2548973e-02 1744:1.1701706e-01 "
          "1850:1.9380710e-01 "
          "1906:8.1850663e-02 1922:1.0363077e-01 2308:1.1504298e-01 2315:1.1394147e-01 2339:1.0004187e-01 "
          "2362:1.4624435e-01 "
          "2521:8.8995002e-02 3722:1.2615867e-01 3841:7.8739211e-02 3921:1.9229399e-01 4150:2.0020519e-01 "
          "5578:2.1461913e-01 "
          "5700:1.7064255e-01 5792:1.1286958e-01 5889:2.5777966e-01 6750:1.4498477e-01 6956:1.2228003e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 18:4.0408708e-02 20:4.6998393e-02 23:8.8649593e-02 24:1.7203273e-02 33:4.2978194e-02 51:2.2359662e-02 "
          "55:3.3937804e-02 74:4.4613354e-02 90:4.5554940e-02 95:6.5728545e-02 127:1.1432914e-01 140:2.7091306e-02 "
          "141:6.2542543e-02 144:6.0937721e-02 161:4.2771656e-02 188:2.3755329e-02 236:3.7564341e-02 257:4.2155944e-02 "
          "264:9.6923582e-02 293:3.4837134e-02 326:4.2666689e-02 351:1.5271950e-01 357:1.1334167e-01 358:1.3093849e-01 "
          "437:5.9222728e-02 465:1.2304399e-01 594:7.0346795e-02 613:3.5112586e-02 644:4.6246700e-02 681:8.4108807e-02 "
          "686:7.0922799e-02 689:9.0450428e-02 709:7.5923212e-02 726:9.2855953e-02 801:8.9263342e-02 811:9.0912096e-02 "
          "815:6.3875556e-02 929:5.8496319e-02 1059:3.6146775e-02 1132:5.2741483e-02 1162:6.2437136e-02 "
          "1449:6.4255901e-02 "
          "1523:1.2029312e-01 1530:1.3137791e-01 1546:5.7074063e-02 1619:9.6801490e-02 1690:7.6980703e-02 "
          "2031:8.7978862e-02 "
          "2032:1.0238650e-01 2039:1.5201813e-01 2083:8.1095770e-02 2153:9.4314106e-02 2298:2.3942128e-02 "
          "2314:1.3721265e-01 "
          "2379:8.0361210e-02 2538:2.0415063e-01 3230:1.2758908e-01 3507:1.3732426e-01 4525:8.3961420e-02 "
          "5424:8.7805338e-02 "
          "5707:1.0682561e-01 5973:1.0954449e-01 6763:1.3737038e-01 10620:4.0032670e-01 12398:2.3920521e-01 "
          "12424:3.8842773e-01 12591:1.3022164e-01 37218:1.6447216e-01 38739:2.7703863e-01 45688:1.7307445e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 6:1.2098865e-01 50:5.2476481e-02 69:6.3242264e-02 126:8.7463625e-02 207:1.0415624e-01 "
          "438:8.9410968e-02 "
          "512:2.6048249e-01 558:7.9431474e-02 646:1.1980396e-01 678:7.0227362e-02 813:1.6814679e-01 824:3.3227935e-01 "
          "894:1.1708596e-01 1075:1.9980006e-01 1091:1.3702656e-01 1101:2.0968843e-01 1163:5.2672112e-01 "
          "1188:7.4632443e-02 "
          "1213:5.9296522e-02 1342:9.6938871e-02 1540:1.0779580e-01 2152:2.1634987e-01 3969:2.8123641e-01 "
          "5306:2.7099904e-01 "
          "10494:1.8709086e-01 11448:2.4845472e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 15:6.4791188e-02 24:6.6470273e-02 39:1.1899768e-01 51:4.1167017e-02 69:4.2158987e-02 73:5.4183118e-02 "
          "140:8.4451780e-02 188:4.3736622e-02 233:1.0701427e-01 240:7.2730370e-02 257:7.7614523e-02 535:9.9777639e-02 "
          "573:8.1711777e-02 765:1.5945594e-01 1029:1.7042992e-01 1424:2.8600758e-01 1645:1.3757850e-01 "
          "1654:1.2825683e-01 "
          "1666:7.5327672e-02 1682:1.2413702e-01 1872:1.7370827e-01 1995:1.6365911e-01 2098:1.3620467e-01 "
          "2099:1.3699080e-01 "
          "2200:3.2016778e-01 2244:1.6817980e-01 2298:4.4080541e-02 2521:1.2801298e-01 2522:2.9314810e-01 "
          "2553:1.9605805e-01 "
          "2806:1.3897239e-01 3146:4.0099138e-01 8040:4.2632872e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 16:8.0772400e-02 24:4.2679664e-02 39:5.5933859e-02 46:1.2245587e-01 61:6.8132281e-02 69:8.0065459e-02 "
          "70:7.2420225e-02 73:4.3121610e-02 123:1.1587596e-01 136:7.7858016e-02 140:6.7210913e-02 232:7.2359018e-02 "
          "238:1.1099234e-01 240:5.7882436e-02 257:6.1769485e-02 277:5.6442235e-02 282:1.1423545e-01 284:9.1231294e-02 "
          "337:7.6103985e-02 342:8.4393516e-02 347:1.7660514e-01 393:9.3137406e-02 469:9.3900383e-02 497:7.5940572e-02 "
          "573:6.5030284e-02 607:2.0964871e-01 617:7.4383549e-02 627:9.3399696e-02 678:6.3083366e-02 724:6.5518506e-02 "
          "821:1.7550419e-01 842:8.4034465e-02 957:1.6723491e-01 976:1.1589795e-01 1288:8.2777657e-02 "
          "1654:1.0207315e-01 "
          "1655:1.0973319e-01 1657:1.5598305e-01 1664:1.3537787e-01 2010:1.1079687e-01 2250:1.7429036e-01 "
          "3339:1.5502429e-01 "
          "3841:9.0138532e-02 4531:1.2283003e-01 6129:2.0567685e-01 10889:2.1611153e-01 26273:6.4333236e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 15:2.0185906e-02 16:3.1620182e-02 33:6.4329728e-02 42:6.5220691e-02 76:3.5135489e-02 79:2.6577581e-02 "
          "98:5.2573599e-02 112:6.9057256e-02 199:1.0892662e-01 209:2.8537406e-02 231:2.6824869e-02 233:1.9691525e-02 "
          "250:5.3470396e-02 265:7.7491850e-02 278:9.2426926e-02 288:3.5562892e-02 318:3.8133956e-02 378:4.3090548e-02 "
          "380:3.2602485e-02 411:7.0232749e-02 453:2.8421521e-02 511:3.2868009e-02 533:1.9268770e-02 545:3.2193035e-02 "
          "555:2.4565641e-02 575:3.0717909e-02 577:5.2096285e-02 591:5.2922376e-02 630:3.8109258e-02 709:9.1395184e-02 "
          "836:6.2105507e-02 882:4.1554693e-02 915:4.4400007e-02 1021:4.3697525e-02 1024:4.0981594e-02 "
          "1043:6.9367610e-02 "
          "1045:3.5665449e-02 1140:6.0001481e-02 1156:4.6114266e-02 1162:3.5814550e-02 1295:3.9944384e-02 "
          "1321:6.4579330e-02 "
          "1422:2.8582489e-02 1443:3.9392844e-02 1456:4.3135028e-02 1493:9.4359346e-02 1554:3.5867773e-02 "
          "1592:6.7311816e-02 "
          "1655:7.2733440e-02 1658:4.0340260e-02 1659:4.7892988e-02 1694:4.6762209e-02 1727:6.3633800e-02 "
          "1769:6.1894808e-02 "
          "1798:4.9446695e-02 1825:4.8446380e-02 1831:5.1770251e-02 1888:1.2383496e-01 2014:4.7153302e-02 "
          "2253:1.2668258e-01 "
          "2367:1.3431102e-01 2438:4.3500293e-02 2495:4.3427363e-02 2554:8.7135687e-02 2556:1.4377250e-01 "
          "2577:4.6454154e-02 "
          "2624:2.0485513e-01 2633:9.5547348e-02 2653:1.0706793e-01 2656:8.9370579e-02 2806:4.3297306e-02 "
          "2848:8.4967472e-02 "
          "2863:8.1920885e-02 3057:6.6088557e-02 3090:1.0772307e-01 3457:4.1507967e-02 3617:1.1091338e-01 "
          "3623:6.8894014e-02 "
          "4235:9.1617800e-02 4307:6.1675694e-02 4337:8.1722550e-02 4376:8.9169741e-02 4387:7.5804561e-02 "
          "4421:9.4661094e-02 "
          "4957:9.9468894e-02 4988:7.6037273e-02 4989:1.4850606e-01 5416:7.0002258e-02 6349:1.0443484e-01 "
          "7758:1.3907754e-01 "
          "8976:1.8869515e-01 9200:1.1005748e-01 10432:7.9958431e-02 15744:1.0350227e-01 16079:7.8050673e-02 "
          "16531:1.6364588e-01 16609:8.7585360e-02 16610:1.1709910e-01 16611:2.0531632e-01 16615:7.1588524e-02 "
          "17026:9.4458029e-02 17125:1.7483428e-01 17127:8.9967325e-02 17129:1.6310476e-01 18068:9.6377440e-02 "
          "18457:1.6477306e-01 18979:1.6177572e-01 23431:8.7093294e-02 26425:1.4575987e-01 27608:1.1271694e-01 "
          "31485:1.6356769e-01 31574:1.7919438e-01 35351:1.8518810e-01 38724:1.1005748e-01 40125:1.3731274e-01 "
          "42331:1.0697608e-01 43409:1.6527583e-01 44576:1.1900251e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 3:1.0156966e-01 5:3.7404574e-02 7:1.0576087e-01 17:4.7164250e-02 53:6.9515519e-02 54:4.4156123e-02 "
          "55:5.0166178e-02 61:6.8732955e-02 64:4.6535462e-02 124:1.0925927e-01 175:8.4788106e-02 196:1.0768202e-01 "
          "230:6.6901781e-02 236:5.5526853e-02 240:5.8392745e-02 264:8.4617861e-02 271:5.0414983e-02 286:4.0122222e-02 "
          "293:5.1495552e-02 417:4.8414428e-02 471:1.8988369e-01 506:6.6742852e-02 620:1.2100034e-01 642:7.7197142e-02 "
          "673:8.6884446e-02 702:6.8197966e-02 785:1.1870509e-01 837:1.5732673e-01 994:1.0302410e-01 "
          "1059:5.3431433e-02 "
          "1122:1.3479076e-01 1127:5.2533433e-02 1218:7.2637208e-02 1308:2.2754733e-01 1321:9.8290056e-02 "
          "1342:8.7845311e-02 "
          "1419:1.1118922e-01 1429:1.0625346e-01 1815:1.9484176e-01 2234:9.1504656e-02 2288:1.1371735e-01 "
          "2298:3.5390768e-02 "
          "2563:3.3616331e-01 3457:1.0696512e-01 3570:1.2930819e-01 4030:1.8469220e-01 4585:1.7205504e-01 "
          "4895:1.7620306e-01 "
          "4965:3.3545464e-01 6177:4.0619469e-01 6203:1.5825327e-01 8889:1.6577055e-01 9104:1.7191488e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 20:4.8953988e-02 33:7.5796291e-02 62:1.2741242e-01 64:1.1651685e-01 69:4.0383667e-02 "
          "179:6.7272000e-02 "
          "336:8.9859590e-02 459:1.8674774e-01 547:8.3252251e-02 553:8.9157887e-02 583:1.4113948e-01 942:1.3941826e-01 "
          "943:1.4205930e-01 1100:1.5015230e-01 1211:1.3720445e-01 1405:1.7953703e-01 1511:1.0498514e-01 "
          "1629:8.4150791e-02 "
          "1762:3.3362228e-01 1778:1.3403487e-01 2124:4.1716281e-01 2137:1.7285104e-01 2335:1.3054898e-01 "
          "2345:2.6876619e-01 "
          "2348:1.7529412e-01 2350:2.3883314e-01 2520:1.4744107e-01 3266:1.7590235e-01 3271:1.2289599e-01 "
          "3492:2.2276691e-01 "
          "5791:1.4828257e-01 6859:2.0540875e-01 13199:2.3453712e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:6.0451169e-02 15:8.4069595e-02 17:6.1497211e-02 21:7.3019855e-02 32:5.6858413e-02 41:1.0235861e-01 "
          "45:9.4746329e-02 50:6.2005147e-02 51:2.5453074e-02 53:5.3533975e-02 64:6.0677338e-02 69:4.4134248e-02 "
          "73:3.3500772e-02 74:5.0785523e-02 75:6.3950442e-02 77:9.2674732e-02 79:5.2744105e-02 90:5.1857371e-02 "
          "102:4.9297985e-02 108:8.8814519e-02 117:5.8110856e-02 128:1.2628224e-01 130:1.0865295e-01 191:6.1330181e-02 "
          "209:5.6633443e-02 215:6.6669792e-02 220:6.4669259e-02 233:1.1512174e-01 242:7.7921517e-02 258:6.4179771e-02 "
          "271:3.8824633e-02 284:4.1860938e-02 286:8.0626853e-02 295:5.7882115e-02 301:1.0165110e-01 336:9.8205186e-02 "
          "337:5.9124470e-02 349:6.6431180e-02 368:8.2842223e-02 379:8.2097895e-02 433:4.4418398e-02 439:7.4101165e-02 "
          "453:5.6403469e-02 454:5.4944467e-02 456:9.4895147e-02 464:8.2980268e-02 467:8.9273289e-02 478:1.1296659e-01 "
          "495:8.7047450e-02 496:7.6245435e-02 504:8.0449603e-02 506:8.7025642e-02 510:1.3066985e-01 511:6.5227672e-02 "
          "512:7.6176822e-02 524:7.4981228e-02 526:3.8718067e-02 530:9.2433959e-02 550:5.8486439e-02 573:5.0521415e-02 "
          "576:7.7627771e-02 601:8.4954508e-02 617:5.7787880e-02 625:6.6520140e-02 686:8.0734827e-02 764:6.7785382e-02 "
          "767:6.6074267e-02 785:9.1414921e-02 802:3.5770871e-02 825:1.2727174e-01 842:3.8558714e-02 931:2.5729227e-01 "
          "1038:7.7015743e-02 1127:4.0456057e-02 1305:7.3919445e-02 1492:7.9681881e-02 1557:6.4461872e-02 "
          "1601:1.2562132e-01 "
          "1654:4.6835661e-02 1701:1.6003096e-01 1726:7.2602555e-02 1947:1.4504695e-01 1956:1.2310752e-01 "
          "1994:8.8415883e-02 "
          "2190:8.2328200e-02 2327:1.1314688e-01 2337:1.2263696e-01 2762:9.6500367e-02 2799:2.2675401e-01 "
          "2874:9.8467998e-02 "
          "3074:9.7945198e-02 3917:1.1587010e-01 6853:3.0042362e-01 6871:1.0875712e-01 7433:1.5858822e-01 "
          "7486:1.0017461e-01 "
          "7877:1.5802112e-01 8725:1.2541343e-01 10593:1.4633317e-01 11817:1.5983672e-01 11818:1.6461062e-01 "
          "19584:1.8589900e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 23:4.5061734e-02 42:5.7796299e-02 55:6.9700137e-02 73:2.5328279e-02 85:4.4580914e-02 "
          "110:3.7737846e-02 "
          "117:4.3934748e-02 121:4.6958577e-02 146:6.7057885e-02 147:3.8083300e-02 161:3.6811367e-02 188:3.4616381e-02 "
          "209:4.2817749e-02 225:8.4210575e-02 230:8.1746377e-02 276:9.2547730e-02 293:2.9982531e-02 307:1.4044575e-01 "
          "319:4.0691562e-02 336:9.2028588e-02 342:4.9570099e-02 344:5.7241056e-02 349:5.0225332e-02 354:4.5617964e-02 "
          "390:6.7566454e-02 464:2.9894652e-02 477:5.3236913e-02 482:6.6783860e-02 506:3.8860053e-02 526:2.9272819e-02 "
          "545:4.8302680e-02 558:7.0958845e-02 578:9.9214785e-02 585:1.4740606e-01 587:4.8393298e-02 678:3.7053190e-02 "
          "680:9.1510572e-02 690:5.3407639e-02 845:7.0552230e-02 910:6.2198263e-02 915:6.6618122e-02 932:4.9191333e-02 "
          "945:1.5748933e-01 967:6.0056239e-02 1029:7.9668663e-02 1038:5.8227796e-02 1040:9.8920129e-02 "
          "1099:5.6150321e-02 "
          "1173:4.5595262e-02 1189:5.1563893e-02 1213:6.5656945e-02 1221:1.3835070e-01 1342:5.1146649e-02 "
          "1398:5.7955842e-02 "
          "1399:5.7585735e-02 1454:4.2998534e-02 1455:3.3279311e-02 1468:1.1218274e-01 1492:6.0243532e-02 "
          "1538:1.4969820e-01 "
          "1544:5.1853307e-02 1560:6.7501858e-02 1584:7.0707791e-02 1623:4.9612720e-02 1773:6.1403673e-02 "
          "1803:8.3119616e-02 "
          "2028:5.8692295e-02 2234:5.3277250e-02 2438:6.5268181e-02 2515:6.9107994e-02 2744:8.7709047e-02 "
          "2971:8.1641048e-02 "
          "3026:7.0893683e-02 3128:8.9201622e-02 3228:8.3975919e-02 3254:1.2250941e-01 3268:1.1959100e-01 "
          "3272:8.7904707e-02 "
          "3317:1.2106538e-01 3329:1.1245076e-01 3330:2.2762235e-01 3534:1.0307879e-01 3570:7.5287811e-02 "
          "3578:9.6517473e-02 "
          "3721:9.9680915e-02 3899:8.0509335e-02 3937:8.3642125e-02 4554:1.0629721e-01 5020:1.0303085e-01 "
          "5602:9.5953457e-02 "
          "5733:1.9126293e-01 6669:1.7401521e-01 8066:9.4827600e-02 8217:1.1098199e-01 8237:9.8983884e-02 "
          "8728:1.0975181e-01 "
          "9429:1.1682741e-01 13491:2.1860139e-01 30652:4.7439462e-01 30862:1.5835567e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:2.4928726e-02 9:4.1233778e-02 20:2.7345821e-02 24:4.9926743e-02 36:6.7099608e-02 38:9.7026668e-02 "
          "46:4.8626427e-02 48:5.8696643e-02 54:2.9428378e-02 64:3.1014116e-02 66:7.0692375e-02 69:2.2558419e-02 "
          "76:6.0343724e-02 78:1.9003981e-01 82:5.9760138e-02 84:5.2963521e-02 127:1.1263143e-01 161:4.2136528e-02 "
          "177:9.0046637e-02 182:4.5139167e-02 189:4.3894164e-02 207:1.0650647e-01 225:5.6930985e-02 229:3.6482144e-02 "
          "233:3.3819366e-02 236:3.7006535e-02 252:4.1498516e-02 265:7.8604504e-02 284:9.4533026e-02 293:3.4319825e-02 "
          "327:4.5324638e-02 354:8.8411227e-02 364:4.3407358e-02 381:5.4720424e-02 417:3.2266375e-02 434:6.1104801e-02 "
          "454:4.7550119e-02 465:2.2046533e-01 479:7.8951694e-02 497:5.1057708e-02 541:9.7181499e-02 545:5.5290181e-02 "
          "550:5.0615415e-02 558:4.7972087e-02 564:1.1825913e-01 586:4.6977162e-02 589:1.8084206e-01 606:5.9393030e-02 "
          "616:5.5492751e-02 627:6.2796138e-02 628:1.2717400e-01 634:1.0327274e-01 655:6.5344781e-02 668:7.8290798e-02 "
          "693:7.5074412e-02 702:4.5451351e-02 769:6.2916011e-02 802:3.0956877e-02 815:6.2927045e-02 922:9.2117511e-02 "
          "927:5.9898421e-02 929:5.7627689e-02 945:1.4602675e-01 1003:7.2843835e-02 1012:8.3661675e-02 "
          "1024:1.1917075e-01 "
          "1026:7.8236476e-02 1036:6.0430132e-02 1040:5.3954694e-02 1059:3.5610020e-02 1062:6.7497447e-02 "
          "1063:9.1570206e-02 "
          "1094:1.2283725e-01 1113:1.0142004e-01 1127:3.5011537e-02 1173:5.2191105e-02 1243:6.9679275e-02 "
          "1342:5.8545560e-02 "
          "1373:6.6676177e-02 1422:8.3115280e-02 1503:6.9814198e-02 1511:5.8644962e-02 1528:6.9675453e-02 "
          "1575:1.8980581e-01 "
          "1592:1.1560522e-01 1664:5.3757668e-02 1700:8.8343546e-02 1711:9.9570274e-02 1747:1.7184444e-01 "
          "1791:1.1288148e-01 "
          "1889:9.9018261e-02 1921:7.0489570e-02 1964:8.7833054e-02 1984:7.9414465e-02 2016:7.2248116e-02 "
          "2097:6.7249261e-02 "
          "2534:7.2577633e-02 2596:2.8627947e-01 2687:1.0340053e-01 2771:8.0048427e-02 2858:9.0680525e-02 "
          "3111:1.0250722e-01 "
          "3564:1.1686731e-01 3655:8.7259784e-02 3852:9.5541455e-02 4075:9.0284660e-02 5166:9.4897412e-02 "
          "5168:1.8965003e-01 "
          "5767:1.6345601e-01 5904:1.3801457e-01 9059:1.2279136e-01 10071:1.2144117e-01 10663:2.5136089e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 8:1.3124579e-01 24:6.9456123e-02 26:6.9934726e-02 50:8.4276251e-02 51:3.4595348e-02 54:7.8254782e-02 "
          "61:1.2181056e-01 69:5.9986454e-02 74:6.9026738e-02 92:1.0852078e-01 99:9.4169043e-02 102:6.7004904e-02 "
          "106:1.4124018e-01 140:1.1702008e-01 175:8.8748321e-02 184:1.6356766e-01 232:7.6406442e-02 277:1.2507592e-01 "
          "297:7.1827710e-02 305:7.4910283e-02 321:9.5425412e-02 339:1.3685843e-01 341:9.1970772e-02 347:1.5045378e-01 "
          "349:9.0292029e-02 367:1.4481646e-01 455:1.3163732e-01 497:1.3577063e-01 663:1.3782199e-01 675:2.0167525e-01 "
          "757:8.8063091e-02 802:4.8619106e-02 842:8.8734955e-02 929:9.0506762e-02 984:1.0264526e-01 "
          "1056:9.4617479e-02 "
          "1160:2.6036075e-01 1288:1.4799434e-01 1557:8.7615386e-02 1598:1.9646087e-01 1616:1.3872078e-01 "
          "1664:8.4428728e-02 "
          "1815:2.0394227e-01 1871:1.2104589e-01 1919:1.2486807e-01 1988:1.2453250e-01 2000:1.7775108e-01 "
          "2455:2.4160595e-01 "
          "2474:1.1086076e-01 2493:8.7126516e-02 2879:2.6726767e-01 4410:1.6945925e-01 6560:1.3723065e-01 "
          "7477:1.7575119e-01 "
          "9927:2.6686695e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 4:1.5362063e-01 10:3.1522740e-02 20:1.9279152e-02 23:3.6364838e-02 24:2.5075113e-02 41:3.6885381e-02 "
          "50:3.7831396e-02 55:6.1507817e-02 62:5.0177805e-02 101:3.8781911e-02 107:3.8284350e-02 147:3.0733237e-02 "
          "170:3.7035894e-02 182:3.1823687e-02 188:2.7935432e-02 221:3.9003178e-02 231:3.2480352e-02 252:2.9256983e-02 "
          "259:3.1971604e-02 276:4.8460428e-02 277:2.6753996e-02 293:2.4195915e-02 349:4.0531863e-02 393:4.4147752e-02 "
          "423:7.9219751e-02 431:7.6564565e-02 451:3.5005085e-02 497:6.0947094e-02 526:2.3623176e-02 573:3.0824790e-02 "
          "575:3.7194163e-02 660:2.4833273e-02 678:5.0628383e-02 702:3.2043781e-02 704:7.7928215e-02 723:8.5905552e-02 "
          "757:3.9531298e-02 789:8.3171837e-02 801:6.1997298e-02 802:2.1824993e-02 815:4.4364370e-02 818:7.7705875e-02 "
          "842:2.3525950e-02 858:3.5443731e-02 882:8.5191816e-02 894:8.4409729e-02 905:4.7409195e-02 916:7.8110918e-02 "
          "943:5.5946060e-02 965:3.8716469e-02 968:5.7649501e-02 1033:6.7106605e-02 1127:5.1801268e-02 "
          "1133:5.2177310e-02 "
          "1188:5.3804096e-02 1213:4.2748109e-02 1214:9.5521480e-02 1221:5.3201377e-02 1264:7.2416537e-02 "
          "1266:4.8712607e-02 "
          "1267:9.1896474e-02 1293:5.6383740e-02 1299:7.1875535e-02 1305:4.5100700e-02 1340:1.2365612e-01 "
          "1376:4.7349431e-02 "
          "1420:8.3444186e-02 1425:5.1988687e-02 1426:7.6066829e-02 1456:5.2229177e-02 1471:8.9148968e-02 "
          "1472:1.0065209e-01 "
          "1504:5.5326335e-02 1509:5.3767510e-02 1513:5.5408899e-02 1529:6.3161112e-02 1567:5.4288801e-02 "
          "1766:6.5933593e-02 "
          "1768:7.2553560e-02 1776:4.4373322e-02 1881:5.6265622e-02 1994:5.3945459e-02 2103:8.6382337e-02 "
          "2136:4.5034174e-02 "
          "2137:1.1525681e-01 2223:5.0299890e-02 2247:7.3931128e-02 2248:4.9384024e-02 2360:4.9107011e-02 "
          "2392:1.2696077e-01 "
          "2446:5.7294827e-02 2472:7.5640753e-02 2883:9.1706909e-02 3017:7.3767468e-02 3027:1.4202923e-01 "
          "3110:8.5578412e-02 "
          "3134:1.0847656e-01 3399:9.2007354e-02 3532:6.5089382e-02 3570:6.0757291e-02 3725:7.2229601e-02 "
          "3793:7.6713115e-02 "
          "4322:8.8410661e-02 5118:9.4197258e-02 5597:9.7133286e-02 5660:9.4115213e-02 5662:7.3116653e-02 "
          "5729:7.3723942e-02 "
          "6024:7.7237874e-02 6491:8.8779204e-02 6731:1.0113516e-01 6794:7.0814446e-02 8401:9.2522234e-02 "
          "8443:1.3503285e-01 "
          "8639:9.0067640e-02 8898:7.5453661e-02 9903:1.0366551e-01 10286:1.9614391e-01 10374:4.1197297e-01 "
          "10444:9.8078020e-02 11553:9.7595640e-02 12017:1.1359930e-01 12230:1.1553901e-01 12950:1.0568542e-01 "
          "18939:9.9679939e-02 19741:1.0478538e-01 20053:2.5116581e-01 21276:1.1014305e-01 27133:1.1071370e-01 "
          "28555:1.2355767e-01 31896:2.4058756e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:6.2228899e-02 15:8.6541899e-02 24:2.4986822e-02 26:6.5650851e-02 32:7.2547033e-02 64:4.5725316e-02 "
          "69:3.3258751e-02 81:8.9904226e-02 140:6.6623062e-02 153:1.2784594e-01 179:5.5403158e-02 188:3.4503330e-02 "
          "284:9.0433352e-02 286:3.9423726e-02 288:5.3184584e-02 298:7.6899901e-02 319:1.1627147e-01 327:1.4023739e-01 "
          "334:8.2355320e-02 345:1.0300016e-01 346:9.6019335e-02 373:1.0573892e-01 385:1.1489599e-01 423:1.6566615e-01 "
          "434:9.0089180e-02 438:7.9613015e-02 443:8.7646507e-02 525:1.2630747e-01 545:8.1516460e-02 613:5.0999131e-02 "
          "646:1.8061723e-01 660:5.1931906e-02 726:7.9655364e-02 820:8.1337422e-02 837:9.1302045e-02 858:7.4120738e-02 "
          "1000:2.0284982e-01 1021:1.1064716e-01 1059:5.2501235e-02 1066:1.1586543e-01 1127:5.1618867e-02 "
          "1160:9.3664713e-02 "
          "1188:6.6453971e-02 1398:2.7305448e-01 1413:1.3821441e-01 1556:1.0545682e-01 1837:9.7804435e-02 "
          "2213:1.4416964e-01 "
          "2214:1.0924514e-01 2226:3.3586377e-01 2280:1.4932516e-01 2433:1.1394821e-01 3282:2.9868567e-01 "
          "3788:1.7916869e-01 "
          "3841:8.9350142e-02 3872:1.6767183e-01 4501:1.1010183e-01 5317:1.6391701e-01 5806:1.4863999e-01 "
          "16147:2.1040961e-01 20102:2.4335927e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("1 |f 26:1.4344682e-01 74:8.3622023e-02 99:1.1408050e-01 169:8.6125858e-02 224:8.0280326e-02 "
                  "271:6.3927561e-02 "
                  "451:9.4468556e-02 939:1.6917953e-01 1102:1.1689339e-01 1186:1.3984001e-01 1556:1.3609134e-01 "
                  "3533:1.6548668e-01 "
                  "3649:1.7051810e-01 4352:2.0408787e-01 5947:1.5338835e-01 6719:2.0739265e-01 42916:8.2917231e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 17:3.0997286e-02 23:5.0865114e-02 24:4.9234394e-02 46:1.4766571e-01 49:3.5789195e-02 50:6.5588586e-02 "
          "52:9.6524723e-02 54:4.9135614e-02 69:3.7665065e-02 70:7.4000552e-02 72:6.5028466e-02 73:2.8590241e-02 "
          "102:4.2071901e-02 136:1.2318283e-01 140:2.6318913e-02 154:2.5940603e-01 188:2.3078049e-02 195:9.0099983e-02 "
          "210:4.4918988e-02 218:8.7023832e-02 232:8.1228830e-02 242:6.6499807e-02 263:6.5881051e-02 264:5.5612545e-02 "
          "274:5.5174123e-02 277:3.7422005e-02 281:8.6712927e-02 284:3.5724975e-02 295:4.9397774e-02 300:2.0972440e-01 "
          "309:5.7635259e-02 311:9.0350412e-02 315:4.9974915e-02 318:6.4585254e-02 320:8.1075519e-02 321:5.9916932e-02 "
          "339:1.0684934e-01 341:9.7775504e-02 351:8.7626964e-02 426:1.9667839e-01 441:6.6735126e-02 453:4.8135865e-02 "
          "469:6.2257286e-02 497:5.0349675e-02 644:7.6070011e-02 802:3.0527588e-02 951:8.2193047e-02 984:1.3525602e-01 "
          "1084:7.7776872e-02 1113:1.0001361e-01 1140:1.0162100e-01 1179:1.1628769e-01 1183:7.5865485e-02 "
          "1186:7.2479248e-02 "
          "1321:6.4598180e-02 1337:1.1432898e-01 1387:7.3415279e-02 1429:6.9831893e-02 1430:9.6214853e-02 "
          "1450:2.5617310e-01 "
          "1544:5.8531355e-02 1573:7.1433865e-02 1906:6.2124725e-02 1932:2.3901512e-01 1964:8.6615048e-02 "
          "1999:1.1450501e-01 "
          "2128:7.0146285e-02 2153:5.4115288e-02 2212:6.8568096e-02 2311:7.3086038e-02 2474:6.9608673e-02 "
          "2927:9.8712012e-02 "
          "3343:9.4831452e-02 3424:1.2204739e-01 3440:1.0370473e-01 3533:8.5771956e-02 3841:5.9763126e-02 "
          "5214:3.3139417e-01 "
          "5761:1.1142533e-01 6120:1.5785398e-01 6732:1.0894231e-01 10525:2.0301495e-01 35832:3.1519878e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 69:8.7522507e-02 75:1.0231753e-01 170:1.6443695e-01 224:7.8007236e-02 255:2.6001275e-01 "
          "459:1.1390492e-01 "
          "463:1.0206854e-01 495:1.3927160e-01 496:1.2198891e-01 837:1.1448856e-01 858:9.2943989e-02 943:1.4670719e-01 "
          "1195:1.1827174e-01 1240:1.0591247e-01 1664:1.6827284e-01 1931:1.7254676e-01 1932:2.1351908e-01 "
          "2335:1.3482030e-01 "
          "3425:2.0540875e-01 4726:3.2024336e-01 7486:2.7136815e-01 10355:4.2243323e-01 11761:3.8076481e-01 "
          "13271:3.0218977e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:2.4313321e-02 23:5.0307050e-02 24:1.6529432e-02 26:7.3532946e-02 32:4.7991745e-02 54:2.8701890e-02 "
          "57:9.6529014e-02 69:3.7251826e-02 95:6.3154005e-02 126:5.1519029e-02 140:2.6030155e-02 169:4.4149380e-02 "
          "173:7.9977766e-02 179:1.1718028e-01 180:9.4921529e-02 188:3.8645826e-02 200:7.6236516e-02 217:3.9881155e-02 "
          "224:4.1152876e-02 236:3.6092971e-02 238:4.2986289e-02 252:4.0474057e-02 263:6.5158233e-02 271:3.2770205e-02 "
          "277:3.7011430e-02 297:4.4605289e-02 326:6.9411352e-02 378:1.2221007e-01 383:2.1977130e-01 415:1.6187036e-01 "
          "469:6.1574232e-02 510:5.2555114e-02 519:9.4035693e-02 526:3.2680258e-02 535:5.2070998e-02 644:7.5235412e-02 "
          "647:6.7661732e-02 684:9.8228797e-02 702:4.4329312e-02 768:5.6907322e-02 820:5.3806815e-02 878:8.1512898e-02 "
          "914:9.8878480e-02 949:1.9261898e-01 955:6.5316536e-02 1056:5.8757827e-02 1127:3.4147218e-02 "
          "1183:7.5033128e-02 "
          "1189:5.7566080e-02 1260:8.5194550e-02 1296:7.9179630e-02 1307:8.0026425e-02 1383:6.1132859e-02 "
          "1425:7.1921058e-02 "
          "1556:6.9762424e-02 1670:5.6094490e-02 1727:1.0659042e-01 1771:1.1251387e-01 1827:7.3852405e-02 "
          "1839:9.6936606e-02 "
          "2090:6.3172817e-02 2214:1.2236120e-01 2216:2.3328030e-01 2371:6.6442028e-02 2373:9.7448863e-02 "
          "2412:1.0708658e-01 "
          "2738:8.4537856e-02 3251:8.4482111e-02 3788:1.1852474e-01 3841:5.9107438e-02 6005:8.6873338e-02 "
          "14798:3.8090965e-01 19837:2.9472211e-01 20906:1.4815067e-01 23219:4.3826514e-01 32636:2.0565461e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 24:2.1215104e-02 64:3.8823158e-02 188:2.9295111e-02 284:7.6782592e-02 364:5.4336894e-02 "
          "388:6.1195467e-02 "
          "415:7.0523702e-02 417:6.8387441e-02 433:8.1473559e-02 438:6.7595564e-02 459:7.7124968e-02 494:6.8886355e-02 "
          "509:9.9251635e-02 616:6.9465265e-02 629:7.7568904e-02 660:4.4092875e-02 678:5.3092577e-02 681:1.0372312e-01 "
          "684:7.4461423e-02 897:6.6640206e-02 965:6.8743274e-02 967:1.4570050e-01 1021:1.5906298e-01 "
          "1080:1.0101104e-01 "
          "1122:5.3583957e-02 1653:1.0257675e-01 1658:8.6727381e-02 1944:8.6264215e-02 1991:1.4846684e-01 "
          "2190:8.9188263e-02 "
          "2396:1.7732351e-01 2561:1.3965967e-01 2806:9.3084723e-02 2824:1.1321451e-01 2937:1.1798465e-01 "
          "3074:1.7965402e-01 "
          "3355:1.0066522e-01 3404:1.1706881e-01 3659:9.7864911e-02 3779:1.8618181e-01 3923:9.5324405e-02 "
          "4049:1.3615172e-01 "
          "4560:1.2672339e-01 4565:1.1348139e-01 5277:2.7709401e-01 5691:2.8078032e-01 6853:1.3638578e-01 "
          "6956:1.1781318e-01 "
          "7201:2.3896313e-01 7416:1.3812700e-01 7866:1.4301831e-01 10497:1.6119386e-01 10527:2.3143013e-01 "
          "11266:1.3419907e-01 11420:1.5546381e-01 11421:1.4145797e-01 11422:1.4098330e-01 11423:1.4064415e-01 "
          "11427:1.5384558e-01 11695:1.7963836e-01 13154:1.4729922e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:6.9240630e-02 14:6.1657250e-02 18:6.5304607e-02 24:4.7073297e-02 39:6.1691940e-02 101:1.5278937e-01 "
          "102:6.9987901e-02 125:8.7113269e-02 188:3.8391043e-02 217:6.7079484e-02 239:7.6549277e-02 254:9.9318407e-02 "
          "271:5.5118982e-02 286:4.3865848e-02 311:1.5030068e-01 339:1.1533215e-01 363:9.7683311e-02 464:5.6135353e-02 "
          "547:7.6289549e-02 573:1.2144064e-01 644:7.4739397e-02 811:1.4692324e-01 918:1.3542104e-01 929:9.4536036e-02 "
          "951:1.3673066e-01 1062:1.1072700e-01 1084:1.2938422e-01 1102:1.0078665e-01 1399:1.0813291e-01 "
          "1683:1.6521426e-01 "
          "2000:1.8566439e-01 2107:1.0424555e-01 2293:1.5093455e-01 2298:3.8692925e-02 2506:1.0579482e-01 "
          "2764:1.6039473e-01 "
          "3046:1.0877777e-01 3537:1.8419562e-01 4642:3.8432321e-01 6749:1.9414295e-01 12382:3.7925291e-01 "
          "18039:2.7661106e-01 42610:3.7435791e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 3:6.2109228e-02 5:3.8726795e-02 9:9.0280481e-02 19:3.3536520e-02 20:2.5090406e-02 51:2.0210851e-02 "
          "54:4.5717005e-02 73:2.6601076e-02 74:4.0325921e-02 76:5.5366728e-02 79:7.0910901e-02 90:9.8260470e-02 "
          "98:4.8930068e-02 110:3.9634250e-02 117:1.1010972e-01 144:1.1559467e-01 161:6.5459117e-02 210:7.0762970e-02 "
          "233:3.1030029e-02 234:9.7903647e-02 252:6.4467974e-02 262:6.4033531e-02 267:1.2342292e-01 269:5.9357923e-02 "
          "271:6.4696975e-02 274:8.6918354e-02 275:6.7874737e-02 276:6.3067697e-02 277:3.4818366e-02 295:1.4153399e-01 "
          "297:4.1962262e-02 334:5.1252034e-02 338:6.9392264e-02 363:9.2505082e-02 386:1.5688507e-01 389:6.2363181e-02 "
          "394:5.6872003e-02 417:1.1517495e-01 445:8.4957205e-02 464:3.1396918e-02 488:5.9282422e-02 489:5.7925224e-02 "
          "504:1.0815908e-01 533:5.1410466e-02 546:4.6584483e-02 550:4.6440784e-02 593:6.4628445e-02 606:9.2267111e-02 "
          "617:4.5886096e-02 625:5.2819889e-02 630:6.0052808e-02 642:7.9925999e-02 647:1.5189368e-01 752:1.3559972e-01 "
          "802:2.8403632e-02 841:6.9749482e-02 867:7.5425133e-02 886:6.4255431e-02 925:1.5590894e-01 929:5.2874703e-02 "
          "971:6.8321534e-02 1036:5.5446006e-02 1061:1.1233438e-01 1062:6.1930429e-02 1162:9.5555805e-02 "
          "1183:7.0587143e-02 "
          "1218:4.4417206e-02 1289:1.6465077e-01 1408:6.8626836e-02 1520:7.3859885e-02 1807:1.7133504e-01 "
          "1913:1.0995238e-01 "
          "1970:1.2248857e-01 1982:6.5998688e-02 2088:6.6477470e-02 2125:8.9440159e-02 2337:9.7379096e-02 "
          "2548:1.1569487e-01 "
          "2570:9.8159261e-02 2602:6.7830801e-02 2870:1.8397249e-01 2875:2.8873327e-01 2909:1.0181410e-01 "
          "3033:8.2717411e-02 "
          "3485:9.9012606e-02 3506:8.5840985e-02 3739:1.2447030e-01 4459:1.7598383e-01 5874:8.2927421e-02 "
          "6002:1.0196354e-01 "
          "6159:9.4522707e-02 6507:7.9958364e-02 6576:1.3842219e-01 7311:9.8950684e-02 14887:2.8781065e-01 "
          "23014:1.8027948e-01 36736:1.8413316e-01 36737:1.9852468e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:3.9342821e-02 69:1.4619699e-01 183:1.0360804e-01 228:1.6730565e-01 277:8.8093415e-02 "
          "284:8.4098518e-02 "
          "288:1.4178653e-01 295:1.9688767e-01 339:9.6392058e-02 608:2.9769155e-01 613:8.0300316e-02 724:1.0225940e-01 "
          "1629:1.0912213e-01 1654:9.4092727e-02 1666:9.3567453e-02 3046:1.5393087e-01 3880:3.6221170e-01 "
          "5297:3.0275497e-01 "
          "6577:2.0228083e-01 6721:2.9787287e-01 14709:4.4048694e-01 31888:3.8741669e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 21:2.9416192e-02 45:2.4765985e-02 46:9.1455318e-02 62:5.6095399e-02 69:1.7779568e-02 90:5.9888769e-02 "
          "107:4.2799320e-02 130:1.5928538e-01 140:3.5615567e-02 157:6.8290979e-02 165:1.4833103e-01 170:7.0102431e-02 "
          "179:5.0146945e-02 180:7.6706663e-02 187:8.7750137e-02 188:3.1229928e-02 197:1.5258618e-01 213:4.4398017e-02 "
          "252:5.5378329e-02 253:4.9527373e-02 257:6.8692014e-02 286:3.5683513e-02 323:4.7921341e-02 326:7.9054788e-02 "
          "351:1.1857953e-01 384:1.8716154e-01 468:9.4600104e-02 476:4.9694076e-02 481:4.1664127e-02 496:8.8053934e-02 "
          "613:4.6160739e-02 681:6.5306544e-02 724:3.4718744e-02 767:1.2582026e-01 820:4.3481614e-02 890:7.1473785e-02 "
          "942:6.1381165e-02 971:5.8688559e-02 995:7.1002312e-02 1028:3.1343404e-02 1125:1.5098183e-01 "
          "1195:2.4964848e-01 "
          "1452:7.6471530e-02 1562:1.7627308e-01 1666:3.1767689e-02 1731:4.7687121e-02 1986:7.6402567e-02 "
          "2083:1.0661250e-01 "
          "2335:5.7476319e-02 2336:8.5421838e-02 2493:9.1758288e-02 2543:2.0440213e-01 2722:1.6139036e-01 "
          "2992:1.2029784e-01 "
          "3132:2.0885801e-01 3361:1.3137586e-01 3370:1.8506478e-01 6609:2.7287903e-01 6610:2.1519174e-01 "
          "6611:2.1766233e-01 "
          "6612:9.5296279e-02 10923:2.4930677e-01 12044:8.3980799e-02 30225:4.0198711e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 24:1.8125966e-02 32:8.9105494e-02 42:7.0756160e-02 56:6.6573560e-02 64:3.3170104e-02 "
          "188:2.5029441e-02 "
          "238:4.7138222e-02 284:6.5602250e-02 364:4.6424881e-02 388:5.2284773e-02 415:6.0254723e-02 417:3.4509417e-02 "
          "433:6.9610164e-02 438:5.7752956e-02 459:6.5894783e-02 494:5.8855791e-02 616:5.9350405e-02 629:6.6274069e-02 "
          "660:3.7672497e-02 678:4.5361750e-02 681:8.8619962e-02 684:6.3619070e-02 739:1.8547653e-01 802:3.3108886e-02 "
          "897:5.6936704e-02 965:5.8733542e-02 1021:1.3590176e-01 1080:1.8111610e-01 1173:5.5819239e-02 "
          "1658:7.4098982e-02 "
          "1910:8.2815468e-02 2190:7.6201528e-02 2406:1.4937504e-01 2561:1.1932378e-01 2806:7.9530627e-02 "
          "2824:9.6729308e-02 "
          "2937:1.0080487e-01 3355:8.6007327e-02 3659:8.3614774e-02 3923:8.1444189e-02 4049:1.1632662e-01 "
          "4560:1.0827116e-01 "
          "4565:9.6957326e-02 5691:2.3989581e-01 5791:8.8589132e-02 6545:1.1459848e-01 6853:1.1652660e-01 "
          "6956:1.0065836e-01 "
          "7416:1.1801428e-01 7866:1.2219336e-01 7997:1.2411820e-01 9444:1.5475233e-01 11266:1.1465830e-01 "
          "11286:1.4314988e-01 11400:1.2352971e-01 11420:1.3282669e-01 11421:1.2086023e-01 11422:1.2045468e-01 "
          "11423:1.2016491e-01 11427:2.2255416e-01 11428:1.2263230e-01 11429:1.3305430e-01 13058:4.5043787e-01 "
          "13154:1.2585093e-01 13166:2.1051678e-01 17244:1.7386235e-01 34248:1.9011807e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 10:4.8034996e-02 22:1.3213019e-01 24:3.0827567e-02 25:6.0591061e-02 31:1.8813923e-01 89:6.2046017e-02 "
          "126:5.6748483e-02 131:6.4961374e-02 138:5.7508193e-02 278:1.0072116e-01 279:9.4894484e-02 293:3.6870234e-02 "
          "307:1.3934092e-01 311:5.8134090e-02 380:6.0154431e-02 460:9.1312364e-02 474:7.9233423e-02 482:8.2125708e-02 "
          "550:5.4376796e-02 582:9.0567291e-02 586:5.0468173e-02 638:6.3557155e-02 651:6.8213880e-02 660:3.7841450e-02 "
          "684:6.3904390e-02 690:6.5676644e-02 764:6.3022338e-02 783:8.9561813e-02 1064:1.2868631e-01 "
          "1172:9.5501952e-02 "
          "1253:8.9582480e-02 1271:9.2191964e-02 1273:8.8084042e-02 1493:1.7410123e-01 1534:2.6486313e-01 "
          "1616:9.4890445e-02 "
          "2146:1.9776161e-01 2243:1.6484985e-01 2722:2.1998641e-01 3272:6.3844718e-02 3556:1.0323196e-01 "
          "3597:1.5718129e-01 "
          "3602:1.2760058e-01 3808:1.9470806e-01 3823:9.7487159e-02 4195:2.1628204e-01 4246:1.1343704e-01 "
          "4337:8.9056186e-02 "
          "4774:1.4201689e-01 5012:8.7452479e-02 5157:1.4375567e-01 5206:1.2309626e-01 5945:1.1247935e-01 "
          "8538:1.3563249e-01 "
          "11614:1.1016484e-01 12083:2.3712364e-01 18977:1.8648611e-01 22705:1.6156238e-01 28893:3.7995270e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 1:5.1868312e-02 5:5.6388289e-02 9:5.3606458e-02 13:4.2534553e-02 16:4.1698433e-02 17:7.1101226e-02 "
          "18:7.2940871e-02 19:9.5363140e-02 21:4.8521910e-02 24:2.2033209e-02 26:3.4191042e-02 32:7.9290994e-02 "
          "36:5.1521592e-02 39:2.8875636e-02 50:5.8070287e-02 51:3.5495177e-02 52:3.5812963e-02 53:7.4654952e-02 "
          "54:3.8258709e-02 56:4.7795132e-02 60:4.0617924e-02 61:5.9553105e-02 64:2.3813801e-02 72:5.0633438e-02 "
          "79:5.9342463e-02 81:9.8261699e-02 82:7.7691875e-02 85:6.6342182e-02 90:5.8344793e-02 102:5.5465225e-02 "
          "104:1.0507901e-01 106:4.0783357e-02 110:5.6158815e-02 119:6.5260693e-02 126:4.0559515e-02 127:8.6482637e-02 "
          "133:4.6218637e-02 147:3.3471920e-02 153:6.6582322e-02 166:5.0389346e-02 170:4.0336214e-02 179:6.8854213e-02 "
          "182:3.4659542e-02 183:3.4269754e-02 188:4.6889968e-02 189:5.7065126e-02 197:5.3246848e-02 207:4.8300382e-02 "
          "208:7.5583242e-02 210:3.4975495e-02 223:6.8619452e-02 229:2.8012358e-02 230:3.4235947e-02 232:3.7355062e-02 "
          "233:4.3967266e-02 234:7.2054252e-02 252:3.1864114e-02 264:4.3301877e-02 265:6.0355484e-02 269:2.9338408e-02 "
          "271:2.5799084e-02 275:5.6801621e-02 276:3.1172013e-02 286:6.3226856e-02 288:2.7698595e-02 296:4.0166445e-02 "
          "323:4.6685893e-02 336:6.5257631e-02 345:5.3642608e-02 346:5.0006986e-02 359:1.5653807e-01 365:6.5926194e-02 "
          "370:7.5798772e-02 381:8.8176116e-02 397:1.0484044e-01 417:6.9166765e-02 425:6.0533315e-02 464:6.2699430e-02 "
          "476:4.8412926e-02 489:4.8475273e-02 496:5.0665319e-02 500:5.7145994e-02 506:3.4154616e-02 512:5.0619725e-02 "
          "527:6.9465600e-02 528:6.2060431e-02 535:4.0994067e-02 544:1.1268854e-01 546:1.3897838e-01 558:6.2366676e-02 "
          "559:5.5212021e-02 574:5.7918984e-02 575:4.0508583e-02 582:6.4730637e-02 606:1.0882502e-01 607:1.3414870e-01 "
          "608:1.2243308e-01 623:7.4236587e-02 644:3.4982648e-02 702:3.4899250e-02 721:7.1929887e-02 724:3.3823673e-02 "
          "726:4.1484609e-02 761:8.9884244e-02 802:2.3769850e-02 867:6.3120238e-02 921:1.4362776e-01 925:5.4676354e-02 "
          "933:5.2003376e-02 987:6.8986841e-02 1012:3.7940335e-02 1025:5.2566994e-02 1032:5.7605427e-02 "
          "1059:4.6295222e-02 "
          "1064:9.1975220e-02 1106:7.5814657e-02 1127:4.5517161e-02 1169:6.6797212e-02 1202:6.2845699e-02 "
          "1213:2.7497580e-02 "
          "1235:5.0123293e-02 1238:6.1940379e-02 1294:6.5973796e-02 1296:6.2335946e-02 1300:9.0858631e-02 "
          "1304:5.2365236e-02 "
          "1305:4.9119689e-02 1313:1.1846520e-01 1373:5.1196463e-02 1383:4.8128221e-02 1389:5.5599477e-02 "
          "1413:7.1982227e-02 "
          "1416:9.2209734e-02 1454:3.7791982e-02 1455:4.9523931e-02 1469:5.9099846e-02 1511:4.5029797e-02 "
          "1554:4.7299858e-02 "
          "1690:5.8230944e-02 1751:5.7387523e-02 1776:4.8327491e-02 1811:6.2514730e-02 1837:5.0936665e-02 "
          "1841:7.4763887e-02 "
          "1869:9.2888109e-02 1908:7.6568261e-02 1909:7.8130990e-02 1988:6.0883857e-02 2022:6.4073421e-02 "
          "2087:6.4231455e-02 "
          "2184:7.4170761e-02 2227:7.1874000e-02 2362:3.6218565e-02 2371:5.2307982e-02 2477:5.7219926e-02 "
          "2509:6.6607691e-02 "
          "2614:5.6977987e-02 2627:7.0116654e-02 2687:7.9394802e-02 2773:7.1300454e-02 2872:8.2302250e-02 "
          "2923:1.2885784e-01 "
          "2924:6.4747266e-02 2965:1.0655305e-01 2970:7.8660391e-02 3112:7.5943805e-02 3192:6.8404958e-02 "
          "3309:8.0322012e-02 "
          "3394:6.4558186e-02 3642:2.6971501e-01 3652:7.6335207e-02 3664:9.4746292e-02 3669:6.4773440e-02 "
          "3767:9.1831289e-02 "
          "4234:9.0621449e-02 4409:1.1103588e-01 5762:1.0928649e-01 6186:1.2386771e-01 7186:1.8027136e-01 "
          "7843:9.6203119e-02 "
          "8884:9.2435271e-02 10808:1.0123029e-01 14586:1.0581525e-01 22549:1.0045056e-01 24623:1.6138409e-01 "
          "41008:1.3485673e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 20:9.6120715e-02 24:2.8386220e-02 69:3.7783526e-02 70:1.2568790e-01 102:7.1457960e-02 "
          "136:8.7676786e-02 "
          "217:6.8488456e-02 223:7.1324639e-02 240:1.1036282e-01 257:6.9559313e-02 269:6.3997217e-02 277:1.5167344e-01 "
          "295:8.3900750e-02 302:1.3875151e-01 339:6.9547787e-02 469:1.0574228e-01 497:8.5517533e-02 995:1.5088767e-01 "
          "1028:6.6608161e-02 1113:1.6987035e-01 1288:1.5782984e-01 1454:1.9671988e-01 1654:1.4247225e-01 "
          "1666:1.1430404e-01 "
          "2521:3.6680856e-01 3841:1.0150602e-01 5791:3.3106315e-01 5792:2.4636120e-01 6560:2.4779345e-01 "
          "6577:3.4827381e-01 "
          "6756:4.0988013e-01 6968:1.9374678e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 19:3.6243372e-02 55:7.9111159e-02 56:1.2953107e-01 57:1.7849179e-01 64:5.2069269e-02 69:3.7873086e-02 "
          "82:5.9256900e-02 147:4.3225367e-02 188:2.3205506e-02 239:4.6270292e-02 257:1.0745727e-01 286:2.6514759e-02 "
          "387:6.7928933e-02 417:3.1994663e-02 526:8.6699307e-02 549:1.7029455e-01 569:9.8486699e-02 616:9.3166187e-02 "
          "757:5.5599570e-02 768:9.7959377e-02 897:1.1078079e-01 942:7.7223577e-02 1036:1.0145549e-01 "
          "1122:1.0128723e-01 "
          "1380:5.8006536e-02 1617:1.6129012e-01 1664:5.3304974e-02 1714:2.3110144e-01 1922:1.6597977e-01 "
          "2039:1.6885628e-01 "
          "2173:2.0342511e-01 2360:6.9067523e-02 3214:1.6992503e-01 3534:2.7918845e-01 3583:1.0958739e-01 "
          "3923:2.4937564e-01 "
          "4025:3.2409722e-01 4026:2.4962354e-01 4525:1.9571935e-01 5307:2.4652199e-01 7873:1.0538442e-01 "
          "11432:1.1738955e-01 12496:2.6739469e-01 12497:1.5263337e-01 12498:1.5294394e-01 37237:1.7017500e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 5:6.0725540e-02 13:4.7071110e-02 24:2.4383178e-02 41:7.5272068e-02 46:6.9959857e-02 49:5.2214745e-02 "
          "50:4.5597102e-02 73:4.1711811e-02 136:7.5312555e-02 140:8.0582619e-02 157:1.2466006e-01 158:1.1111616e-01 "
          "192:9.5334202e-02 200:1.1245932e-01 230:6.4148962e-02 234:6.4333133e-02 239:6.7135386e-02 240:5.5990048e-02 "
          "305:6.8622760e-02 320:1.1828535e-01 322:1.0604933e-01 326:1.0239126e-01 339:1.2537135e-01 341:8.4251300e-02 "
          "347:8.1402019e-02 354:1.7927234e-01 364:6.2451079e-02 379:1.0222008e-01 395:2.3280707e-01 404:1.5389204e-01 "
          "433:5.5305343e-02 654:1.9706072e-01 673:8.3309397e-02 676:1.0933486e-01 946:1.1368933e-01 963:1.4252804e-01 "
          "990:1.2559386e-01 1025:1.6676894e-01 1091:1.1906313e-01 1122:6.1585706e-02 1128:2.7439591e-01 "
          "1132:7.4753508e-02 "
          "1288:8.0071352e-02 1293:1.1506241e-01 1307:1.1804995e-01 1664:7.7342287e-02 1674:6.9263376e-02 "
          "1793:1.9142398e-01 "
          "1837:9.5441625e-02 1881:1.1482137e-01 2128:1.7327689e-01 2184:1.3897607e-01 4410:1.5523586e-01 "
          "6188:1.7458688e-01 "
          "12584:4.2814231e-01 13311:2.0145869e-01 15498:1.9208497e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 32:8.6112469e-02 40:6.5406419e-02 42:5.5168133e-02 50:4.4747300e-02 54:2.4540182e-02 55:4.7205500e-02 "
          "81:5.0850388e-02 84:4.4166028e-02 102:3.5576914e-02 179:5.3057086e-02 181:5.3422127e-02 189:6.1974488e-02 "
          "221:4.6133298e-02 229:3.0422285e-02 231:3.8418040e-02 236:3.0859573e-02 276:5.7319414e-02 297:6.4572617e-02 "
          "305:3.9774347e-02 318:5.4614689e-02 336:4.1858029e-02 349:4.7941439e-02 389:5.6679107e-02 417:2.6906775e-02 "
          "433:6.7271978e-02 437:4.8652206e-02 475:7.1939245e-02 480:5.4800015e-02 558:4.0003691e-02 573:3.6459826e-02 "
          "655:5.4490697e-02 664:8.4126733e-02 678:3.5368271e-02 701:7.5453952e-02 702:3.7901662e-02 773:4.1364335e-02 "
          "860:6.3769981e-02 952:7.0454940e-02 967:5.7325307e-02 1028:3.3162333e-02 1033:4.6879724e-02 "
          "1043:9.9346906e-02 "
          "1051:7.5190127e-02 1094:8.2642622e-02 1112:8.1912868e-02 1127:2.9195951e-02 1131:6.8987295e-02 "
          "1177:1.3920796e-01 "
          "1188:3.7586782e-02 1213:7.1262442e-02 1230:8.8764131e-02 1295:5.7207547e-02 1304:5.6870267e-02 "
          "1389:6.0382750e-02 "
          "1426:8.9972503e-02 1455:5.3784519e-02 1504:6.5440468e-02 1623:4.7356684e-02 1766:7.7986829e-02 "
          "1768:5.0684892e-02 "
          "2024:6.2409416e-02 2107:5.2991088e-02 2129:1.5938686e-01 2131:1.4905703e-01 2186:7.3645763e-02 "
          "2203:7.2485194e-02 "
          "2212:5.7982668e-02 2214:1.2967269e-01 2223:1.0073403e-01 2234:5.0854575e-02 2304:1.2456093e-01 "
          "2385:9.2802264e-02 "
          "2500:1.2579748e-01 2588:8.0582097e-02 2903:7.6876618e-02 2933:7.4399076e-02 3432:8.4775053e-02 "
          "3483:1.9267364e-01 "
          "3570:1.2167676e-01 3593:9.5654711e-02 3772:5.9989650e-02 4276:6.0924683e-02 4296:8.3041951e-02 "
          "4303:2.3010081e-01 "
          "5424:7.2133176e-02 6909:6.8710968e-02 8066:9.0515509e-02 8347:1.1806487e-01 8737:6.8910956e-02 "
          "8738:6.9436610e-02 "
          "10902:2.1714683e-01 11006:3.1315246e-01 15010:1.4045982e-01 15014:1.4091296e-01 15016:2.1954775e-01 "
          "15017:2.2306426e-01 15018:3.1704655e-01 15021:1.4098965e-01 16115:1.2767150e-01 20136:1.0812352e-01 "
          "20784:1.3091016e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "1 |f 24:1.5414893e-02 48:5.3387556e-02 75:8.5230038e-02 110:3.9289877e-02 121:4.8889827e-02 "
          "123:7.0861056e-02 "
          "126:4.8045225e-02 140:6.3344121e-02 144:5.4602891e-02 161:8.0429934e-02 166:5.9689261e-02 179:3.4179363e-02 "
          "181:5.8268853e-02 183:4.0594619e-02 188:3.6040034e-02 189:8.3784901e-02 191:4.8275705e-02 208:5.2879617e-02 "
          "209:7.5478300e-02 217:3.7192065e-02 236:3.3659309e-02 239:4.2442571e-02 240:3.5396561e-02 252:6.3907832e-02 "
          "271:3.0560592e-02 286:2.4321320e-02 293:3.1215612e-02 297:1.0854653e-01 305:7.3453598e-02 318:5.9569612e-02 "
          "319:7.1730293e-02 326:3.8231239e-02 336:4.5655601e-02 353:5.6846894e-02 364:3.9481182e-02 397:7.3348567e-02 "
          "477:5.5426367e-02 526:6.3958794e-02 532:6.2024649e-02 547:4.2298567e-02 582:7.6677397e-02 603:8.4583417e-02 "
          "614:6.4604349e-02 623:5.1937468e-02 625:1.0988533e-01 660:3.2037877e-02 724:4.0066209e-02 726:4.9141057e-02 "
          "802:2.8156841e-02 820:8.4960021e-02 842:3.0351277e-02 882:6.4913191e-02 910:1.3589829e-01 925:1.0966089e-01 "
          "927:5.4480635e-02 932:5.1214408e-02 968:1.5608370e-01 1028:6.1242811e-02 1059:3.2389108e-02 "
          "1071:4.3823585e-02 "
          "1130:6.5707013e-02 1133:6.7314938e-02 1136:1.5634060e-01 1140:9.3729191e-02 1145:4.7492880e-02 "
          "1150:8.2120329e-02 "
          "1170:6.3014060e-02 1173:1.3252604e-01 1189:9.0895832e-02 1218:7.4551433e-02 1232:8.0879845e-02 "
          "1237:5.7843227e-02 "
          "1263:6.7413680e-02 1322:7.0035063e-02 1403:7.8607216e-02 1422:9.3701199e-02 1540:5.9214029e-02 "
          "1573:6.5886371e-02 "
          "1575:5.8602586e-02 1589:1.2112725e-01 1594:7.4034177e-02 1647:6.1493944e-02 1708:1.0600144e-01 "
          "1731:5.5032000e-02 "
          "1839:9.0400413e-02 1889:9.0062097e-02 2080:1.1433426e-01 2090:9.9748768e-02 2094:7.4214786e-02 "
          "2097:6.1166596e-02 "
          "2107:5.7798710e-02 2298:2.1453204e-02 2311:6.7410231e-02 2367:1.1535788e-01 2557:8.4878780e-02 "
          "2933:8.1148937e-02 "
          "3327:8.6945772e-02 3394:7.6473117e-02 3684:1.7477186e-01 3685:1.1838972e-01 3710:9.6796818e-02 "
          "3789:3.5750815e-01 "
          "3813:1.3678429e-01 3854:8.2075328e-02 4096:7.9860263e-02 4254:7.3878303e-02 4256:6.7419708e-02 "
          "5166:8.6313985e-02 "
          "6729:1.3701299e-01 7930:1.1009772e-01 9074:1.4255440e-01 9841:1.0289596e-01 10062:1.2424480e-01 "
          "11614:9.3269356e-02 21961:1.6833763e-01 23923:3.0715787e-01 24363:1.7352384e-01 31277:1.2945653e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 6:4.5481075e-02 17:1.9564936e-02 20:1.7020844e-02 24:2.7526489e-02 45:3.3115238e-02 53:2.8836811e-02 "
          "57:3.6383882e-02 61:2.8512185e-02 63:3.6636863e-02 73:1.8045651e-02 74:2.7356319e-02 85:3.1762585e-02 "
          "87:3.4492414e-02 101:8.1704564e-02 169:2.8175430e-02 182:4.7570571e-02 188:3.0569337e-02 213:3.5062358e-02 "
          "220:5.8980756e-02 231:2.8675687e-02 233:3.5641033e-02 253:3.9113153e-02 274:3.4824926e-02 275:4.6044901e-02 "
          "277:2.3620103e-02 287:5.7663497e-02 298:6.8131946e-02 302:5.1562503e-02 313:4.1626085e-02 315:3.1543277e-02 "
          "319:4.9086936e-02 322:4.5879792e-02 326:4.4297215e-02 334:3.4768380e-02 341:3.6449376e-02 344:4.0782563e-02 "
          "353:1.0151192e-01 354:5.5029746e-02 360:4.0389668e-02 378:4.6063639e-02 404:6.6577837e-02 433:5.0212614e-02 "
          "445:5.7633311e-02 464:2.1299057e-02 494:3.4252468e-02 497:3.1779818e-02 506:2.7686641e-02 526:2.0856019e-02 "
          "557:5.1240236e-02 558:8.7962627e-02 577:5.5690739e-02 586:4.9507570e-02 660:2.1924367e-02 670:4.6247758e-02 "
          "677:5.7134766e-02 678:2.6399303e-02 730:7.1599588e-02 752:5.4329716e-02 787:6.3426949e-02 803:3.8604181e-02 "
          "836:3.9211337e-02 837:3.8545467e-02 858:6.5669656e-02 879:4.6414059e-02 898:4.1172940e-02 916:6.8961211e-02 "
          "946:4.9185064e-02 953:4.3383278e-02 1026:4.8696682e-02 1028:2.4752766e-02 1040:3.3582989e-02 "
          "1056:3.7498306e-02 "
          "1059:2.2164723e-02 1062:1.0025394e-01 1066:4.8915520e-02 1073:6.9676556e-02 1122:4.5111589e-02 "
          "1132:5.4757021e-02 "
          "1136:6.9419712e-02 1145:5.5028360e-02 1162:3.8285624e-02 1171:4.3428585e-02 1196:3.7907597e-02 "
          "1212:4.1693568e-02 "
          "1213:2.2290269e-02 1221:4.6969507e-02 1243:4.3370429e-02 1304:4.2448651e-02 1315:5.3668827e-02 "
          "1322:4.7926843e-02 "
          "1339:6.4122364e-02 1342:3.6440477e-02 1352:8.5072696e-02 1360:4.6838187e-02 1367:7.3667325e-02 "
          "1376:4.1803043e-02 "
          "1380:3.6411595e-02 1398:6.9913141e-02 1492:7.2672822e-02 1509:4.7469322e-02 1511:1.0190578e-01 "
          "1529:5.5762582e-02 "
          "1532:6.2082443e-02 1538:4.4695053e-02 1554:3.8342521e-02 1586:6.3120224e-02 1602:5.4599307e-02 "
          "1629:2.9258441e-02 "
          "1647:4.2081933e-02 1731:3.7659854e-02 1750:5.3391937e-02 1768:3.7831813e-02 1889:3.6400780e-02 "
          "1890:4.5082897e-02 "
          "1966:7.3446214e-02 2016:4.4969354e-02 2017:5.9592545e-02 2074:4.4597924e-02 2166:5.1319227e-02 "
          "2178:7.2105013e-02 "
          "2197:1.0105799e-01 2212:4.3278962e-02 2224:5.7815507e-02 2234:3.7958469e-02 2248:9.1498047e-02 "
          "2330:5.5214193e-02 "
          "2455:5.6552682e-02 2687:6.4359531e-02 2734:8.7787114e-02 2837:6.2417101e-02 2860:6.9821484e-02 "
          "2988:7.6350376e-02 "
          "3020:6.6068359e-02 3021:1.3205419e-01 3027:8.1361435e-02 3124:6.2377647e-02 3191:7.2566964e-02 "
          "3204:1.0510100e-01 "
          "3208:9.1267176e-02 3212:6.1981499e-02 3239:6.5430284e-02 3322:7.6203078e-02 3524:9.5242523e-02 "
          "3530:7.0699684e-02 "
          "3532:1.3712835e-01 3593:7.1397826e-02 3684:5.6990527e-02 3690:4.8055422e-02 3736:5.7837367e-02 "
          "3743:6.4357109e-02 "
          "3818:7.2122648e-02 4206:5.3752538e-02 4501:4.6482269e-02 4836:5.2698646e-02 5012:5.0667729e-02 "
          "5080:8.6059228e-02 "
          "5089:2.7978212e-01 5502:7.3294848e-02 5601:1.5137705e-01 5649:6.8776064e-02 5874:5.6256346e-02 "
          "5947:5.0179850e-02 "
          "6105:9.0530433e-02 6871:5.8583520e-02 6930:1.0204982e-01 7148:6.9332540e-02 7181:7.8765191e-02 "
          "7472:7.2825223e-02 "
          "7684:8.4952302e-02 7795:7.0222624e-02 7956:1.1680830e-01 7962:6.7605317e-02 8292:6.8526581e-02 "
          "8342:5.9624337e-02 "
          "8370:8.1758663e-02 8408:6.4970970e-02 8558:1.3119748e-01 8646:7.5797983e-02 8670:1.0274027e-01 "
          "8839:8.6876743e-02 "
          "8973:6.7655154e-02 9604:1.7439705e-01 10210:8.9695051e-02 10842:1.9604740e-01 13832:1.2785880e-01 "
          "13966:9.7649008e-02 14192:8.3090805e-02 15490:1.0576332e-01 15496:2.9133204e-01 23447:8.3457097e-02 "
          "36054:1.4830720e-01 44863:1.2251504e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 1:4.4559386e-02 3:4.4652496e-02 9:2.7199408e-02 13:2.1581627e-02 14:2.4792727e-02 21:2.4619557e-02 "
          "49:5.7127725e-02 50:2.0905811e-02 51:4.2804923e-02 52:3.0766446e-02 55:6.4969912e-02 64:2.0458123e-02 "
          "73:1.9124443e-02 74:2.8991714e-02 84:5.9153154e-02 119:5.6064602e-02 128:4.2577639e-02 130:6.2026244e-02 "
          "133:6.7227803e-02 144:3.9600004e-02 147:4.8686929e-02 157:5.7155378e-02 188:1.5437255e-02 191:3.5011299e-02 "
          "207:4.1494220e-02 217:6.4365610e-02 218:2.7738117e-02 228:4.7540657e-02 240:2.5670871e-02 271:4.6512917e-02 "
          "277:2.5032142e-02 286:4.2091142e-02 298:3.4406051e-02 300:9.9938467e-02 305:6.6028304e-02 307:5.0531190e-02 "
          "320:8.3582044e-02 341:6.5403514e-02 351:5.8614999e-02 354:3.4444433e-02 365:2.6987510e-02 385:5.1406015e-02 "
          "386:4.0401109e-02 388:1.0310205e-01 394:4.0887270e-02 428:7.5147152e-02 438:7.4752435e-02 440:1.1985973e-01 "
          "443:1.0947669e-01 445:6.1078705e-02 454:3.1365916e-02 464:2.2572342e-02 481:9.0991974e-02 488:7.2162285e-02 "
          "495:4.9692407e-02 501:4.1706365e-02 516:3.8890030e-02 527:5.9676982e-02 585:6.3969605e-02 588:1.2593967e-01 "
          "647:4.5762032e-02 655:5.3426255e-02 690:6.8278067e-02 693:4.9522016e-02 694:5.1411264e-02 702:2.9981485e-02 "
          "726:3.5638880e-02 747:6.5936312e-02 765:5.6281485e-02 770:6.8232678e-02 773:3.2720573e-02 874:6.9286220e-02 "
          "945:6.8345420e-02 948:7.1997255e-02 950:5.4161370e-02 973:9.6461244e-02 1000:1.1486579e-01 "
          "1029:3.5528425e-02 "
          "1040:9.2871517e-02 1063:6.0403284e-02 1086:4.5251172e-02 1094:3.8610395e-02 1107:5.3125955e-02 "
          "1125:5.2953470e-02 "
          "1126:5.7622463e-02 1137:5.2432515e-02 1164:5.0406475e-02 1168:4.0013928e-02 1173:5.8290467e-02 "
          "1179:7.7786595e-02 "
          "1188:2.9732402e-02 1192:1.0126390e-01 1205:7.6037951e-02 1215:5.1769458e-02 1235:4.3060262e-02 "
          "1287:5.7892229e-02 "
          "1304:9.4408773e-02 1305:4.2198077e-02 1380:6.5335713e-02 1419:8.2763560e-02 1422:5.4826085e-02 "
          "1451:5.7488374e-02 "
          "1454:5.4970730e-02 1455:4.2545356e-02 1492:4.5487657e-02 1499:1.1117061e-01 1513:8.7777585e-02 "
          "1557:3.6799073e-02 "
          "1561:5.9734799e-02 1566:4.5776941e-02 1574:6.2538654e-02 1580:5.1746357e-02 1637:7.1174070e-02 "
          "1682:4.3815337e-02 "
          "1727:4.2578034e-02 1747:5.4014403e-02 1807:8.7399006e-02 1827:1.0482359e-01 1910:5.1077589e-02 "
          "1966:7.7836923e-02 "
          "2026:5.3069912e-02 2065:4.6132561e-02 2168:5.9827525e-02 2186:9.8636433e-02 2226:6.2972106e-02 "
          "2247:6.9173016e-02 "
          "2260:6.1541423e-02 2379:5.2222237e-02 2386:6.4068690e-02 2448:5.5936527e-02 2524:1.3761112e-01 "
          "2557:6.1557177e-02 "
          "2577:5.2628018e-02 2903:1.7914663e-01 2927:6.6029958e-02 2958:6.0119461e-02 3108:1.7618531e-01 "
          "3261:6.7466438e-02 "
          "3477:1.0720229e-01 3825:5.5185340e-02 3848:6.8353862e-02 3989:7.2342992e-02 4299:2.5414488e-01 "
          "4501:4.9261041e-02 "
          "4615:6.7763336e-02 5493:7.5218223e-02 5678:8.5232608e-02 5740:6.5553226e-02 5883:2.8932738e-01 "
          "5945:6.9063462e-02 "
          "6090:7.4722551e-02 6200:6.8660289e-02 6269:1.2030964e-01 6289:2.3691998e-01 6642:7.5373098e-02 "
          "6794:6.6256918e-02 "
          "7241:7.2945423e-02 7502:7.7129535e-02 7514:7.6467007e-02 8328:8.2929522e-02 9636:7.2883978e-02 "
          "10278:9.2277177e-02 11237:1.9629893e-01 11922:9.9729583e-02 12171:9.6972734e-02 32475:1.0810307e-01 "
          "34302:1.3324405e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 4:6.7209393e-02 5:4.5049269e-02 9:7.4514493e-02 15:5.0545733e-02 17:6.4590365e-02 20:2.3547584e-02 "
          "21:8.3864145e-02 25:4.8566092e-02 26:8.0469385e-02 43:7.5320326e-02 45:6.4568765e-02 53:8.3722986e-02 "
          "56:5.3600617e-02 60:9.5595196e-02 73:4.2270035e-02 74:6.4079292e-02 75:4.7656987e-02 79:3.9305829e-02 "
          "85:4.3942135e-02 86:6.5233327e-02 90:3.8645018e-02 91:5.0276622e-02 121:7.8368559e-02 169:3.8979463e-02 "
          "182:3.8869500e-02 189:7.9322137e-02 197:5.9714533e-02 229:3.1414907e-02 232:7.0930049e-02 265:6.7686625e-02 "
          "286:6.0084540e-02 288:3.1063035e-02 349:1.0389322e-01 359:1.6106015e-01 363:5.1275466e-02 381:7.9781018e-02 "
          "454:9.7708203e-02 477:5.2474108e-02 489:5.4363374e-02 526:2.8853381e-02 530:6.8883404e-02 535:1.2834683e-01 "
          "546:9.1751292e-02 573:3.7649442e-02 606:1.2204356e-01 608:1.6203539e-01 623:8.3253816e-02 630:5.6360133e-02 "
          "701:7.7915870e-02 721:8.0666929e-02 764:5.0514854e-02 807:6.8092920e-02 842:2.8734630e-02 871:5.8722161e-02 "
          "890:7.8088954e-02 932:4.8486494e-02 954:5.6906085e-02 963:5.0383046e-02 1011:4.9442910e-02 "
          "1024:6.0608063e-02 "
          "1028:3.4244359e-02 1188:6.5716401e-02 1235:5.6211572e-02 1237:5.4762233e-02 1263:6.3822918e-02 "
          "1420:6.0194910e-02 "
          "1449:5.4509364e-02 1455:3.2802466e-02 1477:6.7283437e-02 1546:4.8416886e-02 1690:6.5304026e-02 "
          "1701:1.1925787e-01 "
          "1723:7.4560933e-02 1725:1.3075502e-01 1726:5.4104697e-02 1778:6.4472742e-02 1994:6.5889060e-02 "
          "2015:8.9891486e-02 "
          "2229:7.0397869e-02 2316:1.1684299e-01 2362:4.0617891e-02 2485:1.0251711e-01 2602:6.3659854e-02 "
          "2731:7.0113949e-02 "
          "2743:9.3336463e-02 2773:7.9961039e-02 2885:9.0156578e-02 2938:8.0349527e-02 3010:7.4367203e-02 "
          "3160:7.4690774e-02 "
          "3207:1.9580568e-01 3213:1.4932308e-01 3296:1.0251001e-01 3325:6.2521093e-02 3629:1.2258297e-01 "
          "3642:1.8344587e-01 "
          "3669:1.2299227e-01 3916:1.1992416e-01 5450:1.2385261e-01 5593:1.4908098e-01 7084:1.2599717e-01 "
          "7296:2.1192923e-01 "
          "8242:8.5510999e-02 10179:1.2843487e-01 11734:1.1423887e-01 12629:1.0736758e-01 15978:1.1469734e-01 "
          "22549:1.1265189e-01 30036:1.3183717e-01 37951:1.7355491e-01 41245:3.4029561e-01 46534:1.8076351e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 35:5.8458295e-02 51:2.6359662e-02 63:7.0436887e-02 69:2.6994832e-02 73:5.8742061e-02 "
          "102:5.1053882e-02 "
          "147:8.8323861e-02 170:1.3192588e-01 179:1.0730827e-01 180:6.8785645e-02 184:7.3607981e-02 259:5.4267451e-02 "
          "271:4.0207494e-02 277:4.5411270e-02 287:1.1086204e-01 296:1.0598901e-01 298:1.6287237e-01 302:5.8549225e-02 "
          "318:7.8373633e-02 320:5.8107428e-02 322:8.8207059e-02 400:6.7341670e-02 438:6.4618781e-02 464:4.0948901e-02 "
          "471:7.2161041e-02 532:8.1603639e-02 555:5.0487772e-02 655:9.6921556e-02 764:1.1885855e-01 926:1.9706567e-01 "
          "932:1.1408593e-01 1066:9.4043456e-02 1196:7.2879955e-02 1202:9.7944096e-02 1284:1.0820387e-01 "
          "1368:1.0985880e-01 "
          "1467:9.5101193e-02 1479:2.2746308e-01 1527:1.1019860e-01 1573:1.4676939e-01 1696:1.2327053e-01 "
          "1796:1.2069870e-01 "
          "2649:1.2265328e-01 2968:1.9723578e-01 2992:1.0787543e-01 3008:8.0156349e-02 3025:1.3092628e-01 "
          "3410:3.6779064e-01 "
          "3457:8.5307963e-02 3540:1.0201783e-01 4012:1.0864025e-01 4414:1.1842476e-01 5745:2.6789755e-01 "
          "5995:1.2616053e-01 "
          "7502:1.3992211e-01 7757:3.0334690e-01 10225:1.2754108e-01 18775:1.8573636e-01 20656:1.9244616e-01 "
          "31281:1.8143882e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 107:1.1618066e-01 257:8.8852778e-02 286:1.4928524e-01 433:8.2243212e-02 549:2.3348616e-01 "
                  "550:1.0829099e-01 "
                  "613:7.4007377e-02 620:1.3919832e-01 660:7.5360976e-02 767:1.2234030e-01 842:1.2088000e-01 "
                  "1000:1.1280799e-01 "
                  "1122:9.1582581e-02 1162:1.3159978e-01 1305:1.3686609e-01 1447:1.7479561e-01 1726:1.3442780e-01 "
                  "2166:1.7640039e-01 "
                  "2359:2.1080591e-01 3370:1.6313562e-01 3659:3.5102442e-01 8768:3.3167124e-01 11772:2.4638793e-01 "
                  "13259:4.5261919e-01 13260:3.4124783e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 13:3.6048368e-02 161:4.6426557e-02 191:5.8480304e-02 210:5.0188284e-02 230:4.9127065e-02 "
          "231:5.0761152e-02 "
          "252:4.5723587e-02 276:4.4730455e-02 312:6.2597886e-02 341:6.4521991e-02 400:1.0498188e-01 411:1.3290261e-01 "
          "451:5.4706875e-02 655:7.1997702e-02 690:1.1404668e-01 773:5.4654047e-02 802:3.4108680e-02 815:6.9333814e-02 "
          "918:9.0955235e-02 952:9.3091004e-02 973:9.5161118e-02 984:7.2010666e-02 993:1.0887627e-01 "
          "1028:4.3816872e-02 "
          "1059:6.6431589e-02 1213:3.9457809e-02 1215:8.6471900e-02 1218:5.3338677e-02 1221:8.3144523e-02 "
          "1253:9.1875568e-02 "
          "1403:9.5223330e-02 1441:1.1957479e-01 1504:8.6465463e-02 1524:1.0250428e-01 1655:8.1289276e-02 "
          "1727:7.1119227e-02 "
          "1889:6.4435966e-02 2021:1.9810136e-01 2065:7.7056445e-02 2219:2.9646730e-01 2557:1.7409039e-01 "
          "2559:1.2440807e-01 "
          "2834:8.9707352e-02 3236:1.0607083e-01 3238:1.2704617e-01 3737:1.3954848e-01 4206:1.9968654e-01 "
          "4287:1.3332030e-01 "
          "4697:1.1723314e-01 4769:1.3483971e-01 4957:2.3330209e-01 6347:1.4572088e-01 16830:1.5602425e-01 "
          "17581:1.3572225e-01 23737:1.5588960e-01 28086:2.1466075e-01 41203:5.1835734e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.6123588e-02 9:9.5891327e-02 14:2.6466111e-02 15:4.1333415e-02 16:3.8240418e-02 17:3.7476171e-02 "
          "18:5.8827721e-02 19:6.1418250e-02 20:5.3757757e-02 21:5.5154160e-02 23:6.1496668e-02 24:3.1141022e-02 "
          "26:3.1355608e-02 33:2.9814189e-02 34:6.2246539e-02 35:3.4399040e-02 39:6.9100529e-02 40:5.5230767e-02 "
          "43:1.0428544e-01 46:3.4240849e-02 47:4.9047168e-02 48:4.1331906e-02 49:2.5555758e-02 51:4.0475015e-02 "
          "53:5.5236224e-02 55:3.9861467e-02 56:4.3831520e-02 60:3.7249517e-02 61:6.7693159e-02 64:2.1838943e-02 "
          "65:3.7209086e-02 69:1.5884766e-02 70:3.4286212e-02 73:2.0415246e-02 74:5.2400380e-02 84:6.3145690e-02 "
          "90:3.1601690e-02 102:5.0865542e-02 106:7.8490682e-02 107:3.8238116e-02 127:7.9310700e-02 161:7.0803531e-02 "
          "169:3.1875178e-02 170:3.6991164e-02 209:3.4512211e-02 221:6.5958373e-02 223:2.9985959e-02 224:2.9711746e-02 "
          "229:4.3495793e-02 231:3.2441124e-02 232:3.4257237e-02 233:4.9976964e-02 258:3.9110914e-02 271:2.3659587e-02 "
          "276:2.8586945e-02 280:8.2916386e-02 283:4.3906916e-02 286:3.1880654e-02 293:4.0917769e-02 298:3.6728285e-02 "
          "313:4.7092054e-02 315:3.5685260e-02 318:4.6117969e-02 327:5.4038242e-02 337:3.6030233e-02 364:3.0565783e-02 "
          "381:3.8532007e-02 388:3.4423891e-02 394:4.3646954e-02 399:6.1862852e-02 400:3.9626352e-02 417:5.9288345e-02 "
          "433:2.7068406e-02 449:6.8736576e-02 453:3.4372065e-02 459:4.3384615e-02 460:5.9850935e-02 464:2.4095861e-02 "
          "478:4.0658850e-02 479:5.5594727e-02 504:1.0288592e-01 506:3.1322204e-02 516:7.0290856e-02 528:5.6913812e-02 "
          "546:8.5314088e-02 548:8.6285621e-02 550:3.5641417e-02 564:8.3273508e-02 606:8.7768741e-02 613:2.4357777e-02 "
          "655:2.7176175e-02 660:4.1995607e-02 724:5.2519228e-02 789:4.9063295e-02 802:2.1798635e-02 811:3.0051371e-02 "
          "892:1.0274277e-01 894:4.9793538e-02 963:4.1200377e-02 1011:4.0431585e-02 1024:4.9561810e-02 "
          "1028:2.8003080e-02 "
          "1056:4.2422250e-02 1059:2.5075199e-02 1062:8.0473751e-02 1081:5.7980534e-02 1122:5.1035244e-02 "
          "1124:5.6396309e-02 "
          "1127:4.1742463e-02 1145:3.6768332e-02 1305:4.5046233e-02 1408:1.1053037e-01 1420:8.3343409e-02 "
          "1431:8.1389949e-02 "
          "1470:5.5105738e-02 1561:6.3766591e-02 1567:5.4223236e-02 1604:5.7862125e-02 1623:3.9989132e-02 "
          "1645:5.1837165e-02 "
          "1654:2.8541477e-02 1707:6.9687754e-02 1772:6.6277936e-02 1776:4.4319730e-02 1801:7.4081562e-02 "
          "1862:6.8376839e-02 "
          "1961:1.0015213e-01 1988:5.5834811e-02 2071:6.7447998e-02 2122:8.7974772e-02 2184:6.8019837e-02 "
          "2227:6.5913543e-02 "
          "2248:4.9324382e-02 2298:1.6608773e-02 2327:6.8951286e-02 2377:7.3577143e-02 2501:9.5371239e-02 "
          "2693:7.6918177e-02 "
          "2771:5.6367006e-02 2870:6.7278467e-02 2878:1.3930528e-01 2923:6.9794148e-02 3006:1.8668208e-01 "
          "3033:1.6565301e-01 "
          "3570:6.0683917e-02 3623:8.3318181e-02 3767:8.4215797e-02 3883:1.4473291e-01 3925:8.9565925e-02 "
          "3989:7.7225782e-02 "
          "4002:8.0585629e-02 4229:9.3462959e-02 4479:8.7266885e-02 4499:7.5906776e-02 4510:7.4530005e-02 "
          "4667:1.0062209e-01 "
          "4869:9.7913727e-02 4969:7.8364484e-02 5481:6.1759822e-02 5757:1.2619390e-01 6277:8.8232934e-02 "
          "6607:7.3850654e-02 "
          "7531:1.1567993e-01 7682:8.7370299e-02 8292:1.3126105e-01 10795:1.0131807e-01 11108:7.9564758e-02 "
          "12707:9.2018016e-02 14193:1.2013233e-01 14584:9.1926590e-02 14899:1.0774893e-01 15572:1.0721998e-01 "
          "15625:1.5105733e-01 15791:1.1054371e-01 15974:1.0553205e-01 19253:2.2342294e-01 23563:1.1617782e-01 "
          "25871:2.3266333e-01 26352:1.1144036e-01 27984:1.3309994e-01 35467:1.4948702e-01 36688:1.2587984e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 50:5.9808217e-02 85:5.6876283e-02 188:2.6083700e-02 221:1.0440066e-01 293:6.4765729e-02 "
          "298:5.8134500e-02 "
          "349:6.4077429e-02 494:6.1334841e-02 526:3.7346233e-02 533:3.6884643e-02 651:1.1982354e-01 815:7.0136294e-02 "
          "820:1.0411020e-01 932:1.3170524e-01 1028:4.4324014e-02 1033:1.3149561e-01 1110:7.0425287e-02 "
          "1122:4.7709934e-02 "
          "1123:1.5132362e-01 1164:8.5169762e-02 1316:1.1937881e-01 1527:1.7378180e-01 1590:1.9654270e-01 "
          "1974:9.4381638e-02 "
          "2136:1.4941110e-01 2453:1.0140708e-01 2576:9.5358744e-02 2842:8.8435106e-02 2869:1.0463132e-01 "
          "3026:2.1583100e-01 "
          "3198:1.0329752e-01 4060:1.8146484e-01 4301:1.1786601e-01 5012:9.0729140e-02 7756:3.5693744e-01 "
          "8520:3.5871562e-01 "
          "8640:1.9187011e-01 10199:2.4340677e-01 10368:1.3422486e-01 10475:2.1823749e-01 11134:4.2042136e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.5211756e-02 13:7.2461836e-02 45:6.9594435e-02 50:1.1884662e-01 51:8.2602657e-02 54:6.5177508e-02 "
          "56:1.3786240e-01 65:1.9815406e-01 73:6.4211659e-02 223:1.5968788e-01 284:1.3585098e-01 552:1.9548327e-01 "
          "588:1.5146407e-01 724:1.6518767e-01 820:1.2218688e-01 939:1.9693646e-01 1014:1.2078688e-01 "
          "1664:1.1906164e-01 "
          "1726:1.3915890e-01 2493:1.2286608e-01 6987:2.9685137e-01 6988:7.1141857e-01 12044:2.3599288e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 98:2.6920034e-02 166:3.3127293e-02 175:4.8297148e-02 187:3.3193804e-02 262:3.5229560e-02 "
          "380:2.8265281e-02 "
          "660:1.7780889e-02 667:4.6839487e-02 724:2.2236578e-02 741:7.4038543e-02 872:4.7195777e-02 897:2.6873324e-02 "
          "1067:1.1587790e-01 1350:3.8464785e-02 1384:4.1937191e-02 1426:2.5952706e-02 1429:3.5746619e-02 "
          "1456:3.7396651e-02 "
          "1667:4.9153224e-02 1685:4.3700445e-02 2009:3.1834390e-02 2032:8.6209789e-02 2074:3.6169376e-02 "
          "2094:9.8288834e-02 "
          "2104:3.7231028e-02 2117:9.9491671e-02 2123:4.0815368e-02 2842:1.0451597e-01 2869:8.0235668e-02 "
          "2878:4.7586054e-02 "
          "2953:9.6028782e-02 3006:4.3458525e-02 3269:1.1201553e-01 3341:5.9928026e-02 3423:6.8984553e-02 "
          "3686:1.7301251e-01 "
          "3811:4.5970295e-02 4131:5.8949284e-02 4310:7.4097753e-02 4509:4.9311299e-02 4726:5.1644374e-02 "
          "6011:5.2352309e-02 "
          "6147:8.9627564e-02 6158:6.1606981e-02 8026:5.4919779e-02 10804:1.4644408e-01 10964:6.9524616e-02 "
          "11092:8.1792139e-02 12465:2.4662797e-01 12737:2.2414306e-01 12908:8.0842659e-02 13667:8.3247006e-02 "
          "13710:7.8616098e-02 14296:8.5163318e-02 14720:2.6182851e-01 16048:2.7036312e-01 17902:8.0782317e-02 "
          "18319:9.6438371e-02 19798:8.3477944e-02 20508:8.8658392e-02 21573:7.8763902e-02 21574:7.9324409e-02 "
          "21578:7.9168536e-02 21590:1.3265882e-01 21594:2.2264776e-01 21599:8.3095834e-02 21603:1.7286490e-01 "
          "21656:9.5914818e-02 21687:7.4906617e-02 21893:1.0609818e-01 22818:7.9091467e-02 23065:1.0028801e-01 "
          "25912:8.6020328e-02 28615:9.2935100e-02 29878:2.0156176e-01 30068:9.4710179e-02 30088:1.7568342e-01 "
          "30089:2.0073487e-01 30096:7.9403222e-02 30102:1.7872478e-01 30135:9.5538661e-02 35094:8.1892006e-02 "
          "36747:8.2231931e-02 36752:1.5066051e-01 37849:9.2104532e-02 37869:8.4119916e-02 42530:1.1794262e-01 "
          "44021:1.4816867e-01 44022:1.4235747e-01 46952:9.4156146e-02")));
  examples.push_back(VW::read_example(*vw,
      std::string("-1 |f 111:9.2882141e-02 161:1.1178293e-01 348:7.4419893e-02 380:8.7732174e-02 465:1.1217353e-01 "
                  "690:9.5786043e-02 "
                  "778:1.4992724e-01 784:1.0993265e-01 851:1.3735342e-01 1045:1.6249897e-01 1127:5.4857150e-02 "
                  "1193:7.1480684e-02 "
                  "1194:1.2495786e-01 1218:1.8100084e-01 1231:1.5970886e-01 1253:2.7418679e-01 1273:1.2846608e-01 "
                  "1889:9.1631047e-02 "
                  "2010:1.1671779e-01 2021:1.6638228e-01 2144:1.3601635e-01 2146:1.3743617e-01 2167:2.7298513e-01 "
                  "2940:1.3372785e-01 "
                  "3026:1.2714708e-01 3507:2.6272991e-01 4337:1.2988392e-01 4721:1.4874476e-01 6185:3.4382784e-01 "
                  "6491:3.3406508e-01 "
                  "8167:1.9210005e-01 9566:2.3459153e-01 29915:2.5481227e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 1:5.9533998e-02 39:5.6116316e-02 41:4.6109404e-02 45:2.7693335e-02 54:4.3913014e-02 62:6.2725902e-02 "
          "73:2.5551399e-02 86:1.1304232e-01 92:6.0896914e-02 98:4.6999291e-02 141:5.4301322e-02 169:3.9894465e-02 "
          "182:3.9781921e-02 184:5.4210711e-02 210:4.0144570e-02 225:5.0174251e-02 252:3.6573350e-02 276:1.1017924e-01 "
          "305:4.2036235e-02 310:6.8223149e-02 334:4.9229629e-02 351:7.8313142e-02 379:6.2616944e-02 388:4.3084398e-02 "
          "453:4.3019529e-02 468:6.2476479e-02 531:9.8716646e-02 532:6.0099348e-02 550:4.4608232e-02 585:1.2045611e-01 "
          "587:4.8819598e-02 617:4.4075433e-02 620:3.3865850e-02 660:3.1043394e-02 664:5.2512184e-02 755:6.6239648e-02 "
          "756:7.6540895e-02 805:7.5762503e-02 836:5.5520546e-02 837:5.4577723e-02 866:5.9719078e-02 897:4.6917740e-02 "
          "967:6.0585279e-02 1029:8.0370471e-02 1045:5.3984124e-02 1061:6.3728467e-02 1177:8.6894058e-02 "
          "1194:7.0286788e-02 "
          "1234:7.5909294e-02 1266:6.0894296e-02 1280:6.5037206e-02 1370:9.2518747e-02 1389:6.3816592e-02 "
          "1416:6.2509350e-02 "
          "1454:4.3377310e-02 1455:3.3572473e-02 1468:6.6840596e-02 1479:1.1886167e-01 1513:6.9265150e-02 "
          "1605:8.9206710e-02 "
          "1766:8.2421780e-02 1788:8.0172189e-02 1871:6.7925438e-02 1986:8.5433386e-02 2010:1.7131451e-01 "
          "2097:5.9267927e-02 "
          "2153:4.8363399e-02 2182:6.7750260e-02 2234:5.3746574e-02 2298:2.0787276e-02 2316:7.0629284e-02 "
          "2477:6.5676533e-02 "
          "2495:6.5732747e-02 2605:1.2502356e-01 2611:8.6143918e-02 2612:2.1221662e-01 2688:8.8155843e-02 "
          "2871:7.3416479e-02 "
          "3010:7.6112896e-02 3302:8.1450924e-02 3570:7.5951025e-02 3732:9.1516152e-02 3937:8.4378935e-02 "
          "4105:1.1054944e-01 "
          "4276:6.4389348e-02 4405:1.1597670e-01 4965:8.2569070e-02 5502:1.0378046e-01 5594:1.4362794e-01 "
          "5608:1.9793989e-01 "
          "5611:2.0854303e-01 5612:1.4462288e-01 5615:1.4436902e-01 5616:1.0839337e-01 5623:1.4933532e-01 "
          "5624:1.4908886e-01 "
          "5657:7.9001762e-02 6252:1.2152592e-01 7339:1.1412713e-01 8490:1.1861067e-01 8889:9.7367711e-02 "
          "8890:1.0726668e-01 "
          "8892:1.3597661e-01 8893:1.3662511e-01 9539:1.3157450e-01 9558:1.1770938e-01 10316:1.0854366e-01 "
          "14409:1.7347285e-01 16939:1.4393307e-01 17481:1.3166863e-01 17833:1.3478209e-01 18711:1.6064970e-01 "
          "25013:1.5641828e-01 40079:1.4011492e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:7.7200904e-02 17:6.9068700e-02 50:6.9639176e-02 52:6.0529798e-02 61:5.9448190e-02 64:6.8147883e-02 "
          "73:3.7625361e-02 87:7.1917027e-02 108:9.9749297e-02 110:5.6059875e-02 117:6.5265417e-02 170:1.1543002e-01 "
          "175:7.3334537e-02 210:5.9114337e-02 233:4.3889809e-02 286:8.2809962e-02 311:7.0226066e-02 451:6.4436570e-02 "
          "459:7.9957977e-02 462:9.7201444e-02 464:7.5190544e-02 480:8.5283972e-02 494:7.1416736e-02 511:7.3258452e-02 "
          "514:1.2168348e-01 537:2.0764463e-01 637:9.6783817e-02 724:5.7167564e-02 741:1.1242033e-01 773:1.0899525e-01 "
          "866:8.7938510e-02 1071:6.2528692e-02 1127:7.6931484e-02 1145:1.1473468e-01 1388:1.9282424e-01 "
          "1390:1.2528101e-01 "
          "1469:9.9888459e-02 1785:1.9630548e-01 2094:1.0589170e-01 2298:3.0610021e-02 2820:2.1616383e-01 "
          "2949:9.3558036e-02 "
          "3257:3.6808041e-01 3266:2.1590739e-01 3917:1.3013594e-01 4253:2.0870142e-01 5820:1.7879222e-01 "
          "7108:1.1891425e-01 "
          "7692:2.5216860e-01 7851:3.6322495e-01 7877:3.0049396e-01")));
  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 5:5.6836270e-02 18:3.2510605e-02 20:2.2332555e-02 26:8.6778976e-02 45:2.5661999e-02 52:3.8090654e-02 "
          "54:2.4033319e-02 61:8.9271292e-02 64:5.3154383e-02 66:5.7732455e-02 79:3.7277691e-02 80:1.1231524e-01 "
          "87:4.5256499e-02 102:3.4842093e-02 110:5.9730489e-02 140:2.1796161e-02 152:5.1215898e-02 170:1.1194900e-01 "
          "188:1.9112220e-02 207:5.1372267e-02 209:4.0026538e-02 224:5.8344264e-02 231:3.7624538e-02 233:9.8461457e-02 "
          "286:7.2121009e-02 293:2.8028026e-02 321:4.9620558e-02 323:4.9655095e-02 336:4.0993474e-02 359:4.7775690e-02 "
          "364:3.5449557e-02 365:3.3412110e-02 405:7.6536387e-02 436:8.6243190e-02 438:4.4099554e-02 443:8.2201451e-02 "
          "451:4.0549137e-02 462:6.1167669e-02 463:4.5087945e-02 477:4.9766496e-02 497:4.1697379e-02 501:5.1634911e-02 "
          "525:6.9964729e-02 526:4.6332255e-02 534:1.0745141e-01 540:1.0730396e-01 547:7.9703711e-02 550:4.1336171e-02 "
          "560:5.3403221e-02 591:7.4228875e-02 593:5.7524707e-02 620:3.1381752e-02 637:1.0312089e-01 644:3.7207529e-02 "
          "674:1.5788959e-01 686:5.7060551e-02 709:6.1083607e-02 741:1.1978123e-01 747:8.1632994e-02 752:7.1284443e-02 "
          "757:4.5792203e-02 807:6.4579397e-02 811:5.9011176e-02 842:6.5031178e-02 897:1.3900341e-01 963:4.7783334e-02 "
          "1014:4.4538517e-02 1041:9.0216756e-02 1071:3.9348535e-02 1085:6.5637678e-02 1127:4.8412036e-02 "
          "1145:4.2643141e-02 "
          "1186:6.0024112e-02 1236:8.3431490e-02 1305:5.2243680e-02 1308:5.9014991e-02 1360:6.1455023e-02 "
          "1371:6.3465290e-02 "
          "1379:7.4427895e-02 1381:3.1726137e-01 1382:9.5972680e-02 1383:8.6670779e-02 1384:1.1487485e-01 "
          "1390:1.6544996e-01 "
          "1391:1.0169523e-01 1394:1.0272623e-01 1397:5.6940686e-02 1398:9.1731012e-02 1399:9.1145210e-02 "
          "1401:1.6442318e-01 "
          "1417:5.7063702e-02 1422:6.7877889e-02 1426:4.1986879e-02 1452:4.6799365e-02 1477:1.3391598e-01 "
          "1535:6.8344727e-02 "
          "1540:9.0020195e-02 1590:5.1584698e-02 1668:5.4274768e-02 1705:8.4030628e-02 1776:5.1401097e-02 "
          "1824:1.0479019e-01 "
          "1851:1.0152044e-01 1868:1.0401787e-01 2009:5.1502399e-02 2094:1.3984384e-01 2110:8.9846157e-02 "
          "2298:1.9262508e-02 "
          "2322:6.5851167e-02 2534:5.9272092e-02 2604:6.1038941e-02 2820:6.4818650e-02 2841:6.2619045e-02 "
          "3394:6.8664059e-02 "
          "3563:8.8447921e-02 3734:1.2552956e-01 5202:1.5142207e-01 6624:9.8206535e-02 6977:1.2779115e-01 "
          "7924:2.0518513e-01 "
          "7927:1.6018383e-01 8288:9.3575358e-02 8699:1.0677977e-01 9153:1.1944566e-01 10128:1.1044679e-01 "
          "11176:2.2038181e-01 14534:1.6788375e-01 22982:1.4343356e-01")));

  examples.push_back(VW::read_example(*vw,
      std::string(
          "-1 |f 9:6.2699720e-02 14:3.3754818e-02 21:3.3519048e-02 25:8.5761078e-02 35:4.3872457e-02 39:9.4288357e-02 "
          "40:7.0441186e-02 45:2.8220249e-02 48:8.9253604e-02 51:5.5228550e-02 52:4.1887917e-02 54:2.6429206e-02 "
          "55:9.9164948e-02 63:5.2862287e-02 84:9.9822134e-02 86:6.8034925e-02 90:1.0517266e-01 92:6.2055584e-02 "
          "110:6.5685034e-02 119:7.6330863e-02 140:5.0301693e-02 141:1.1612565e-01 147:3.9149761e-02 170:9.9009261e-02 "
          "188:3.5585757e-02 193:7.3115274e-02 209:9.2374183e-02 213:5.0590482e-02 217:6.2177896e-02 218:3.7764907e-02 "
          "221:8.4123150e-02 229:3.2764092e-02 233:3.0372689e-02 239:7.0955716e-02 253:5.6435257e-02 269:3.4315083e-02 "
          "286:2.4014754e-02 291:5.8397882e-02 293:3.0822147e-02 313:6.0061093e-02 315:4.5512896e-02 354:7.9400860e-02 "
          "386:1.1543484e-01 437:5.2397292e-02 453:7.4224271e-02 454:4.2704083e-02 457:7.4147679e-02 481:4.7475278e-02 "
          "529:6.3872963e-02 550:4.5456979e-02 555:6.4154439e-02 558:4.3083046e-02 573:6.6483773e-02 575:4.7380056e-02 "
          "584:1.4771688e-01 587:4.9748477e-02 620:3.4510206e-02 644:4.0916756e-02 694:6.9995433e-02 702:4.0819209e-02 "
          "724:6.6982903e-02 767:5.1354416e-02 769:9.5669545e-02 802:2.7801929e-02 803:5.5700876e-02 811:6.4894013e-02 "
          "911:5.5302896e-02 945:5.4957401e-02 1007:6.3262910e-02 1011:5.1566351e-02 1012:7.5135358e-02 "
          "1028:3.5715062e-02 "
          "1036:5.4271437e-02 1040:8.2043037e-02 1059:3.1980850e-02 1094:8.9004174e-02 1099:1.2113762e-01 "
          "1122:3.8443342e-02 "
          "1127:3.1443361e-02 1132:7.9007350e-02 1213:3.2161996e-02 1235:5.8625709e-02 1308:6.4898208e-02 "
          "1340:1.3853024e-01 "
          "1420:6.2780119e-02 1454:4.4202637e-02 1455:3.4211244e-02 1492:6.1930560e-02 1523:1.0642930e-01 "
          "1545:7.6326557e-02 "
          "1731:5.4338336e-02 1753:1.0155998e-01 1755:6.3911997e-02 1874:7.8952558e-02 1970:7.0811190e-02 "
          "1984:7.1320996e-02 "
          "2039:1.0851215e-01 2234:1.1493931e-01 2277:9.2282124e-02 2353:1.1663673e-01 2362:7.1725652e-02 "
          "2506:5.7918329e-02 "
          "2701:7.0818663e-02 2738:1.3180126e-01 2771:7.1890347e-02 2824:8.1224762e-02 2933:8.0126077e-02 "
          "3137:6.1298497e-02 "
          "3219:9.8932967e-02 3230:1.1288441e-01 3231:1.3121083e-01 3272:5.3371817e-02 3387:7.7760033e-02 "
          "3656:7.6234907e-02 "
          "3860:1.0627814e-01 4523:2.7653658e-01 5740:8.9249440e-02 8168:1.3357452e-01 9026:1.0093617e-01 "
          "12058:1.0700921e-01 12275:2.6784596e-01 12276:2.7168319e-01 12282:1.2917174e-01 13346:1.1627406e-01 "
          "14967:2.0771316e-01 21623:1.2864026e-01 34501:1.8448383e-01")));

  for (auto _ : state)
  {
    for (auto* example : examples)
    {
      VW::setup_example(*vw, example);
      vw->learn(*example);
      vw->finish_example(*example);
    }

    benchmark::ClobberMemory();
  }

  VW::finish(*vw, true);
}

BENCHMARK_CAPTURE(benchmark_rcv1_dataset, simple, "--quiet");
BENCHMARK_CAPTURE(benchmark_rcv1_dataset, quadratic, "--quiet -q ::");
