root_folder=/xxx/nersemble-v1
subject="xxx"
sequence="HAIR"
workdir=${root_folder}/${subject}/${sequence}
track_output_folder="${workdir}/flame_fitting/raw_data"
export_as_nerf_dataset="${workdir}/flame_fitting/preprocessed_data"
project_dir="/xxx/Dynamic_Hair_Reconstruction"
cd ${project_dir}

GPU="0"
camera="PINHOLE"
exp_name_1="stage1"
exp_name_2="stage2"
exp_name_3="stage3"
exp_path_1=$workdir/3d_gaussian_splatting/$exp_name_1

eval "$(conda shell.bash hook)"

conda deactivate && conda activate VHAP
mkdir -p ${workdir}/images
python data_utils/preprocess_raw_images.py --input ${workdir} 

# Run Matte-Anything
conda deactivate && conda activate matte_anything
python data_utils/calc_masks.py --data_path ${workdir} --image_format png --max_size 3072

# Resize images
conda deactivate && conda activate gaussian_splatting_hair_cuda
python data_utils/resize_images.py --data_path ${workdir}

# Calculate orientation maps 
conda deactivate && conda activate VHAP
python data_utils/calc_orientation_maps.py \
--data_path ${workdir} \
--img_scale 4

# Flame parameters matching
conda deactivate && conda activate VHAP
mkdir -p ${track_output_folder}
python ext/vhap/track_nersemble.py \
--data.root_folder ${root_folder} \
--exp.output_folder ${track_output_folder} \
--data.subject ${subject} --data.sequence ${sequence} \
--data.n_downsample_rgb 4

# Export tracking results into a NeRF-style dataset
conda deactivate && conda activate VHAP
mkdir -p ${export_as_nerf_dataset}
python ext/vhap/export_as_nerf_dataset.py \
--src_folder ${track_output_folder} \
--tgt_folder ${export_as_nerf_dataset} --background-color black \
--n_downsample_rgb 4


