import os
import sys
import shutil
import tyro
from pathlib import Path

def main(folder_path: Path):
    # folder_path = sys.argv[1]
    colmap_path = Path(str(folder_path) + f"/colmap/images")
    if not colmap_path.exists():
        colmap_path.mkdir(parents=True)
    folder_path = folder_path / 'images'
    for images_path in folder_path.glob('cam_*'):
        if images_path.is_dir():
            for image_path in sorted(images_path.glob('*.jpg')):
                image_name = image_path.name
                file_name = image_path.parents[0].name
                if image_name.startswith("frame_00001"):
                    cam_name = file_name.split('_')[-1]
                    dst_path = colmap_path / f'cam_{cam_name}.jpg'
                    shutil.copyfile(image_path, dst_path)

if __name__ == '__main__':
    tyro.cli(main)
    

