import os
import logging
from argparse import ArgumentParser
import shutil
def main(args):
    if not args.skip_matching:
        os.makedirs(args.source_path + "/sparse", exist_ok=True)

        ## Feature extraction
        feat_extracton_cmd = colmap_command + " feature_extractor "\
            "--database_path " + args.source_path + "/database.db \
            --image_path " + args.source_path + "/images \
            --SiftExtraction.use_gpu " + str(use_gpu) + " \
            --SiftExtraction.max_image_size " + str(args.max_size) +"\
            --SiftExtraction.max_num_features " + str(16384) +"\
            --SiftExtraction.estimate_affine_shape 1"+"\
            --SiftExtraction.domain_size_pooling 1"  
                
        exit_code = os.system(feat_extracton_cmd)
        if exit_code != 0:
            logging.error(f"Feature extraction failed with code {exit_code}. Exiting.")
            exit(exit_code)

        ## Feature matching
        feat_matching_cmd = colmap_command + " exhaustive_matcher \
            --database_path " + args.source_path + "/database.db \
            --SiftMatching.use_gpu " + str(use_gpu)
        exit_code = os.system(feat_matching_cmd)
        if exit_code != 0:
            logging.error(f"Feature matching failed with code {exit_code}. Exiting.")
            exit(exit_code)

        ### Bundle adjustment
        # The default Mapper tolerance is unnecessarily large,
        # decreasing it speeds up bundle adjustment steps.
        os.makedirs(args.source_path + "/sparse", exist_ok=True)
        mapper_cmd = (colmap_command + " mapper \
            --database_path " + args.source_path + "/database.db \
            --image_path "  + args.source_path + "/images \
            --output_path "  + args.source_path + "/sparse")# \
            # --Mapper.ba_global_function_tolerance=0.000001")
        exit_code = os.system(mapper_cmd)
        if exit_code != 0:
            logging.error(f"Mapper failed with code {exit_code}. Exiting.")
            exit(exit_code)
        os.makedirs(args.source_path + "/sparse_", exist_ok=True)
        if os.path.exists(args.source_path + "/sparse/0"):
            shutil.copytree(args.source_path + "/sparse/0", args.source_path + "/sparse_",dirs_exist_ok=True)
        
    ### Image undistortion
    ## We need to undistort our images into ideal pinhole intrinsics.
    os.makedirs(args.source_path + "/dense", exist_ok=True)
    img_undist_cmd = (colmap_command + " image_undistorter \
        --image_path " + args.source_path + "/images \
        --input_path " + args.source_path + "/sparse/0 \
        --output_path " + args.source_path + "/dense \
        --output_type COLMAP")
    exit_code = os.system(img_undist_cmd)
    if exit_code != 0:
        logging.error(f"Mapper failed with code {exit_code}. Exiting.")
        exit(exit_code)
    
    ### Patch match stereo
    ## We need to compute depth maps from stereo pairs.
    patch_match_stereo_cmd = (colmap_command + " patch_match_stereo \
        --workspace_path " + args.source_path + "/dense \
        --workspace_format COLMAP \
        --PatchMatchStereo.geom_consistency true")
    exit_code = os.system(patch_match_stereo_cmd)
    if exit_code != 0:
        logging.error(f"Patch match stereo failed with code {exit_code}. Exiting.")
        exit(exit_code)
    
    ### Stereo fusion
    ## We need to fuse depth maps into a single point cloud.
    stereo_fusion_cmd = (colmap_command + " stereo_fusion \
        --workspace_path " + args.source_path + "/dense \
        --workspace_format COLMAP \
        --input_type geometric \
        --output_path " + args.source_path + "/dense/fused.ply")
    exit_code = os.system(stereo_fusion_cmd)
    if exit_code != 0:
        logging.error(f"Stereo fusion failed with code {exit_code}. Exiting.")
        exit(exit_code) 
    
    if(args.resize):
        print("Copying and resizing...")

        # Resize images.
        os.makedirs(args.source_path + "/images_2", exist_ok=True)
        os.makedirs(args.source_path + "/images_4", exist_ok=True)
        os.makedirs(args.source_path + "/images_8", exist_ok=True)
        # Get the list of files in the source directory
        files = os.listdir(args.source_path + "/images")
        # Copy each file from the source directory to the destination directory
        for file in files:
            source_file = os.path.join(args.source_path, "images", file)

            destination_file = os.path.join(args.source_path, "images_2", file)
            shutil.copy2(source_file, destination_file)
            exit_code = os.system(magick_command + " mogrify -resize 50% " + destination_file)
            if exit_code != 0:
                logging.error(f"50% resize failed with code {exit_code}. Exiting.")
                exit(exit_code)

            destination_file = os.path.join(args.source_path, "images_4", file)
            shutil.copy2(source_file, destination_file)
            exit_code = os.system(magick_command + " mogrify -resize 25% " + destination_file)
            if exit_code != 0:
                logging.error(f"25% resize failed with code {exit_code}. Exiting.")
                exit(exit_code)

            destination_file = os.path.join(args.source_path, "images_8", file)
            shutil.copy2(source_file, destination_file)
            exit_code = os.system(magick_command + " mogrify -resize 12.5% " + destination_file)
            if exit_code != 0:
                logging.error(f"12.5% resize failed with code {exit_code}. Exiting.")
                exit(exit_code)

    print("Done.")
if __name__ == "__main__":
    # This Python script is based on the shell converter script provided in the MipNerF 360 repository.
    parser = ArgumentParser("Colmap converter")
    parser.add_argument("--no_gpu", action='store_true')
    parser.add_argument("--skip_matching", action='store_true')
    parser.add_argument("--source_path", "-s", required=True, type=str)
    parser.add_argument("--camera", default="OPENCV", type=str)
    parser.add_argument("--colmap_executable", default="", type=str)
    parser.add_argument("--resize", action="store_true")
    parser.add_argument("--magick_executable", default="", type=str)
    parser.add_argument("--max_size", default=4096, type=int)
    args = parser.parse_args()
    colmap_command = '"{}"'.format(args.colmap_executable) if len(args.colmap_executable) > 0 else "colmap"
    magick_command = '"{}"'.format(args.magick_executable) if len(args.magick_executable) > 0 else "magick"
    use_gpu = 1 if not args.no_gpu else 0
    main(args)