subject="xxx"
sequence="HAIR"
workdir=/xxx/nersemble-v1/${subject}/${sequence}
project_dir="/xxx/Dynamic_Hair_Reconstruction"
cd ${project_dir}
GPU="0"
camera="PINHOLE"
exp_name_1="stage1"
exp_name_2="stage2"
exp_name_3="stage3"
exp_path_1=${workdir}/3d_gaussian_splatting/$exp_name_1

eval "$(conda shell.bash hook)"

TORCH_USE_CUDA_DSA=1
conda deactivate && conda activate gaussian_splatting_hair_cuda && cd src
CUDA_VISIBLE_DEVICES="$GPU" python train_latent_strands.py \
    --configs arguments/multipleview/defor.py \
    -s ${workdir} -m "${exp_path_1}" -r 1 \
    --model_path_hair "${workdir}/strands_reconstruction/$exp_name_2" \
    --flame_mesh_dir "${workdir}/flame_fitting" \
    --pointcloud_path_head "${exp_path_1}/point_cloud_cropped/iteration_30000/raw_point_cloud.ply" \
    --hair_conf_path "${project_dir}/src/arguments/hair_strands_textured.yaml" \
    --static_nerf --lambda_dmask 0.1 --lambda_dorient 0.1 --lambda_dsds 0.01 --start_time_step 0 --num_time_steps 1 \
    --binarize_masks --iteration_data 20000 \
    --use_barf --iterations 20000 --port "800$GPU"
