### 1. Environment

Environment Preparation:

```
Bash install.sh
```

### 2. Datasets

#### 2.1 FLAME

Our code relies on FLAME. Please download assets from the [official website](https://flame.is.tue.mpg.de/download.php) and store them in the paths below: 

- FLAME 2023 (versions w/ jaw rotation) -> `ext/vhap/asset/flame/flame2023.pkl`
- FLAME Vertex Masks -> `ext/vhap/asset/flame/FLAME_masks.pkl`

#### 2.2 NeRSemble

To get access to [NeRSemble](https://tobias-kirschstein.github.io/nersemble/) dataset, please request via the [Google Form](https://forms.gle/rYRoGNh2ed51TDWX9). The directory structure is expected to be like:

```
<root_folder>/
    |---camera_params/
    |   |---<subject>/
    |       |---camera_params.json
    |
    |---color_correction/
    |   |---<subject>/
    |       |---<camera_id>.npy
    |
    |---<subject>/
        |---<HAIR>/
        |---<Multi-view videos>/
```

### 3. Usage

#### 3.1 Data Preprocessing

​	Modify the `root_folder`, `subject`, and `project_dir` in file `preprocess_datasets.sh`  to match your dataset directory, subject ID (e.g. 304), and project path, respectively. 

```
Bash preprocess_datasets.sh
```

#### 3.2 Dynamic Hair reconstruction

##### 3.2.1 Coarse Stage
Modify `--start_time_step` and `--num_time_steps` in file `run_fine.sh` to set the desired starting frame and total number of frames. Note that `--start_time_step` starts from 0.

```
Bash run.sh
```

##### 3.2.2 Refine Stage

Modify the `--start_checkpoint_hair` weight path in file `run_fine.sh`  to the output of the coarse stage. The weight file from the coarse stage, typically corresponding to 20,000 iterations, can be found in the most recent dated folder under `${workdir}/strands_reconstruction/${exp_name_2}/checkpoints`

```
Bash run_fine.sh
```

##### 3.2.3 Render

Modify the `--checkpoint_hair` weight path in file `render.sh`  to the output of the coarse stage  and the `--checkpoint_curves` weight path in file `render.sh`  to the output of the refine stage. The weight file from the coarse stage, typically corresponding to 10,000 iterations, can be found in the most recent dated folder under `${workdir}/curves_reconstruction/${exp_name_3}/checkpoints`.

```
Bash render.sh
```



