subject="xxx"
sequence="HAIR"
workdir=/xxx/nersemble-v1/${subject}/${sequence}
project_dir="/xxx/Dynamic_Hair_Reconstruction"
cd ${project_dir}
GPU="0"
camera="PINHOLE"
exp_name_1="stage1"
exp_name_2="stage2"
exp_name_3="stage3"
exp_path_1=${workdir}/3d_gaussian_splatting/$exp_name_1

eval "$(conda shell.bash hook)"
conda deactivate && conda activate gaussian_splatting_hair_cuda && cd src
CUDA_VISIBLE_DEVICES="$GPU" python render_strands.py \
    -s ${workdir} --data_dir "${workdir}" --data_device 'cpu' \
    -m "${workdir}/3d_gaussian_splatting/${exp_name_1}" --iteration 30000 \
    --configs arguments/multipleview/defor.py \
    --flame_mesh_dir "${workdir}/flame_fitting" \
    --model_hair_path "${workdir}/curves_reconstruction/${exp_name_3}" \
    --hair_conf_path "arguments/hair_strands_textured.yaml" \
    --checkpoint_hair "${workdir}/strands_reconstruction/${exp_name_2}/checkpoints/xxx/20000.pth" \
    --checkpoint_curves "${workdir}/curves_reconstruction/${exp_name_3}/checkpoints/xxx/10000.pth" \
    --pointcloud_path_head "${exp_path_1}/point_cloud/iteration_30000/raw_point_cloud.ply" \
    --interpolate_cameras --static_nerf --start_time_step 30 --num_time_steps 10


