subject="xxx"
sequence="HAIR"
workdir=/xxx/nersemble-v1/${subject}/${sequence}
project_dir="/xxx/Dynamic_Hair_Reconstruction"
cd ${project_dir}
GPU="0"
camera="PINHOLE"
exp_name_1="stage1"
exp_name_2="stage2"
exp_name_3="stage3"
exp_path_1=${workdir}/3d_gaussian_splatting/$exp_name_1

eval "$(conda shell.bash hook)"
conda deactivate && conda activate gaussian_splatting_hair_cuda && cd src
CUDA_VISIBLE_DEVICES="$GPU" python train_strands.py \
    --configs arguments/multipleview/defor.py \
    -s ${workdir} -m "${workdir}/3d_gaussian_splatting/$exp_name_1" -r 1 \
    --model_path_curves "${workdir}/curves_reconstruction/$exp_name_3" \
    --flame_mesh_dir "${workdir}/flame_fitting" \
    --pointcloud_path_head "$exp_path_1/point_cloud_cropped/iteration_30000/raw_point_cloud.ply" \
    --start_checkpoint_hair "${workdir}/strands_reconstruction/$exp_name_2/checkpoints/xxx/20000.pth" \
    --hair_conf_path "${project_dir}/src/arguments/hair_strands_textured.yaml" \
    --lambda_dmask 0.1 --lambda_dorient 0.1 --lambda_dsds 0.01 --lambda_dl1 0.8 --lambda_dssim 0.2 --lambda_hair_smoothness 0.01  \
    --binarize_masks --iteration_data 10000 \
    --position_lr_init 0.0000016 --position_lr_max_steps 10000 --start_time_step 0 --num_time_steps 1 \
    --static_nerf --use_barf \
    --iterations 10000 --port "800$GPU"

