# Constrained Initial Representations

This is the code for our novel method, Constrained Initial Representations (CIR). Under review, please do not distribute.


## Results

We gather CIR logs on all evaluated DMC and HumanoidBench tasks in the `results/cir.csv` file.


## How to run

To reproduce our reported results in the submission, please check the following instructions:

You need to install some necessary packages before running our code, please check the `requirement.txt` file.

**MuJoCo**

```
# Additional environmental variables for headless rendering
export MUJOCO_GL="egl"
export MUJOCO_EGL_DEVICE_ID="0"
export MKL_SERVICE_FORCE_INTEL="0"
```

**HumanoidBench**
```
git clone https://github.com/joonleesky/humanoid-bench
cd humanoid-bench
pip install -e .
```

In the `dmc` file, run `train_dmc.py` by calling:

```
CUDA_VISIBLE_DEVICES=0 python train_dmc.py --env cheetah-run --policy cir --smr --ratio 2 --hidden-sizes 512,512 --seed 2 --dir test
```

Similarly, in the `humanoidbench` file, run `train_humanoid.py` by calling:

```
python train_humanoid.py --env h1-reach-v0 --policy cir --hidden-sizes 512,512 --cuda 0 --smr --ratio 2 --seed 2 --dir test
```