import logging

def log_creator(path):
    # 创建一个日志器
    logger = logging.getLogger("logger")
    logger.propagate = False
 
    # 设置日志输出的最低等级,低于当前等级则会被忽略
    logger.setLevel(logging.INFO)
 
    # 创建处理器：sh为控制台处理器，fh为文件处理器
    sh = logging.StreamHandler()
 
    # 创建处理器：sh为控制台处理器，fh为文件处理器,log_file为日志存放的文件夹
    fh = logging.FileHandler(path,encoding="UTF-8")
 
    # 创建格式器,并将sh，fh设置对应的格式
    formator = logging.Formatter(fmt = "%(asctime)s %(levelname)s %(message)s",
                                         datefmt="%Y/%m/%d %X")
    sh.setFormatter(formator)
    fh.setFormatter(formator)
 
    # 将处理器，添加至日志器中
    logger.addHandler(sh)
    logger.addHandler(fh)
    return logger