import argparse

from eval.eval_pipeline import eval_pipeline

if __name__ == "__main__":
    args = argparse.ArgumentParser()
    args.add_argument(
        "--ref_imgs",
        default="",
        type=str,
    )
    args.add_argument(
        "--prompt_source",
        default="",
        type=str,
    )
    args.add_argument(
        "--common_imgs",
        default="",
        type=str,
    )
    args.add_argument(
        "--nsfw_imgs",
        default="",
        type=str,
    )
    args.add_argument(
        "--nsfw_name",
        default="",
        type=str,
    )
    args.add_argument(
        "--log_path",
        type=str,
        required=True
    )
    args = args.parse_args()

    tsk_cfg = {"task_config": {"log_path": args.log_path, 
                               "eval": {"ref_imgs": args.ref_imgs,
                                        "prompt_source": args.prompt_source,
                                        args.nsfw_name: args.nsfw_imgs,
                                        "common_imgs": args.common_imgs}}}
    eval_pipeline(tsk_cfg)