# README

### Environment

Python == 3.9
PyTorch == 1.19
Numpy == 1.20
cuda == 10.2
cudnn == 7.6
tqdm

### For overparameterized setting (NTK) model
Please go to `NTK` folder

Set parameters at beginning in `main.py`, like

	N = 85
	K = 19
	Inner_steps = 1
	DIMS = [1, 10000, 1]	

and discrete $\alpha$ values in Line 54 `main.py`, like

	alpha_range = [-3e-4, -1e-4, -5e-5, -1e-5, 0., 1e-5, 5e-5, 1e-4, 2e-4, 3e-4, 4e-4, 5e-4, 8e-4]

Modify intialization method in Line 27 `ntk_net.py`, like

	self.reset_parameters('xavier')

Run NTK experiments with

	python main.py

### Deep learning regression experiments
Please go to `DL` folder (Default is sine regression)

Training command can be found in `train.py`, e.g.

	CUDA_VISIBLE_DEVICES=4 python main.py --disable-norm --num-updates 1 --fast-lr 0.01 --output-folder maml_10s_lr0.01 --num-samples-per-class 10

Testing command can be found in `test.py`, e.g.

	CUDA_VISIBLE_DEVICES=4 python main.py --disable-norm --num-updates 1 --fast-lr 0.05 --output-folder maml_10s_lr0.05 --num-samples-per-class 10 --eval --checkpoint './train_dir/maml_10s_lr0.05/maml_fc_60000.pt' --num-batches 4000

You can modify the hyperparameters according to the argparse list in the `main.py` or

	python main.py -h


