# Stein Variational Evolution Strategies

Code for the paper *Stein Variational Evolution Strategies*.

## Installation
First create an environment that contains all required packages.
Then install all local files into the environment.
This can be done in the following way:
```
python3.10 -m venv --prompt sves .venv
source .venv/bin/activate

pip install evosax/.    // install evosax fork from source
pip install -r requirements.txt

// Install jax from url directly
pip install jaxlib==0.4.28+cuda12.cudnn89 -f https://storage.googleapis.com/jax-releases/jax_cuda_releases.html
pip install jax==0.4.28    // Get matching jax for jaxlib

pip install -e .
```
In case some of the dependencies do not work for you (e.g. CUDA related stuff) the code should also be runnable with older / newer versions of jax, but we cannot guarantee the results will not differ in this case.

## Code
The code for our paper is in `sves`. The `evosax` module is simply a fork of the [evosax package](https://github.com/RobertTLange/evosax) with a minor modification of the singular value decomposition to improve numerical stability.
Note that the author information in the evosax module is _NO_ information about the authors of this paper.

## Reproducing Experiments & Plots
All code to reproduce the experimental results can be found in `evaluation/`.
For each experiment there is a jupyter notebook that runs experiments and produces plots.
For memory efficiency, the notebooks have been transformed into normal Python source using [jupytext](https://jupytext.readthedocs.io/en/latest/).
You can reverse this by running:
```
jupytext --to notebook example.py   // this creates example.ipynb
```
It should be clear from those how to reproduce all plots from the paper.

For legacy reasons the naming convention in the code is slightly different than in the paper. 
Gradient-based SVGD is implemented in `svgd.py`, GF-SVGD in `gf_svgd.py`, SV-OpenAI-ES in `mc_svgd.py`, and SV-CMA-ES in `svgd_cma_es.py`.

## Acknowledgements
The evolution strategies in this code are based on [evosax](https://github.com/RobertTLange/evosax/tree/main).
The code for the logistic regression experiment is based on the repository for [Neural Variational Gradient Descent](https://github.com/langosco/neural-variational-gradient-descent/tree/master) (Langosco di Langosco et al., 2021).
We thank the authors of the above works for making their code public.
The code is free to use under the MIT License.
