from espercentile import calc_social_welfare

def brute_force_optimal(x, k1, k2):
    if k1 == k2:
        return _brute_force_optimal_eq(x, k1, k2)
    else:
        return _brute_force_optimal_ineq(x, k1, k2)

def _brute_force_optimal_eq(x, k1, k2):
    assert k1 == k2 # Currently we're only doing this case

    x = sorted(x)
    n = len(x)

    best_sw = -1
    for j1 in range(n - 1):
        for j2 in range(j1 + 1, n):
            sw = calc_social_welfare(x, k1, k2, j1, j2, ordered=True)
            if sw > best_sw:
                best_sw = sw    

    return best_sw


def _brute_force_optimal_ineq(x, k1, k2):
    assert k1 != k2 # Use the above function if equal

    x = sorted(x)
    n = len(x)

    best_sw = -1
    for j1 in range(n):
        for j2 in range(n):
            sw = calc_social_welfare(x, k1, k2, j1, j2, ordered=True)
            if sw > best_sw:
                best_sw = sw
                best_indices = (j1, j2)
    
    return best_sw
