import math


def es_percentile(x, k1, k2, v1, v2):
    x = sorted(x)

    n = len(x)
    j1 = math.floor(v1 * (n - 1)) # We don't add 1 as indexing starts at 0 in python
    j2 = math.floor(v2 * (n - 1))

    return calc_social_welfare(x, k1, k2, j1, j2)


def calc_social_welfare(x, k1, k2, j1, j2, ordered=False):
    if not ordered:
        x = sorted(x)
    y1 = x[j1]
    y2 = x[j2]

    # Order agents by distance
    y1_dist = [(abs(x[i] - y1), i, 1) for i in range(len(x))]
    y2_dist = [(abs(x[i] - y2), i, 2) for i in range(len(x))]
    dists = sorted(y1_dist + y2_dist, key = lambda k: k[0])

    y1_count = 0
    y2_count = 0
    y1_sw = 0
    y2_sw = 0
    assigned = set()
    # Assign each agent to a facility based on which is closest.
    for dist, index, y in dists:
        if index in assigned:
            continue
        if y == 1 and y1_count < k1:
            y1_count += 1
            y1_sw += 1 - dist
            assigned.add(index)
        if y == 2 and y2_count < k2:
            y2_count += 1
            y2_sw += 1 - dist
            assigned.add(index)
        if y1_count == k1 and y2_count == k2:
            break
    
    return y1_sw + y2_sw
