from espercentile import es_percentile


def esp_worst(x, k1, k2):
    return es_percentile(x, k1, k2, 0, 1)


def esp_equal_k_best(x, k1, k2):
    assert k1 == k2  # Assumption made by algorithm
    v1 = 0.5 - (k1 / len(x))
    v2 = 0.5 + (k1 / len(x))
    return es_percentile(x, k1, k2, v1, v2)


def esp_diff_k_best(x, k1, k2):
    assert k1 > k2  # Assumption made by algorithm
    n = len(x)
    big_delta = n - (k1 + k2)
    small_delta = max(((n - 2 * k1) / n), 0)
    v1 = (big_delta - 1) / n + small_delta
    v2 = 1 - small_delta
    return es_percentile(x, k1, k2, v1, v2)

def esp_mixed_equal_k_best(x, k1, k2):
    return es_percentile(x, k1, k2, 0.25, 0.75)
