import numpy as np
import matplotlib.pyplot as plt
import seaborn as sns
import gurobipy as gp
from gurobipy import GRB



n_content = 100
S_max = 10
c_b = 1
B_budget = 30
pop = np.load('Requestmatrixbinary.npy')
n_request = np.load('Requestnumber.npy')
mu = 1 / n_content
a_number = 3

fldpr = np.zeros((n_content,  S_max+1 , 2, S_max+1))
for i in range( n_content):
    for s in range(0, S_max+1):             
        if s == S_max:
            fldpr[i][s][0][s] = 1
            fldpr[i][s][1][s-1] = 1 
        elif s == 0:
            fldpr[i][s][0][s+1] = 1
            fldpr[i][s][1][s] = 1
        else:
            fldpr[i][s][0][s+1] = 1
            fldpr[i][s][1][s+1] = pop[i]/(pop[i]+mu*s)
            fldpr[i][s][1][s-1] = mu*s/(pop[i]+mu*s)
            

m = gp.Model("fluid")


x = m.addMVar((n_content,  S_max + 1, a_number), vtype = 'C', lb = 0, ub = 1, name = 'ab')
sumsx = m.addMVar((n_content, S_max + 1), vtype = 'C')
sumsa = m.addMVar((n_content), vtype = 'C')
sumn = m.addMVar((n_content, 1), vtype = 'C')
sumsa1 = m.addMVar((n_content), vtype = 'C')
sumsa1n = m.addMVar(( 1), vtype = 'C')
sumsp = m.addMVar((n_content,  S_max + 1, S_max + 1), vtype = 'C')
sumsp1 = m.addMVar((n_content, S_max + 1, S_max + 1), vtype = 'C')

b = m.addMVar(( 1), vtype = 'I', lb = 0, name = 'Bt')


# Set objective
# m.setObjective(sum(b), GRB.MAXIMIZE)

for i in range(n_content):
    for s in range(S_max +1):
        m.addConstr(sumsx[i][s] == sum(x[i][s][a_number] for a_number in range(a_number)))
            
for i in range(n_content):
        m.addConstr(sumsa[i] == sum(sumsx[i][j] * j for j in range(S_max + 1)))
        
for i in range(n_content):
    m.addConstr(sumn[i] == sum(sumsa[i][j])

m.setObjective(sum(sumn[i] for i in range(n_content)), GRB.MAXIMIZE)
                
for i in range(n_content):
    m.addConstr(sumsa1[i] == sum(x[i][s][1] for s in range(S_max + 1 )))

for t in range(n_frame):
    m.addConstr(sumsa1n == sum(sumsa1[i] for i in range(n_content)))

for t in range(n_frame):
    m.addConstr(sumsa1n[t] <= b[t])        

for i in range(n_content):
    for s in range(S_max +1):
        for s_n in range(S_max + 1):            
            m.addConstr(sumsp[i][s][s_n] == sum(x[i][s][a_number] * fldpr[i][s][a_number][s_n]  for a_number in range(a_number))
            m.addConstr(sumsp1[i][s_n][s] == sum(x[i][s_n][a_number] * fldpr[i][s][a_number][s_]  for a_number in range(a_number))

for i in range(n_content):
    for s in range(S_max + 1):
        m.addConstr(sum(sumsp[i][s][j] for j in range(S_max + 1)) == sum(sumsp1[i][j][s] for j in range(S_max + 1)))


m.addConstr(sum(b[t] for t in range(n_frame))<= B_budget)





# Optimize model
m.optimize()

for v in m.getVars():
    print('%s %g' % (v.varName, v.x))

print('Obj: %g' % m.objVal)