from genericpath import exists
import itertools
from select import select
import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.optim as optim
from torchvision import datasets, transforms
from torch.optim.lr_scheduler import StepLR
from torch.utils.data import DataLoader, Dataset
import os
from tqdm import tqdm
from random import random, seed, shuffle
from matplotlib import cm
from matplotlib.collections import LineCollection
import matplotlib.pyplot as plt
WN = 2**20

KPD = 4
train_accuracy = []
test_accuracy = []
for i in range(32):
    train_ac = torch.load('./accuracy/2153/temp_train{}_{}.pt'.format(i, 32))
    test_ac = torch.load('./accuracy/2153/temp_test{}_{}.pt'.format(i, 32))
    train_accuracy.append(train_ac[int(i * WN / 32): int((i+1)*WN/32)])
    test_accuracy.append(test_ac[int(i * WN / 32): int((i+1)*WN/32)])
train_accuracy = torch.cat(train_accuracy, dim=0).float()
test_accuracy = torch.cat(test_accuracy, dim=0).float()
sorted_train_accuracy = train_accuracy.sort(descending=True)


search_space = 79 ** KPD
mask = torch.ge(train_accuracy, 64)
train_accuracy_kpd = torch.pow(train_accuracy, KPD)
miss_kpd :torch.Tensor = search_space - train_accuracy_kpd

theta = torch.arcsin(torch.sqrt(train_accuracy_kpd.mean()/(search_space)))


rot = (9) * theta

optimal_possibility = torch.sin(rot) * torch.sin(rot) * train_accuracy_kpd[mask].sum() / train_accuracy_kpd.sum() +\
    torch.cos(rot) * torch.cos(rot) * miss_kpd[mask].sum() / miss_kpd.sum()
print(optimal_possibility)
