from genericpath import exists
import itertools
from select import select
from tkinter.tix import Tree
import torch
import torch.nn as nn
import torch.nn.functional as F
import torch.optim as optim
from torchvision import datasets, transforms
from torch.optim.lr_scheduler import StepLR
from torch.utils.data import DataLoader, Dataset
import os
from tqdm import tqdm
from random import random, seed, shuffle
WN = 2**20
WB = 20
import argparse
parser = argparse.ArgumentParser()
parser.add_argument('-p', type=int, help='number of process')
parser.add_argument('-n', type=int, help='id of process')
parser.add_argument('-f', type=str, help='storage')
args = parser.parse_args()


def matrix2bitstring(matrix  : torch.Tensor):
    return matrix[0][0] + 2 * matrix[0][1] + 4 * matrix[0][2] + \
            8 * matrix[1][0] + 16 * matrix[1][1] + 32 * matrix[1][2] + \
                64 * matrix[2][0] + 128 * matrix[2][1] + 256 * matrix[2][2]
def bitstring2matrix(bitstring : int) -> torch.Tensor:
    matrix = torch.zeros((3,3))
    bitstring = list(bin(bitstring)[2:].rjust(9, '0'))
    matrix[2][2] = int(bitstring[0] == '1')
    matrix[2][1] = int(bitstring[1] == '1')
    matrix[2][0] = int(bitstring[2] == '1')
    matrix[1][2] = int(bitstring[3] == '1')
    matrix[1][1] = int(bitstring[4] == '1')
    matrix[1][0] = int(bitstring[5] == '1')
    matrix[0][2] = int(bitstring[6] == '1')
    matrix[0][1] = int(bitstring[7] == '1')
    matrix[0][0] = int(bitstring[8] == '1')
    return matrix
    


def load(label: list):
    
    train0 : torch.Tensor = torch.load('./data/train/samples_{}.pt'.format(label[0]))
    train0_label = torch.Tensor([1 for _ in range(train0.shape[0])]).long()
    train1 : torch.Tensor = torch.load('./data/train/samples_{}.pt'.format(label[1]))
    train1_label = torch.Tensor([2 for _ in range(train1.shape[0])]).long()
    train2 : torch.Tensor = torch.load('./data/train/samples_{}.pt'.format(label[2]))
    train2_label = torch.Tensor([3 for _ in range(train2.shape[0])]).long()
    
    train_data = torch.cat([train0, train1, train2], dim=0).long()
    train_label = torch.cat([train0_label, train1_label, train2_label], dim=0).long()

    test0 : torch.Tensor = torch.load('./data/test/samples_{}.pt'.format(label[0]))
    test0_label = torch.Tensor([1 for _ in range(test0.shape[0])]).long()
    test1 : torch.Tensor = torch.load('./data/test/samples_{}.pt'.format(label[1]))
    test1_label = torch.Tensor([2 for _ in range(test1.shape[0])]).long()
    test2 : torch.Tensor = torch.load('./data/test/samples_{}.pt'.format(label[2]))
    test2_label = torch.Tensor([3 for _ in range(test2.shape[0])]).long()
    
    test_data = torch.cat([test0, test1, test2], dim=0).long()
    test_label = torch.cat([test0_label, test1_label, test2_label], dim=0).long()

    reduce_table_train = torch.zeros((512, 4))
    reduce_table_test = torch.zeros((512, 4))
    for i in range(train_data.shape[0]):
        bits = matrix2bitstring(train_data[i])
        reduce_table_train[bits][train_label[i]] += 1
    for i in range(test_data.shape[0]):
        bits = matrix2bitstring(test_data[i])
        reduce_table_test[bits][test_label[i]] += 1
    
    reduce_train_label = reduce_table_train.argmax(dim=1)
    reduce_test_label = reduce_table_test.argmax(dim=1)
    
    for i in range(reduce_train_label.shape[0]):
        if reduce_table_train[i].ge(reduce_table_train[i][reduce_train_label[i]]).long().sum() > 1:
            reduce_train_label[i] = 0
    
    for i in range(reduce_test_label.shape[0]):
        if reduce_table_test[i].ge(reduce_table_test[i][reduce_test_label[i]]).long().sum() > 1:
            reduce_test_label[i] = 0
    train_sample_num = reduce_train_label.gt(0).long().sum().item()
    test_sample_num = reduce_test_label.gt(0).long().sum().item()

    train_data_output = torch.zeros((train_sample_num, 3, 3)).long()
    train_label_output = torch.zeros((train_sample_num)).long()

    test_data_output = torch.zeros((test_sample_num, 3, 3)).long()
    test_label_output = torch.zeros((test_sample_num)).long()

    train_data_num = 0
    for i in range(reduce_train_label.shape[0]):
        if reduce_train_label[i] != 0:
            train_data_output[train_data_num] = bitstring2matrix(i)
            train_label_output[train_data_num] = reduce_train_label[i] - 1
            train_data_num += 1
    test_data_num = 0
    for i in range(reduce_test_label.shape[0]):
        if reduce_test_label[i] != 0:
            test_data_output[test_data_num] = bitstring2matrix(i)
            test_label_output[test_data_num] = reduce_test_label[i] - 1
            test_data_num += 1
    return train_data_output.long(), train_label_output.long(), test_data_output.long(), test_label_output.long()


from torch.utils.data import Dataset, DataLoader
def train(args, model, device, train_loader, optimizer, epoch):
    model.train()
    for batch_idx, (data, target) in enumerate(train_loader):

       
        
        data, target = data.to(device), target.to(device)
        optimizer.zero_grad()
        output = model(data)
        loss = F.nll_loss(output, target)
        loss.backward()
        optimizer.step()
        
        print('Train Epoch: {} [{}/{} ({:.0f}%)]\tLoss: {:.6f}'.format(
                epoch, batch_idx * len(data), len(train_loader.dataset),
                100. * batch_idx / len(train_loader), loss.item()))
            


def test(model, device, test_loader):
    model.eval()
    test_loss = 0
    correct = 0
    with torch.no_grad():
        for data, target in test_loader:
            data, target = data.to(device), target.to(device)
            output = model(data)
            test_loss += F.nll_loss(output, target, reduction='sum').item()  # sum up batch loss
            pred = output.argmax(dim=1, keepdim=True)  # get the index of the max log-probability
            correct += pred.eq(target.view_as(pred)).sum().item()

    test_loss /= len(test_loader.dataset)

    print('\nTest set: Average loss: {:.4f}, Accuracy: {}/{} ({:.0f}%)\n'.format(
        test_loss, correct, len(test_loader.dataset),
        100. * correct / len(test_loader.dataset)))

class QuantumDataset(Dataset):
    def __init__(self, train : bool = True):
       self.train_data, self.train_label, self.test_data, self.test_label = load([1, 2, 7])
       self.train = train
       if self.train == True:
            self.data = self.train_data.float()
            self.label = self.train_label
       else :
            self.data = self.test_data.float()
            self.label = self.test_label
    def __len__(self):
        return self.data.shape[0]

    def __getitem__(self, idx):
        return self.data[idx].unsqueeze(0), self.label[idx]
    
class Net(nn.Module):
    def __init__(self):
        super(Net, self).__init__()
        
        self.fc = nn.Linear(9, 3)

    def forward(self, x):
        

       
        x = torch.flatten(x,1)
        x = self.fc(x)
        output = F.log_softmax(x, dim=1)
        return output
torch.manual_seed(0)
device = torch.device("cpu")
train_dataset = QuantumDataset(True)
test_dataset = QuantumDataset(False)
train_kwargs = {'batch_size': 8}
test_kwargs = {'batch_size': 46}
test_train_kwargs = {'batch_size': 79}
train_loader = DataLoader(train_dataset,**train_kwargs)
test_loader = DataLoader(test_dataset, **test_kwargs)
test_train_loader = DataLoader(train_dataset, **test_train_kwargs)
model = Net()
optimizer = optim.Adadelta(model.parameters(), 1.0)

for epoch in range(1, 100 + 1):
        train(args, model, device, train_loader, optimizer, epoch)
        test(model, device, test_loader)
        test(model, device, test_train_loader)
       
        





