from turtle import title
from qram import QRAMDataSet, RowPatternDataset, MNISTDataset
from qmodel import QModel, RowdetectModel, RowdetectModelA, RowdetectModelB, MNISTMODEL
from qoptimizer import QOptimizer
from qiskit import QuantumCircuit
import matplotlib.pyplot as plt
import torch
from qiskit.visualization import plot_histogram,plot_state_city
from qiskit import IBMQ, Aer, assemble, transpile, execute
import time
import numpy as np

def verification():
    
            ACC = []
            TACC = []
            torch.set_printoptions (profile="full") 
            W = [i for i in range(1024)]
            Weights = []
            for w in W:
                w = list(bin(w)[2:].rjust(10, '0'))
                for i in range(len(w)):
                    w[i] =  int((w[i] == '1'))
                Weights.append(w)
            train_data = torch.load('./mnist_dataset/train_data2_7.pt')
            train_label = torch.load('./mnist_dataset/train_label2_7.pt')
            test_data = torch.load('./mnist_dataset/test_data2_7.pt')
            test_label = torch.load('./mnist_dataset/test_label2_7.pt')
            TRAIN_DATA = []
            TEST_DATA = []
            for i in range(train_data.shape[0]):
                x = train_data[i]
                x = list(bin(x)[2:].rjust(9, '0'))
                for j in range(len(x)):
                    x[j] =  int((x[j] == '1'))
                TRAIN_DATA.append(x)
            for i in range(test_data.shape[0]):
                x = test_data[i]
                x = list(bin(x)[2:].rjust(9, '0'))
                for j in range(len(x)):
                    x[j] =  int((x[j] == '1'))
                TEST_DATA.append(x)
            for k in range(len(Weights)):
                w = Weights[k]
                train_accuracy = 0
                test_accuracy = 0
                for i in range(len(TRAIN_DATA)):
                    sample = TRAIN_DATA[i]
                    o = 0
                    for j in range(9):
                        o += w[j] * sample[j]
                    o = int(o>=1)^w[9]
                    if o == train_label[i]:
                        train_accuracy += 1
                for i in range(len(TEST_DATA)):
                    sample = TEST_DATA[i]
                    o = 0
                    for j in range(9):
                        o += w[j] * sample[j]
                    o = int(o>=1)^w[9]
                    if o == test_label[i]:
                        test_accuracy += 1
                ACC.append(train_accuracy)
                TACC.append(test_accuracy)
                # print("{}:  {:.3f}, {:.3f} ".format(w,train_accuracy/len(TRAIN_DATA),test_accuracy/len(TEST_DATA)))
            ACC = torch.Tensor(ACC).float()
            TACC = torch.Tensor(TACC).float()
            return ACC, TACC
            # optimal = list(range(42))
            # others = list(range(42, 1024))
            
            # ACC = torch.pow(ACC, 3)
            # S_ACC = ACC.sort(descending=True)
            # theta = torch.arcsin(torch.sqrt(ACC.mean()/(128 * 128 * 128)))
            # print(theta)
            # print(ACC.max())
            # print(ACC.mean())
            # Mis = 128 * 128 * 128 - S_ACC[0]
            
            # for i in range(8):
            #     pos = torch.zeros((1024))
            #     plt.title('Weights Sample Possibility Distribution')
            #     plt.xlabel('weights ordered by accuracy')
            #     plt.ylabel('weights sample possibility')
            #     rot = (2 * i + 1) * theta
            #     for j in range(1024):
            #         pos[j] = torch.sin(rot) * torch.sin(rot) * S_ACC[0][j] / S_ACC[0].sum() + torch.cos(rot) * torch.cos(rot) * Mis[j] / Mis.sum()
            #     plt.bar(others, pos[others],fc='b')
            #     plt.bar(optimal, pos[optimal], fc='r')
            #     print(pos.sum()/pos[optimal].sum())
            #     plt.savefig('3PD_weights_sample_possibility_after_grover{}.pdf'.format(i))
            #     plt.clf()
    
            
            
    #acc = torch.Tensor(ACC)
    # print(acc.mean())
    # print(acc.sort(descending=True))
    # acc = acc.sort(descending=True)[0]
    # print(acc)
    # presum = torch.zeros_like(acc)
    # for i in range(acc.shape[0]):
    #     presum[i] = acc[0:i].sum()
    # presum = presum / acc.sum()
    # plt.title('Accuracy Distribution of WEIGHTS')
    # plt.xlabel('order of accuracy')
    # plt.ylabel('prefix sum')
    # plt.plot(presum)
    # plt.savefig('weights_distribution.jpg')
    # print(presum)

def Optimize(shots):
    weights_bits = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]
    address_bits = [10, 11, 12, 13, 14, 15, 16]
    dataset_bits = [10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20]
    ancillas = [21, 22, 23, 24, 25, 26, 27, 28, 29]
    output = 30
    allqubits = list(range(31))
    qc = QuantumCircuit(31, 10)
    train = torch.Tensor([1 for _ in range(128)]).long()
    train[94:128] = 0
    mnist_dataset = MNISTDataset(address_qubits=address_bits,qc=qc,dataset_qubits=dataset_bits,train=train)
    mnist_model = MNISTMODEL(qc=qc,ancilla_bits=ancillas,dataset_qubits=dataset_bits, weights=weights_bits,output=output)
    optimizer = QOptimizer(qc=qc,dataset_qubits=dataset_bits,output=output,data=mnist_dataset,model=mnist_model,allqubits=allqubits)
    mnist_dataset.encode()
    mnist_model.forward()
#    mnist_model.de_forward()
#    mnist_dataset.decode()
    optimizer.optimize(iter=3)
    #qc.cx(dataset_bits[-2], output)
    qc.measure(weights_bits, weights_bits)
    #qc.measure_all()
    aer_sim = Aer.get_backend('aer_simulator')
    job = execute(qc, aer_sim, shots=shots)
    counts = job.result().get_counts()
    return counts
#verification()
# for _ in range(10):
#     performance = []
#     Tperformance = []
#     shots = [10, 100, 500, 1000, 5000,10000]
#     for shot in shots:
#         counts = Optimize(shots=shot)
#         keys = list(counts.keys())
#         MAX_ID = int(keys[0], 2)
#         for it in keys:
#             number = int(it, 2)
#             if ACC[number] > ACC[MAX_ID]:
#                 MAX_ID = number
#         performance.append(ACC[MAX_ID])
#         Tperformance.append(TACC[MAX_ID])
#     print(performance)
#     print(Tperformance)
train_acc , test_acc = verification()
shots = [8, 16, 32, 64, 128]
for _ in range(10):
    performance = []
    Tperformance = []
    for x in shots:
        
        counts = Optimize(shots=x)
        keys = list(counts.keys())
        MAX_ID = int(keys[0], 2)
        for it in keys:
            number = int(it, 2)
            if train_acc[number] > train_acc[MAX_ID]:
                    MAX_ID = number
        performance.append(train_acc[MAX_ID])
        Tperformance.append(test_acc[MAX_ID])
    print(performance)
    print(Tperformance)


"""
dic = {'0101111110': 648, '0111110001': 493, '0110011000': 502, '0010110010': 673, '0111000010': 505, '0101001000': 397, '1001010110': 1122, '0000101000': 832, '0110001010': 500, '0010110011': 729, '0010011110': 686, '0111011101': 486, '0010111011': 678, '0001011000': 477, '0011011101': 523, '0011111110': 568, '0011001100': 461, '0001110110': 732, '0001101000': 600, '1101010110': 1228, '1100000000': 858, '0100101010': 618, '0100111000': 609, '1000000110': 779, '1111001001': 1554, '1000100100': 685, '0111110100': 525, '0111001010': 439, '0010111000': 559, '0110101111': 723, '1111111001': 1361, '0111101101': 580, '0010010100': 666, '1001100111': 974, '0101111100': 581, '0001010100': 717, '0010010010': 693, '1100000110': 964, '0101011011': 571, '1011010100': 1416, '0101101100': 678, '1010100100': 1071, '0110001000': 451, '1110101101': 1221, '0001100011': 807, '0001011100': 518, '0001110111': 761, '0101111111': 676, '0000010010': 735, '1011101110': 1279, '1010001011': 1307, '1010110110': 1138, '0111101100': 493, '1100010110': 1159, '1111101001': 1391, '1101000000': 1339, '0111001111': 577, '0111011110': 562, '1000001000': 1182, '0111010001': 473, '0101010011': 639, '1010110011': 1267, '0100100011': 859, '1111101111': 1307, '0100111100': 731, '0011010100': 549, '0110101011': 724, '1101111001': 1380, '0101110111': 772, '1001010111': 1107, '1000100000': 877, '1100111111': 1248, '1001000011': 1001, '0010011101': 577, '1000100001': 772, '1100011010': 1367, '0111000001': 419, '1010100101': 934, '1001001110': 1260, '0110101001': 669, '1101000001': 1309, '1101000111': 946, '0110010101': 682, '0110010111': 721, '1000010111': 1106, '0011001010': 516, '1000010010': 1152, '0011101010': 655, '0001010001': 652, '1001010000': 1339, '1101111100': 1288, '0101000101': 952, '0011100001': 610, '0011000000': 442, '0111111111': 614, '1100000011': 1031, '0011011001': 540, '1111101101': 1389, '0000101011': 743, '1111001011': 1428, '0100011010': 588, '0001110100': 680, '1111010011': 1331, '0010010011': 733, '1011111100': 1383, '1011000111': 1096, '0001111101': 670, '0011101001': 628, '0010011111': 651, '1000000100': 472, '1011001001': 1428, '0011101101': 663, '0010001111': 722, '1110100100': 1214, '1010110111': 1181, '0011101110': 728, '1010111100': 1404, '1101100111': 1092, '0000111010': 653, '1001100000': 1224, '0110001111': 654, '1100101010': 1298, '1000101011': 1179, '0110100010': 695, '0110010011': 685, '0100111101': 795, '1111111000': 1485, '1100111011': 1366, '1000101000': 1142, '0100011110': 628, '0001101001': 706, '1101110100': 1327, '1001110001': 1333, '0100010111': 839, '0000100110': 1066, '1100100001': 913, '0000000101': 1544, '0101110001': 646, '0001001100': 627, '0011001000': 332, '0001110010': 652, '1111100011': 1375, '0110100000': 654, '1110000010': 1202, '0110111001': 623, '1001011000': 1496, '0001000001': 934, '1101101101': 1240, '0101111101': 657, '0110100110': 826, '0101100011': 667, '0111010010': 561, '1010111000': 1394, '0011011010': 568, '0110111110': 669, '1111001101': 1509, '0001100010': 699, '1111110000': 1522, '0110011111': 643, '1001000010': 1107, '1000101001': 1080, '1110011111': 1315, '1011001011': 1375, '0111011000': 467, '0010111100': 586, '0111000111': 714, '0101110010': 615, '1011001101': 1424, '0100010001': 782, '0111000110': 636, '0011001101': 533, '1000001110': 1230, '1111110110': 1237, '1000110010': 1221, '1001111000': 1402, '0010000000': 770, '0000110000': 741, '1111000100': 1530, '0101111001': 574, '1010011001': 1354, '0111011100': 487, '0100010101': 872, '1100100000': 1006, '1000010001': 1114, '1010000100': 1062, '1000000101': 371, '0011000010': 695, '1001000000': 1038, '1001000100': 890, '0010011001': 573, '1000111010': 1339, '0001111000': 477, '1101000100': 1193, '0101000001': 779, '1000001111': 1116, '0010111111': 670, '0010001011': 665, '0100011101': 694, '1000000010': 902, '0111101111': 721, '0001100000': 771, '0111101001': 503, '0100110100': 840, '0111111110': 582, '1101011110': 1385, '1011000101': 1227, '0100010000': 717, '0011111011': 629, '0001010111': 828, '0001000100': 1023, '1111011101': 1404, '0100001101': 942, '0110110111': 734, '0111010110': 655, '1110100011': 1186, '0001001001': 610, '1000011100': 1321, '0011111000': 485, '0101010101': 696, '0001100001': 813, '1010101111': 1185, '0101000110': 878, '0110101000': 567, '0011001011': 605, '0011001110': 610, '0011110001': 525, '0100111001': 707, '1010111010': 1296, '0011111111': 657, '0011001111': 671, '0100010110': 824, '1001100100': 1000, '1001011001': 1359, '1110101011': 1352, '1111011001': 1436, '1101010010': 1282, '0011101100': 562, '0010011010': 604, '0001110001': 646, '1110100110': 1093, '0101001100': 547, '0100110001': 783, '0101010000': 569, '1011110101': 1296, '1000000111': 639, '0000010110': 919, '1111111110': 1339, '0000011111': 718, '0100111011': 623, '0100010011': 695, '0000101010': 679, '0011110111': 738, '1000010100': 1108, '1100010000': 1234, '0111000000': 269, '0000101111': 900, '0000111100': 632, '1001101111': 1212, '0011110011': 649, '1001011110': 1317, '1011110100': 1372, '0000010101': 881, '1001100110': 1071, '0001111010': 560, '1100010101': 1053, '1101010100': 1206, '1010010100': 1298, '0011011000': 404, '0100010100': 803, '1100001010': 1337, '0101001001': 477, '0010100110': 917, '1110111000': 1418, '1000100010': 1079, '1010010011': 1246, '1100110111': 1186, '1001011010': 1370, '1100110100': 1132, '0011000110': 830, '0010001010': 571, '1110101100': 1256, '0100011001': 630, '1100100111': 895, '1110101111': 1221, '1101001101': 1311, '0100111010': 585, '1110011110': 1376, '0111001000': 261, '1011000000': 1472, '0111110011': 601, '0001100110': 927, '0011111001': 589, '1111110001': 1467, '1000000001': 592, '1010100001': 1039, '1000010110': 1060, '1010100000': 1196, '1010111111': 1263, '0100011100': 624, '1000110111': 1083, '1110011010': 1374, '0111100001': 477, '1001001111': 1212, '1100111110': 1317, '0000001100': 939, '1101101111': 1178, '1001110000': 1398, '1101111101': 1295, '0011010011': 638, '1110110010': 1345, '1111011110': 1352, '1011110011': 1343, '1011000100': 1359, '0000111101': 759, '1011000011': 1110, '1001110101': 1189, '0001011001': 515, '0011101111': 718, '0111001101': 465, '1011101010': 1368, '0000101110': 789, '1011100110': 1160, '1100101110': 1224, '0001001111': 755, '0000011000': 618, '1000111111': 1281, '1011001010': 1500, '1001110010': 1313, '0001010000': 571, '0101010010': 610, '1010111110': 1313, '0101000000': 704, '1011001111': 1261, '1011111000': 1454, '0110110101': 755, '1010011100': 1394, '0101001101': 613, '1101100001': 1297, '1101010101': 1215, '0110110110': 718, '1001111111': 1323, '1101100100': 1173, '0000111110': 678, '0110010000': 566, '1001001101': 1273, '1011010001': 1451, '0000110010': 720, '0100000010': 860, '0010100000': 738, '1010101101': 1098, '0001001010': 528, '1101011101': 1325, '1111010111': 1332, '0000101101': 1058, '1001010100': 1227, '1000011011': 1344, '1110110001': 1319, '0010110110': 781, '0100111111': 700, '0000011100': 618, '1110000110': 1136, '1111110111': 1302, '0100000001': 1231, '1110101010': 1348, '0110010001': 588, '1110011000': 1438, '0011110000': 466, '0000001001': 852, '1110110000': 1369, '1010000010': 1115, '1010010001': 1293, '0000110001': 811, '0001101110': 746, '1111010101': 1399, '1110100001': 1232, '1011000001': 1350, '1110111110': 1293, '1111111100': 1391, '1100000100': 665, '1000110000': 1249, '1110110011': 1313, '0001101101': 765, '0000100101': 1298, '1001101101': 1195, '1101110010': 1321, '0000010000': 746, '1111100110': 1239, '0011000001': 630, '0010010101': 733, '0010011011': 654, '1011111111': 1315, '1010001110': 1362, '1010101100': 1197, '1000011001': 1299, '1101011111': 1354, '1110111001': 1290, '0000100000': 1024, '0000010100': 865, '0100101000': 784, '1011010000': 1531, '1001111100': 1442, '1101110111': 1251, '0001101010': 595, '1000111011': 1249, '1010101110': 1239, '0101101000': 525, '0000000110': 1202, '1010000011': 1062, '0111010111': 640, '1000101010': 1226, '1010100111': 957, '1110001010': 1457, '0000000111': 1276, '1010001001': 1364, '0011000100': 618, '1101110101': 1227, '0001010110': 851, '1101010000': 1373, '1010000111': 872, '1110011100': 1422, '0001110101': 769, '1101100010': 1261, '1010101011': 1257, '0101110000': 562, '1010101010': 1322, '0101111010': 553, '0111011011': 536, '0010000101': 1004, '1000001100': 1073, '1000011110': 1285, '0101011010': 532, '1111011000': 1497, '1011100010': 1308, '1001111110': 1219, '1100101101': 972, '0010011100': 536, '1000001010': 1315, '1011000010': 1296, '0010001000': 550, '0001111110': 665, '0011111100': 547, '0011011100': 435, '1011010010': 1311, '1010011011': 1308, '1111101000': 1495, '1110101001': 1244, '0010110111': 829, '0001001101': 694, '0111111011': 588, '1101000110': 1101, '1111111101': 1364, '1101101100': 1308, '1010011110': 1337, '1100110010': 1283, '1001110100': 1243, '1000010000': 1165, '0010110001': 683, '1000011111': 1265, '0101100101': 850, '1101010111': 1183, '1010110010': 1321, '1011110110': 1305, '0100001100': 789, '1100101000': 1216, '0001000101': 1076, '1011010101': 1390, '0001010101': 849, '1111100100': 1503, '0000001011': 717, '1100010111': 1171, '0101101101': 796, '1000011000': 1390, '1101100110': 1194, '1101010001': 1320, '1010110000': 1383, '0111101010': 542, '1101011011': 1329, '1001011100': 1370, '1110001100': 1485, '1011101000': 1487, '1000110011': 1231, '1100010010': 1258, '1111000010': 1437, '0110111000': 528, '0110000101': 764, '1110010111': 1238, '0101011111': 606, '1100000111': 835, '1000111110': 1275, '0100001010': 545, '1000101110': 1142, '1101011000': 1497, '1111100000': 1530, '1100101111': 1110, '0100001011': 660, '1011110111': 1248, '1001110011': 1277, '0100101101': 955, '0111110101': 597, '0100100101': 1205, '1011001100': 1553, '0010101010': 692, '0100101100': 941, '0111010100': 505, '1101101010': 1443, '0111011111': 571, '0010110000': 602, '1000101100': 1012, '0000100001': 1129, '0111010011': 619, '0010000110': 972, '1000101101': 1040, '0101011100': 520, '0110101100': 587, '0101101110': 718, '0110011101': 610, '1100010011': 1277, '0100101011': 674, '1100101100': 1052, '1110000000': 1295, '0101110101': 734, '0000100100': 1372, '0110011010': 509, '1000010011': 1201, '1010101000': 1318, '0110101010': 594, '1110010011': 1284, '0111010000': 406, '0100000101': 1435, '1011111110': 1308, '1000101111': 1109, '1010001000': 1513, '0001011010': 545, '0101100010': 631, '0101010110': 686, '1111011010': 1377, '0100000100': 1261, '1001010101': 1188, '0100110000': 711, '1101110011': 1349, '1101111111': 1288, '0001111111': 681, '1100001111': 1162, '1100011011': 1418, '1100110101': 1108, '0101100100': 790, '0000101100': 920, '1110000100': 1227, '1110001001': 1443, '1010100010': 1137, '0111100101': 603, '0001110011': 684, '1001101010': 1344, '0001011111': 638, '1101101001': 1316, '1010001010': 1482, '1110010101': 1242, '1010100110': 1035, '0100111110': 656, '1010011000': 1497, '0011010101': 588, '1100011110': 1355, '0101101010': 486, '1100001100': 1099, '0100110110': 751, '1101001100': 1300, '0011001001': 463, '1101001011': 1414, '1001111001': 1396, '1010110101': 1181, '1011100101': 1152, '1100001011': 1303, '0111000100': 398, '1010000000': 1154, '0011011111': 661, '1111101100': 1448, '1001000101': 823, '0101100111': 820, '0100100000': 970, '0001000011': 901, '0110111100': 570, '1100100110': 991, '0011010001': 494, '1101110000': 1297, '0001000111': 1152, '1001001011': 1330, '0110110001': 691, '0001011011': 591, '0010110101': 765, '0110011011': 584, '0000110011': 683, '1110010010': 1332, '1111001100': 1547, '1010010010': 1286, '1100001000': 1227, '0001000010': 832, '0010001001': 596, '1000110110': 1162, '0001100101': 968, '0101101111': 749, '0101100001': 717, '1010100011': 1082, '1101111010': 1352, '1011111011': 1319, '1110110100': 1285, '1100011000': 1390, '0101000011': 779, '1101110110': 1267, '0101001111': 679, '0010000111': 1030, '0111100010': 582, '0010000011': 923, '0010010000': 554, '1000110001': 1160, '1010010101': 1205, '0010001100': 555, '0101000010': 698, '1110000011': 1211, '0111100000': 400, '0111001001': 402, '0001101100': 706, '1010110100': 1184, '1110000001': 1285, '0001111100': 607, '0000111011': 633, '1100001001': 1199, '1101011001': 1428, '0011111010': 618, '0110100011': 752, '1011101011': 1329, '1001101110': 1264, '1110010000': 1414, '1011101001': 1376, '0110100101': 873, '0000001111': 866, '0010010001': 635, '0101101001': 561, '0001111001': 593, '1101011100': 1425, '1011011010': 1358, '1100101001': 1141, '0100010010': 688, '1100011111': 1308, '0110011110': 594, '0010101000': 597, '1111111011': 1385, '1010000001': 1048, '1101111110': 1279, '1000001001': 1115, '1100111000': 1293, '1111110100': 1390, '1100000001': 761, '0001101011': 677, '0001001011': 613, '1110011001': 1375, '0010111001': 594, '0110111101': 674, '1110001101': 1310, '1011111010': 1379, '1001011101': 1379, '0001000000': 883, '1110000101': 1110, '0011100000': 570, '0101001010': 464, '1111000001': 1595, '0100100010': 784, '0010000100': 905, '1111101110': 1356, '1100001110': 1271, '1000011101': 1311, '1101001111': 1228, '1100110001': 1191, '1101001001': 1474, '1010001111': 1236, '1100110110': 1162, '0000011010': 594, '1110100101': 1062, '0011110010': 618, '0110110010': 631, '1100010001': 1162, '0100100111': 1015, '1111111010': 1329, '0111011001': 508, '1000010101': 996, '1011011101': 1467, '0010111101': 680, '1111010001': 1445, '0111101011': 593, '0100110010': 651, '1111001000': 1759, '0100110101': 845, '0010101111': 774, '1010111011': 1266, '0110110100': 683, '0110001100': 520, '1110010110': 1289, '0001101111': 781, '0001001000': 492, '1001101011': 1335, '1100110011': 1236, '0001011101': 601, '1001100101': 896, '0010100100': 889, '1010001101': 1286, '1001001010': 1485, '1110101000': 1318, '0111011010': 543, '0101011101': 609, '1011001110': 1325, '0010010110': 711, '0100100110': 1000, '0000001000': 734, '0000111000': 643, '1110111010': 1366, '1110100000': 1323, '1111010000': 1579, '0001011110': 614, '0011000111': 919, '0110000011': 794, '1111001110': 1523, '0001001110': 667, '0001110000': 590, '0110100100': 688, '0000011101': 693, '0100100100': 1117, '1100011001': 1295, '0111110110': 646, '1111110101': 1437, '0111100100': 513, '1010011111': 1249, '0100001111': 781, '0010001110': 627, '0100110111': 810, '1110010100': 1366, '0011010110': 708, '1010001100': 1369, '0010000010': 821, '1000000011': 868, '1101101000': 1398, '1010101001': 1193, '1100111010': 1309, '0110000000': 594, '0100101110': 760, '1101110001': 1310, '1111011100': 1503, '0010110100': 700, '0011000101': 705, '0011100111': 868, '0000110100': 866, '1011111001': 1383, '0100011000': 574, '0000011011': 696, '0010100101': 1036, '1111000101': 1490, '1101101011': 1314, '1000100011': 995, '0011110101': 598, '0100001110': 661, '1100101011': 1223, '0110111010': 606, '1001111101': 1207, '0101011000': 446, '1000001011': 1245, '1011010110': 1221, '0010100010': 756, '1100111101': 1216, '0000011110': 712, '0101110100': 617, '1000100101': 596, '1100100100': 825, '0011010111': 746, '1101001010': 1480, '1001111010': 1318, '1110110111': 1185, '1111000011': 1306, '1000100111': 861, '0010100011': 856, '1111011111': 1369, '0000110110': 765, '0110110011': 641, '1011011000': 1495, '1111000000': 1747, '1110001110': 1350, '1110001000': 1404, '1011011110': 1349, '0011100110': 771, '1001101000': 1362, '0111000101': 534, '1011001000': 1621, '1111010100': 1437, '1001001100': 1398, '1011101101': 1383, '0101011110': 596, '0001100111': 953, '1001100001': 1093, '0000000001': 1305, '1011100000': 1404, '1000110101': 1046, '0101010100': 637, '0001010010': 682, '0111100111': 746, '1101100101': 1093, '1111101010': 1397, '1110101110': 1323, '0111001110': 552, '1001110110': 1170, '0000011001': 595, '0111100110': 645, '1110010001': 1355, '0000001010': 607, '1011011111': 1346, '0100100001': 1011, '0010101100': 742, '1011110001': 1378, '0101110011': 623, '0010001101': 654, '0101000100': 795, '1111100101': 1292, '0111100011': 597, '0110000110': 733, '0011110100': 544, '0110001001': 538, '0011101000': 541, '0101001011': 561, '0000001110': 762, '1110110110': 1277, '0011000011': 790, '0010111110': 641, '0110010100': 564, '0101100000': 587, '0111001011': 508, '1110001011': 1301, '0100001001': 761, '1001001001': 1400, '1111001111': 1312, '0111111100': 553, '0100101001': 813, '0111001100': 374, '0000110111': 859, '1001111011': 1245, '0111110000': 459, '1101001110': 1295, '0111111010': 552, '0110100001': 766, '1000111001': 1245, '0111111000': 513, '1010010110': 1151, '0110011001': 593, '0101111011': 583, '1011010111': 1230, '1101000011': 1171, '1001100010': 1287, '0110111111': 630, '0110011100': 598, '0011101011': 665, '1100010100': 1126, '0000100011': 974, '0001100100': 963, '0111101110': 646, '0000000100': 1520, '1111100010': 1374, '1010011010': 1403, '1000111100': 1270, '1101111000': 1372, '0010011000': 520, '1100011101': 1240, '0100000110': 1034, '1011100001': 1309, '1111010110': 1339, '1000111000': 1303, '0100000000': 1156, '1001100011': 1120, '1101100011': 1253, '1111100111': 1291, '0000010001': 860, '1011110010': 1450, '1011110000': 1524, '0000001101': 940, '1001010011': 1274, '1100111100': 1346, '1010110001': 1270, '1101001000': 1530, '0001000110': 1103, '0011100101': 769, '0111110010': 557, '0011100010': 659, '0011110110': 708, '0101101011': 575, '1100110000': 1198, '1100001101': 1026, '0011010000': 461, '1001000111': 850, '1100011100': 1339, '0001010011': 733, '1011111101': 1342, '1000000000': 672, '0110001110': 544, '0111000011': 637, '0111111101': 556, '0111111001': 579, '1100000101': 638, '0000000011': 1086, '0110110000': 592, '0110000111': 871, '1000111101': 1258, '1011100100': 1314, '1001101001': 1272, '1110100111': 1143, '0111010101': 530, '1110111111': 1289, '0010100001': 838, '1111100001': 1454, '0000000000': 1327, '1010010111': 1128, '0111110111': 667, '1001001000': 1461, '1111001010': 1541, '1110011101': 1375, '1111111111': 1342, '0000100111': 1093, '0101110110': 691, '1101100000': 1296, '0100011011': 590, '1010111001': 1309, '0011100011': 724, '1110111011': 1399, '1110111101': 1295, '1101101110': 1349, '0100000111': 1040, '0000010011': 785, '0010010111': 885, '1100100101': 708, '1101111011': 1350, '0000111111': 711, '1001000001': 1019, '1001010001': 1276, '0110000010': 691, '1011101111': 1254, '1011010011': 1281, '0000111001': 647, '1111000111': 1226, '0010101011': 713, '0100000011': 934, '1011011011': 1341, '1101000101': 1002, '1101000010': 1224, '0110010010': 586, '0110010110': 641, '1001110111': 1145, '0110001011': 627, '1111000110': 1330, '1110001111': 1289, '0110001101': 605, '0010111010': 668, '1010010000': 1415, '0101010111': 723, '1110000111': 1088, '0001111011': 631, '1001101100': 1234, '0110000100': 707, '1011101100': 1420, '1001011111': 1274, '0111101000': 421, '1110111100': 1318, '1100111001': 1219, '0000100010': 890, '0101011001': 552, '0101001110': 577, '0010100111': 973, '1001000110': 944, '0110101110': 665, '1010111101': 1276, '1100100011': 1104, '1001011011': 1317, '0110111011': 650, '0110101101': 744, '1011000110': 1125, '0000110101': 889, '1101010011': 1281, '0100110011': 653, '0110100111': 820, '0101111000': 531, '1111011011': 1410, '0011010010': 634, '0110000001': 760, '1011100111': 1108, '0010101110': 710, '0010101001': 718, '1000001101': 972, '1010000110': 1059, '0011011011': 618, '1111110011': 1403, '0100011111': 642, '1111110010': 1443, '1100000010': 1156, '1011011100': 1459, '0011111101': 632, '0011100100': 619, '1010000101': 949, '1001010010': 1274, '0101010001': 652, '1110100010': 1260, '1010011101': 1386, '1000110100': 1119, '1111010010': 1440, '1000011010': 1326, '0100101111': 822, '1100100010': 1140, '0101100110': 782, '0101000111': 915, '0010000001': 898, '0000101001': 880, '1101011010': 1385, '0011011110': 615, '0010101101': 760, '0000000010': 1072, '1011011001': 1489, '0000010111': 879, '1111101011': 1376, '1011100011': 1205, '1110011011': 1362, '1000100110': 935, '1110110101': 1262, '0100001000': 685}
print(len(list(dic.keys())))
dic = sorted(dic.items(),key=lambda d: d[1],reverse=True)

print(dic)
"""

