#!/bin/bash

EPS=8.0

CONFIG_BASES=()

CONFIG_BASES+=("cifar10_crafted_none_wrn_16_4_eps${EPS}_n49500_m1000_r49000")
CONFIG_BASES+=("cifar10_crafted_mislabel_wrn_16_4_eps${EPS}_n49500_m1000_r49000")
CONFIG_BASES+=("cifar10_crafted_sgd_wrn_16_4_eps${EPS}_n49500_m1000_r49000")

OUT_DIR=out/crafted/black_box

for DATA_SEED in 0 1 2 3 4
do
for CONFIG_BASE in "${CONFIG_BASES[@]}";
do
    CONFIG=ft_cinic10_${CONFIG_BASE}_seed${DATA_SEED}

    python -u run/audit/audit_google.py --out_dir ${OUT_DIR} \
        --name ${CONFIG} \
        >> logs/audit_google/${CONFIG}.log 2>&1 &

    python -u run/audit/audit_meta.py --out_dir ${OUT_DIR} \
        --name ${CONFIG} \
        >> logs/audit_meta/${CONFIG}.log 2>&1 &
done
done
