#!/bin/bash

DEVICE=$1

EPS=8.0

CONFIG_BASES=()

CONFIG_BASES+=("cifar10_crafted_none_wrn_16_4_eps${EPS}_n49500_m1000_r49000")
CONFIG_BASES+=("cifar10_crafted_mislabel_wrn_16_4_eps${EPS}_n49500_m1000_r49000")
CONFIG_BASES+=("cifar10_crafted_sgd_wrn_16_4_eps${EPS}_n49500_m1000_r49000")

for CONFIG_BASE in "${CONFIG_BASES[@]}";
do
for DATA_SEED in 0 1 2 3 4
do
    CONFIG=${CONFIG_BASE}_seed${DATA_SEED}

    CUDA_VISIBLE_DEVICES=${DEVICE} python run/train.py \
        --config=run/configs/from_scratch/${CONFIG}.py

    CUDA_VISIBLE_DEVICES=${DEVICE} python run/get_scores.py \
        --config=run/configs/from_scratch/${CONFIG}.py
done
done
