# https://stackoverflow.com/questions/242538/unix-shell-script-find-out-which-directory-the-script-file-resides
# Absolute path to this script
SCRIPT=$(readlink -f "$0")
SCRIPT_DIR=$(dirname "$SCRIPT")

EXECUTION_DIR="$SCRIPT_DIR/../.."

GPU=$1
LR=$2
WARMUP_RATIO=$3
RANK=$4
SCALING_FACTOR=$5
SEED=$6
MODEL=$7

CUDA_VISIBLE_DEVICES=$GPU python $SCRIPT_DIR/train.py -task math \
    -data_dir $EXECUTION_DIR/data/language_data \
    --output_dir $EXECUTION_DIR/artifacts/math/$MODEL \
    -model $MODEL \
    -seed $SEED \
    -e 3 -lr $LR \
    -gradient_accumulation_steps 1 \
    -batch_size 16 \
    -eval_batch_size 4 \
    --dropout 0.00 \
    --test_split test \
    --use_normalized_template \
    --rank $RANK \
    --warmup_ratio $WARMUP_RATIO \
    --scaling_factor $SCALING_FACTOR \
    --greedy_decoding \
    --weight_decay 0.0 \
    --use_gradient_checkpointing \
    --save_model \
    ${@:8}
