# https://stackoverflow.com/questions/242538/unix-shell-script-find-out-which-directory-the-script-file-resides
# Absolute path to this script
SCRIPT=$(readlink -f "$0")
SCRIPT_DIR=$(dirname "$SCRIPT")

EXECUTION_DIR="$SCRIPT_DIR/../.."

export PYTHONPATH=$EXECUTION_DIR:$EXECUTION_DIR/peft/src:$PYTHONPATH

GPU=$1
LR=$2
WARMUP_RATIO=$3
RANK=$4
SCALING_FACTOR=$5
SEED=$6
MODEL=$7

CUDA_VISIBLE_DEVICES=$GPU python $SCRIPT_DIR/train.py -task alpaca \
    -data_dir $EXECUTION_DIR/data/language_data \
    --output_dir $EXECUTION_DIR/artifacts/alpaca/$MODEL \
    -model $MODEL \
    -seed $SEED \
    -e 12 -lr $LR \
    -gradient_accumulation_steps 32 \
    -batch_size 4 \
    -eval_batch_size 2 \
    --test_split test \
    --use_normalized_template \
    --rank $RANK \
    --warmup_ratio $WARMUP_RATIO \
    --scaling_factor $SCALING_FACTOR \
    --weight_decay 0.0 \
    --max_length 768 \
    --use_gradient_checkpointing \
    --save_model \
    ${@:8}
