#!/bin/bash
source ~/.bashrc
conda activate ICLR
cd ~/mbrl-lib-iclr
python3 -m mbrl.examples.main \
	seed=$1 \
	algorithm=mbpo \
	overrides=mbpo_hopper_distraction \
	overrides.num_steps=500000 \
	overrides.model_batch_size=256 \
	dynamics_model=gaussian_mlp_ensemble \
	overrides.distraction_dimensions=$2 \
	overrides.pure_noise_distraction=True \
	hydra.run.dir="$HOME//$SLURM_JOB_ID"
