module StagHunt

using DynamicPolynomials

import NormalFormGames.Presets.SH as Game
import ...GameDynamics

export replicator

# DOCME
function replicator(x)
  REPLICATOR(x)
end

function replicator(x::AbstractArray{<: Variable})
  GameDynamics.replicator(
    [[xᵢ] for xᵢ ∈ x], 
    Game.marginal_payoffs(x)
  )
end

# Improve running time by constructing static versions of any polynomial functions
const REPLICATOR = (function()
  @polyvar x[1:2]
  GameDynamics.replicator_as_polynomial_system(
    [[xᵢ] for xᵢ ∈ x], 
    Game.marginal_payoffs(x)
  )
end)()

end # module StagHunt