using Test
using PolynomialTools
using DynamicPolynomials

@testset "PolynomialTools.jl" begin

  @polyvar x y z

  p₁ = [
    (y - 1)^2,
    (x - 2)^2 + (y - 2)^2
  ]

  p₂ = [
    (z - 2)^2
  ]

  system = polynomial_system(p₁)
  @test system([1, 2]) == [1, 1]

  system = polynomial_system(subs(p₁, x => 1))
  @test system([1, 2]) == [0, 2]

  system = polynomial_system(subs(p₁, x => 1), [x, y])
  @test system([1, 2]) == [1, 1]

  system = polynomial_system(subs(p₁, y => 1), [x, y])
  @test system([1, 2]) == [0, 2]

  systems = polynomial_systems([p₁, p₂])
  @test (
    systems[1]([1, 2, 3]) == [1, 1] &&
    systems[2]([1, 2, 3]) == [1]
  )
  
  @test variables([p₁, p₂]) == [x, y, z]

end