function [A_func, Bmv_func] = generateJacobian_rps(polynomial, n_state, n_input)
syms v1 v2 v3 v4 w1 w2 w3 w4
    A = sym(zeros(n_state,n_state));
    Bmv = sym(zeros(n_state,n_input));

    for i = 1:n_state
        A(i,1) = diff(polynomial(i), v1);
        A(i,2) = diff(polynomial(i), v2);
        A(i,3) = diff(polynomial(i), v3);
        A(i,4) = diff(polynomial(i), v4);
    end

    for i = 1:n_state
        Bmv(i,1) = diff(polynomial(i), w1);
        Bmv(i,2) = diff(polynomial(i), w2);
        Bmv(i,3) = diff(polynomial(i), w3);
        Bmv(i,4) = diff(polynomial(i), w4);
    end

    A_func = matlabFunction(A, 'Vars', {v1,v2,v3,v4,w1,w2,w3,w4});
    Bmv_func = matlabFunction(Bmv, 'Vars', {v1,v2,v3,v4,w1,w2,w3,w4});
end
