function polynomials_siar = generate_polynomials_siar_rps(all_siar_coeffs, all_siar_terms)

syms v1 v2 v3 v4 w1 w2 w3 w4

polynomials_siar = sym([]);

    for setIdx = 1:size(all_siar_coeffs, 1)
        c = all_siar_coeffs{setIdx,1};
        m = all_siar_terms{setIdx,1};

        for i = 1:length(m)
            m{i} = strrep(m{i}, 'x₁[1]', 'v1');
            m{i} = strrep(m{i}, 'x₁[2]', 'v2');
            m{i} = strrep(m{i}, 'x₂[1]', 'v3');
            m{i} = strrep(m{i}, 'x₂[2]', 'v4');
            m{i} = strrep(m{i}, 'w[1]', 'w1');
            m{i} = strrep(m{i}, 'w[2]', 'w2');
            m{i} = strrep(m{i}, 'w[3]', 'w3');
            m{i} = strrep(m{i}, 'w[4]', 'w4');
            m{i} = str2sym(m{i});
        end

        polynomial = 0;
        for i = 1:length(c)
            polynomial = polynomial + c(i) * m{i};
        end

        polynomials_siar(setIdx) = polynomial;
    end

end