module RockPaperScissors

using DynamicPolynomials

import NormalFormGames.Presets.RPS as Game
import ...GameDynamics

export replicator

# DOCME
function replicator(x)
  REPLICATOR(x)
end

function replicator(x::AbstractArray{<: AbstractArray{<: Variable}})
  GameDynamics.replicator(x, Game.marginal_payoffs(x))
end

# Improve running time by constructing static versions of any polynomial functions
const REPLICATOR = (function()
  @polyvar x₁[1:2] x₂[1:2]
  x = [x₁, x₂]
  GameDynamics.replicator_as_polynomial_system(x, Game.marginal_payoffs(x))
end)()

end # module RockPaperScissors