module StagHunt

using DynamicPolynomials

import ...NormalFormGames

export PAYOFF_MATRIX₁, PAYOFF_MATRIX₂, NASH_EQUILIBRIA
export player_marginal_payoffs, marginal_payoffs

# DOCME
const PAYOFF_MATRIX₁ = [
  4 0;
  3 1
]

# DOCME
const PAYOFF_MATRIX₂ = [
  4 3;
  0 1
]

# DOCME
const NASH_EQUILIBRIA = [[0.0, 0.0], [0.5, 0.5], [1.0, 1.0]]

# DOCME
function player_marginal_payoffs(i, x)
  MARGINAL_PAYOFFS[i](x)
end

# DOCME
function marginal_payoffs(x)
  [vᵢ(x) for vᵢ ∈ MARGINAL_PAYOFFS]
end

function marginal_payoffs(x::AbstractVector{<: Variable})
  NormalFormGames.marginal_payoffs(
    [PAYOFF_MATRIX₁, PAYOFF_MATRIX₂],
    [[xᵢ] for xᵢ ∈ x]
  )
end

# Improve running time by constructing static versions of any polynomial functions
const MARGINAL_PAYOFFS = (function()
  NormalFormGames.marginal_payoffs_as_polynomial_systems([PAYOFF_MATRIX₁, PAYOFF_MATRIX₂])
end)()

end # module StagHunt