using Test
using DynamicPolynomials
using NormalFormGames

ABSOLUTE_TOLERANCE = 1e-4

@testset "NormalFormGames.jl" begin

  @polyvar x₁ x₂
  x = [[x₁], [x₂]]

  A₁ = [
     1 -1;
    -1  1
  ]
  A₂ = - A₁

  v = marginal_payoffs([A₁, A₂], x)
  @test v[1][1] ==   x₂ - (1 - x₂)
  @test v[1][2] == - x₂ + (1 - x₂)
  @test v[2][1] == - x₁ + (1 - x₁)
  @test v[2][2] ==   x₁ - (1 - x₁)

  @test NormalFormGames.variables(v) == x

  # Test the marginal payoffs of a Stag Hune game
  @testset "Stag Hunt Game" begin

    sh = NormalFormGames.Presets.SH

    @polyvar x[1:2]

    v = sh.marginal_payoffs(x) 
    @test v[1][1] == 4 * x[2]
    @test v[1][2] == 3 * x[2] + (1 - x[2])
    @test v[2][1] == 4 * x[1]
    @test v[2][2] == 3 * x[1] + (1 - x[1])

  end

  # Test the marginal payoffs of a Matching Pennies game
  @testset "Matching Pennies Game" begin

    mp = NormalFormGames.Presets.MP

    @polyvar x[1:2]

    v = mp.marginal_payoffs(x) 
    @test v[1][1] ==   x[2] - (1 - x[2])
    @test v[1][2] == - x[2] + (1 - x[2])
    @test v[2][1] == - x[1] + (1 - x[1])
    @test v[2][2] ==   x[1] - (1 - x[1])

  end

  # Test the marginal payoffs of a Rock-Paper-Scissors game
  @testset "Rock-Paper-Scissors Game" begin

    rps = NormalFormGames.Presets.RPS

    @polyvar x₁[1:2] x₂[1:2]

    v = rps.marginal_payoffs([x₁, x₂]) 
    @test v[1][1] == - x₂[2]         + (1 - x₂[1] - x₂[2])
    @test v[1][2] ==   x₂[1]         - (1 - x₂[1] - x₂[2])
    @test v[1][3] == - x₂[1] + x₂[2]
    @test v[2][1] == - x₁[2]         + (1 - x₁[1] - x₁[2])
    @test v[2][2] ==   x₁[1]         - (1 - x₁[1] - x₁[2])
    @test v[2][3] == - x₁[1] + x₁[2]

    # Verify that the uniform distribution is a Nash equilbrium
    v = rps.marginal_payoffs([1, 1, 1, 1] / 3)
    @test v[1] ≈ [0, 0, 0] atol=ABSOLUTE_TOLERANCE
    @test v[2] ≈ [0, 0, 0] atol=ABSOLUTE_TOLERANCE

  end

end