module SINDySLSMethod

using LinearAlgebra
using DynamicPolynomials

import ...DEFAULT_ZERO_THRESHOLD
import ...rescale_data!

export SINDySLS

# DOCME
function SINDySLS(
  x_data, 
  ẋ_data, 
  b; 
  zero_threshold=DEFAULT_ZERO_THRESHOLD, 
  max_iters=10,
  rescale=true
)

  Θ = [bᵢ(x) for x ∈ x_data, bᵢ ∈ b]

  if rescale
    scaling = rescale_data!(Θ)
  end

  p_values = Polynomial[]

  for i ∈ eachindex(first(ẋ_data))

    ẋ_dataᵢ = [ẋ[i] for ẋ ∈ ẋ_data]

    if rescale
      scalingᵢ = scaling / only(rescale_data!(ẋ_dataᵢ))
      zero_thersholdᵢ = zero_threshold * scalingᵢ
    else
      zero_thersholdᵢ = zero_threshold
    end

    ξ = Θ \ ẋ_dataᵢ
    support = abs.(ξ) .≥ zero_thersholdᵢ
    if !all(support)
      ξ[.!support] .= 0
      for i ∈ 1:max_iters - 1 # Technically, one iteration has already occurred.
        ξ[support] .= Θ[:, support] \ ẋ_dataᵢ
        if any(abs.(ξ[support]) .< zero_thersholdᵢ[support])
          support = abs.(ξ) .≥ zero_thersholdᵢ
          ξ[.!support] .= 0
        else
          @goto SOLUTION_FOUND
        end
      end
      @warn "SINDySLS terminated because the maximum number of iterations was reached."
    end
    
    @label SOLUTION_FOUND
    if rescale
      ξ ./= scalingᵢ
    end
    
    p_value = polynomial(ξ, b)
    @info "SINDySLS found a polynomial" p=p_value
    push!(p_values, p_value)

  end
  
  p_values

end

function SINDySLS(x_data, w_data, ẋ_data, b; kwargs...)
  SINDySLS(
    [vcat(x, w) for (x, w) ∈ zip(x_data, w_data)],
    ẋ_data,
    b;
    kwargs...
  )
end

end # module SINDySLSMethod