module Correlation

using LinearAlgebra
using SemialgebraicSets
using SumOfSquares

export positive_correlation

function positive_correlation(model, ẋ, u; domain=FullSpace(), maxdegree=:auto)
  g = u ⋅ [ẋ; - sum(ẋ)]
  if maxdegree == :auto
    maxdegree = SumOfSquares.default_maxdegree(g, domain)
  end
  [@constraint(model, g ∈ SOSCone(), domain=domain, maxdegree=maxdegree)]
end

end # module Correlation