using Test
using Logging
using DynamicPolynomials
using JuMP
# TODO The packages PolynomialTools, NormalFormGames, and GameDynamics are imported only for testing and should be removed from the dependencies of the SystemIdentification package.
using PolynomialTools
using NormalFormGames
using GameDynamics
using SystemIdentification

import MosekTools: Mosek

const SINDy    = SystemIdentification.Methods.SINDy
const SINDySLS = SystemIdentification.Methods.SINDySLS
const SIAR     = SystemIdentification.Methods.SIAR
const SI       = SideInformation

global_logger(ConsoleLogger(Warn))

# Some of the following tests are challenging for the default SOCP solver (SCS). Therefore, we rely on the Mosek solver.
SOCP_optimizer=optimizer_with_attributes(
  Mosek.Optimizer, 
  "MSK_DPAR_INTPNT_CO_TOL_PFEAS"   => 1e-12,
  "MSK_DPAR_INTPNT_CO_TOL_DFEAS"   => 1e-12,
  "MSK_DPAR_INTPNT_CO_TOL_REL_GAP" => 1e-12
)

const ABSOLUTE_TOLERANCE = 1e-2

@testset "SystemIdentification.jl" begin

  @testset "SINDy" begin
    include("SINDy_tests.jl")
  end

  @testset "SINDySLS" begin
    include("SINDySLS_tests.jl")
  end

  @testset "SIAR" begin
    include("SIAR_tests.jl")
  end

end