function [A_func, Bmv_func] = generateJacobian(polynomial, n_state, n_input)
syms v1 v2 w1 w2 w3

    A = sym(zeros(n_state,n_state));
    Bmv = sym(zeros(n_state,n_input));

    for i = 1:n_state
        A(i,1) = diff(polynomial(i), v1);
        A(i,2) = diff(polynomial(i), v2);
    end

    for i = 1:n_state
        Bmv(i,1) = diff(polynomial(i), w1);
        Bmv(i,2) = diff(polynomial(i), w2);
        Bmv(i,3) = diff(polynomial(i), w3);
    end

    A_func = matlabFunction(A, 'Vars', {v1,v2,w1,w2,w3});
    Bmv_func = matlabFunction(Bmv, 'Vars', {v1,v2,w1,w2,w3});
end
