function nlobj = initializeMPC(my_est, my_Jacobian, n_state, n_input, Ts, Tc, Tp, lb_s, ub_s, lb_c, ub_c, weight_s, weight_c, weight_dc)
    nlobj = nlmpc(n_state, n_state, n_input);

    % MPC Parameters
    nlobj.Ts = Ts;
    nlobj.PredictionHorizon = Tp;
    nlobj.ControlHorizon = Tc*ones(1,(Tp/Tc));

    nlobj.Model.StateFcn = @(v,w)my_est(v,w);
    
    nlobj.Jacobian.StateFcn = @(v,w)my_Jacobian(v,w);

    % Setting Weights
    nlobj.Weights.OutputVariables = weight_s*ones(1, n_state);
    nlobj.Weights.ManipulatedVariables = weight_c*ones(1, n_input);
    nlobj.Weights.ManipulatedVariablesRate = weight_dc*ones(1, n_input);

    % Setting State Constraints
    for i = 1:n_state
        nlobj.State(i).Min = lb_s;
        nlobj.State(i).Max = ub_s;
    end

    % Setting MV Constraints
    for i = 1:n_input
        nlobj.MV(i).Min = lb_c;
        nlobj.MV(i).Max = ub_c;
    end

%     % Setting inequlity constraints for states
%     nlobj.Optimization.CustomIneqConFcn = @(X,U,e,data) myIneqConFunction(X,U,e,data);

    % Return the configured nlobj
    return
end
