function [A,Bmv] = myStateJacobian_PINN(x,u, nn_w1,nn_w2,nn_w3,nn_b1,nn_b2,nn_b3)

    Nx = size(x, 1); 
    X = [x;u];

    % Forward pass
    z1 = nn_w1' * X + nn_b1;
    a1 = tanh(z1);
    z2 = nn_w2' * a1 + nn_b2;
    a2 = tanh(z2);
    y = nn_w3' * a2 + nn_b3;
    
    % Backward pass
    dy_da2 = nn_w3;
    da2_dz2 = 1 - tanh(z2).^2;
    dz2_da1 = nn_w2;
    da1_dz1 = 1 - tanh(z1).^2;
    dz1_dx = nn_w1;
    
    % Gradient of y with respect to x
    grad_y_x = (dz1_dx * (da1_dz1 .* (dz2_da1 * (da2_dz2 .* dy_da2))))';

    A = grad_y_x(1:Nx, 1:Nx);
    Bmv = grad_y_x(1:Nx, Nx+1:end);

end


