import torch
import torch.nn as nn




class NNet2l(nn.Module):
    #two layers, one of which hidden with 6 neurons
    def __init__(self, dropout_prob=0.0, device='cpu'):
        super().__init__()
        self.l1 = nn.Linear(1, 6, device)
        self.l2 = nn.Linear(6, 1, device)
        self.d = nn.Dropout(dropout_prob)

    def forward(self, x):
        # forward pass for the network
        x = x.view(-1, 1*1)
        x = self.d(self.l1(x))
        x = torch.tanh(x)
        x = self.l2(x)
        return x


def MYtrainNNet(net, optimizer, data, target, device=torch.device("cpu")):
    """Train function"""
    
    net.zero_grad()
    outputs = net(data)
    loss_fn = torch.nn.MSELoss()
    loss = loss_fn(outputs, target.view(len(outputs),1))

    loss.backward()
    optimizer.step()
    
    return 0


def mytestNNet(net, test, C):
    # Evaluates percentage of points falling outside the tube
    net.eval()
    with torch.no_grad():
        data = torch.tensor(test[0], dtype=torch.float)
        target =  torch.tensor(test[1], dtype=torch.float)
        outputs = net(data.float()) 
        
        total = len(target)
        upper_envelope = outputs + C
        lower_envelope = outputs - C
        target = target.view(total,1)
        inside = torch.logical_and(target<=upper_envelope, target>=lower_envelope)
        inside = sum(inside)
        outside = total-inside
      

    return (outside/total).item()

