#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
CREATE DATASET WITH TRAINING POINTS FOR 1D REGRESSION
(X,Y) with X in [-0.5,1.4] and Y = f(X)+noise
"""

from numpy.random import default_rng
import numpy as np
import matplotlib.pyplot as plt
import math 

# inputs
a = -0.5   # left interval 
b = +1.5   # right intercal
sigma =  0.05 # noise level
n_data = 20000 # datapoints
####

# extract uniformly at random points from [a,b]
rng = default_rng()
X = rng.uniform(a,b,n_data)

# compute Y=f(x) with f = sinc
Y = np.sinc(2.5*X) 

# add noise
Y = Y + sigma*rng.standard_normal(n_data)

# plot to verify
plt.plot(X,Y,'*')
plt.pause(0.1)

# save
np.save('dataset_regression_data', [X,Y], allow_pickle =False)

# load
data, targets = np.load('dataset_regression_data.npy')


# replot
plt.plot(data, targets, '*')

