%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%% Clear previous work
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear;
close all;
clc;

addpath('utils')
addpath('../tensorlab/')
if isempty(gcp('nocreate'))
    parpool('threads');  % Start with default settings
end
% fix random seed for reproducibility
rng(pi);

%% generate synthetic data for testing
I   = 2;    % the number of factor matrices
AVG = 200;
% initialize dimensions
N = 80*ones(I,1);Nbar = prod(N);
M = 64*ones(I,1);Mbar = prod(M);
% sparsity pattern
K = 15; % s-sparse, #nonzeros in total
% SNR condition
SNR = [3:2:25]; % Define the range of SNR values for testing

error = zeros(AVG,length(SNR),4);
time  = zeros(AVG,length(SNR),4);
srr   = zeros(AVG,length(SNR),4);


for avg = 1:AVG

    avg

    % generate measuring dictionaries
    A = cell(1,I);
    for i = 1:I
        A{i} = randn(M(i),N(i));
        col_norm = vecnorm(A{i});
    end

    % generate sparse vector x
    tX = generate_sparse_tensor(N, K);
    % generate noisy measurements
    tY_ori         = tmprod(tX,A,1:I);
    control.tX     = tX; % for debugging 
    for snr = 1:length(SNR)
        signal_power   = norm(vec(tY_ori),'fro')^2/numel(tY_ori); %average signal power per asymbol
        n_var          = (signal_power)/(10^(SNR(snr)/10));
        noise          = sqrt(n_var)*randn(size(tY_ori));
        tY             = tY_ori + noise;

        coef = 0.05;
        %% sparse vector estimation
        %% Benchmark 1: KroOMP
        result_kroomp = kron_omp_refined(A,tY,coef);
        disp('Kro-OMP is done!')
        %% using sbl: sequential
        result_sbl_se = tenMulReSBL(tY,A,N,M);
        disp('Multi-Stage SBL is done!')
        %% using sbl: parallel
        result_sbl_pl = tenMulReSBL_pl(tY,A,N,M);
        disp('Multi-Stage SBL is done!')
        %% using OMP
        result_mtomp = tenMulReOMP(tY,A,N,M,coef);
        disp('Multi-Stage OMP is done!')
        %% track results
        error(avg,snr,1) = (norm(vec(result_mtomp{1} - tX), 'fro')/norm(vec(tX),'fro'))^2;
        time(avg,snr,1) = result_mtomp{2};
        srr(avg,snr,1) = recover_rate(vec(result_mtomp{1}),vec(tX));
        %%
        error(avg,snr,2) = (norm(vec(result_kroomp{1} - tX), 'fro')/norm(vec(tX),'fro'))^2;
        time(avg,snr,2) = result_kroomp{2};
        srr(avg,snr,2) = recover_rate(vec(result_kroomp{1}),vec(tX));
        %%
        error(avg,snr,3) = (norm(vec(result_sbl_se{1} - tX), 'fro')/norm(vec(tX),'fro'))^2;
        time(avg,snr,3) = result_sbl_se{2};
        srr(avg,snr,3) = recover_rate(vec(result_sbl_se{1}),vec(tX));
        %%
        error(avg,snr,4) = (norm(vec(result_sbl_pl{1} - tX), 'fro')/norm(vec(tX),'fro'))^2;
        time(avg,snr,4) = result_sbl_pl{2};
        srr(avg,snr,4) = recover_rate(vec(result_sbl_pl{1}),vec(tX));
    end
end

save s_sparse_snr.mat